#!/bin/sh
#
# Scirpt permettant de mettre à jour automatiquement les sous-modules des applications contenant ce module
#

for repo in `echo doc_app_vmap doc_app_gtf doc_app_calimap doc_app_extraction doc_app_myrecepisse doc_app_risdict doc_app_sigrando`; do
    echo "---- Clone ${repo} ----"
    if [ ! -d "$repo" ]; then
        git clone "git@vm09.veremes.net:Documentation/${repo}.git"
    fi
    if [ -d "$repo" ]; then
        if [ -d "$repo/.git" ]; then
              cd ${repo}
              echo "-- config email --"
              env -i git config user.email "gitlab@veremes.com"
              env -i git config user.name "Veremes"
              echo "-- git pull --"
              env -i git pull
              echo "-- git submodule update --"
              env -i git submodule update --recursive --remote --init
              echo "-- git add --"
              env -i git add -A
              echo "-- git commit --"
              env -i git commit -a -m "update submodules"
              echo "-- git push --"
              env -i git push
              cd ..
        fi
    fi
done
