#ifdef __unix__
	#define OS_Windows 0
	#define MAX_PATH 4096
	#include <locale.h>
	typedef unsigned long DWORD;
	const char * separator = "/";
#else
	#define OS_Windows 1
	#include <windows.h>
	#include <Winbase.h>
	#include <tchar.h>
	#include <psapi.h>
	const char * separator = "\\";
#endif
#include <stdio.h>
#include <ctype.h>
#include <string.h> 
#include <stdlib.h>
#include <sys/types.h>  
#include <unistd.h> 
#include "sha1.h"
#include <time.h>
#include "regex.h"
#include "engine.h"

#define TAILLE_MAX 1000

int num_pid = 0, debug = 0;
char *current_directory;
// const char * separator = "/";

int main(int argc, char *argv[]){
	int valid = 0;;
	unsigned int i;
	if (argc > 1){
		for (i = 0; i < strlen(argv[1]); ++i){
			if (!isdigit(argv[1][i]))
			{
				valid = 1;
				break;
			}
		}
		if (valid ==0){
			if (argc > 2){
				if (strcmp(argv[2],"d") == 0){
					debug = 1;
				}
			}
		}else{
			printf("Syntaxe : engine.exe [moteur_number] [d]\n");
			printf("d : Debug mode\n");

			exit(1);
		}
	}else{
		printf("Syntaxe : engine.exe [motor_number] [d]\n");
		printf("d : Debug mode\n");

		exit(1);
	}
	//declaration des variables
	int exist_pid_file = 0;
	
	// Nom du fichier pid
	char* pid_file = malloc(strlen("pid_.txt") + strlen(argv[1]) + 1);
	sprintf(pid_file, "pid_%s.txt", argv[1]);
	int result = 0;
	printf("1\n");
	//Rcupration du rpertoire courant du fichier courant
	#ifdef __unix__
		char *cwd_buffer = malloc(sizeof(char) * MAX_PATH);
		current_directory = getcwd(cwd_buffer, MAX_PATH);
	#else
		char current_path[MAX_PATH];
		GetModuleFileName( NULL, current_path, MAX_PATH );
		current_directory = RemplacerFragment((char *)current_path, "\\engine.exe", "");
	#endif
	writeToDebugLog("Rpertoire courant : ", current_directory);
	//remplacement du nom de l exe par le nom du fichier pid
	char* pid_file_path = malloc(strlen(current_directory) + strlen("/") + strlen(pid_file) + 1);
	sprintf(pid_file_path, "%s%s%s", current_directory, separator, pid_file);

	writeToDebugLog("fichier PID : ", pid_file_path);
	//test de l'existence des fichiers
    exist_pid_file = findPidFile(pid_file_path);
	
	char tmp[5];
	sprintf(tmp, "%i", exist_pid_file);
	writeToDebugLog("existence Fichier pid (0, n existe pas) : ", tmp);
	char *motor_number = argv[1];
	//si fichier inexistant
	if (exist_pid_file == 0){
		writeToDebugLog("Execution", " robot non existence fichier pid.");
		result = execRobot(pid_file_path, motor_number);
	} else {
		//si fichier vide
		if (num_pid == 0){
			writeToDebugLog("Execution", " robot fichier pid vide.");
			result = execRobot(pid_file_path, motor_number);
		} else {
			sprintf(tmp, "%i", num_pid);
			writeToDebugLog("num PID : ", tmp);
			int process = 0;
			process = verifyProcess(num_pid);
			if (process == 0){
				writeToDebugLog("Execution", " robot processus fini.");
				result = execRobot(pid_file_path, motor_number);
			}
		} 
	}
	return result;
}

//fonction de recherche d'un numero de pid
int findPidFile(char *pid_file_path){
	//declaration des variables
	char line[512];
	int nb_lines = 0;
	FILE *fic;
	//ouverture du fichier
	fic = fopen(pid_file_path, "r"); // ouvrir en lecture
	
	//si le programme n a pas trouve de fichier
	if(fic == NULL){
		return 0;
	}
	//si le programme a trouvee un fichier
	else{
		//lecture du fichier
		while(fgets(line, 512, fic) != NULL){
			//recuperation du pid
			num_pid = atoi(line);
			//passage a la ligne suivante
			nb_lines++;
		}
		//fermeture du fichier
		fclose(fic); 
		return 1;
	}
}

//Fonction de remplacement de chaine de caractere par une autre : n'existe pas par defaut en c.
char *RemplacerFragment(char *source, char *vieux, char *nouveau){
	//Recuperation des parametres
	char *original = source;
	char temp[256];
	int ancienne_long = strlen (vieux);
	int i, j, k, place = -1;
	 
	//recherche de la position de l'occurence tant que la fonction n a pas trouvee
	for (i = 0; source[i] && (place == -1); ++i){
		for (j = i, k = 0; source[j] == vieux[k]; j++, k++){
			if (!vieux[k+1]){
				place = i;
			}
		}
	}
	//remplacement de lancienne chaine par la nouvelle
	if (place != -1){
		//recuperation de la chaine jusqu a l'emplacement de la chaine a remplacer
		for (j=0; j < place; j++){
			temp[j] = source[j];
		}
		//remplacement de l ancienne valeur par la nouvelle
		for (i=0; nouveau[i]; i++, j++){
			temp[j] = nouveau[i];
		}
		//reucperation de la fin de la chaine de caracteres
		for (k = place + ancienne_long; source[k]; k++, j++){
			temp[j] = source[k];
		}
		temp[j] = 0;
		for (i=0; (source[i] = temp[i]); i++){
		}
	}
	return original;
} 

int execRobot(char *pid_file_path, char *motor_number){
	writeToDebugLog("path pid : ", pid_file_path);
	getWritePid(pid_file_path);
	char var_env_engine[MAX_PATH];
	char var_env_php[MAX_PATH];
	
	strcpy(var_env_engine, "GTF_ENGINE_HOME=");
	strcat(var_env_engine, current_directory);
	
	strcpy(var_env_php, "PHP_HOME=");
	strcat(var_env_php, current_directory);
	strcat(var_env_php, "/php");
	
	writeToDebugLog("", var_env_php);
	writeToDebugLog("", var_env_engine);
	putenv(var_env_engine);
	putenv(var_env_php);
	putenv("PYTHONPATH=");
	// Changement de la locale pour traiter les nombres
	setlocale(LC_NUMERIC, "en_US.UTF8");
	
	char *argument = verifyLicense(motor_number);
	writeToDebugLog("value verification : ", argument);
	char function_robot[512];
	if (OS_Windows == 0) {
		sprintf(function_robot, "\"%s%sphp%sbin%sphp\" \"%s%sengine.php\" %s %s", current_directory, separator, separator, separator, current_directory, separator, motor_number, argument);	
	} else {
		sprintf(function_robot, "\"\"%s%sphp%sphp.exe\" \"%s%sengine.php\" %s %s\"", current_directory, separator, separator, current_directory, separator, motor_number, argument);		
	}
	writeToDebugLog("function : ", function_robot);
	system(function_robot);

	remove(pid_file_path);
	return 0;
}

void getWritePid(char *pid_file_path){
	FILE *fic;
	//ouverture du fichier
	fic = fopen(pid_file_path, "w"); //"w"  : mode texte en criture (cration)
	//recuperation du pid
	pid_t pid = getpid();
	fprintf(fic, "%i", pid);
	fclose(fic);
}


int verifyProcess(int num_pid){
	int running = 0;
	int i = 0;
	int j = 0;
	char *szProcessName;
	char *szProcessNameWithSpaces;
	#ifdef __unix__
		if (getpgid(num_pid) >= 0){
			FILE *fic;
			char* process_path = malloc(strlen("/proc//comm") + 6);
			sprintf(process_path, "/proc/%i/comm", num_pid);
			//ouverture du fichier
			fic = fopen(process_path, "r"); // ouvrir en lecture
	
			//si le programme n a pas trouve de fichier
			if(fic != NULL){
				//lecture du fichier
				char line[512];
				int nb_lines = 0;
				while(fgets(line, 512, fic) != NULL){
					//recuperation du nom du pid
					szProcessNameWithSpaces = line;
					//passage a la ligne suivante
					nb_lines++;
				}
				//trim 
				while(i < strlen(szProcessNameWithSpaces)){
					if (&szProcessNameWithSpaces[i] != " " || &szProcessNameWithSpaces[i] != "\n"){
						i++;
					} else {
						szProcessName[j] = szProcessNameWithSpaces[i];
						i++;
						j++;
					}
				}
				//fermeture du fichier
				fclose(fic);
				writeToDebugLog("Pid name: ",  szProcessName);
				writeToDebugLog("Exe file : engine", "");
				if (strcmp(szProcessName, "engine") == 0){
					running = 1;
				}
			}
		}
	#elif defined(_WIN32)
		HANDLE hProcess=OpenProcess(PROCESS_VM_READ|PROCESS_QUERY_INFORMATION,FALSE, num_pid);
		if(hProcess){
			HMODULE hMod;
			DWORD unused;
			if(EnumProcessModules(hProcess, &hMod, sizeof(hMod), &unused)){
				GetModuleBaseNameA(hProcess, hMod, szProcessName, sizeof(szProcessName)/sizeof(char));
				writeToDebugLog("Pid name: ",  szProcessName);
				writeToDebugLog("Exe file : engine.exe", "");
				if (strcmp(szProcessName, "engine.exe") == 0){
					running = 1;
				}
			}
		}
	#endif
	return running;
}

char *verifyLicense(char *motor_number){
	char *returnValue = "";
	char expireDate[TAILLE_MAX] = "";
	char motorNumber[TAILLE_MAX] = "";

	char* licence_path = malloc(strlen(current_directory) + strlen("licenseslicense.txt") + 3);
	sprintf(licence_path, "%s%slicenses%slicense.txt", current_directory, separator, separator);

	FILE* fichier = NULL;
	writeToDebugLog("Fichier License : ",licence_path);
	fichier = fopen(licence_path, "r");
	if (fichier != NULL){
		char chaine[TAILLE_MAX] = "";
		char testChaine[TAILLE_MAX] = "";
		// char *chaine = "";
		char *key;
		char *temp;
		char toKey[TAILLE_MAX] = "";
		int z = 0;
		while (fgets(chaine, TAILLE_MAX, fichier) != NULL){ // On lit le fichier tant qu'on ne reoit pas d'erreur (NULL)
			if (chaine[0]!= '#'){
				RemplacerFragment(chaine, "\r", "");
				copie(chaine, testChaine);
				if (strncmp( verifyRegexp(testChaine, "^Expiry date: (Permanent|[0-9]{6,8})"), "error", 1000)  != 0){
					RemplacerFragment(testChaine, "Expiry date: ", "");
					copie(testChaine, expireDate);
				}
				if (strncmp( verifyRegexp(testChaine, "^Engines: ([0-9]+)"), "error", 1000)  != 0){
					RemplacerFragment(testChaine, "Engines: ", "");
					copie(testChaine, motorNumber);
				}
				if (chaine[0]!= 'K'){
					if (z == 0){
						z = z+1;
					}else{
						strcat(toKey, "\n");
					}
					temp = RemplacerFragment(chaine, "\n", "");
					strcat(toKey, temp);
				}else{
					if (chaine[1]!= 'e'){
						if (z == 0){
							z = z+1;
						}else{
							strcat(toKey, "\n");
						}
						temp = RemplacerFragment(chaine, "\n", "");
						strcat(toKey, temp);
					}else{
						if (chaine[2]!= 'y'){
							if (z == 0){
								z = z+1;
							}else{
								strcat(toKey, "\n");
							}
							temp = RemplacerFragment(chaine, "\n", "");
							strcat(toKey, temp);
						}else{
							key=RemplacerFragment(chaine, "Key: ", "");
						}
					}
				}
			}
		}
		writeToDebugLog("Expire Date: ",expireDate);
		writeToDebugLog("Motor Number: ",motorNumber);
		writeToDebugLog("clef: ", key);
		writeToDebugLog("Toclef: ", toKey);
		SHA1Context sha;
		int i;
		SHA1Reset(&sha);
		for(i = 1; i <= 1000; i++) {
			SHA1Input(&sha, toKey, strlen(toKey));
		}
		if (!SHA1Result(&sha)){
			 writeToErrorLog("Erreur licence : ", "Impossible de hasher la clef");
			 returnValue = "E001";
		}else{
			char clefTemp[5][TAILLE_MAX];
			char *clef, *clefTest;
			for(i = 0; i < 5; i++){
				sprintf(clefTemp[i], "%X ", sha.Message_Digest[i]);
			}
			int j=0;
			for(j = 0; j < 5; j++){
				clefTest= clefTemp[j];
				 if (j == 0){
					clef = clefTest;
				}else{
					strcat(clef, clefTest);
				}
			}
			writeToDebugLog("clef calcule: ", clef);
			int result = strncmp(clef, key, 1000);
			if (result == 0){
				writeToDebugLog("Comparaison Clefs: ", "Egales");
				time_t current_time;
				current_time = time(NULL);
				struct tm *nowtm;
				int yy, mm, dd;
				yy = makeInt(expireDate +  0, 4) -1900;
				mm = makeInt(expireDate +  4, 2)-1;
				dd = makeInt(expireDate +  6, 2);
				nowtm = localtime(&current_time);
				writeToDebugLog("Comparaison Date Nombre moteur: ",motorNumber);
				writeToDebugLog("Comparaison Date numro moteur: ",motor_number);
				if (strncmp(expireDate, "permanent", 1000) ==0){
					writeToDebugLog("Comparaison Date : ", "OK");
					if (atoi(motor_number) <= atoi(motorNumber)){
						writeToDebugLog("Comparaison Moteur : ", "Ok");
						returnValue = "0";
					}else{
						writeToDebugLog("Comparaison Moteur : ", "Numro de moteur trop grand");
						returnValue = "E003";
					}
				}else{
					if (yy < nowtm->tm_year){
						writeToDebugLog("Comparaison Date : ", "Anne courante suprieure");
						writeToErrorLog("Erreur licence : ", "Anne courante suprieure");
						returnValue = "E002";
					}else{
						if (mm < nowtm->tm_mon){
							writeToDebugLog("Comparaison Date : ", "Mois courant suprieur");
							returnValue = "E002";
						}else{
							if (dd < nowtm->tm_mday){
								writeToDebugLog("Comparaison Date : ", "Jour courant suprieur");
								returnValue = "E002";
							}else{
								writeToDebugLog("Comparaison Date : ", "OK");
								if (atoi(motor_number) <= atoi(motorNumber)){
									writeToDebugLog("Comparaison Moteur : ", "Ok");
									returnValue = "0";
								}else{
									writeToDebugLog("Comparaison Moteur : ", "Numro de moteur trop grand");
									writeToErrorLog("Erreur licence : ", "Numro de moteur trop grand");
									returnValue = "E003";
								}
							}
						}
					}
				}
				
			}else{
				returnValue = "E001";
				writeToDebugLog("Comparaison Clefs : ", "Diffrentes");
				writeToErrorLog("Erreur licence : ", "Clefs diffrentes");
			}
		} 
		fclose(fichier);
	}else{
		// On affiche un message d'erreur si on veut
		writeToErrorLog("Erreur licence : ", "Ouverture du fichier impossible");
		returnValue = "E001";
	}
	
	return returnValue;
}

void writeToDebugLog(char *titre, char *error){
	if (debug == 1){
		FILE *fic;
		//ouverture du fichier
		char* debug_file_path = malloc(strlen(current_directory) + strlen("engine.log") + 2);
		sprintf(debug_file_path, "%s%sengine.log", current_directory, separator);
		fic = fopen(debug_file_path, "a"); //"w"  : mode texte en criture (cration)
		char resultat[MAX_PATH];
		strcpy(resultat, titre);
		strcat(resultat, error);
		strcat(resultat, "\n");
		//recuperation du pid
		fprintf(fic, "%s", resultat);
		fclose(fic); 
	}
}

void writeToErrorLog(char *titre, char *error){
	FILE *fic;
	//ouverture du fichier
	char* error_file_path = malloc(strlen(current_directory) + strlen("engine_error.log") + 2);
	sprintf(error_file_path, "%s%sengine_error.log", current_directory, separator);
	fic = fopen(error_file_path, "a"); //"w"  : mode texte en criture (cration)
	char resultat[MAX_PATH];
	strcpy(resultat, titre);
	strcat(resultat, error);
	strcat(resultat, "\n");
	//recuperation du pid
	fprintf(fic, "%s", resultat);
	fclose(fic);
}

char *verifyRegexp (char *str_request, char *str_regex){
	char *returnValue = "error";
	int err;
	regex_t preg;
	err = regcomp (&preg, str_regex, REG_EXTENDED);
	if (err == 0){
		int match;
		size_t nmatch = 0;
		regmatch_t *pmatch = NULL;
		nmatch = preg.re_nsub;
		pmatch = malloc (sizeof (*pmatch) * nmatch);
		if (pmatch){
			match = regexec (&preg, str_request, nmatch, pmatch, 0);
			regfree (&preg);
			if (match == 0){
				char *site = NULL;
				int start = pmatch[0].rm_so;
				int end = pmatch[0].rm_eo;
				size_t size = end - start;
				site = malloc (sizeof (*site) * (size + 1));
				if (site){
				   strncpy (site, &str_request[start], size);
				   site[size] = '\0';
				   returnValue = site;
				   free (site);
				}
			}else if (match == REG_NOMATCH){
				returnValue = "error";
			}else{
				char *text;
				size_t size;
				size = regerror (err, &preg, NULL, 0);
				text = malloc (sizeof (*text) * size);
				if (text){
				   regerror (err, &preg, text, size);
				   returnValue = text;
				   free (text);
				}else{
				   returnValue = "error";
				}
			}
		}else{
			 returnValue = "error";
		}	
	}else{
		returnValue = "error";
	}
	
	return returnValue;
}

void copie(char srce[] , char dest[]) { 
  register int i;     /* un indice est necessaire */
  for( i=0 ; (dest[i] = srce[i]) != 0 ; i++) 
     ;
}

int makeInt(const char *p, int size){
    const char *endp;
    int intval = 0;
    endp = p + size;
    while (p < endp){
        intval = intval * 10 + *p - '0';
        p++;
    }
    return intval;
}
