<?php

/**
 * \file engine.php
 * \brief engine.php \n \n Ce fichier contient un programme php.
 *
 * Ce programme permet de traiter des demandes de traitements.
 *
 * \author Fabien Marty <fabien.marty@veremes.com>
 */
$properties["id_gtf_engine"] = $_SERVER['argv'][1]; //Identifiant du moteur calculé à partir de la valeur passée en argument
$ErrorLicense = $_SERVER['argv'][2]; //Identifiant du moteur calculé à partir de la valeur passée en argument

require_once ("php_engine_conf.inc");
require_once ("vmlib/BD.class.inc");
require_once ("vmlib/logUtil.inc");
require_once("vmlib/dbUtil.inc");
require_once ("gtf_lib/phpUtility.inc");
require_once("vmlib/phpUtil.inc");

require_once ("properties_engine.inc");
require_once ("engine.sql.inc");
//require_once ("PEAR/Mail.php");
require_once("Ldap.class.inc");

require_once("vmlib/Email.class.inc");
require_once("gtf_lib/gtf_object/Order.class.inc");
require_once("vmlib/error.inc");
require_once 'string.inc';

loadLang("engines", $properties["language"]);
if ($ErrorLicense == "0") {
    //writeToLog('|INFO |PHP| dump prop '. var_export($properties,true),$properties["engine_log_file"]);

    $sDateDebut = new DateTime(date("Y-m-d H:i:s"));
    $sDateFin = new DateTime(date("Y-m-d H:i:s"));

    //Connexion à la base de données de Données gtf : pas de mot de passe pour le robot
    $oBd = new BD($properties['login_scheduler'], $properties['password_scheduler'], $properties["database"], $properties["server"], $properties["port"], $properties["sgbd"], $properties["page_encoding"]);
    //$oBd = new Vm  ('admin', 'admin', $properties["database"], $properties["server"], $properties["port"], $properties["sgbd"], $properties["page_encoding"]);
    if ($oBd->erreurRencontree) {
        writeToLog(INFO_BASE_CONNECTION_ERROR . $properties["database"], $properties["engine_log_file"]);
    } else {
        writeToLog(INFO_BASE_CONNECTION . $properties["database"], $properties["engine_log_file"]);

        //Recherche du Moteur V2 (ExecuteWithParams)
        //Selection du chemin fme
        $aParams = array();
        $aParams['sSchemaGtf'] = array('value' => $properties['schema_gtf'], 'type' => 'schema_name');
        $aParams['gtf_engine_id'] = array('value' => $properties['id_gtf_engine'], 'type' => 'number');
        $oPDOResult = $oBd->executeWithParams($aSql['pgsql']['select_fme_path'], $aParams);

        if ($aRecord = $oBd->ligneSuivante($oPDOResult)) {
            $properties["fme_path"] = $aRecord['fme_path'];
        } else {
            $properties["fme_path"] = '';
        }
        putenv("FME_PATH=" . $properties["fme_path"]);
        putenv("GTF_HOME=" . $properties["workspace_dir"] . "/");

        /*
        // Traitement des demandes en fonction du moteur
        $iNbTraitement = 0;
        $aUserToRefresh = Array();
        //$sSql = $aSql[$properties["sgbd"]]["boucle_1"];
        if (TesteHeureCreuse($properties["heure_creuse_min"], $properties["heure_creuse_max"])) { // On est en heure creuse (0 correspond à "Heure Creuse")
            $iPlageHorraire = 0;
            $sSql = $aSql[$properties["sgbd"]]["boucle_1"];
        } else { // On est PAS en heure creuse
            $iPlageHorraire = 0;
            $sSql = $aSql[$properties["sgbd"]]["boucle_2"];
        }
        $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
        $sSql = str_replace("[iPriorityId]", $iPlageHorraire, $sSql);
        $sSql = str_replace("[iIdGtfEngine]", $properties["id_gtf_engine"], $sSql);
        if ($properties["nbr_order_max"] < 1)
            $properties["nbr_order_max"] = 1;
        $sSql = str_replace("[iNnbrOrderMax]", $properties["nbr_order_max"], $sSql);
        $sEnErreur = 2;
        $oPDOResult = $oBd->execute($sSql);
        //*/
        
        ///*
        // Traitement des demandes en fonction du moteur7
        // Gestion des heures creuses
        $iNbTraitement = 0;
        $aUserToRefresh = Array();
        $aParams = array();

        $iPlageHorraire = 0;
        
        $aParams['sSchemaGtf'] = array('value' => $properties['schema_gtf'], 'type' => 'schema_name');
        $aParams['iPriorityId'] = array('value' => $iPlageHorraire, 'type' => 'number');
        $aParams['iIdGtfEngine'] = array('value' => $properties["id_gtf_engine"], 'type' => 'number');
        if ($properties["nbr_order_max"] < 1)
            $properties["nbr_order_max"] = 1;
        $aParams['iNnbrOrderMax'] = array('value' => $properties["nbr_order_max"], 'type' => 'number');

        $sEnErreur = 2;
        
        if (TesteHeureCreuse($properties["heure_creuse_min"], $properties["heure_creuse_max"])) { // On est en heure creuse (0 correspond à "Heure Creuse")
            $oPDOResult = $oBd->executeWithParams($aSql[$properties["sgbd"]]["boucle_1"], $aParams);
        } else { // On est PAS en heure creuse
            $oPDOResult = $oBd->executeWithParams($aSql[$properties["sgbd"]]["boucle_2"], $aParams);
        }
        
        while ($aDemande = $oBd->ligneSuivante($oPDOResult)) {
            //test pour connaitre les nombres de tentatives de chaque demande
            //if ($aDemande['attempt']>=1){    modif par og 26/04/13
            if ($properties["max_attempt"] == '') {
                $properties["max_attempt"] = 2;
            }
            if ($aDemande['attempt'] >= $properties["max_attempt"]) {
                writeToLog(str_replace("[aDemande['order_id']]", $aDemande['order_id'], INFO_TOO_MANY_ORDER_ATTEMPT), $properties["engine_log_file"]);
                $iStatut = 4;

                /*
                  //Mise à jour de la demande.
                  $sDateTraitement = Date('Y-m-d H:i:s');
                  $sSql = $aSql[$properties["sgbd"]]["update_demande"];
                  $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                  $sSql = str_replace("[iStatut]", $iStatut, $sSql);
                  $sSql = str_replace("[iNbSec]", 0, $sSql);
                  $sSql = str_replace("[sMessage]", $sMessage, $sSql);
                  $sSql = str_replace("[sDateTraitement]", $sDateTraitement, $sSql);
                  $sSql = str_replace("[sResultat]", $sResultat, $sSql);
                  $sSql = str_replace("[sLogFme]", $sLogFme, $sSql);

                  $sSql = str_replace("[iOrderId]", $aDemande["order_id"], $sSql);
                  $oPDOResult2 = $oBd->execute($sSql);
                  // */

                //Mise à jour de la demande V2
                // Requete d'update de la demande
                $aParams = array();
                $aParams['sSchemaGtf'] = array('value' => $properties['schema_gtf'], 'type' => 'schema_name');
                $aParams['iStatut'] = array('value' => $iStatut, 'type' => 'number');
                $aParams['iNbSec'] = array('value' => 0, 'type' => 'number');
                $aParams['sDateTraitement'] = array('value' => $sDateTraitement, 'type' => 'string');
                $aParams['sResultat'] = array('value' => $sResultat, 'type' => 'string');
                $aParams['sLogFme'] = array('value' => $sLogFme, 'type' => 'string');
                $aParams['iOrderId'] = array('value' => $aDemande["order_id"], 'type' => 'number');
                $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["update_demande"], $aParams);

                if ($oBd->erreurRencontree) {
                    writeToLog(INFO_ORDER_UPDATE_ERROR . "(SQL : $sSql)", $properties["engine_log_file"]);
                } else {
                    writeToLog(INFO_ORDER_UPDATE, $properties["engine_log_file"]);
                    // La demande passe en cours
                    sendWebsocketMessage($properties['websocket_server'], $properties['websocket_port'], $properties['websocket_alias'], array(
                        'action' => 'event',
                        'service' => 'GtfEvents',
                        'data' => array(
                            'event' => 'order_started',
                            'order' => array(
                                'order_id' => $aDemande['order_id'],
                                'order_status_id' => $aDemande['order_status_id'],
                                'user_id' => $aDemande['user_id'],
                                'workspace_id' => $aDemande['workspace_id']
                            )
                        )
                    ));
                }
                $oPDOResult2 = $oBd->fermeResultat();
            } else {

                /*
                  //Vérification des droits de l'utilsateur
                  $sSql = $aSql[$properties["sgbd"]]["getLogin"];
                  $sSql = str_replace("[sSchemaFramework]", $properties["schema_framework"], $sSql);
                  $sSql = str_replace("[iUserId]", $aDemande['user_id'], $sSql);
                  $oPDOResult2 = $oBd->execute($sSql);
                  // */

                //Vérification des droits de l'utilsateur
                // Recuperation des login et droits de l'utilisateur en cour
                $aParams = array();
                $aParams['sSchemaFramework'] = array('value' => $properties["schema_framework"], 'type' => 'schema_name');
                $aParams['iUserId'] = array('value' => $aDemande['user_id'], 'type' => 'number');
                $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["getLogin"], $aParams);

                $aUser = $oBd->ligneSuivante($oPDOResult2);
                $sGroupListId = getUserGroupsEngines($aUser["login"], $oBd, $properties["mixed_rights_management"]);
                // Mise à jour du nombre de tentative dans la base
                $iTentative = $aDemande['attempt'] + 1;
                $sTable = $properties["schema_gtf"] . ".order";
                $sChamp = "attempt";
                $sWhere = "order_id";
                $sListDemande = $aDemande['order_id'];
                $oBd->updateLinkedTable($sTable, $sChamp, $sWhere, $sListDemande, $iTentative);

                // Mise à jour de l'état de la demande de traitement
                $oBd->updateLinkedTable($sTable, "order_status_id", $sWhere, $sListDemande, 5);

                writeToLog(str_replace("[aDemande['order_id']]", $aDemande['order_id'], INFO_ORDER_PROCESSING), $properties["engine_log_file"]);
                // OG 27/03/2013 for table job
                $sBeginExecutionDate = Date('Y-m-d H:i:s');
                $date = new DateTime();
                $iTimeStampBegin = $date->getTimestamp(); // Pour calcul de la durée
                // fin OG 27/03/2013 for job
                // $sContenuMail = "";
                $iNbTraitement = $iNbTraitement + 1;
                $aUserToRefresh[$iNbTraitement] = $aDemande['user_id'];
                $aUserToRefresh[$iNbTraitement] = $aDemande['user_id'];

                /*
                  //Vérification si l'utilisateur a les droits pour faire une demande de ce traitement.
                  $sSql = $aSql[$properties["sgbd"]]["right_user"];
                  $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                  $sSql = str_replace("[sGroupListId]", $sGroupListId, $sSql);
                  $oPDOResult2 = $oBd->execute($sSql);
                  // */

                ///*
                //Vérification si l'utilisateur a les droits pour faire une demande de ce traitement.
                $aParams = array();
                $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                $aParams['sGroupListId'] = array('value' => str_replace(',', '|', $sGroupListId), 'type' => 'group');
                $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["right_user"], $aParams);
                //*/

                if ($oBd->erreurRencontree) {
                    writeToLog(INFO_REQUEST_ERROR . $sSql, $properties["engine_log_file"]);
                    writeToLog(INFO_PHP_ERROR, $properties["engine_log_file"]);
                    $sMessage = "Erreur SQL.";
                    // $sContenuMail = 'Votre demande de traitement "'.$aDemande['workspace_nom'].'" a échoué. Voici le message d\'erreur renvoyé : <br><font color="#FF0000">'.$sMessage.'</font><br>';
                    $iStatut = $sEnErreur;
                } else {
                    if ($sGroupListId == "0") {
                        $bAutorisationDemande = true;
                    } else {
                        $bAutorisationDemande = false;
                        while ($aTraitementsAutorise = $oBd->ligneSuivante($oPDOResult2)) {

                            if ($aTraitementsAutorise['workspace_id'] == $aDemande['workspace_id']) {
                                $bAutorisationDemande = true;
                            }
                        }
                    }
                    if ($bAutorisationDemande == true) {
                        if (class_exists("Traitement.class.inc") == false) {
                            include_once ("Traitement.class.inc");
                        }

                        /*
                          // recuperer le nom du fichier fmw a traiter
                          $sSql = $aSql[$properties["sgbd"]]["select_traitement"];
                          $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                          $sSql = str_replace("[iWorkspaceId]", $aDemande['workspace_id'], $sSql);
                          $oPDOResult3 = $oBd->execute($sSql);
                          // */

                        ///*
                        // recuperer le nom du fichier fmw a traiter
                        $aParams = array();
                        $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                        $aParams['iWorkspaceId'] = array('value' => $aDemande['workspace_id'], 'type' => 'number');
                        $oPDOResult3 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["select_traitement"], $aParams);
                        //*/

                        $aTraitement = $oBd->ligneSuivante($oPDOResult3);
                        $iEmailTemplateId = $aTraitement['email_template_id'];
                        $oPDOResult3 = $oBd->fermeResultat();
                        // $sSql = $aSql[$properties["sgbd"]]["select_transit_dir"];
                        // $oPDOResult4 = $oBd->execute($sSql);
                        // $aAction = $oBd->ligneSuivante ($oPDOResult4);
                        // $properties["transit_dir"] = $aAction["value"];
                        // $oPDOResult4 = $oBd->fermeResultat();
                        //Lancement du traitement correspondant à la demande.
                        $aLicence = getFmeLicence($properties['fme_path']);
                        $bLicenceIsValid = $aLicence['valid'];
                        $aLicence['valid'] = 1;
                        if ($aLicence['valid'] == 1) {
                            $sDateDebut = new DateTime(date("Y-m-d H:i:s"));
                            $oTraitement = new Traitement($oBd, $aDemande['order_id'], $properties["engine_log_file"], $aDemande['wk_params'], $properties, $aDemande['workspace_id'] . "/fme/" . $aTraitement['fmw_file']);

                            if (!$oTraitement->bErreur) {
                                $sResultat = $oTraitement->Process();
                                $sDateFin = new DateTime(date("Y-m-d H:i:s"));
                                $sLogFme = $oTraitement->sLogFme;
                            }
                            //Gestion des erreurs.

                            if ($oTraitement->bFmeCrash)
                                $iStatut = 1;
                            elseif ($oTraitement->bErreur) {
                                if ($aTraitement["failed_action_id"] != "" && $oTraitement->sSource != "") {
                                    $aSource = explode("/", $oTraitement->sSource);
                                    $sSourceDirectory = $properties["upload_dir"] . $aSource[0];

                                    if ($aTraitement["failed_action_id"] == 1) {
                                        clearDir($sSourceDirectory);
                                        writeToLog(INFO_DELETE_DIRECTORY . $sSourceDirectory . '.', $properties["engine_log_file"]);
                                    } elseif ($aTraitement["failed_action_id"] == 2) {
                                        /*
                                          $sSql = $aSql[$properties["sgbd"]]["select_user"];
                                          $sSql = str_replace("[iUserId]", $aDemande['user_id'], $sSql);
                                          $sSql = str_replace("[sSchemaFramework]", $properties["schema_framework"], $sSql);
                                          $oPDOResult2 = $oBd->execute($sSql);
                                          // */
                                        ///*
                                        // Selection de l'utilisateur
                                        $aParams = array();
                                        $aParams['iUserId'] = array('value' => $aDemande['user_id'], 'type' => 'number');
                                        $aParams['sSchemaFramework'] = array('value' => $properties["schema_framework"], 'type' => 'schema_name');
                                        $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["select_user"], $aParams);
                                        //*/
                                        if ($oBd->erreurRencontree) {
                                            writeToLog(INFO_GET_USER_INFO_ERROR . $aDemande['user_id'] . ". (SQL = " . $sSql . ")", $properties["engine_log_file"]);
                                        } else {
                                            $aUser = $oBd->ligneSuivante($oPDOResult2);

                                            $sUser = userToFolder($aUser["name"]);
                                            if (file_exists($properties["transit_dir"])) {
                                                if (!file_exists($properties["transit_dir"] . "/failed/")) {
                                                    mkdir($properties["transit_dir"] . "/failed/");
                                                }
                                                if (!file_exists($properties["transit_dir"] . "/failed/" . $sUser)) {
                                                    mkdir($properties["transit_dir"] . "/failed/" . $sUser);
                                                }
                                                if (!file_exists($properties["transit_dir"] . "/failed/" . $sUser . "/" . $aTraitement["workspace_id"])) {
                                                    mkdir($properties["transit_dir"] . "/failed/" . $sUser . "/" . $aTraitement["workspace_id"]);
                                                }
                                                rename($sSourceDirectory, $properties["transit_dir"] . "/failed/" . $sUser . "/" . $aTraitement["workspace_id"] . "/" . $aDemande["order_id"]);
                                                writeToLog(str_replace('[sSourceDirectory]', $sSourceDirectory, INFO_MOVING_FILE) . $properties["transit_dir"] . "/failed/" . $sUser . "/" . $aTraitement["workspace_id"] . "/" . $aDemande["order_id"] . '.', $properties["engine_log_file"]);
                                            } else {
                                                writeToLog(str_replace("[properties['transit_dir']]", $properties['transit_dir'], INFO_DIRECTORY_NOT_FOUND_ENGINE), $properties["engine_log_file"]);
                                                $iStatut = $sEnErreur;
                                            }
                                        }
                                    }
                                }
                                $sMessage = $oTraitement->sMessageErreur;
                                $iStatut = $sEnErreur;
                                $sResultat = '';
                                // $sContenuMail = 'Votre demande de traitement "'.$aDemande['workspace_nom'].'" a échoué. Voici le message d\'erreur renvoyé : <br><font color="#FF0000">'.$sMessage.'</font><br>';
                                // $sContenuMail .= "Contactez l'administrateur pour consulter le fichier de log du robot.<br>";
                                $sLienLogFme = $sLogFme;
                            } else {
                                if ($aTraitement["success_action_id"] != "" && $oTraitement->sSource != "") {
                                    $aSource = explode("/", $oTraitement->sSource);
                                    $sSourceDirectory = $properties["upload_dir"] . $aSource[0];
                                    if ($aTraitement["success_action_id"] == 1) {
                                        clearDir($sSourceDirectory);
                                        writeToLog(INFO_DELETE_DIRECTORY . $sSourceDirectory . '.', $properties["engine_log_file"]);
                                    } elseif ($aTraitement["success_action_id"] == 2) {

                                        /*
                                          $sSql = $aSql[$properties["sgbd"]]["select_user"];
                                          $sSql = str_replace("[iUserId]", $aDemande['user_id'], $sSql);
                                          $sSql = str_replace("[sSchemaFramework]", $properties["schema_framework"], $sSql);
                                          $oPDOResult2 = $oBd->execute($sSql);
                                          // */
                                        ///*
                                        //Selection de l'utilisateur
                                        $aParams = array();
                                        $aParams['iUserId'] = array('value' => $aDemande['user_id'], 'type' => 'number');
                                        $aParams['sSchemaFramework'] = array('value' => $properties["schema_framework"], 'type' => 'schema_name');
                                        $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["select_user"], $aParams);
                                        //*/

                                        if ($oBd->erreurRencontree) {
                                            writeToLog(INFO_GET_USER_INFO_ERROR . $aDemande['user_id'] . ". (SQL = " . $sSql . ")", $properties["engine_log_file"]);
                                        } else {
                                            $aUser = $oBd->ligneSuivante($oPDOResult2);
                 
                                            $sUser = userToFolder($aUser["name"]);
                                            if (file_exists($properties["transit_dir"])) {
                                                if (!file_exists($properties["transit_dir"] . "/success/")) {
                                                    mkdir($properties["transit_dir"] . "/success/");
                                                }
                                                if (!file_exists($properties["transit_dir"] . "/success/" . $sUser)) {
                                                    mkdir($properties["transit_dir"] . "/success/" . $sUser);
                                                }
                                                if (!file_exists($properties["transit_dir"] . "/success/" . $sUser . "/" . $aTraitement["workspace_id"])) {
                                                    mkdir($properties["transit_dir"] . "/success/" . $sUser . "/" . $aTraitement["workspace_id"]);
                                                }
                                                rename($sSourceDirectory, $properties["transit_dir"] . "/success/" . $sUser . "/" . $aTraitement["workspace_id"] . "/" . $aDemande["order_id"]);
                                                writeToLog(str_replace('[sSourceDirectory]', $sSourceDirectory, INFO_MOVING_FILE) . $properties["transit_dir"] . "/success/" . $sUser . "/" . $aTraitement["workspace_id"] . "/" . $aDemande["order_id"] . '.', $properties["engine_log_file"]);
                                            } else {
                                                writeToLog(str_replace("[properties['transit_dir']]", $properties['transit_dir'], INFO_DIRECTORY_NOT_FOUND_ENGINE), $properties["engine_log_file"]);
                                                $iStatut = $sEnErreur;
                                            }
                                        }
                                    }
                                }
                                $sMessage = "";
                                $iStatut = 3;
                                // $sContenuMail = "Votre demande de traitement '".$aDemande['workspace_nom']."' a réussi.<br>";
                                if ($sResultat != "") {
                                    // $sContenuMail .= '<A href="'.$properties["url_export"]."/".$sResultat.'">Télécharger le résultat</A><br>';
                                    $sLienResultat = $sResultat;
                                }
                                $sLienLogFme = $sLogFme;
                            }
                            unset($oTraitement);
                        } else {
                            $iTentative = $iTentative - 1;
                            $sTable = $properties["schema_gtf"] . ".order";
                            $sChamp = "attempt";
                            $sWhere = "order_id";
                            $sListDemande = $aDemande['order_id'];
                            $oBd->updateLinkedTable($sTable, $sChamp, $sWhere, $sListDemande, $iTentative);
                            writeToLog(INFO_INVALID_FME_LICENCE_FILE, $properties["engine_log_file"]);
                            writeToLog(INFO_CONTACT_ADMINISTRATOR, $properties["engine_log_file"]);
                            $sMessage = "Invalid FME licence file. ";
                            // $sContenuMail = 'Votre demande de traitement "'.$aDemande['workspace_nom'].'" a échoué. Voici le message d\'erreur renvoyé : <br><font color="#FF0000">'.$sMessage.'</font><br>';
                            $iStatut = 1;
                            $sLienLogFme = 'Non disponible';
                        }
                    } else {
                        writeToLog(INFO_NO_USER_GRANT . $aDemande['workspace_nom'] . ' n\'a pas été défini.', $properties["engine_log_file"]);
                        writeToLog(INFO_CONTACT_ADMINISTRATOR, $properties["engine_log_file"]);
                        $sMessage = "Vous n''avez pas les droits nécessaires pour réaliser ce traitement.";
                        // $sContenuMail = 'Votre demande de traitement "'.$aDemande['workspace_nom'].'" a échoué. Voici le message d\'erreur renvoyé : <br><font color="#FF0000">'.$sMessage.'</font><br>';
                        $iStatut = 6;

                        if (file_exists($sLogFme)) {
                            $sLienLogFme = $sLogFme;
                        } else {
                            $sLienLogFme = 'Non disponible';
                        }
                    }
                }
                $oPDOResult2 = $oBd->fermeResultat();

                //Mise à jour de la demande.

                if ($iStatut == 3) {
                    /*
                      $sSql = $aSql[$properties["sgbd"]]["update_message"];
                      $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                      $sSql = str_replace("[iOrderId]", $aDemande["order_id"], $sSql);
                      $oPDOResult2 = $oBd->execute($sSql);
                      // */
                    ///*
                    // Mise a jour du message
                    $aParams = array();
                    $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                    $aParams['iOrderId'] = array('value' => $aDemande["order_id"], 'type' => 'number');
                    $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["update_message"], $aParams);
                    //*/
                    if ($oBd->erreurRencontree) {
                        writeToLog(INFO_TEST_REQUEST_ERROR . '(' . $oBd->getBDMessage() . ')', $properties["engine_log_file"]);
                    }
                    // Fin - OG 27/03/2013 for table job
                    $oPDOResult2 = $oBd->fermeResultat();
                }
                if ($iStatut == 2 || $iStatut == 4) {

                    /*
                      $sSql = $aSql[$properties["sgbd"]]["delete_message"];
                      $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                      $sSql = str_replace("[iOrderId]", $aDemande["order_id"], $sSql);
                      $oPDOResult2 = $oBd->execute($sSql);
                      // */
                    ///*
                    
                    // Mise a jour du message
                    $aParams = array();
                    $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                    $aParams['iOrderId'] = array('value' => $aDemande["order_id"], 'type' => 'number');
                    $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["update_message"], $aParams);
                    //*/

                    if ($oBd->erreurRencontree) {
                        writeToLog(INFO_TEST_REQUEST_ERROR . '(' . $oBd->getBDMessage() . ')', $properties["engine_log_file"]);
                    }
                    // Fin - OG 27/03/2013 for table job
                    $oPDOResult2 = $oBd->fermeResultat();
                }
                $sDateTraitement = Date('Y-m-d H:i:s');

                /*
                $sSql = $aSql[$properties["sgbd"]]["update_demande"];
                $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                if ($iStatut != 1) {
                    $timeFirst = strtotime(date_format($sDateDebut, 'Y-m-d H:i:s'));
                    $timeSecond = strtotime(date_format($sDateFin, 'Y-m-d H:i:s'));
                    $diff = $timeSecond - $timeFirst;
                    $iNbSec = $diff;
                } else {
                    $iNbSec = "NULL";
                }
                // OG 27/03/2013 for table job
                $date = new DateTime();
                $iTimeStampEnd = $date->getTimestamp();
                $iDelay = $iTimeStampEnd - $iTimeStampBegin;
                $sSql = str_replace("[iNbSec]", $iDelay, $sSql);
                $sSql = str_replace("[$iStatut]", $iStatut, $sSql);
                /* $sSql = str_replace("[sMessage]", $sMessage, $sSql); *//*
                $sSql = str_replace("[sDateTraitement]", $sDateTraitement, $sSql);
                $sSql = str_replace("[sResultat]", utf8_encode($sResultat), $sSql);
                $sSql = str_replace("[iOrderId]", $aDemande["order_id"], $sSql);
                if ($sLogFme == "") {
                    $sSql = str_replace("'[sLogFme]'", "NULL", $sSql);
                } else {
                    $sSql = str_replace("[sLogFme]", $sLogFme, $sSql);
                }

                $oPDOResult2 = $oBd->execute($sSql);
                //*/

                //*
                // Mise a jour de la demande
                  $aParams = array();
                  $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                  if ($iStatut != 1) {
                  $timeFirst = strtotime(date_format($sDateDebut, 'Y-m-d H:i:s'));
                  $timeSecond = strtotime(date_format($sDateFin, 'Y-m-d H:i:s'));
                  $diff = $timeSecond - $timeFirst;
                  $iNbSec = $diff;
                  } else {
                  $iNbSec = "NULL";
                  }
                  // OG 27/03/2013 for table job
                  $date = new DateTime();
                  $iTimeStampEnd = $date->getTimestamp();
                  $iDelay = $iTimeStampEnd - $iTimeStampBegin;
                  $aParams['iNbSec'] = array('value' => $iDelay, 'type' => 'number');
                  $aParams['iStatut'] = array('value' => $iStatut, 'type' => 'number');
                  $aParams['sDateTraitement'] = array('value' => $sDateTraitement, 'type' => 'string');
                  $aParams['sResultat'] = array('value' =>  utf8_encode($sResultat), 'type' => 'string');
                  $aParams['iOrderId'] = array('value' =>  $aDemande["order_id"], 'type' => 'number');
                  if ($sLogFme == "") {
                  $aParams['sLogFme'] = array('value' =>  "NULL", 'type' => 'string');
                  } else {
                  $aParams['sLogFme'] = array('value' =>  $sLogFme, 'type' => 'string');
                  }

                  $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["update_demande"], $aParams);
                  // */


                if ($oBd->erreurRencontree) {
                    writeToLog(INFO_ORDER_UPDATE_ERROR . '(' . $oBd->getBDMessage() . ')', $properties["engine_log_file"]);
                } else {
                    writeToLog(INFO_ORDER_UPDATE, $properties["engine_log_file"]);
                    // La demande est terminée avec un résultat
                    sendWebsocketMessage($properties['websocket_server'], $properties['websocket_port'], $properties['websocket_alias'], array(
                        'action' => 'event',
                        'service' => 'GtfEvents',
                        'data' => array(
                            'event' => 'order_finished_with_result',
                            'order' => array(
                                'order_id' => $aDemande['order_id'],
                                'order_status_id' => $aDemande['order_status_id'],
                                'user_id' => $aDemande['user_id'],
                                'workspace_id' => $aDemande['workspace_id']
                            )
                        )
                    ));
                }
                if ($iStatut != 1) {
                    /*
                      $sSql = $aSql[$properties["sgbd"]]["insertJob"];
                      $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                      $sSql = str_replace("[iOrderId]", $aDemande["order_id"], $sSql);
                      $sSql = str_replace("[iWorkspaceId]", $aDemande["workspace_id"], $sSql);
                      $sSql = str_replace("[iUserId]", $aDemande['user_id'], $sSql);
                      $sSql = str_replace("[sBeginExecutionDate]", $sBeginExecutionDate, $sSql);
                      $sSql = str_replace("[iDelay]", $iDelay, $sSql);
                      $sSql = str_replace("[iGtfEngineId]", $properties["id_gtf_engine"], $sSql);
                      $sSql = str_replace("[iStatut]", $iStatut, $sSql);
                      //writeToLog('|INFORM|PHP|Test requête OG : '.$sSql,$properties["engine_log_file"]);
                      $oPDOResult2 = $oBd->execute($sSql);
                      // */
                    ///*
                    // Insert de schemaGtf
                    $aParams = array();
                    $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                    $aParams['iOrderId'] = array('value' => $aDemande["order_id"], 'type' => 'number');
                    $aParams['iWorkspaceId'] = array('value' => $aDemande["workspace_id"], 'type' => 'number');
                    $aParams['iUserId'] = array('value' => $aDemande['user_id'], 'type' => 'number');
                    $aParams['sBeginExecutionDate'] = array('value' => $sBeginExecutionDate, 'type' => 'string');
                    $aParams['iDelay'] = array('value' => $iDelay, 'type' => 'number');
                    $aParams['iGtfEngineId'] = array('value' => $properties["id_gtf_engine"], 'type' => 'number');
                    $aParams['iDelay'] = array('value' => $iDelay, 'type' => 'number');
                    $aParams['iStatut'] = array('value' => $iStatut, 'type' => 'number');
                    //writeToLog('|INFORM|PHP|Test requête OG : '.$sSql,$properties["engine_log_file"]);
                    $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["insertJob"], $aParams);
                    //*/
                    if ($oBd->erreurRencontree) {
                        writeToLog(INFO_TEST_REQUEST_ERROR . '(' . $oBd->getBDMessage() . ')', $properties["engine_log_file"]);
                    }
                    // Fin - OG 27/03/2013 for table job
                    $oPDOResult2 = $oBd->fermeResultat();
                }
                // Mise à jour de la demande si resultat est vide
                if ($sResultat == "") {

                    /*
                      $sSql = $aSql[$properties["sgbd"]]["update_demande_resultat_null"];
                      $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                      $sSql = str_replace("[iOrderId]", $aDemande["order_id"], $sSql);
                      $oPDOResult2 = $oBd->execute($sSql);
                      // */

                    ///*
                    // Mise a jour de la demande si resultat null
                    $aParams = array();
                    $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                    $aParams['iOrderId'] = array('value' => $aDemande["order_id"], 'type' => 'number');
                    $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["update_demande_resultat_null"], $aParams);
                    //*/

                    if ($oBd->erreurRencontree) {
                        writeToLog(INFO_ORDER_UPDATE_ERROR . ' (' . $oBd->getBDMessage() . ')', $properties["engine_log_file"]);
                    } else {
                        writeToLog(INFO_INFO_ORDER_UPDATE_NULL, $properties["engine_log_file"]);
                        // La demande est terminée où en erreur
                        sendWebsocketMessage($properties['websocket_server'], $properties['websocket_port'], $properties['websocket_alias'], array(
                            'action' => 'event',
                            'service' => 'GtfEvents',
                            'data' => array(
                                'event' => 'order_finished_or_error',
                                'order' => array(
                                    'order_id' => $aDemande['order_id'],
                                    'order_status_id' => $aDemande['order_status_id'],
                                    'user_id' => $aDemande['user_id'],
                                    'workspace_id' => $aDemande['workspace_id']
                                )
                            )
                        ));
                    }
                    $oPDOResult2 = $oBd->fermeResultat();
                }

                // Notification par e-mail.
                $bMailToSend = false;
                switch (strtoupper(trim($aDemande['email_option_id']))) {
                    case 1:
                        $bMailToSend = True;
                        break;
                    case 2:
                        $bMailToSend = False;
                        break;
                    case 3:
                        if ($iStatut == $sEnErreur) {
                            $bMailToSend = True;
                        }
                        break;
                    case 4:
                        if ($iStatut != $sEnErreur) {
                            $bMailToSend = True;
                        }
                        break;
                    default:
                        $bMailToSend = True;
                }

                // Licence invalide.
                if ($iStatut == 2 && !$bLicenceIsValid) {
                    // Mise à jour de l'état de la demande de traitement (en attente).
                    $oBd->updateLinkedTable($properties["schema_gtf"] . ".order", "order_status_id", "order_id", $aDemande['order_id'], 1);
                    // Licence invalide : 1 mail par jour max.
                    $sToday = date('d/m/Y');
                    $sMailLicenceFile = __DIR__ . '\mail_licence.txt';
                    if (file_exists($sMailLicenceFile))
                        if (file_get_contents($sMailLicenceFile) == $sToday)
                            $bMailToSend = false;
                    file_put_contents($sMailLicenceFile, $sToday);
                    // Mise à jour du nombre de tentative dans la base.
                    $oBd->updateLinkedTable($properties["schema_gtf"] . ".order", "attempt", "order_id", $aDemande['order_id'], 0);
                }
                
                // Envoi du mail.
                if ($bMailToSend == true) {
                    /*
                      $sSql = $aSql[$properties["sgbd"]]["select_user"];
                      $sSql = str_replace("[iUserId]", $aDemande['user_id'], $sSql);
                      $sSql = str_replace("[sSchemaFramework]", $properties["schema_framework"], $sSql);
                      $oPDOResult2 = $oBd->execute($sSql);
                      // */
                    ///*
                    
                    //Mise a jour de la demande si resultat null
                    /*
                    $aParams = array();
                    $aParams['iOrderId'] = array('value' => $aDemande['order_id'], 'type' => 'number');
                    $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                    $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["update_demande_resultat_null"], $aParams);
                    if ($oBd->erreurRencontree) {
                        writeToLog(INFO_GET_USER_INFO_ERROR . $aDemande['user_id'] . ". (SQL = " . $sSql . ")", $properties["engine_log_file"]);
                    } else {
                    */
                        // $aUser = $oBd->ligneSuivante ($oPDOResult2);
                        // $sContenuMail = "Bonjour ".$aUser["name"].",<br><br><br>".$sContenuMail;
                        // $sContenuMail .= "<br><br><cite><h6>Cet e-mail a été envoyé par un robot, merci de ne pas répondre.</h6></cite><br>";
                        //	

                        if (empty($iEmailTemplateId))
                            $iEmailTemplateId = $properties['default_mail_model'];

                        /*
                          // Nom des moteurs GTF et FME
                          $sSql = $aSql[$properties["sgbd"]]["get_gtf_engine_name"];
                          $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                          $sSql = str_replace('[gtf_engine_id]', $aDemande['gtf_engine_id'], $sSql);
                          $oPDOResult2 = $oBd->execute($sSql);
                          // */
                        ///*
                        // Nom des moteurs GTF et FME
                        $aParams = array();
                        $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                        $aParams['gtf_engine_id'] = array('value' => $aDemande['gtf_engine_id'], 'type' => 'number');
                        $oPDOResult2 = $oBd->executeWithParams($sSql = $aSql[$properties["sgbd"]]["get_gtf_engine_name"], $aParams);
                        //*/


                        if ($oBd->erreurRencontree) {
                            writeToErrorLog(ERROR_0001);
                        } else
                            $aRow = $oBd->ligneSuivante($oPDOResult2);

                        // URL de téléchargement du résultat
                        $sResultUrl = '';
                        if ($sResultat != "")
                            $sResultUrl = '<a href="' . $properties["url_export"] . "/gtf/" . $sResultat . '">Télécharger le résultat</a>';

                        // Dates
                        $sOrderDate = date_format(date_create($aDemande['order_date']), 'd/m/Y H:i:s');

                        // Envoi du mail
                        $aObjects = array();
                        if (!empty($sMessage))
                            $aObjects['error'] = $sMessage;
                        $aObjects['oOrder'] = new OrderLib($oBd, $aDemande["order_id"], $properties, "v_order");
                        $aObjects['oOrder']->formatOrderEmail();
                        $oEmail = new Email($oBd, $iEmailTemplateId, $properties, $aObjects);
                        if (!empty($oEmail->oEmailTemplate->name))
                            $oEmail->send();
                    //}
                    $oPDOResult2 = $oBd->fermeResultat();
                } else {
                    // pas d'envoi de mail
                    writeToLog(INFO_NO_MAIL_SEND, $properties["engine_log_file"]);
                }
            } //fin du if sur les tentatives
            //fin de while	
        }
        if ($iNbTraitement >= 1) {
            //Crée ou modifie le fichier de maj de l'application pour l'utilisateur.
            writeToLog(INFO_END_ORDER_PROCESSING, $properties["engine_log_file"]);
        }
        $oPDOResult = $oBd->fermeResultat();
    }
} else {
    writeToErrorLog(constant($ErrorLicense));
}

//Teste si le traitement est autorisé si la demande est en heure creuse.
//retourne true si le traitement est autorisé, retourne false si le traitement n'est pas autorisé.
function TesteHeureCreuse($sHeureMin, $sHeureMax) {
    $sHeure = date('H');
    $sMinute = date('i');
    $aHeureMin = explode(":", $sHeureMin);
    $aHeureMax = explode(":", $sHeureMax);
    $bMax = false;
    $bMin = false;
    //Test de l'heure minimale.
    if ($sHeure > $aHeureMin[0]) {
        $bMin = true;
    } else {
        if ($sHeure == $aHeureMin[0] && $sMinute >= $aHeureMin[1]) {
            $bMin = true;
        }
    }
    //Test de l'heure maximale. 
    if ($sHeure < $aHeureMax[0]) {
        $bMax = true;
    } else {
        if (($aHeureMax[0] < $aHeureMin[0]) && ($sHeure < 24)) {
            $bMax = true;
        }
        if ($sHeure == $aHeureMax[0] && $sMinute <= $aHeureMax[1]) {
            $bMax = true;
        }
    }
    if ($bMin && $bMax) {
        return true;
    } else {
        return false;
    }
}

?>
