<?php

/**
 * \file subscription.php
 * \brief subscription.php \n \n Ce fichier contient un programme php.
 *
 * Ce programme permet de traiter les demandes d'abonnement de traitements.
 *
 * \author Laurent Panabieres <laurent.panabieres@veremes.com>
 */
//set_include_path(dirname($_SERVER["PHP_SELF"]).'/../gtf.client'.';'.dirname($_SERVER["PHP_SELF"]).'/php/lib');
//ini_set ('writeToErrorLog', dirname($_SERVER["PHP_SELF"]).'/php/php.log');
require_once ("php_engine_conf.inc");
require_once ("gtf_lib/GtfFmwParser.class.inc");
require_once ("vmlib/Vm.class.inc");
require_once ("vmlib/phpUtil.inc");
require_once("vmlib/dbUtil.inc");
//require_once ("robot_properties.inc");
//require_once ("engine_properties.inc");
$properties["id_gtf_engine"] = "";
require_once ("properties_engine.inc");
require_once ("subscription.sql.inc");
require_once ("vmlib/logUtil.inc");
require_once("Ldap.class.inc");
require_once 'vmlib/error.inc';
require_once 'string.inc';

//writeToLog('|INFO  |PHP| dump prop '. var_export($properties,true),$properties["subscription_log_file"]);

/*
  // Création du dossier journalier pour l'écriture du log
  if (!is_dir($properties["engine_log_home"]. "/".date($properties["log_period"]))){
  // Le dossier pour l'écritude du log n'existe pas, il est créé
  if (!mkdir($properties["engine_log_home"]. "/".($properties["log_period"]), 0777, true)) {
  writeToErrorLog(ERROR_0025.$properties["engine_log_home"]. "/".date($properties["log_period"]).'"');
  }
  }
 */
//Pas besoin de mot de passe pour le robot
$oBd = new Vm($properties["login_scheduler"], $properties['password_scheduler'], $properties["database"], $properties["server"], $properties["port"], $properties["sgbd"], $properties["page_encoding"]);
if ($oBd->erreurRencontree) {
    writeToLog(INFO_BASE_CONNECTION_ERROR . $properties["database"], $properties["subscription_log_file"]);
} else {
    writeToLog(INFO_BASE_CONNECT . $properties["database"], $properties["subscription_log_file"]);
    // Traitement des demandes d'abonnement.
    $iNbTraitement = 0;
    // Récupération de l'identifiant de la période d'abonnement qui est lancé !
    $iPeriodeId = $_SERVER['argv'][1];
    
    /*
    $sSql = $aSql[$properties["sgbd"]]["verif_period_id"];
    $sSql = str_replace("[iOrderPeriodId]", $iPeriodeId, $sSql);
    $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
    $oPDOResult = $oBd->execute($sSql);
    */
    
    // Récupération de l'identifiant de la période d'abonnement qui est lancé !
    $aParams = array();
    $aParams['iOrderPeriodId'] = array('value' => $iPeriodeId, 'type' => 'number');
    $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
    $oPDOResult = $oBd->executeWithParams($aSql[$properties["sgbd"]]["verif_period_id"], $aParams);

    if ($oBd->ligneSuivante($oPDOResult) != "") {
        
        /*
        $sSql = $aSql[$properties["sgbd"]]["abonnement"];
        $sSql = str_replace("[iOrderPeriodId]", $iPeriodeId, $sSql);
        $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
        $oPDOResult = $oBd->execute($sSql);
         */
        
        // Recuperation des éléments de gestion des abonnements Gtf
        $aParams = array();
        $aParams['iOrderPeriodId'] = array('value' => $iPeriodeId, 'type' => 'number');
        $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
        $oPDOResult = $oBd->executeWithParams($aSql[$properties["sgbd"]]["abonnement"], $aParams);
        
        while ($aDemande = $oBd->ligneSuivante($oPDOResult)) {
            if (is_null($aDemande['order_date'])) {
                $sDateTraitement = $aDemande['order_date'];
            } else {
                $sDateTraitement = $aDemande['execution_date'];
            }
            
            /*
            $sSql = $aSql[$properties["sgbd"]]["getLogin"];
            $sSql = str_replace("[sSchemaFramework]", $properties["schema_framework"], $sSql);
            $sSql = str_replace("[iUserId]", $aDemande['user_id'], $sSql);
            $oPDOResult2 = $oBd->execute($sSql);
            */
            
            // Récupération des information de connection de l'utilisateur et de ses droits
            $aParams = array();
            $aParams['sSchemaFramework'] = array('value' => $properties["schema_framework"], 'type' => 'schema_name');
            $aParams['iUserId'] = array('value' => $aDemande['user_id'], 'type' => 'number');
            $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["getLogin"], $aParams);
            
            $aUser = $oBd->ligneSuivante($oPDOResult2);
            $sGroupListId = getUserGroupsEngines($aUser["login"], $oBd, $properties["mixed_rights_management"]);
            writeToLog(INFO_SUBSCRIPTION_PROCESSING . $aDemande["order_id"], $properties["subscription_log_file"]);
            $iNbTraitement = $iNbTraitement + 1;
            //Vérification si l'utilisateur a les droits pour faire une demande de ce traitement.
            /*
            $sSql = $aSql[$properties["sgbd"]]["right_user"];
            $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
            $sSql = str_replace("[sGroupListId]", $sGroupListId, $sSql);
            $oPDOResult2 = $oBd->execute($sSql);
            */
            
            // Verification des droits utilisateur sur la demande
            $aParams = array();
            $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
            $aParams['sGroupListId'] = array('value' => str_replace(',', '|', $sGroupListId), 'type' => 'group');
            $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["right_user"], $aParams);

            if ($oBd->erreurRencontree) {
                writeToLog(INFO_REQUEST_ERROR . $sSql, $properties["subscription_log_file"]);
                writeToLog(INFO_PHP_ERROR, $properties["subscription_log_file"]);
            } else {
                if ($sGroupListId == "0") {
                    $bAutorisationDemande = true;
                } else {
                    $bAutorisationDemande = false;
                    while ($aTraitementsAutorise = $oBd->ligneSuivante($oPDOResult2)) {
                        if ($aTraitementsAutorise['workspace_id'] == $aDemande['workspace_id']) {
                            $bAutorisationDemande = true;
                        }
                    }
                }
                if ($bAutorisationDemande == true) {
                    //Création d'une nouvelle demande.
                    require_once("gtf_lib/gtf_object//Order.class.inc");
                    $iNouvelId = $oBd->insert($properties["schema_gtf"], "order", Array("priority_id" => 1, "workspace_id" => $aDemande['workspace_id'], "order_status_id" => 1, "user_id" => $aDemande['user_id'], "period_id" => "", "order_date" => date("Y-m-d H:i:s"), "execution_date" => null, "wk_params" => $aDemande['wk_params'], "result_url" => "", "message" => "", "email_option_id" => $aDemande['email_option_id'], "gtf_engine_id" => $aDemande['gtf_engine_id'], "email_notifications" => $aDemande['email_notifications']), $properties["schema_gtf"] . ".seq_order", "order_id");
                    $oOrder = new OrderLib($oBd, -1, $properties);
                    $oOrder->getIdEngine($iNouvelId, "order", $aDemande['workspace_id']);
                    $oOrder->update();
                    if ($iNouvelId != "") {
                        writeToLog(str_replace('[iNouvelId]', $iNouvelId, INFO_ORDER_CREATED), $properties["subscription_log_file"]);
                        // L'abonnement crée une demande
                        sendWebsocketMessage($properties['websocket_server'], $properties['websocket_port'], $properties['websocket_alias'], array(
                            'action' => 'event',
                            'service' => 'GtfEvents',
                            'data' => array(
                                'event' => 'subscription_creating_order',
                                'order' => array(
                                    'order_id' => $aDemande['order_id'],
                                    'order_status_id' => $aDemande['order_status_id'],
                                    'user_id' => $aDemande['user_id'],
                                    'workspace_id' => $aDemande['workspace_id']
                                )
                            )
                        ));
                    } else {
                        writeToLog(INFO_ORDER_CREATION_ERROR, $properties["subscription_log_file"]);
                        writeToLog(INFO_CHECK_SQL_LOG, $properties["subscription_log_file"]);
                    }
                } else {
                    writeToLog(INFO_NO_USER_GRANT . $aDemande['name'] . ' n\'as pas été définie.', $properties["subscription_log_file"]);
                    writeToLog(INFO_CONTACT_ADMINISTRATOR, $properties["subscription_log_file"]);
                    $iNouvelId = $oBd->update($properties["schema_gtf"], "order", Array("enabled" => FALSE), "order_id", $aDemande["order_id"], "");
                }
            }
            $oPDOResult2 = $oBd->fermeResultat();
        }
        /*
        $sSql = $aSql[$properties["sgbd"]]["dir_survey"];
        $sSql = str_replace("[iOrderPeriodId]", $iPeriodeId, $sSql);
        $sSql = str_replace("[sSchemaFramework]", $properties["schema_framework"], $sSql);
        $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
        writeToErrorLog($sSql);
        $oPDOResult = $oBd->execute($sSql);
        */
        
        $aParams = array();
        $aParams['iOrderPeriodId'] = array('value' => $iPeriodeId, 'type' => 'number');
        $aParams['sSchemaFramework'] = array('value' => $properties["schema_framework"], 'type' => 'schema_name');
        $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
        $oPDOResult = $oBd->executeWithParams($aSql[$properties["sgbd"]]["dir_survey"], $aParams);
        
        while ($aDemande = $oBd->ligneSuivante($oPDOResult)) {
            if (is_null($aDemande['order_date'])) {
                $sDateTraitement = $aDemande['order_date'];
            } else {
                $sDateTraitement = $aDemande['execution_date'];
            }
            //writeToLog(str_replace('[aDemande["order_id"]]', $aDemande["order_id"], INFO_CHECK_ORDER_FILES), $properties["subscription_log_file"]); 
            writeToLog(INFO_CHECK_DIRECTORY . $aDemande["condition"] . ' for survey order_id=' . $aDemande["order_id"], $properties["subscription_log_file"]);
            //parcours du dossier de la condition de la demande
            $sFolder = utf8_decode($aDemande["condition"]);
            if (is_dir($sFolder)) {
                $MyDirectory = opendir($sFolder);
                while ($Entry = @readdir($MyDirectory)) {

                    if ($Entry != '.' && $Entry != '..') {
                        //deplacement vers le dossier upload en fonction du type
                        $bCopie = false;
                        $bIsFile = false;
                        $sUnique = UniqFileName();
                        if (is_dir($sFolder . '/' . $Entry)) {
                            $bIsFile = false;
                            $bCopie = rename($sFolder . "/" . $Entry, $properties["upload_dir"] . "/" . $sUnique);
                            writeToLog(INFO_MOVE_DIRECTORY . $sFolder . "/" . $Entry . ' to ' . $properties["upload_dir"] . "/" . $sUnique, $properties["subscription_log_file"]);
                        } else {
                            $bIsFile = true;
                            mkdir($properties["upload_dir"] . "/" . $sUnique);
                            $bCopie = rename($sFolder . "/" . $Entry, $properties["upload_dir"] . "/" . $sUnique . "/" . $Entry);
                            writeToLog(INFO_MOVE_FILE . $sFolder . "/" . $Entry . ' to ' . $properties["upload_dir"] . "/" . $sUnique . "/" . $Entry, $properties["subscription_log_file"]);
                        }
                        if ($bCopie) {
                            //creation de la demande
                            //Vérification si l'utilisateur a les droits pour faire une demande de ce traitement.
                            /*
                            $sSql = $aSql[$properties["sgbd"]]["getLogin"];
                            $sSql = str_replace("[sSchemaFramework]", $properties["schema_framework"], $sSql);
                            $sSql = str_replace("[iUserId]", $aDemande['user_id'], $sSql);
                            $oPDOResult2 = $oBd->execute($sSql);
                            */
                            
                            // Récupération des infos utilisateurs
                            $aParams = array();
                            $aParams['sSchemaFramework'] = array('value' => $properties["schema_framework"], 'type' => 'schema_name');
                            $aParams['iUserId'] = array('value' => $aDemande['user_id'], 'type' => 'number');
                            $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["getLogin"], $aParams);

                            $aUser = $oBd->ligneSuivante($oPDOResult2);
                            $sGroupListId = getUserGroupsEngines($aUser["login"], $oBd, $properties["mixed_rights_management"]);
                            /*
                            $sSql = $aSql[$properties["sgbd"]]["right_user"];
                            $sSql = str_replace("[sSchemaGtf]", $properties["schema_gtf"], $sSql);
                            $sSql = str_replace("[sGroupListId]", $sGroupListId, $sSql);
                            $oPDOResult2 = $oBd->execute($sSql);
                            */
                            
                            // Vérification des droits de l'utilisateurs pour la demande
                            $aParams = array();
                            $aParams['sSchemaGtf'] = array('value' => $properties["schema_gtf"], 'type' => 'schema_name');
                            $aParams['sGroupListId'] = array('value' => str_replace(',', '|', $sGroupListId), 'type' => 'group');
                            $oPDOResult2 = $oBd->executeWithParams($aSql[$properties["sgbd"]]["right_user"], $aParams);

                            if ($oBd->erreurRencontree) {
                                writeToLog(INFO_REQUEST_ERROR . $sSql, $properties["subscription_log_file"]);
                                writeToLog(INFO_PHP_ERROR, $properties["subscription_log_file"]);
                            } else {
                                if ($sGroupListId == "0") {
                                    $bAutorisationDemande = true;
                                } else {
                                    $bAutorisationDemande = false;
                                    while ($aTraitementsAutorise = $oBd->ligneSuivante($oPDOResult2)) {
                                        if ($aTraitementsAutorise['workspace_id'] == $aDemande['workspace_id']) {
                                            $bAutorisationDemande = true;
                                        }
                                    }
                                }
                                if ($bAutorisationDemande == true) {
                                    //Création d'une nouvelle demande.
                                    //writeToLog($properties["workspace_dir"],$properties["subscription_log_file"]);
                                    $oGtfFmwParser = new GtfFmwParser($properties['vas_home'] . '/ws_data/gtf/workspace' . "/" . $aDemande['workspace_id'] . "/fme/" . $aDemande['fmw_file']);
                                    $iNouvelId = "";

                                    if ($bIsFile) {
                                        $aDemande['wk_params'] = getParams($oGtfFmwParser, $sUnique . "/" . utf8_encode($Entry), $aDemande['wk_params']);
                                    } else {
                                        $aDemande['wk_params'] = getParams($oGtfFmwParser, $sUnique . "/", $aDemande['wk_params']);
                                    }
                                    require_once("gtf_lib/gtf_object/Order.class.inc");
                                    $iNouvelId = $oBd->insert($properties["schema_gtf"], "order", Array("priority_id" => 1, "workspace_id" => $aDemande['workspace_id'], "order_status_id" => 1, "user_id" => $aDemande['user_id'], "period_id" => "", "order_date" => date("Y-m-d H:i:s"), "execution_date" => null, "wk_params" => $aDemande['wk_params'], "result_url" => "", "message" => "", "email_option_id" => $aDemande['email_option_id'], "gtf_engine_id" => $aDemande['gtf_engine_id'], "email_notifications" => $aDemande['email_notifications']), $properties["schema_gtf"] . ".seq_order", "order_id");
                                    $oOrder = new OrderLib($oBd, -1, $properties);
                                    $oOrder->getIdEngine($iNouvelId, "order", $aDemande['workspace_id']);
                                    $oOrder->update();
                                    if ($iNouvelId != "") {
                                        writeToLog(str_replace('[iNouvelId]', $iNouvelId, INFO_ORDER_CREATED), $properties["subscription_log_file"]);
                                        // La surveillance crée une demande
                                        sendWebsocketMessage($properties['websocket_server'], $properties['websocket_port'], $properties['websocket_alias'], array(
                                            'action' => 'event',
                                            'service' => 'GtfEvents',
                                            'data' => array(
                                                'event' => 'survey_creating_order',
                                                'order' => array(
                                                    'order_id' => $aDemande['order_id'],
                                                    'order_status_id' => $aDemande['order_status_id'],
                                                    'user_id' => $aDemande['user_id'],
                                                    'workspace_id' => $aDemande['workspace_id']
                                                )
                                            )
                                        ));
                                    } else {
                                        writeToLog(INFO_ORDER_CREATION_ERROR, $properties["subscription_log_file"]);
                                        writeToLog(INFO_CHECK_SQL_LOG, $properties["subscription_log_file"]);
                                    }
                                } else {
                                    writeToLog(INFO_NO_USER_GRANT . $aDemande['name'] . ' n\'as pas été définie.', $properties["subscription_log_file"]);
                                    writeToLog(INFO_CONTACT_ADMINISTRATOR, $properties["subscription_log_file"]);
                                    $iNouvelId = $oBd->update($properties["schema_gtf"], "order", Array("enabled" => FALSE), "order_id", $aDemande["order_id"], "");
                                }
                            }
                        }
                    }
                }
            } else {
                writeToLog(str_replace('[sFolder]', $sFolder, INFO_DIRECTORY_NOT_FOUND_SUBSCRIPTION), $properties["subscription_log_file"]);
            }
        }
    } else {
        writeToLog(str_replace('[iPeriodeId]', $iPeriodeId, INFO_ORDER_PERIOD_NOT_FOUND), $properties["subscription_log_file"]);
    }

    if ($iNbTraitement >= 1) {
        //writeToLog(INFO_END_ORDER_PROCESSING, $properties["subscription_log_file"]);
    }
    $oPDOResult = $oBd->fermeResultat();
}

function getParams($oGtfFmwParser, $sNewSource, $sParams) {
    $aTGui = array();
    $sChaine = "";
    $aParams = dbParamsAsArray($sParams);
    foreach ($oGtfFmwParser->aGuiObject as $aGui) {
        if ($aGui->sDefault_Macro != "") {
            array_push($aTGui, $aGui);
        }
    }
    foreach ($aTGui as $oGui) {
        //Teste si le paramètre est une source
        if ($oGui->bIsSource) {
            writeToErrorLog($oGui->sDefault_Macro);
            writeToErrorLog($sNewSource);
            $aParams[$oGui->sDefault_Macro] = $sNewSource;
        }
    }
    $aKeys = array_keys($aParams);

    for ($i = 0; $i < count($aKeys); $i++) {
        if ($sChaine == "") {
            $sChaine = $aKeys[$i] . "=" . $aParams[$aKeys[$i]];
        } else {
            $sChaine .= "|" . $aKeys[$i] . "=" . $aParams[$aKeys[$i]];
        }
    }
    //$sChaine = substr($sChaine, 0, -1)."\"";
    return $sChaine;
}

function dbParamsAsArray($sAllParams) {
    $aAllParams = Array();
    //$aLigne = explode("|", $sAllParams);
    $aLigne = stringExplode($sAllParams, "|", "\"", "\"");
    foreach ($aLigne as $sValeur) {
        $sValeur = str_replace("\"", "", $sValeur);
        $aValeurs = explode("=", $sValeur);
        if ($aValeurs[2] != "") {
            $sTemp = $aValeurs[1] . "=" . $aValeurs[2];
            $aValeurs[1] = $sTemp;
        }
        $aAllParams[$aValeurs[0]] = $aValeurs[1];
    }
    return $aAllParams;
}

?>