# Récupération des variables d'environnement
set sEnginesDir [file dirname $argv0]/..

set sGtfDir $env(GTF_HOME)
set sFmePath \{$env(FME_PATH)\}

# Lecture de la librairie tclUtil
source "$sEnginesDir/tcl/tclUtil.tcl"

# Récupération des parametres sous forme de variables TCL
set lLParams [stringToParam [lindex $argv 0] "|" "="]
set lParametre [lindex $lLParams 0]
set lValeur [lindex $lLParams 1]

set sFmwFileName [lindex $lValeur 0]
set sRobotLogName [lindex $lValeur 1] 
set sFmeLogName [lindex $lValeur 2] 

set i 0
set sFmeParam ""
foreach sParam $lParametre {
  if {$sParam!="LOG_ROBOT" && $sParam!="LOG_FILENAME" && $sParam!="FMWFILENAME"} then {
	set valeur [lindex $lValeur $i]
	
	# Vérification de l'emplacement de la balise <space>
	set iSpacePlace [string first <space> $valeur]
	# Si la balise existe, elle est remplacée par un espace (ça permet de gérer les cas ou la source (ex : de type access) peut contenir plusieurs extensions (mdb, accdb)
	if {$iSpacePlace > 0} then {
		set valeur [string map {<space> \ } $valeur]
	}
 	set sFmeParam "$sFmeParam --$sParam \{$valeur\}"
  }
	incr i 
}

# Création de nouvelles variables
set sScriptPath $sGtfDir/$sFmwFileName

# Ecriture des parametres du traitement FME dans le log
set sLigne "$sFmePath {$sScriptPath} $sFmeParam -LOG_FILENAME {$sFmeLogName}"

# Variable qui va permettre d'écrire la commande TCL dans un fichier avec un nom unique
set rand [expr int([expr rand() * 100000])]

set sCommandeFile "$sEnginesDir/tcl/$rand.tcl"

# Permet de récupérer un guillement (ajouté pour Edgar)
set sLigne [string map {<quote> \"} $sLigne] 
# Permet de récupérer un backslash (ajouté pour Edgar)
set sLigne [string map {<backslashes> \\} $sLigne]

set fCommande [open $sCommandeFile w+]
# subst -nobackslashes $sLigne -- ligne inutile. Mis en commentaire le 20/06/12 par L.P.	
puts $fCommande $sLigne
close $fCommande

if [ catch { source "$sCommandeFile" } sErreurFME] {
	puts stdout "1|$sErreurFME" 
} else {
	puts stdout "0|Traitement réalisé avec succés"
}

file delete -force $sCommandeFile

