# + ---------------------------------------------------------------------- +
# + tclUtil.tcl                                                            +
# + Fonction TCL qui peuvent tre rutilises                              +
# + Veremes - Fabien Marty - Mai 2007                                      +
# + ---------------------------------------------------------------------- +


##
#Dcoupe une chaine et renvoie les lments d'une liste 
#contenant une liste des paramtres et une liste des valeurs.
##

proc stringToParam {sString sDelimited1 sDelimited2} {
	set lParams [split $sString $sDelimited1]
	
	foreach sParam $lParams {
		set lResult [split $sParam =]
		set sParametre [lindex $lResult 0]
		set iLength [llength $lResult]
	
		if  { $iLength > 2 } {
		set i 1
		 while {$i < $iLength} {
			set sTemp [lindex $lResult $i]
			append sValeur $sTemp =
		  set i [incr i]
		 }

		set sValue [string trimright $sValeur =]
		} else {

		set sValue [lindex $lResult 1]
		}
	lappend lListeParam $sParametre
	lappend lListeValue $sValue
	}	
 return  [list $lListeParam $lListeValue]
}

##
#criture dans le log de la chaine passe en paramtre. 
##

proc writeToLog {sLogName sString sType} {
	set oLogFile [open $sLogName "a"]
	set sHeure [clock seconds]
	set sHeureFormat [clock format $sHeure -format "%d/%m/%Y %H:%M:%S" -gmt false]
	puts $oLogFile "$sHeureFormat	|$sType|TCL| $sString"
	close $oLogFile
}