<?php
require_once("vmlib/logUtil.inc");

class Action {
	protected $messageclass_action_id;
	protected $aParams;
	protected $oMessage;
	protected $aProperties;
	
/***********************************************************
  Récupère les paramètres de l'action d'un message
	\$messageclass_action_id : id de l'actionclass
	\$oMessage : objet du message
	\$aParams :  paramètres de l'actionclass
***********************************************************/
	function __construct($messageclass_action_id, $oMessage, $aParams) {
		$this->oMessage = $oMessage;
		$this->messageclass_action_id = $messageclass_action_id;
		$this->aProperties = $oMessage->aProperties;
	// Application des paramètres
		$this->setActionClassParameters($aParams);
	}

/*******************************************************
*******************************************************/
	function execute() {
	}

	function getError(){
		writeToLog("You need to implement your action error controller", $properties["processMessage_log_file"], false);
		writeToErrorLog("You need to implement your action error controller");
		return true;
	}

/*******************************************************
  
  \$aParams : Tableau des paramètres définis en base
*******************************************************/
	function setActionClassParameters($aParams) {
		if (!empty($aParams)) {
			$this->aParams = array();
			foreach($aParams as $sActionParam) {
				list($sActionParamName, $sActionParamValue) = explode('=', $sActionParam);
				eval('$this->aParams[\'' . $sActionParamName . '\'] = ' . $sActionParamValue . ';');
			}
			$this->aParams["token"] = $this->getToken($this->aProperties);
		}
	}

	function getToken ($properties) {

		if($properties['web_server_name'] === "[HTTP_HOST]"){
			$properties['web_server_name'] = "https://localhost";
		}
		$sUrl = $properties['web_server_name'] . '/' . $properties['services_alias'] . '/vitis/privatetoken';
		$postfields = array('user'=>$properties["login_bot"], 'password'=>$properties["pass_bot"]);

		$oToken = json_decode($this->postCurlRequest ($sUrl, $postfields));
		return $oToken->token;
	}

	function postCurlRequest ($sUrl, $postfields) {
		$ch = curl_init($sUrl);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array("Accept: application/json"));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postfields);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		return curl_exec($ch);
	}
}
?>
