<?php
require_once("vmlib/logUtil.inc");
require_once("Action.class.inc");

class BoAction Extends Action {
	protected $oBusinessObject;
	protected $bError;
/**********************************************************
  Class constructor
	\$oBd : objet PDO
	\$messageclass_action_id : id de l'actionclass
	\$oMessage : Objet de la classe message
	\$aParams :  paramètres de l'actionclass
**********************************************************/
	function __construct($oBd, $messageclass_action_id, $oMessage, $aParams, $properties) {
		parent::__construct($messageclass_action_id, $oMessage, $aParams);
		$iBoId = $oMessage->getBody($this->aParams['bo_id_attribute']);
		if (!empty($iBoId)){
			require_once($properties["vas_home"] ."/rest/ws/" . $this->aParams['module'] . "/" . $this->aParams['class'] . ".class.inc");
			$aPath = array($this->aParams['module'], $this->aParams['class'], $iBoId);
			$aValues = array($this->aParams['bo_id_attribute'] => $iBoId, "token" => $this->aParams['token']);

			$this->oBusinessObject = new $this->aParams['class']($aPath, $aValues, $properties);
			$this->oBusinessObject->oConnection->oBd = $oBd;
			$this->bError = false;
		} else {
			$this->bError = true;
		}
	}

/*******************************************************
  Change le statut.
*******************************************************/
	function execute() {
		$sTransitionMethod = $this->aParams['method'];
		$this->oBusinessObject->$sTransitionMethod();
	}

	function getError() {
		return $this->bError;
	}
}
?>
