<?php
require_once("vmlib/logUtil.inc");
require_once("vmlib/Email.class.inc");
require_once("Action.class.inc");

class EmailAction Extends Action {
	protected $oEmail;
	protected $bError;
/**********************************************************
  - Récupère les paramètres de l'action d'un message
  - Crée un objet de la classe "Email".
  - Applique les paramètres 
	\$oBd : objet PDO
	\$messageclass_action_id : id de l'actionclass
	\$oMessage : Objet de la classe message
	\$aParams :  paramètres de l'actionclass
**********************************************************/
	function __construct($oBd, $messageclass_action_id, $oMessage, $aParams) {
		parent::__construct($messageclass_action_id, $oMessage, $aParams);
		$aObjects['oMessage'] = $oMessage;
		$iEmailTemplateId = $this->aParams['template_id'];
		if (empty($iEmailTemplateId))
			$iEmailTemplateId = $oMessage->aProperties['default_mail_model'];
		$this->oEmail = new Email($oBd, $iEmailTemplateId, $oMessage->aProperties, $aObjects);
		$this->bError = false;
	}

/*******************************************************
  Envoi un email.
*******************************************************/
	function execute() {
		if (!empty($this->oEmail->oEmailTemplate->name))
			$this->oEmail->send();
	}

	function getError() {
		return $this->bError;
	}
}
?>
