<?php
/**
* \class Message
* \file Message.class.inc
*/

require_once("vmlib/logUtil.inc");

class Message {
	protected $message_id;
	public $messageclass;
	protected $creation_date;
	protected $status;
	protected $body;
	protected $bo_class_name;
	protected $bo_class;
	protected $bo_id;
	protected $sender;
	protected $oBo;
	protected $oBd;
	protected $aBodyValue;
	public $aProperties;
	protected $aSql;

	/**
	* Class constructor
	* \param $oBd Connection object.
	* \param $message_id Message id.
	* \param $aProperties Array of properties.
	*/
	function __construct($oBd, $message_id , $aProperties) {
		require("Message.class.sql.inc");
		$this->aProperties = $aProperties;
		$this->oBd = $oBd;
		$this->aSql = $aSql;
		$sSql = $this->aSql[$oBd->sgbd]['getMessage'];
		//$sSql = str_replace('[message_id]',$message_id , $sSql);
		//$sSql = str_replace('[schema]',$aProperties['schema_gtf'] , $sSql);
		$aParams = array(
			"message_id" => array("value"=> $message_id, "type"=> 'number'),
			"schema" => array("value"=> $aProperties['schema_gtf'], "type"=> 'column_name')
			);
		$oResult = $oBd->executeWithParams($sSql, $aParams);
		if($oBd->erreurRencontree)
			$sErrorMsg = $oBd->getBDMessage();
		else {
			if ($oBd->nombreLigne ($oResult) > 0) {
				$oRow = $oBd->objetSuivant ($oResult);
				$this->message_id = $oRow->message_id;
				$this->messageclass = $oRow->messageclass;
				$this->creation_date = $oRow->creation_date;
				$this->status = $oRow->status;
				$this->body = $oRow->body;
				//$this->bo_class_name = $oRow->bo_class_name;
				//$this->bo_id = $oRow->bo_id;
				$this->sender = $oRow->sender;
			// Extrait les paramètres pour les actions de body
				if (!empty($this->body)) {
					preg_match_all('/(.)+:(.)+/', $this->body, $aActionParams);
					if (!empty($aActionParams[0])) {
						foreach ($aActionParams[0] as $sActionParam) {
							list($sIndex, $sValue) = explode(':', $sActionParam);
							$this->aBodyValue[trim($sIndex)] = trim($sValue);
						}
					}
				}
			}
		}
		if (isset($sErrorMsg)){
			writeToLog("The message " . $message_id . "encountered this error : " . $sErrorMsg, $properties["processMessage_log_file"], false);
		}
	}

	/*
	* function setProcessed
	* \brief Change the status of a message.
	* \param $processed boolean.
	*/
	function setProcessed($processed) {
		if ($processed === true)
                $this->status = 3; // Traité
            else
                $this->status = 2; // En erreur
        }

	/*
	* function process
	* \brief Executes all actions of the message.
	*/
	function process() {
	// Liste des actions du message	
		$sSql = $this->aSql['pgsql']['getMessageActions'];
		//$sSql = str_replace("[messageclass]", $this->messageclass, $sSql);
		//$sSql = str_replace("[schema]", $this->aProperties['schema_gtf'], $sSql);
		$aParams = array(
			"messageclass" => array("value"=> $this->messageclass, "type"=> 'string'),
			"schema" => array("value"=> $this->aProperties['schema_gtf'], "type"=> 'column_name')
			);
		$oActionResult = $this->oBd->executeWithParams($sSql, $aParams);
		if(!$this->oBd->erreurRencontree) {
			if ($this->oBd->nombreLigne($oActionResult) > 0) {
				while ($oActionRow = $this->oBd->objetSuivant ($oActionResult)) {
					if (file_exists(__DIR__ . '/' . $oActionRow->actionclass . '.class.inc')) {
						require_once __DIR__ . '/' . $oActionRow->actionclass . '.class.inc';
						if (!empty($oActionRow->parameters))
							$aParams = explode('|', $oActionRow->parameters);
						$oAction = new $oActionRow->actionclass($this->oBd, $oActionRow->messageclass_action_id, $this, $aParams, $this->aProperties);
						if($oAction->getError() == false){
							$oAction->execute();
						} else {
							writeToLog("ERROR : cannot create action with this body's parameters", $properties["processMessage_log_file"], false);
							throw new Exception("ERROR : cannot create action with this body's parameters");
						}
					}
				}
			}
		}
	}
	
	/*
	* function getBody
	* \param $key boolean.
	* \return Returns the value of a parameter of action (or all the parameters and values).
	*/
	function getBody($key = null) {
		if (is_null($key))
			return $this->body;
		else {
			if (isset($this->aBodyValue[$key]))
				return $this->aBodyValue[$key];
			else
				return null;
		}
	}

	/*
	* function update
	* \brief Saves the settings of a message.
	*/
	function update() {
	// Tous les paramètres sauf les tableaux et objets	
		foreach (get_object_vars($this) as $sIndex => $value) {
			if (!is_array($value) && !is_object($value)) {
			// Le paramètre est une date ?	
				/*if (strtotime($value) !== false)
					$aValues[$sIndex] = "'$value'";
				else*/
					$aValues[$sIndex] = $value;
			}
		}
		//error_log(print_r($this->oBd, true));
		$this->oBd->update($this->aProperties['schema_gtf'], 'message', $aValues, 'message_id', $this->message_id, 'numeric');
	}
}
?>
