<?php
	session_start();
	
	require_once dirname($_SERVER['PHP_SELF']).'/../gtf.engines/php_engine_conf.inc';
	require_once dirname($_SERVER['PHP_SELF']).'/../gtf.engines/properties_engine.inc';
	
	require_once("vmlib/BD.class.inc");
	require_once("vmlib/Vm.class.inc"); 
	require_once("processMessages.sql.inc");
	require_once("class/Message.class.inc");

	$sPidFile = __DIR__ . "/PID_processMessages.pid";

	$oNow = new DateTime();
	$properties["processMessage_log_file"] = $properties['log_directories'] ['Application'] . "/processMessage/log_" . $oNow->format('Y-m-d') . ".log";

	processIsRunnning ($sPidFile, $properties);
	createPidFile($sPidFile, $properties);

	//journalisation des logs pour le mailReader aussi 
	// instanciation d'un objet pour accéder à la base compte u_vitis
	$oBd = new BD ($properties['login_scheduler'], $properties['password_scheduler'], $properties["database"], $properties["server"], $properties["port"], $properties["sgbd"], $properties["page_encoding"]);

	$iMessages = 0;
	$iMessagesTraite = 0;

	if ($oBd->erreurRencontree)
		writeToLog('can\'t connect to database ' . $properties["database"] . " on " . $properties["server"] . ":" . $properties["port"] , $properties["processMessage_log_file"], false);
	else {
		// Traitement des messages en attente.
		$sSql = $aSql['pgsql']['getWaitingMessages'];

		$aParams = array(
			"messageclass_type" => array("value"=> 'action', "type"=> 'string'),
			"schema" => array("value"=> $properties['schema_gtf'], "type"=> 'column_name')
			);

		$oMessageResult=$oBd->executeWithParams($sSql, $aParams);
		if(!$oBd->erreurRencontree) {
			$iMessages = $oBd->nombreLigne($oMessageResult);
			if ($iMessages > 0) {
                // fonction à appeler à la fin du script.
                register_shutdown_function('shutdownCallBack', $oBd, $properties);
                // Traitement des messages en attente.
                while ($oMessageRow = $oBd->objetSuivant ($oMessageResult)) {
                    $iMessageId = $oMessageRow->message_id;
                    $oMessage = new Message($oBd, $oMessageRow->message_id, $properties);
                    $iOrderId = $oMessage->getBody("order_id");
					if (!empty($iOrderId)){
						$sSql = $aSql['pgsql']['getOrderStatus'];;
						$sSql = str_replace("[ORDER_ID]", $iOrderId, $sSql);
						$oOrderResult=$oBd->execute($sSql);
						if(!$oBd->erreurRencontree) {
							$oOrderRow = $oBd->objetSuivant ($oOrderResult);
							if ($oOrderRow->order_status_id == 3 ){
								$oMessage->process();
								$oMessage->setProcessed(true);
							    $oMessage->update();
							    $iMessagesTraite ++;
							}else{
								writeToLog("message " . $iMessageId . " : can't be processing for the moment because the linked GTF order is not completed or it status is not 'valid'", $properties["processMessage_log_file"], false);
							}
						} else {
							$oMessage->setProcessed(false);
							$oMessage->update();
							writeToLog("message " . $iMessageId . " : can't be processing because we can't find the linked GTF order", $properties["processMessage_log_file"], false);
						}
					} else {
						$oMessage->process();
						$oMessage->setProcessed(true);
						$oMessage->update();
						$iMessagesTraite ++;
					}
                }
			}
		}else{
			writeToLog($oBd->getBDMessage(), $properties["processMessage_log_file"], false);
		}
	}

	writeToLog("Iteration of the process completed : " . $iMessages . "(". $iMessagesTraite ." as OK)", $properties["processMessage_log_file"], false);

	unlink($sPidFile);
        
	/*
	* function shutDownCallBack
	*   @oBd Database connection object.
	*   @properties
	*/
        function shutDownCallBack($oBd, $properties) {
            $aError = error_get_last();
            // Erreur fatale pendant le traitement d'un message ?
            if ($aError['type'] & E_ERROR > 0) {
                writeToLog("[ERROR] [PHP] while processing the message " . $GLOBALS['iMessageId'] . "check the main log file", $properties["processMessage_log_file"], false);
                // Change le statut du message : "en erreur".
                $oMessage = new Message($oBd, $GLOBALS['iMessageId'], $properties);
                $oMessage->setProcessed(false);
                $oMessage->update();
                // Re-exécute le script (au cas où il resterait des messages non traités).
                if(DIRECTORY_SEPARATOR === "/"){
                	// if linux
                	exec(__DIR__ . '/processMessages.sh');
                } else {
                	// if windows
                	exec(__DIR__ . '\processMessages.bat');
                }
            }
        }

        function processIsRunnning ($sPidFile, $properties){
			if (file_exists ($sPidFile)){
				// récupération du fichier .pid
				$sPid = file_get_contents($sPidFile);
				
				$bProcessIsRunning = true;
				$sOsName = PHP_OS;
				// detection de l'os pour savoir comment controler le PID
				if (strtoupper(substr($sOsName, 0, 3)) === 'WIN') {
			    	$bProcessIsRunning = windowsPidCheck($sPid);
				} else {
				    $bProcessIsRunning = linuxPidCheck($sPid);
				}

				if($bProcessIsRunning === false){
					//si le fichier PID est présent mais que le PID n'existe pas sur le serveur
					// on supprime le fichier .pid et on lance le mailReader 
					writeToLog("previous process exited without cleaning pidfile, removing", $properties["processMessage_log_file"], false);
					unlink($sPidFile);
				} else {
					//si le process tourne déjà on ferme le process courant
					writeToLog("found a running instance of processMessages.php, exiting.", $properties["processMessage_log_file"], false);
					exit(0);
				}
			}
			return true;
		}

		function windowsPidCheck ($iPid){
			// fonction pour controller si un pid existe sous windows
			$processes = explode( "\n", shell_exec('tasklist.exe /fi "PID eq ' . $iPid . '"'));

			foreach( $processes as $process ) {

			     if( ! empty($process) && (strpos("===", $process ) === 0) ){
			          continue;
			     }

			     $matches = array();
			     preg_match("/(.*?)\s+(\d+).*$/", $process, $matches);

			     if(count($matches) > 0){
			     	return true;
			     }
			}
			return false;
		}

		function linuxPidCheck ($iPid){
			// fonction pour controller si un pid existe sous linux
			return file_exists("/proc/" . $iPid);
		}

		function createPidFile($sPidFile , $properties){
		   	$file = fopen($sPidFile, 'w');
		   	
		   	if($file){ 
		   		writeToLog("PID file creation with pid : " . getmypid(), $properties["processMessage_log_file"], false);
		   		fwrite($file, getmypid());
			}

		   	fclose($file);
		}
?>