// Google closure
goog.provide("vitis.controllers.projectDirectory");
goog.require("vitis.modules.main");

/**
 * projectDirectory Controller.
 * .
 * @param {angular.$log} $log Angular log service.
 * @param {angular.$scope} $scope Angular scope.
 * @param {service} envSrvc Paramètres d'environnement.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @ngInject
 **/
vitisApp.projectDirectoryCtrl = function ($log, $scope, propertiesSrvc, envSrvc) {
        // Initialisation
        $log.info("initProjectDirectory");
        $scope["aTreeviewLogs"] = {};
        
        /**
         * downloadFile function.
         * Téléchargement du fichier sélectionné.
         **/
        $scope["downloadFile"] = function() {
                var aFiles = $scope["aSelectedWorkspaceFile"];
                var sFileName = aFiles[0].split("/").pop();
                $scope.$root["downloadGtfWorkspaceFile"](sFileName);
        };
        
        /**
         * deleteFile function.
         * Suppression d'un fichier dans le répertoire du projet fme.
         **/
        $scope["deleteFile"] = function() {
                var aFiles = $scope["aSelectedWorkspaceFile"];
                // Au moins un fichier à supprimer ?
                if (aFiles.length > 0) {
                        var oOptions = {
                                "className": "modal-warning",
                                "message": "CONFIRM_DELETE_FILE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY",
                                "callback": function(bResponse) {
                                        if (bResponse) {
                                                var oParams = {
                                                        "file_name": aFiles[0].split("/").pop()
                                                };
                                                ajaxRequest({
                                                    "method": "DELETE",
                                                    "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/Workspaces/" + envSrvc["sId"] + "/File",
                                                    "params": oParams,
                                                    "scope": $scope,
                                                    "success": function(response) {
                                                        if (response["data"]["status"] == 1) {
                                                                // Recharge  la liste des fichiers.
                                                                $scope["loadTreeview"]();
                                                        }
                                                        else {
                                                                // Affichage de la fenêtre modale d'erreur.
                                                                $scope["modalWindow"]("dialog", response["data"]["errorMessage"], {"className": "modal-danger"});
                                                        }
                                                    }
                                                });
                                        }
                                }
                        };
                        $scope["modalWindow"]("confirm", "", oOptions);
                }
        };
};
vitisApp.module.controller("projectDirectoryCtrl", vitisApp.projectDirectoryCtrl);
