// Google closure
goog.provide("vitis.controllers.statistics");
goog.require("vitis.modules.main");

/**
 * statistics Controller.
 * .
 * @param {angular.$log} $log Angular log service.
 * @param {angular.$rootScope} $rootScope Angular rootScope.
 * @param {angular.$scope} $scope Angular scope.
 * @param {service} envSrvc Paramètres d'environnement.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @ngInject
 **/
vitisApp.statisticsCtrl = function ($log, $rootScope, $scope, envSrvc, propertiesSrvc) {
        // Initialisation
        $log.info("initStatistics");
        //
        sessionStorage["statistics_web_service_url"] = propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/statistics/";
        //
        $scope["bStatsLoaded"] = false;
        // Fichiers javascript de RGraph.
        var aJsScript = ["javascript/externs/rgraph/RGraph.common.core_min.js",
                        "javascript/externs/rgraph/RGraph.common.effects_min.js",
                        "javascript/externs/rgraph/RGraph.common.dynamic_min.js",
                        "javascript/externs/rgraph/RGraph.common.key_min.js",
                        "javascript/externs/rgraph/RGraph.common.tooltips_min.js",
                        "javascript/externs/rgraph/RGraph.common.context_min.js",
                        "javascript/externs/rgraph/RGraph.drawing.text_min.js",
                        "javascript/externs/rgraph/RGraph.drawing.rect_min.js",
                        "javascript/externs/rgraph/RGraph.bar_min.js",
                        "javascript/externs/rgraph/RGraph.pie_min.js",
                        "javascript/externs/rgraph/RGraph.scatter_min.js"
        ];
        // Fichier "statistics.js" uniquement en mode "debug".
        if (sessionStorage['debug'] == "true")
            aJsScript.push("modules/gtf/javascript/statistics.js");
        // Chargement des fichiers.
        loadExternalJs(aJsScript, {
                "callback": function(){
                    $scope["bStatsLoaded"] = true;
                }
        });
        
        // Valeurs du formulaire des stats.
        envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]] = {
                "max_elements": 5,
                "max_labels_characters": 50,
                "view_id": "view_graph",
                "first_day_week": "",
                "per_date_sql": "",
                "date_format": "d/m/Y",
                "graph_type": "",
                "per_type_save": ""
        };
        
        // Sauve les valeurs du form.
        envSrvc["oFormDefaultValues"][envSrvc["sFormDefinitionName"]] = angular.copy(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]);
        
        // Attends la fin de la compilation du formulaire.
        var clearListener = $rootScope.$on("formExtracted", function(event) {
                // Supprime le "listener".
                clearListener();
                var iIntervalId = setInterval(function() {
                    if ($scope["bStatsLoaded"]) {
                        clearInterval(iIntervalId);
                        // Lance le script des stats.
                        initStatistics();
                        // Recalcule les stats si les dimensions de la fenêtre changent.
                        window.addEventListener("resize", $rootScope["refreshStatistics"]);
                    }
                }, 100);
        });
};
vitisApp.module.controller("statisticsCtrl", vitisApp.statisticsCtrl);
