// Google closure
goog.provide("vitis.controllers.subForm");
goog.require("vitis.modules.main");

/**
 * subForm Controller.
 * .
 * @param {angular.$log} $log Angular log service.
 * @param {angular.$scope} $scope Angular scope.
 * @param {$translateProvider.$translate} $translate TranslateProvider translate service.
 * @ngInject
 **/
vitisApp.subFormCtrl = function ($log, $scope, $translate) {
        // Initialisation
        $log.info("initSubForm");
        
        // Traductions des intitulés des actions sur le formulaire.
        $translate([
                "FORM_PREVISU_PUBLISHED_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_PREVISU_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_PREVISU_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_CODE_PUBLISHED_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_CODE_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_CODE_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_GENERATE_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_PUBLISH_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_PUBLISH_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM",
                "FORM_COPY_DEFAULT_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM"]
        ).then(function (translations) {
                // Données du <select>.
                $scope["oWorkspaceChoice"] = {
                        "selectedOption": {"value": 1},
                        "options": [
                                {"label": translations["FORM_PREVISU_PUBLISHED_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 1},
                                {"label": translations["FORM_PREVISU_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 2},
                                {"label": translations["FORM_PREVISU_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 3},
                                {"label": translations["FORM_CODE_PUBLISHED_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 4},
                                {"label": translations["FORM_CODE_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 5},
                                {"label": translations["FORM_CODE_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 6},
                                {"label": translations["FORM_GENERATE_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 7},
                                {"label": translations["FORM_PUBLISH_DEFAULT_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 9},
                                {"label": translations["FORM_PUBLISH_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 10},
                                {"label": translations["FORM_COPY_DEFAULT_CUSTOM_PUBLICATION_WORKSPACE_SUB_FORM"], "value": 11}
                        ]
                };
        });
};
vitisApp.module.controller("subFormCtrl", vitisApp.subFormCtrl);
