// Google closure
goog.provide("vitis.directives.importWorkspace");
goog.require("vitis.modules.main");

/**
 * appImportWorkspace directive.
 * Association du contrôleur à la directive.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @ngInject
 * @export
 **/
vitisApp.appImportWorkspaceDrtv = function(propertiesSrvc,sessionSrvc) {
        return {
                restrict: 'A',
                controller : 'importWorkspaceCtrl',
                controllerAs : 'ctrl',
                link: function (scope, element, attrs) {
                        $("#publication_workspace_import_workspace_fmw_file")["fileinput"]({
                                "language": propertiesSrvc["language"],
                                "uploadUrl": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces?mode=import",
                                "uploadExtraData":{"mode":"import", "token":sessionSrvc['token']},
                                "uploadAsync": false,
                                //"showUpload": false,
                                "showRemove": false,
                                "minFileCount": 1,
                                //"maxFileCount": 10,
                                "mainClass": "input-file-xs",
                                "allowedFileExtensions": ["fmw"],
                                "removeFromPreviewOnError": true,
                                "previewTemplates": {
                                        "object": '<div class="file-preview-frame" id="{previewId}" data-fileindex="{fileindex}" title="{caption}" height:20px;">\n' +
                                                        '{footer}\n' +
                                                    '</div>'
                                },
                                "previewSettings": {
                                        object: {width: "213px", height: "70px"}
                                }
                        }).on('fileloaded', function(event, file, previewId, index, reader) {
                            var sFileExtension = document.getElementById(previewId).title.split(".").pop();
                            if (sFileExtension == "" || sFileExtension != "fmw")
                                document.querySelector("#" + previewId + " .kv-file-remove").click();
                        });
                        // Attends la suppression du scope.
                        scope.$on("$destroy", function () {
                            // Supprime le treeview.
                            $("#publication_workspace_import_workspace_fmw_file")["fileinput"]("destroy");
                        });
                }
        }
};
vitisApp.module.directive("appImportWorkspace", vitisApp.appImportWorkspaceDrtv);

/**
 * appImportWorkspaceForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appImportWorkspaceFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appImportWorkspaceForm", vitisApp.appImportWorkspaceFormDrtv);
