// Google closure
goog.provide("vitis.directives.order");
goog.require("vitis.modules.main");

/**
 * appOrder directive.
 * Association du contrôleur à la directive.
 * @export
 **/
vitisApp.appOrderDrtv = function() {
        return {
                restrict: 'A',
                controller : 'orderCtrl',
                controllerAs : 'ctrl'
        }
};
vitisApp.module.directive("appOrder", vitisApp.appOrderDrtv);

/**
 * appOrderLeftForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appOrderLeftFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appOrderLeftForm", vitisApp.appOrderLeftFormDrtv);

/**
 * appOrderRightForm directive.
 * Formulaire du projet FME.
 **/
vitisApp.appOrderRightFormDrtv = function() {
        return {
                replace: true,
                scope: true,
                link: function (scope, element, attrs) {
                        scope["tab_id"] = "order";
                        scope["initSubForm"](scope, element);
                }
        }
};
vitisApp.module.directive("appOrderRightForm", vitisApp.appOrderRightFormDrtv);