// Google closure
goog.provide("vitis.directives.projectDirectory");
goog.require("vitis.modules.main");

/**
 * appProjectDirectory directive.
 * Association du contrôleur à la directive.
 * @param {angular.$rootScope} $rootScope Angular rootScope.
 * @ngInject
 * @export
 **/
vitisApp.appProjectDirectoryDrtv = function($rootScope) {
        return {
                restrict: 'A',
                controller : 'projectDirectoryCtrl',
                controllerAs : 'ctrl',
                scope: true,
                link: function (scope, element, attrs) {
                        // Attends le chargement de la structure et des données du formulaire.
                        var clearListener = $rootScope.$on('endFormNgRepeat', function(event) {
                                // Redimensionne le conteneur.
                                scope.$root["resizeProjectDirectoryTreeviewContainer"]();
                                window.addEventListener("resize", scope.$root["resizeProjectDirectoryTreeviewContainer"]);
                                // Supprime le "listener".
                                clearListener();
                        });
                        // Attends la suppression du scope.
                        scope.$on("$destroy", function () {
                            // Supprime l'évènement.
                            window.removeEventListener("resize", scope.$root["resizeProjectDirectoryTreeviewContainer"]);
                        });
                }
        }
};
vitisApp.module.directive("appProjectDirectory", vitisApp.appProjectDirectoryDrtv);

/**
 * appProjectDirectoryForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appProjectDirectoryFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appProjectDirectoryForm", vitisApp.appProjectDirectoryFormDrtv);

/**
 * appProjectDirectoryTreeview directive.
 * Crée le treeview du répertoire du projet Fme.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @param {service} envSrvc Paramètres d'environnement.
 * @ngInject
 **/
vitisApp.appProjectDirectoryTreeviewDrtv = function(propertiesSrvc, envSrvc) {
        return {
                //replace: true,
                link: function (scope, element, attrs) {
                        /**
                         * loadTreeview function.
                         * Crée le treeview des fichiers du projet fme.
                         **/
                        scope["loadTreeview"] = function() {
                        // Charge l'arborescence des logs.
                            ajaxRequest({
                                "method": "GET",
                                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/Workspaces/" + envSrvc["sId"] + "/Tree",
                                "scope": scope,
                                "success": function(response) {
                                    if (response["data"]["status"] == 1) {
                                        data = response["data"]["tree"];
                                        scope["aSelectedWorkspaceFile"] = [];
                                        scope["aTreeviewLogs"] = data;
                                        // Crée l'arborescence dans l'élément.
                                        $(element)["treeview"]({
                                                "showBorder": false,
                                                "expandIcon": "glyphicon glyphicon-folder-close",
                                                "collapseIcon": "glyphicon glyphicon-folder-open",
                                                "onNodeSelected": function(event, data) {
                                                        scope["aSelectedWorkspaceFile"].push(data["path"]);
                                                },
                                                "onNodeUnselected": function(event, data) {
                                                        scope["aSelectedWorkspaceFile"] = [];
                                                },
                                                //"showTags": true,
                                                "highlightSelected": true,
                                                "multiSelect": false,
                                                //"showCheckbox": true,
                                                "showTags": true,
                                                "data": scope["aTreeviewLogs"]["data"]
                                        });
                                    }
                                }
                            });
                        };
                                
                        // Crée le treeview.
                        scope["loadTreeview"]();
                        
                        // Attends la suppression du scope.
                        scope.$on("$destroy", function () {
                            // Supprime le treeview.
                            $("#" + element[0].id)["treeview"]("remove");
                        });
                }
        }
};
vitisApp.module.directive("appProjectDirectoryTreeview", vitisApp.appProjectDirectoryTreeviewDrtv);

