// Google closure
goog.provide("vitis.directives.statistics");
goog.require("vitis.modules.main");

/**
 * appStatisticsForm directive.
 * Charge le template des éléments de formulaire.
 * @export
 **/
vitisApp.appStatisticsFormDrtv = function() {
        return {
                restrict: 'A',
                controller : 'statisticsCtrl',
                controllerAs : 'ctrl',
                replace: true,
                templateUrl: "templates/formTpl.html",
                link: function (scope, element, attrs) {
                        // Classe css du conteneur des graphiques.
                        $("#double_form_right_section_statistics_gtf_statistics").addClass("statistics-graphs-container");
                        // Attends la suppression du scope.
                        scope.$on("$destroy", function () {
                            // Supprime l'évènement.
                            window.removeEventListener("resize", scope.$root["refreshStatistics"]);
                        });
                }
        }
};
vitisApp.module.directive("appStatisticsForm", vitisApp.appStatisticsFormDrtv);