// Google closure
goog.provide("vitis.directives.subForm");
goog.require("vitis.modules.main");

/**
 * appSubFormContainer directive.
 * Association du contrôleur à la directive.
 * @export
 **/
vitisApp.appSubFormContainerDrtv = function() {
        return {
                restrict: 'A',
                controller : 'subFormCtrl',
                controllerAs : 'ctrl',
                link: function (scope, element, attrs) {
                        // Hauteur du conteneur du formulaire.
                        element[0].style.height = "calc(100% - 34px)";
                }
        }
};
vitisApp.module.directive("appSubFormContainer", vitisApp.appSubFormContainerDrtv);

/**
 * appSubFormFormular directive.
 * Formulaire du projet FME.
 * @param {angular.$templateRequest} $templateRequest Angular templateRequest service.
 * @param {angular.$compile} $compile Angular compile.
 * @param {angular.$rootScope} $rootScope Angular rootScope.
 * @param {service} envSrvc Paramètres d'environnement.
 * @param {service} formSrvc Service de gestion des formulaires.
 * @param {service} propertiesSrvc Paramètres des properties.
 * @param {service} sessionSrvc Service de gestion des sessions.
 * @param {service} modesSrvc Liste des modes et objets de l'utilisateur.
 * @ngInject
 **/
vitisApp.appSubFormFormularDrtv = function($templateRequest, $compile, $rootScope, envSrvc, formSrvc, propertiesSrvc, sessionSrvc, modesSrvc) {
        return {
                replace: true,
                scope: true,
                link: function (scope, element, attrs) {
                        // Sauve le nouveau scope crée dans la définition de l'onglet. 
                        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
                        // Nom + url du formulaire.
                        scope["sFormDefinitionName"] = envSrvc["sFormDefinitionName"].replace(/_form/, "_subform");
                        // Paramètres pour la requête ajax du subform.
                        scope["oFormRequestParams"] = {
                                "sUrl": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces/" + envSrvc["sId"],
                                "sResourceId": "gtf/workspaces",
                                "oParams": {
                                        "form": "Published"
                                },
                                "sExtractData": "extractSubformData(oFormRequestParams)"
                        };
                        // Suppression de la définition et des données du formulaire (sinon problème de cache...).
                        scope.$root["clearFormData"](scope["sFormDefinitionName"], scope);
                        //formSrvc["clearFormData"](scope["sFormDefinitionName"]);
                        // Compilation du template de formulaire.
                        $templateRequest("templates/formTpl.html").then(function(sTemplate) {
                                $compile($(element).html(sTemplate).contents())(scope);
                                var clearFormDefListener = $rootScope.$on('formDefinitionLoaded', function(event, sFormDefinitionName) {
                                        // Titre du formulaire.
                                        scope.$parent["sSubFormTitle"] = envSrvc["oFormDefinition"][scope["sFormDefinitionName"]]["title"];
                                        // Supprime le "listener".
                                        clearFormDefListener();
                                });
                        });                        
                }
        }
};
vitisApp.module.directive("appSubFormFormular", vitisApp.appSubFormFormularDrtv);