// Google closure
goog.provide("vitis.directives.subscription");
goog.require("vitis.modules.main");

/**
 * appSubscription directive.
 * Association du contrôleur à la directive.
 * @export
 **/
vitisApp.appSubscriptionDrtv = function() {
        return {
                restrict: 'A',
                controller : 'subscriptionCtrl',
                controllerAs : 'ctrl'
        }
};
vitisApp.module.directive("appSubscription", vitisApp.appSubscriptionDrtv);

/**
 * appSubscriptionForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appSubscriptionFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appSubscriptionForm", vitisApp.appSubscriptionFormDrtv);

/**
 * appSubscriptionRightForm directive.
 * Formulaire du projet FME.
 **/
vitisApp.appSubscriptionRightFormDrtv = function() {
        return {
                replace: true,
                scope: true,
                link: function (scope, element, attrs) {
                        scope["tab_id"] = "subscription";
                        scope["initSubForm"](scope, element);
                }
        }
};
vitisApp.module.directive("appSubscriptionRightForm", vitisApp.appSubscriptionRightFormDrtv);