// Google closure
goog.provide("vitis.directives.survey");
goog.require("vitis.modules.main");

/**
 * appSurvey directive.
 * Association du contrôleur à la directive.
 * @export
 **/
vitisApp.appSurveyDrtv = function() {
        return {
                restrict: 'A',
                controller : 'surveyCtrl',
                controllerAs : 'ctrl'
        }
};
vitisApp.module.directive("appSurvey", vitisApp.appSurveyDrtv);

/**
 * appSurveyForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appSurveyFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appSurveyForm", vitisApp.appSurveyFormDrtv);

/**
 * appSurveyRightForm directive.
 * Formulaire du projet FME.
 **/
vitisApp.appSurveyRightFormDrtv = function() {
        return {
                replace: true,
                scope: true,
                link: function (scope, element, attrs) {
                        scope["tab_id"] = "survey";
                        scope["initSubForm"](scope, element);
                }
        }
};
vitisApp.module.directive("appSurveyRightForm", vitisApp.appSurveyRightFormDrtv);