// Google closure
goog.provide("vitis.directives.userOrder");
goog.require("vitis.modules.main");

/**
 * appUserOrder directive.
 * Association du contrôleur à la directive.
 * @export
 **/
vitisApp.appUserOrderDrtv = function() {
        return {
                restrict: 'A',
                controller : 'userOrderCtrl',
                controllerAs : 'ctrl'
        }
};
vitisApp.module.directive("appUserOrder", vitisApp.appUserOrderDrtv);

/**
 * appUserOrderLeftForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appUserOrderLeftFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appUserOrderLeftForm", vitisApp.appUserOrderLeftFormDrtv);

/**
 * appUserOrderRightForm directive.
 * Formulaire du projet FME.
 **/
vitisApp.appUserOrderRightFormDrtv = function() {
        return {
                replace: true,
                scope: true,
                link: function (scope, element, attrs) {
                        scope["tab_id"] = "order";
                        scope["initSubForm"](scope, element);
                }
        }
};
vitisApp.module.directive("appUserOrderRightForm", vitisApp.appUserOrderRightFormDrtv);