// Google closure
goog.provide("vitis.directives.userSubscription");
goog.require("vitis.modules.main");

/**
 * appUserSubscription directive.
 * Association du contrôleur à la directive.
 * @export
 **/
vitisApp.appUserSubscriptionDrtv = function() {
        return {
                restrict: 'A',
                controller : 'userSubscriptionCtrl',
                controllerAs : 'ctrl'
        }
};
vitisApp.module.directive("appUserSubscription", vitisApp.appUserSubscriptionDrtv);

/**
 * appUserSubscriptionForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appUserSubscriptionFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appUserSubscriptionForm", vitisApp.appUserSubscriptionFormDrtv);

/**
 * appUserSubscriptionRightForm directive.
 * Formulaire du projet FME.
 **/
vitisApp.appUserSubscriptionRightFormDrtv = function() {
        return {
                replace: true,
                scope: true,
                link: function (scope, element, attrs) {
                        scope["tab_id"] = "subscription";
                        scope["initSubForm"](scope, element);
                }
        }
};
vitisApp.module.directive("appUserSubscriptionRightForm", vitisApp.appUserSubscriptionRightFormDrtv);