// Google closure
goog.provide("vitis.directives.userSurvey");
goog.require("vitis.modules.main");

/**
 * appUserSurvey directive.
 * Association du contrôleur à la directive.
 * @export
 **/
vitisApp.appUserSurveyDrtv = function() {
        return {
                restrict: 'A',
                controller : 'userSurveyCtrl',
                controllerAs : 'ctrl'
        }
};
vitisApp.module.directive("appUserSurvey", vitisApp.appUserSurveyDrtv);

/**
 * appUserSurveyForm directive.
 * Charge le template des éléments de formulaire.
 **/
vitisApp.appUserSurveyFormDrtv = function() {
        return {
                replace: true,
                templateUrl: "templates/formTpl.html"
        }
};
vitisApp.module.directive("appUserSurveyForm", vitisApp.appUserSurveyFormDrtv);

/**
 * appUserSurveyRightForm directive.
 * Formulaire du projet FME.
 **/
vitisApp.appUserSurveyRightFormDrtv = function() {
        return {
                replace: true,
                scope: true,
                link: function (scope, element, attrs) {
                        scope["tab_id"] = "survey";
                        scope["initSubForm"](scope, element);
                }
        }
};
vitisApp.module.directive("appUserSurveyRightForm", vitisApp.appUserSurveyRightFormDrtv);