/* global vitisApp, angular, goog, oVFB */

'use strict';

goog.provide('vitis.gtf.script_module');
goog.require('vitis.gtf');
goog.require('oVFB');

vitisApp.on('appMainDrtvLoaded', function () {

    // S'inscrit au service WebSocket VmapEvents    
    if (goog.isDefAndNotNull(vitisApp['oWebsocket'])) {
        vitisApp['oWebsocket'].subscribeService('GtfEvents');
    }

    // Évènements de rechargement
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('my_work_gtf_user_order', 'order_started', function (oResult) {
        if (!goog.isDefAndNotNull(oResult['order'])) {
            return false;
        }
        if (!goog.isDefAndNotNull(oResult['order']['user_id'])) {
            return false;
        }
        if (sessionStorage['user_id'] == oResult['order']['user_id']) {
            return true;
        }
        return false;
    });
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('my_work_gtf_user_order', 'order_finished_with_result', function (oResult) {
        if (!goog.isDefAndNotNull(oResult['order'])) {
            return false;
        }
        if (!goog.isDefAndNotNull(oResult['order']['user_id'])) {
            return false;
        }
        if (sessionStorage['user_id'] == oResult['order']['user_id']) {
            return true;
        }
        return false;
    });
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('my_work_gtf_user_order', 'order_finished_or_error', function (oResult) {
        if (!goog.isDefAndNotNull(oResult['order'])) {
            return false;
        }
        if (!goog.isDefAndNotNull(oResult['order']['user_id'])) {
            return false;
        }
        if (sessionStorage['user_id'] == oResult['order']['user_id']) {
            return true;
        }
        return false;
    });
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('supervision_gtf_order', 'order_finished_with_result');
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('supervision_gtf_order', 'order_finished_or_error');
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('supervision_gtf_order', 'order_started');
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('my_work_gtf_user_subscription', 'subscription_creating_order');
    angular.element(vitisApp.appMainDrtv).scope()['refreshGridByEvent']('my_work_gtf_user_survey', 'survey_creating_order');
    

    angular.element(vitisApp.appHtmlFormDrtv).scope().$on("updateStudio_publication_gtf_workspace", function (event, data) {
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        var sessionSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["sessionSrvc"]);
        if (data["index"] === 3 && data["oSectionForm"]["template"] === "modules/gtf/templates/subFormTpl.html") {
            //console.log("gtf studio update **************************");
            oVFB["reset"]();
            oVFB["setId"](envSrvc["sId"]);
            oVFB["setToken"](sessionSrvc["token"]);
            oVFB["setApplication"]("gtf");
            oVFB["setContainer"]("#container_section_" + envSrvc["oSelectedObject"]["name"] + "_SubForm");
            oVFB["setAppProperties"](propertiesSrvc);
        }
    });

    /**
     * loadStatistics function.
     * Paramétrage avant la compilation du template de statistiques.
     */
    angular.element(vitisApp.appStatisticsFormDrtv).scope()["loadStatistics"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["envSrvc"]);
        // Passage en mode "Update" (pour le formulaire).
        envSrvc["sMode"] = "update";
        $log.info("loadStatistics");
    };

    /**
     * showSupervisionRecap function.
     * Affiche le bandeau récapitulatif de la supervision (Etat des demandes, abonnements, surveillances, messages).
     */
    angular.element(vitisApp.appWorkspaceListDrtv).scope()["showSupervisionRecap"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$log"]);
        var $timeout = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$timeout"]);
        var $templateRequest = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$templateRequest"]);
        var $compile = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$compile"]);
        var $rootScope = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$rootScope"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        var externFunctionSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["externFunctionSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        // Log.
        $log.info("showSupervisionRecap");
        // Récupération du scope de la liste actuellement affichée.
        var $scope = angular.element("#" + envSrvc["oSelectedObject"]["name"] + "_" + envSrvc["sSelectedSectionName"] + "_grid").scope();
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], $scope);
        // Mise à jour de l'état des demandes.
        $scope["refreshSupervisionRecap"]();
        // Actualisation de la barre de recap des demandes, abonnements, surveillances à chaque chargement ou raffraîchissement de la liste.
        $rootScope["gridApi"][$scope["sSelectedGridOptionsName"]]["grid"]["options"]["appBeforeEvent"] = "refreshSupervisionRecap()";
        // Compile le template du récap. de la supervision.
        $timeout(function () {
            var sTemplateUrl = 'modules/gtf/templates/supervisionStatusTpl.html';
            $templateRequest(sTemplateUrl).then(function (sTemplate) {
                $compile($("#" + envSrvc["oSelectedObject"]["name"] + "_" + envSrvc["sSelectedSectionName"] + "_grid_header_option_bar").html(sTemplate).contents())($scope);
                // Attends le raffraîchissement du statut de la supervision.
                var clearListener = $rootScope.$on('supervisionRecapRefreshed', function (event) {
                    // Supprime le "listener".
                    clearListener();
                    // Attends la fin du $digest().
                    $timeout(function () {
                        // Redimensionne la fenêtre principale de l'application.
                        externFunctionSrvc["resizeWin"]();
                        // Redimensionne la liste (ui-grid).
                        $rootScope["gridApi"][$scope["sSelectedGridOptionsName"]]["core"]["handleWindowResize"]();
                    });
                });
            });
            $log.info('compileObjectTemplate : ' + sTemplateUrl);
        });
    };

    /**
     * refreshSupervisionRecap function.
     * Mise à jour du bandeau récapitulatif de la supervision (Etat des demandes, abonnements, surveillances).
     */
    angular.element(vitisApp.appWorkspaceListDrtv).scope()["refreshSupervisionRecap"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        // Log.
        $log.info("refreshSupervisionRecap");
        // Récupération du scope de la liste actuellement affichée.
        var $scope = angular.element("#" + envSrvc["oSelectedObject"]["name"] + "_" + envSrvc["sSelectedSectionName"] + "_grid").scope();
        //
        $scope["gridOptions"]["appHeaderOptionBar"] = true;
        var oSupervisionStatus = {
            "order": {
                "iNotUsed": "",
                "iWaitingOrders": 0,
                "iErrors": 0,
                "iTreatedOrders": 0,
                "iNonTreatableOrders": 0,
                "iProcessingOrders": 0,
                "iNonAuthorizedOrders": 0
            },
            "subscription": {
                "iNonEnabledSubscription": 0,
                "iEnabledSubscription": 0
            },
            "survey": {
                "iNonEnabledSurvey": 0,
                "iEnabledSurvey": 0
            },
            "message": {
                "iNotUsed0": "",   // stub
                "iWaitingMessages": 0,
                "iErrorMessage" : 0,
                "iTreatedMessages": 0,
                "iNotUsed4": "",   // Non traitable
                "iProcessingMessages": 0,
                "iNotUsed6": ""    // Non autorisé
            }
        };

        // Charge le résumé de la supervision.
        ajaxRequest({
            "method": "GET",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/supervisionstatutes",
            "scope": $scope,
            "success": function(response) {
                if (response["data"]["status"] === 1) {
                    if (typeof (response["data"]["supervisionstatutes"]) !== "undefined") {
                        var aSupervisionStatutes = response["data"]["supervisionstatutes"];
                        var i = 0, sKey;
                        while (i < aSupervisionStatutes.length) {
                            sKey = Object.keys(oSupervisionStatus[aSupervisionStatutes[i]["table_name"]])[aSupervisionStatutes[i]["filter"]];
                            oSupervisionStatus[aSupervisionStatutes[i]["table_name"]][sKey] = aSupervisionStatutes[i]["nb_order_id"];
                            i++;
                        }
                    }
                    //
                    $scope["oSupervisionStatus"] = oSupervisionStatus;
                    $scope.$root.$emit("supervisionRecapRefreshed");
                }
            }
        });
    };

    /**
     * testFmeEngine function.
     * Teste le moteur FME.
     */
    angular.element(vitisApp.appMainDrtv).scope()["testFmeEngine"] = function (sFieldName) {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $templateRequest = angular.element(vitisApp.appMainDrtv).injector().get(["$templateRequest"]);
        var $compile = angular.element(vitisApp.appMainDrtv).injector().get(["$compile"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        // .
        $log.info("testFmeEngine");
        var scope = this;
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        scope["oTestFmeEngineResult"] = {};
        // Paramètres du service web (vitis, gtf...)
        var sResourceId = envSrvc["getSectionWebServiceResourceId"]();
        var aResourceId = envSrvc["explodeWebServiceResourceId"](sResourceId);
        ajaxRequest({
            "method": "GET",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/" + aResourceId[0] + "/" + aResourceId[1] + "/" + envSrvc["sId"] + "/Test",
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] === 1) {
                    scope["oTestFmeEngineResult"] = envSrvc["extractWebServiceData"](aResourceId[1], response["data"])[0];
                    var sContainerElementName = scope["sFormDefinitionName"] + "_test_fme_engine_container";
                    var oLastFormElement = document.querySelector("#" + envSrvc["oFormDefinition"][scope["sFormDefinitionName"]]["name"] + " .form-row:last-child");
                    // Crée l'élément conteneur pour afficher le résultat.
                    if (typeof (document.getElementById(sContainerElementName))) {
                        var oDiv = document.createElement("div");
                        oDiv.id = scope["sFormDefinitionName"] + "_test_fme_engine_container";
                        oLastFormElement.parentElement.insertBefore(oDiv, oLastFormElement);
                    }
                    // Test en erreur ? 
                    var sErrorMessage;
                    if (scope["oTestFmeEngineResult"]["exists"] !== true)
                        sErrorMessage = "ERROR_FME_PATH_ENGINE_FME_ENGINE";
                    else if (scope["oTestFmeEngineResult"]["valid"] !== true)
                        sErrorMessage = "ERROR_FME_LICENSE_ENGINE_FME_ENGINE";
                    if (typeof (sErrorMessage) !== "undefined") {
                        $translate([sErrorMessage]).then(function (translations) {
                            scope["oTestFmeEngineResult"]["sErrorMessage"] = translations[sErrorMessage];
                        });
                    }
                    // Compile le template du résultat.
                    $templateRequest("modules/gtf/templates/testFmeEngineTpl.html").then(function (sTemplate) {
                        $compile($("#" + sContainerElementName).html(sTemplate).contents())(scope);
                    });
                }
            }
        });
    };

    /**
     * appGtfEngineTagsColumn directive.
     * Mise en forme de la colonne "tags" dans la liste de l'onglet "engine_gtf_engine" (Moteur GTF).
     * @ngInject
     */
    vitisApp.appGtfEngineTagsColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appGtfEngineTagsColumn", function (value) {
                    // Si le champ est vide : supprime l'icône.  
                    if (scope["row"]["entity"][scope["col"]["field"]] == null || scope["row"]["entity"][scope["col"]["field"]] == "")
                        element[0].className = "";
                    else {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents wk-params-icon";
                        // Création du "tooltip".
                        $(element)["popover"]({
                            "trigger": "hover",
                            "container": "body",
                            "title": function () {
                                return "#" + scope["row"]["entity"]["gtf_engine_id"];
                            },
                            // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                            "placement": function (oPopoverNode, oElementNode) {
                                return scope.$root["workspaceTooltipPlacement"](oElementNode);
                            },
                            "content": function () {
                                return scope["row"]["entity"][scope["col"]["field"]];
                            }
                        });
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime le tooltip.
                    $(element)["popover"]("destroy");
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        };
    };
    vitisApp["compileProvider"].directive("appGtfEngineTagsColumn", vitisApp.appGtfEngineTagsColumnDrtv);

    /**
     * appWorkspaceDescriptionColumn directive.
     * Mise en forme de la colonne "description" dans la liste de l'onglet "publication_workspace" (Projets FME).
     * @param {service} $translate Translate service.
     * @ngInject
     */
    vitisApp.appWorkspaceDescriptionColumnDrtv = function ($translate) {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appWorkspaceDescriptionColumn", function (value) {
                    // Si le champ est vide : supprime l'icône.  
                    if (scope["row"]["entity"][scope["col"]["field"]] == null || scope["row"]["entity"][scope["col"]["field"]] == "")
                        element[0].className = "";
                    else {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents info-icon";
                        // Traduction du titre et du contenu.
                        $translate(["DESCRIPTION_TOOLTIP_TITLE_PUBLICATION_WORKSPACE"]).then(function (translations) {
                            // Création du "tooltip".
                            $(element)["popover"]({
                                "trigger": "hover",
                                "container": "body",
                                "title": function () {
                                    return "#" + translations["DESCRIPTION_TOOLTIP_TITLE_PUBLICATION_WORKSPACE"];
                                },
                                "content": function () {
                                    return scope["row"]["entity"][scope["col"]["field"]];
                                },
                                // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                                "placement": function (oPopoverNode, oElementNode) {
                                    return scope.$root["workspaceTooltipPlacement"](oElementNode);
                                },
                                "html": true
                            });
                        });
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime le tooltip.
                    $(element)["popover"]("destroy");
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        };
    };
    vitisApp["compileProvider"].directive("appWorkspaceDescriptionColumn", vitisApp.appWorkspaceDescriptionColumnDrtv);

    /**
     * appEmailTemplateReceiverColumn directive.
     * Mise en forme des colonnes "to", "cc", "cci" dans la liste de l'onglet "publication_email_template" (Email template).
     * @ngInject
     */
    vitisApp.appEmailTemplateReceiverColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appEmailTemplateReceiverColumn", function (value) {
                    if (value !== "") {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents enveloppe-icon";
                        // Création du "tooltip".
                        $(element)["popover"]({
                            "trigger": "hover",
                            "container": "body",
                            //"html": true
                            "title": function () {
                                return "#" + scope["row"]["entity"]["email_template_id"];
                            },
                            // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                            "placement": function (oPopoverNode, oElementNode) {
                                return scope.$root["workspaceTooltipPlacement"](oElementNode);
                            },
                            "content": function () {
                                return scope["row"]["entity"][scope["col"]["field"]];
                            }
                        });
                    } else {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents";
                        // Détruit le tooltip.
                        $(element)["popover"]("destroy");
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime le tooltip.
                    $(element)["popover"]("destroy");
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        };
    };
    vitisApp["compileProvider"].directive("appEmailTemplateReceiverColumn", vitisApp.appEmailTemplateReceiverColumnDrtv);

    /**
     * extractSubformData function.
     * Extrait les données d'un formulaire subform retourné par un web service.
     * @param {object} oFormRequestParams Paramètres et données retournés par le web service (demande du subform).
     */
    angular.element(vitisApp.appMainDrtv).scope()["extractSubformData"] = function (oFormRequestParams) {
        // Injection des services.
        var $log = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var aResourceId = envSrvc["explodeWebServiceResourceId"](oFormRequestParams["sResourceId"]);
        return oFormRequestParams["oData"][aResourceId[1]][0]["json_form"][0];
    };

    /**
     * appOrderStatusColumn directive.
     * Mise en forme de la colonne "order_status_id" dans la liste de l'onglet "my_work_user_order" et "supervision_order" (les 2 onglets "demandes").
     * @ngInject
     */
    vitisApp.appOrderStatusColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // Traduction des libellés de statuts des demandes.
                if (typeof(scope["gtf_order_status_label"]) == "undefined") {
                    var $translate = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$translate"]);
                    var aOrderStatusLabel = ["WAITING_BOX_TITLE_SUPERVISION_ORDER", "ERROR_BOX_TITLE_SUPERVISION_ORDER", "TREATED_BOX_TITLE_SUPERVISION_ORDER", "NON_TREATABLE_BOX_TITLE_SUPERVISION_ORDER", "PROCESSING_BOX_TITLE_SUPERVISION_ORDER", "NON_AUTHORIZED_BOX_TITLE_SUPERVISION_ORDER"];
                    scope.$root["gtf_order_status_label"] = [];
                    $translate(aOrderStatusLabel).then(function (translations) {
                        for(var i= 0; i < aOrderStatusLabel.length; i++)
                            scope.$root["gtf_order_status_label"][i+1] = translations[aOrderStatusLabel[i]];
                    });
                }
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appOrderStatusColumn", function (value) {
                    // Si le champ est vide : supprime l'icône.  
                    if (scope["row"]["entity"][scope["col"]["field"]] == null || scope["row"]["entity"][scope["col"]["field"]] == "")
                        element[0].className = "";
                    else {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents status" + scope["row"]["entity"]["order_status_id"] + "-icon";
                        // Création du "tooltip".
                        $(element)["popover"]({
                            "trigger": "hover",
                            "container": "body",
                            "title": function () {
                                return "#" + scope["row"]["entity"]["order_id"];
                            },
                            // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                            "placement": function (oPopoverNode, oElementNode) {
                                return scope.$root["workspaceTooltipPlacement"](oElementNode);
                            },
                            "content": function () {
                                return scope.$root["gtf_order_status_label"][scope["row"]["entity"]["order_status_id"]];
                            }
                        });
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime le tooltip.
                    $(element)["popover"]("destroy");
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        };
    };
    vitisApp["compileProvider"].directive("appOrderStatusColumn", vitisApp.appOrderStatusColumnDrtv);

    /**
     * appWorkspaceParametersColumn directive.
     * Mise en forme de la colonne "wk_params" dans la liste de l'onglet "my_work_user_order" et "supervision_order" (les 2 onglets "demandes").
     * @ngInject
     */
    vitisApp.appWorkspaceParametersColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appWorkspaceParametersColumn", function (value) {
                    // Si le champ est vide : supprime l'icône.  
                    if (scope["row"]["entity"][scope["col"]["field"]] == null || scope["row"]["entity"][scope["col"]["field"]] == "")
                        element[0].className = "";
                    else {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents wk-params-icon";
                        // Création du "tooltip".
                        $(element)["popover"]({
                            "trigger": "hover",
                            "container": "body",
                            "title": function () {
                                return "#" + scope["row"]["entity"]["order_id"];
                            },
                            // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                            "placement": function (oPopoverNode, oElementNode) {
                                return scope.$root["workspaceTooltipPlacement"](oElementNode);
                            },
                            "content": function () {
                                var sWkParams = scope["row"]["entity"]["wk_params"];
                                if (sWkParams != null) {
                                    sWkParams = sWkParams.replace(/\|/g, "<br>");
                                    sWkParams = scope.$root["decodeFmeGtfTags"](sWkParams);
                                }
                                return sWkParams;
                            },
                            "html": true
                        });
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime le tooltip.
                    $(element)["popover"]("destroy");
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        };
    };
    vitisApp["compileProvider"].directive("appWorkspaceParametersColumn", vitisApp.appWorkspaceParametersColumnDrtv);

    /**
     * appOrderEmailNotificationsColumn directive.
     * Mise en forme de la colonne "email_notifications" dans la liste de l'onglet "my_work_user_order" et "supervision_order" (les 2 onglets "demandes").
     * @ngInject
     */
    vitisApp.appOrderEmailNotificationsColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appOrderEmailNotificationsColumn", function (value) {
                    var sEmailNotifications = scope["row"]["entity"]["email_notifications"];
                    if (sEmailNotifications != null) {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents enveloppe-icon";
                        // Création du "tooltip".
                        sEmailNotifications = sEmailNotifications.replace(/;/g, "<br>");
                        $(element)["popover"]({
                            "trigger": "hover",
                            "container": "body",
                            //"title": "#" + scope["row"]["entity"]["order_id"],
                            //"content": sEmailNotifications,
                            "title": function () {
                                return "#" + scope["row"]["entity"]["order_id"];
                            },
                            // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                            "placement": function (oPopoverNode, oElementNode) {
                                return scope.$root["workspaceTooltipPlacement"](oElementNode);
                            },
                            "content": function () {
                                return sEmailNotifications;
                            },
                            "html": true
                        });
                    } else {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents";
                        // Détruit le tooltip.
                        $(element)["popover"]("destroy");
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime le tooltip.
                    $(element)["popover"]("destroy");
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        };
    };
    vitisApp["compileProvider"].directive("appOrderEmailNotificationsColumn", vitisApp.appOrderEmailNotificationsColumnDrtv);

    /**
     * appOrderDownloadUrlColumn directive.
     * Mise en forme des colonnes "result_url" et "log_url" dans la liste de l'onglet "my_work_user_order" et "supervision_order" (les 2 onglets "demandes").
     * @param {service} propertiesSrvc Paramètres des properties.
     * @ngInject
     */
    vitisApp.appOrderDownloadUrlColumnDrtv = function (propertiesSrvc) {
        return {
            replace: true,
            template: '<a href="" target="_blank" class="icon-link download-icon"></a>',
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appOrderDownloadUrlColumn", function (value) {
                    // Si le champ est vide : supprime le lien.  
                    if (scope["row"]["entity"][scope["col"]["field"]] == null || scope["row"]["entity"][scope["col"]["field"]] == "")
                        element[0].className = "";
                    else {
                        element[0].className = "icon-link download-icon";
                        element[0].href = propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["public_alias"] + "/gtf/" + scope["row"]["entity"][scope["col"]["field"]];
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        };
    };
    vitisApp["compileProvider"].directive("appOrderDownloadUrlColumn", vitisApp.appOrderDownloadUrlColumnDrtv);

    /**
     * loadSubForm function.
     * Charge le formulaire "subform" (onglets "demande", "abonnements", "surveillances").
     * @param {integer} iWorkspaceId Id du projet Fme.
     * @param {angular.scope} scope .
     * @param {object} element Elément html.
     * @param {object} oFormValues Données du formulaire.
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadSubForm"] = function (iWorkspaceId, scope, element, oFormValues) {
        // Injection des services.
        var $log = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$log"]);
        var $templateRequest = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$templateRequest"]);
        var $compile = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$compile"]);
        var $rootScope = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$rootScope"]);
        var $q = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$q"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["formSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["propertiesSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        //
        $log.info("loadSubForm");
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        if (typeof (oFormValues) === "undefined")
            oFormValues = {};
        // Nom + url du formulaire.
        scope["sFormDefinitionName"] = envSrvc["sFormDefinitionName"].replace(/_form/, "_subform");
        // Paramètres pour la requête ajax du subform.
        scope["oFormRequestParams"] = {
            "sUrl": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces/" + iWorkspaceId,
            "sResourceId": "gtf/workspaces",
            "oParams": {
                "form": "Published"
            },
            "sExtractData": "extractSubformData(oFormRequestParams)",
        };

        // Suppression de la définition et des données du formulaire (sinon problème de cache...).
        //formSrvc["clearFormData"](scope["sFormDefinitionName"]);
        scope.$root["clearFormData"](scope["sFormDefinitionName"], scope);
        // Pas de données de form. à charger.
        scope["bLoadFormValues"] = false;
        // Compilation du template de formulaire.
        $templateRequest("templates/simpleFormTpl.html").then(function (sTemplate) {
            $compile($(element).html(sTemplate).contents())(scope);
            var clearFormDefListener = $rootScope.$on('formDefinitionLoaded', function (event, sFormDefinitionName) {
                // Sauve les valeurs d'origine.
                scope["oOriginalFormValues"] = angular.copy(oFormValues);
                // Si des valeurs du wk_params sont utilisés par des champs de form. "double_select" -> remplace les espaces par des "pipes".
                Object.keys(oFormValues).forEach(function (sFormElementName) {
                    var oFormElementDefinition = formSrvc["getFormElementDefinition"](sFormElementName, sFormDefinitionName);
                    if (typeof (oFormElementDefinition) !== "undefined" && oFormElementDefinition["type"] === "double_select")
                        oFormValues[sFormElementName] = oFormValues[sFormElementName].replace(/ /g, "|");
                });
                // Sauve les données du form.
                envSrvc["oFormValues"][sFormDefinitionName] = oFormValues;
                // Titre du formulaire.
                //scope.$parent["sSubFormTitle"] = envSrvc["oFormDefinition"][sFormDefinitionName]["title"];

                // Vérification avant l'envoi du formulaire
                envSrvc["oFormDefinition"][sFormDefinitionName]["beforeEvent"] = function () {
                    var deferred = $q.defer();
                    var promise = deferred.promise;
                    var sErrorMessage;
                    formSrvc["getAllFormElementDefinition"](sFormDefinitionName).forEach(function (oElementDefinition) {
                        if (oElementDefinition["type"] === "upload") {
                            // Vérification du fichier de ressources complémentaires.
                            if (typeof (oFormValues[oElementDefinition["name"]]) === "object" && typeof (oFormValues[oElementDefinition["name"]]["aFiles"]) !== "undefined" && oFormValues[oElementDefinition["name"]]["aFiles"].length > 0) {
                                var sFileExtension = oFormValues[oElementDefinition["name"]]["aFiles"][0]["name"].split(".").pop();
                                var sForbiddenExtension = propertiesSrvc["forbidden_extension"].replace(/[^a-zA-Z0-9\|]+/g, "");
                                if (sForbiddenExtension.split("|").indexOf(sFileExtension) === -1) {
                                    // Taille maxi du fichier.
                                    if (oFormValues[oElementDefinition["name"]]["aFiles"][0]["size"] > parseInt(propertiesSrvc["max_upload_file_size"]))
                                        sErrorMessage = "ERROR_FILE_SIZE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
                                } else
                                    sErrorMessage = "ERROR_ADDITIONAL_RESOURCES_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
                            }
                            if (typeof (sErrorMessage) !== "undefined") {
                                deferred.reject();
                            }
                        }
                    });
                    // Affichage de la fenêtre modale d'erreur.
                    if (typeof (sErrorMessage) !== "undefined") {
                        var oOptions = {
                            "className": "modal-danger",
                            "message": sErrorMessage
                        };
                        scope.$root["modalWindow"]("dialog", "FORM_VALIDATION_ERROR", oOptions);
                    } else
                        deferred.resolve();
                    return promise;
                };

                // Fonctions à appeler pendant et après l'envoi du form (insertion de la demande).
                //envSrvc["oFormDefinition"][sFormDefinitionName]["event"] = "sendUserSurveySubForm()";
                envSrvc["oFormDefinition"][sFormDefinitionName]["afterEvent"] = function () {
                    if (propertiesSrvc['engines_list'] == "") {
                        var oOptions = {
                            "className": "modal-danger",
                            "message": "ERROR_NO_GTF_ENGINE_CONTENT_MY_WORK_USER_ORDER"
                        };
                        scope.$root["modalWindow"]("alert", "ERROR_NO_GTF_ENGINE_TITLE_MY_WORK_USER_ORDER", oOptions);
                    }
                    else {
                        angular.element(vitisApp.appMainDrtv).scope()["sendSubForm"](scope).then(function (bFormValid) {
                            if (bFormValid === true) {
                                // Rechargement obligatoire du mode supervision.
                                delete envSrvc["oLastSelectedObjectMode"]["supervision"];
                                // Retour vers la liste des demandes.
                                angular.element(vitisApp.appMainDrtv).scope()["setMode"]("search");
                            }
                        });
                    }
                };
                // Largeur du formulaire.
                envSrvc["oFormDefinition"][sFormDefinitionName]["nb_cols"] = 8;
                // Ajoute le bouton "demander".
                if (envSrvc["sMode"] !== "display") {
                    // Nom du bouton suivant le mode.
                    var sButtonLabel;
                    if (envSrvc["sMode"] === "insert")
                        sButtonLabel = "FORM_BTN_CREATE_" + scope["tab_id"].toUpperCase() + "_" + envSrvc["oSelectedObject"]["name"].toUpperCase();
                    else
                        sButtonLabel = "FORM_BTN_UPDATE_" + scope["tab_id"].toUpperCase() + "_" + envSrvc["oSelectedObject"]["name"].toUpperCase();
                    // Bouton submit ajouté au formulaire (si pas déja présent).
                    if (typeof(formSrvc["getFormElementDefinition"]("form_submit", sFormDefinitionName) == "undefined")) {
                        envSrvc["oFormDefinition"][sFormDefinitionName]["rows"].push(
                                {
                                    "fields": [
                                        {
                                            "type": "button",
                                            "class": "btn-ungroup btn-group-sm",
                                            "nb_cols": 12,
                                            "buttons": [
                                                {
                                                    "type": "submit",
                                                    "name": "form_submit",
                                                    "label": sButtonLabel,
                                                    "class": "btn-primary",
                                                    "visibleAllTabs": true
                                                }
                                            ]
                                        }
                                    ]
                                }
                        );
                    }
                }
                //}
                // Supprime le "listener".
                clearFormDefListener();
            });
        });
    };

    /**
     * sendSubForm function.
     * Envoi le formulaire "subform" (onglets "demandes", "abonnements", "surveillances") avec les paramètres du workspace.
     * @param {angular.scope} scope .
     */
    angular.element(vitisApp.appMainDrtv).scope()["sendSubForm"] = function (scope) {
        // Injection des services.
        var $log = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["formSrvc"]);

        $log.info("sendSubForm");
        // Valeurs des champs cachés du form. de la demande.
        var oWkParams = {};
        //var aSerializedSubForm = angular.element("#double_form_right_section_" + envSrvc["oSelectedObject"]["name"] + " form").serializeArray();
        //mise en forme pour fme 
        /***********************************************************************/

        var encoderFME = function (str) {

            if (!goog.isString(str))
                return str;
            // table de correspondance
            var caracInGTF = [" ", "=", "\r\n", "(", ")", "$", "&", "@", "°", "'", ",", "\"", "{", "}", "[", "]", "|", ";", "/", "\\", "é", "à"];
            var caracForFME = ["<space>", "<GTF_EQUAL>", "<lf>", "<openparen>", "<closeparen>", "<dollar>", "<amp>", "<at>", "<u00b0>", "<apos>", "<comma>", "<quote>", "<opencurly>", "<closecurly>", "<openbracket>", "<closebracket>", "<GTF_PIPE>", "<semicolon>", "<solidus>", "<backslash>", "<u00e9>", "<u00e0>"];
            //variables parcours de chaine
            var result = str;
            var istr = 0;
            var iresult = 0;
            // remplacement des <> par parcours de chaine
            // avec vérification des mots clef
            // et gestion des caractère unicode
            while (istr < str.length) {
                if (str.charAt(istr) === "<") {

                    var j = 0;
                    var find = false;
                    while (j < caracForFME.length && !find) {
                        var clipper = result.substr(iresult, caracForFME[j].length);
                        if (clipper === caracForFME[j]) {
                            istr += caracForFME[j].length;
                            iresult += caracForFME[j].length;
                            find = true;
                        }
                        j++;
                    }
                    /*****************************/
                    //GTF_QUOTE et GTF BACKSLASH
                    /* var quote = "<GTF_QUOTE>";
                     var backslash = "<GTF_BACKSLASH>";
                     
                     var clipper = result.substr(iresult, quote.length);
                     if (clipper === quote) {
                     istr += quote.length;
                     iresult += quote.length;
                     find = true;
                     }
                     
                     clipper = result.substr(iresult, backslash.length);
                     console.error(result,clipper, iresult);
                     if (clipper === backslash) {
                     istr += backslash.length;
                     iresult += backslash.length;
                     find = true;
                     }
                     /*****************************/

                    if (!find) {
                        var part1 = result.substr(0, iresult);
                        var part2 = result.substr(iresult + 1, result.length - 1);
                        result = part1 + "<lt>" + part2;
                        iresult += 4;
                        istr += 1;
                    }
                } else if (str.charAt(istr) === ">") {
                    var part1 = result.substr(0, iresult);
                    var part2 = result.substr(iresult + 1, result.length - 1);
                    result = part1 + "<gt>" + part2;
                    istr += 1;
                    iresult += 4;
                } else {
                    //unicode
                    var code = str.charCodeAt(istr);
                    if (code > 127) {
                        var part1 = result.substr(0, iresult);
                        var part2 = result.substr(iresult + 1, result.length - 1);
                        var charCode = (+code).toString(16);

                        while (charCode.length < 4) {
                            charCode = "0" + charCode;
                        }

                        result = part1 + "<u" + charCode + ">" + part2;
                        istr += 1;
                        iresult += 7;
                    } else {
                        istr += 1;
                        iresult += 1;
                    }
                    /*******************************************/
                }
            }

            for (var j = 0; j < caracInGTF.length; j++) {
                while (result.indexOf(caracInGTF[j]) !== - 1)
                    result = result.replace(caracInGTF[j], caracForFME[j]);
            }

            return result;
        };

        var decoderFME = function (str) {
            if (!goog.isString(str))
                return str;
            // table de correspondance
            var caracInGTF = ["<", ">", " ", "\n", "<GTF_EQUAL>", "(", ")", "$", "&", "@", "°", "'", "<comma>", "\"", "{", "}", "[", "]", "<GTF_PIPE>", ";", "/", "\\", "é", "à"];
            var caracForFME = ["<lt>", "<gt>", "<lf>", "<space>", "=", "<openparen>", "<closeparen>", "<dollar>", "<amp>", "<at>", "<u00b0>", "<apos>", ",", "<quote>", "<opencurly>", "<closecurly>", "<openbracket>", "<closebracket>", "|", "<semicolon>", "<solidus>", "<backslash>", "<u00e9>", "<u00e0>"];
            //variables parcours de chaine
            var result = str;

            for (var j = 0; j < caracInGTF.length; j++) {
                while (result.indexOf(caracForFME[j]) !== - 1)
                    result = result.replace(caracForFME[j], caracInGTF[j]);
            }

            var code = result.search(/<u[0-9a-fA-F]{4}>/);
            while (code !== -1) {
                var part1 = result.substr(0, code);
                var char = result.substr(code + 2, code + 6);
                var part2 = result.substr(code + 7, result.length - 1);
                char = String.fromCharCode(parseInt(char, 16));
                result = part1 + char + part2;
                //console.log(part1, char, part2);
                code = result.search(/<u[0-9a-fA-F]{4}>/);
            }

            return result;
        };

        var oFormValues = goog.object.clone(scope["oFormValues"][scope["sFormDefinitionName"]]);
        for (var i = 0; i < scope["oFormDefinition"][scope["sFormDefinitionName"]]["rows"].length; i++) {
            for (var j = 0; j < scope["oFormDefinition"][scope["sFormDefinitionName"]]["rows"][i]["fields"].length; j++) {
                var val = scope["oFormDefinition"][scope["sFormDefinitionName"]]["rows"][i]["fields"][j];
                //for (var k = 0; k < aSerializedSubForm.length; k++) {
                if (goog.isDef(oFormValues[val["name"]])) {
                    switch (val["type"]) {
                        //case "date":
                        //console.log("date");
                        //break;
                        case "datetime":
                            var tmp = angular.copy(oFormValues[val["name"]]);
                            tmp = tmp.split(" ");
                            // si il y a un espace alors mise en forme sinon c'est une valeur par défaut à ne pas retoucher
                            if (tmp.length === 2) {
                                var date = tmp[0];
                                var time = tmp[1];
                                //traitement date
                                date = date.split("/");
                                //traitement time
                                time = time.split(":");
                                if (time.length === 2) {
                                    time.push("00");
                                }
                                //reconstitution
                                oFormValues[val["name"]] = date[2] + date[1] + date[0] + time[0] + time[1] + time[2];
                            }
                            break;
                        case "color_picker":
                            var tmp = angular.copy(oFormValues[val["name"]]);
                            if (tmp.indexOf('(') !== -1 && tmp.indexOf(')') !== -1 && tmp.indexOf(',') !== -1) {
                                tmp = tmp.split("(");
                                tmp = tmp[1].split(")");
                                tmp = tmp[0].split(",");
                                var R = (parseFloat(tmp[0]) / 255).toFixed(6);
                                var G = (parseFloat(tmp[1]) / 255).toFixed(6);
                                var B = (parseFloat(tmp[2]) / 255).toFixed(6);
                                // alpha non pris en charge par fme
                                // fme ne prend que des % de couleur
                                oFormValues[val["name"]] = R + "," + G + "," + B;
                            } else {
                                console.error('ColorPicker value not acceptable: ', tmp);
                                oFormValues[val["name"]] = '1,1,1';
                            }
                            break;
                        case "list":
                            var tmp = angular.copy(oFormValues[val["name"]]["selectedOption"]);
                            if (goog.isArray(tmp)) {
                                oFormValues[val["name"]] = "";
                                if (tmp.length > 0) {
                                    for (var choice = 0; choice < tmp.length - 1; choice++) {
                                        //console.log(tmp[choice]["value"]);
                                        if (!goog.isString(tmp[choice]["value"])) {
                                            tmp[choice]["value"] = tmp[choice]["value"].toString();
                                        }
                                        if (tmp[choice]["value"].indexOf(" ") !== -1) {
                                            oFormValues[val["name"]] += ("\"" + tmp[choice]["value"] + "\"" + " ");
                                        } else {
                                            oFormValues[val["name"]] += (tmp[choice]["value"] + " ");
                                        }
                                    }
                                    if (!goog.isString(tmp[tmp.length - 1]["value"])) {
                                        tmp[tmp.length - 1]["value"] = tmp[tmp.length - 1]["value"].toString();
                                    }
                                    if (tmp[tmp.length - 1]["value"].indexOf(" ") !== -1) {
                                        //oFormValues[val["name"]] += ("\"" + tmp[tmp.length - 1]["value"] + "\"");
                                        oFormValues[val["name"]] += tmp[tmp.length - 1]["value"];
                                    } else {
                                        oFormValues[val["name"]] += (tmp[tmp.length - 1]["value"]);
                                    }
                                }
                                //oFormValues[val["name"]] += tmp[tmp.length - 1]["value"];
                            } else if (goog.isObject(tmp)) {
                                if (typeof (tmp["value"]) != "undefined")
                                    oFormValues[val["name"]] = tmp["value"].replace("|", " ");
                            }

                            //oFormValues[val["name"]] = decoderFME(oFormValues[val["name"]]);
                            //console.log("encoder", oFormValues[val["name"]]);
                            oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                            break;
                        case "select":
                            var tmp = angular.copy(oFormValues[val["name"]]["selectedOption"]);
                            //console.log(tmp);
                            if (goog.isObject(tmp)) {
                                oFormValues[val["name"]] = tmp["value"];
                            } else {
                                oFormValues[val["name"]] = tmp;
                            }
                            //oFormValues[val["name"]] = decoderFME(oFormValues[val["name"]]);
                            oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                            break;
                        case "double_select":
                            var oSelectedOptions = oFormValues[val["name"]];
                            var aSelectedOptions = [];
                            oSelectedOptions["options"].forEach(function (oOption) {
                                aSelectedOptions.push(oOption["value"]);
                            });
                            oFormValues[val["name"]] = encoderFME(aSelectedOptions.join(" "));
                            delete oFormValues[val["name_from"]];
                            break;
                        case "upload":
                            if (goog.isDefAndNotNull(oFormValues[val["name"]])) {
                                var tmp = oFormValues[val["name"]];
                                // Répertoire côté serveur pour tous les fichiers uploadés.
                                var sDirectory;
                                if (typeof(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"]) == "undefined") {
                                    sDirectory = new Date().getTime() + parseInt(Math.random() * 100000);
                                    envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"] = sDirectory;
                                }
                                else
                                    sDirectory = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"];
                                //
                                envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["rows"].push({"fields": [formSrvc["getFormElementDefinition"](val["name"], scope["sFormDefinitionName"])]});
                                envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]][val["name"]] = envSrvc["oFormValues"][scope["sFormDefinitionName"]][val["name"]];

                                // Fichier sélectionné.
                                if (typeof (tmp["aFiles"]) != "undefined" && tmp["aFiles"].length > 0) {
                                    var aUploadFiles = [];
                                    for (var iFileIndex = 0; iFileIndex < tmp["aFiles"].length; iFileIndex++) {
                                        aUploadFiles.push(sDirectory + "/" + tmp["aFiles"][iFileIndex]["name"]);
                                    }
                                    oFormValues[val["name"]] = aUploadFiles.join(",");
                                }
                                else {
                                    if (typeof (scope["oOriginalFormValues"][val["name"]]) != "undefined")
                                        oFormValues[val["name"]] = scope["oOriginalFormValues"][val["name"]];
                                    else
                                        oFormValues[val["name"]] = "";
                                }
                            } else {
                                if (typeof (scope["oOriginalFormValues"][val["name"]]) != "undefined")
                                    oFormValues[val["name"]] = scope["oOriginalFormValues"][val["name"]];
                                else
                                    oFormValues[val["name"]] = "";
                            }
                            break;
                        case "textarea":
                            //var tmp = oFormValues[val["name"]];
                            //oFormValues[val["name"]] = encoderFME(tmp);
                            oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                            break;
                        case "text":
                            oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                            //oFormValues[val["name"]] = decoderFME(oFormValues[val["name"]]);
                            break;
                        case "treeview":
                            oFormValues[val["name"]] = String(oFormValues[val["name"]]).replace(/\|/g, "<GTF_PIPE>");
                    }
                }
                //}
            }
        }

        /*************************************************************************/
        // Dédoublonnage (select multiple).
        //var i = 0;
        //while (i < aSerializedSubForm.length) {
        //    if (typeof (oWkParams[aSerializedSubForm[i]["name"]]) == "undefined")
        //        oWkParams[aSerializedSubForm[i]["name"]] = aSerializedSubForm[i]["value"];
        //    else
        //        oWkParams[aSerializedSubForm[i]["name"]] += "," + aSerializedSubForm[i]["value"];
        //    i++;
        //}
        // Création du paramètre wk_params.
        var aKeys = Object.keys(oFormValues);
        var aWkParams = [];
        i = 0;
        while (i < aKeys.length) {
            aWkParams.push(aKeys[i] + "=" + oFormValues[aKeys[i]]);
            i++;
        }
        var sWkParams = aWkParams.join("|");
        // Fichiers à uploader ?
        //var oFileInput = document.querySelector("form[name='" + envSrvc["oFormDefinition"][scope["sFormDefinitionName"]]["name"] + "']").querySelectorAll("input[type='file']");

        //i = 0;
        //while (i < oFileInput.length) {
        //    var sDirectory = new Date().getTime() + parseInt(Math.random() * 100000);
        //    envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"] = sDirectory;
        // Si un fichier est sélectionné -> ajoute la définition et les valeurs du champ sur le formulaire de la demande.
        //    if (oFileInput[i]["files"].length > 0) {
        //        envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["rows"].push({"fields": [formSrvc["getFormElementDefinition"](oFileInput[i]["name"], scope["sFormDefinitionName"])]});
        //        envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]][oFileInput[i]["name"]] = envSrvc["oFormValues"][scope["sFormDefinitionName"]][oFileInput[i]["name"]];
        //        sWkParams += "|" + oFileInput[i]["name"] + "=" + sDirectory + "/" + oFileInput[i]["files"][0]["name"];
        //    }
        //    i++;
        //}
        // Sauve les valeurs du formulaire du projet FME + id de l'utilisateur connecté.
        envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["wk_params"] = sWkParams;
        //envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["user_id"] = sessionStorage["user_id"];
        // 
        envSrvc["sFormDefinitionName"] = envSrvc["sFormDefinitionName"].replace(/_subform/, "_form");
        // Envoi du formulaire.
        return scope["sendSimpleForm"](true);
    };

    /**
     * sendSubForm function.
     * Initialisation des onglets "demandes", "abonnements", "surveillances" (mode "my_work").
     * @param {angular.scope} scope .
     * @param {object} element Elément html.
     */
    angular.element(vitisApp.appMainDrtv).scope()["initSubForm"] = function (scope, element) {
        // Injection des services.
        var $log = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$log"]);
        var $rootScope = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$rootScope"]);
        var $timeout = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$timeout"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        $log.info("initSubForm");
        // Attends la fin de l'affichage du 1er formulaire.
        var clearListener = $rootScope.$on('formExtracted', function (event) {
            // Supprime le "listener".
            clearListener();
            if (envSrvc["sMode"] != "display") {
                // Attends la fin du $digest().
                $timeout(function () {
                    // Evènement sur le <select> des projets Fme.
                    document.getElementById("workspace_id").addEventListener("change", function () {
                        scope["loadSubForm"](this.value, scope, element);
                    });
                }, 100);
            } else {
                // Formatage de la date de demande.
                if (goog.isDefAndNotNull(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["order_date"]))
                    envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["order_date"] = moment(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["order_date"]).format('L LTS');
            }
        });

        // Attends la fin du chargement des données et structure du formulaire.
        var clearListener2 = $rootScope.$on('formDefinitionLoaded', function (event) {
            // Supprime le "listener".
            clearListener2();
            if (envSrvc["sMode"] != "insert") {
                // Extraction des données de formulaire du projet FME.
                var sWkParams = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["wk_params"];
                var oFormValues = {}, aKeysValues;
                if (sWkParams != null) {
                    var aWkParams = sWkParams.split("|");
                    var i = 0;
                    while (i < aWkParams.length) {
                        aKeysValues = aWkParams[i].split("=");
                        oFormValues[aKeysValues[0]] = scope.$root["decodeFmeGtfTags"](aKeysValues[1]);
                        i++;
                    }
                }

                // Traduction du booléen ("enabled") pour le mode "display".
                if (envSrvc["sMode"] == "display") {
                    scope.$root["getBooleanTranslation"](envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"]).then(function (sTranslation) {
                        envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"] = sTranslation;
                    });
                }

                // Charge le subform.
                scope["loadSubForm"](envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["workspace_id"], scope, element, oFormValues);
            }
        });
    };

    /**
     * appMessageStatusIconColumn directive.
     * Mise en forme de la colonne "status" avec un icône (Supervision > messages).
     * @ngInject
     */
    vitisApp.appMessageStatusIconColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // Traduction des libellés de statuts des messages.
                if (typeof(scope["gtf_message_status_label"]) == "undefined") {
                    var $translate = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$translate"]);
                    var aOrderStatusLabel = ["WAITING_BOX_TITLE_SUPERVISION_ORDER", "ERROR_BOX_TITLE_SUPERVISION_ORDER", "TREATED_BOX_TITLE_SUPERVISION_ORDER", "PROCESSING_BOX_TITLE_SUPERVISION_ORDER"];
                    scope.$root["gtf_message_status_label"] = [];
                    $translate(aOrderStatusLabel).then(function (translations) {
                        for(var i= 0; i < aOrderStatusLabel.length; i++)
                            scope.$root["gtf_message_status_label"][i] = translations[aOrderStatusLabel[i]];
                    });
                }
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appMessageStatusIconColumn", function (value) {
                    // Si le champ est vide : supprime l'icône.  
                    if (scope["row"]["entity"][scope["col"]["field"]] == null || String(scope["row"]["entity"][scope["col"]["field"]]) == "")
                        element[0].className = "";
                    else {
                        //
                        if (value == 0)
                            value = 4;
                        /*else if (value == 6)
                            value = 5;
                        else
                            value = 5;*/
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents status" + value + "-icon";
                        // Création du "tooltip".
                        $(element)["popover"]({
                            "trigger": "hover",
                            "container": "body",
                            "title": function () {
                                return "#" + scope["row"]["entity"]["message_id"];
                            },
                            // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                            "placement": function (oPopoverNode, oElementNode) {
                                return scope.$root["workspaceTooltipPlacement"](oElementNode);
                            },
                            "content": function () {
                                return scope.$root["gtf_message_status_label"][scope["row"]["entity"]["status"]];
                            }
                        });
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        }
    };
    vitisApp["compileProvider"].directive("appMessageStatusIconColumn", vitisApp.appMessageStatusIconColumnDrtv);

    /**
     * appMessageBodyColumn directive.
     * Mise en forme de la colonne "body" dans la liste de l'onglet "my_work_3" (messages de gtf).
     * @ngInject
     */
    vitisApp.appMessageBodyColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appMessageBodyColumn", function (value) {
                    // Si le champ est vide : supprime l'icône.  
                    if (scope["row"]["entity"][scope["col"]["field"]] == null || scope["row"]["entity"][scope["col"]["field"]] == "")
                        element[0].className = "";
                    else {
                        // Classes css (ui-grid + spécifiques).
                        element[0].className = "ui-grid-cell-contents page-icon";
                        // Création du "tooltip".
                        $(element)["popover"]({
                            "trigger": "hover",
                            "container": "body",
                            //"title": "#" + scope["row"]["entity"]["message_id"],
                            //"content": sWkParams,
                            "title": function () {
                                return "#" + scope["row"]["entity"]["message_id"];
                            },
                            // Placement du tooltip à gauche ou à droite suivant la position horizontale de l'élément.
                            "placement": function (oPopoverNode, oElementNode) {
                                return scope.$root["workspaceTooltipPlacement"](oElementNode);
                            },
                            "content": function () {
                                var sWkParams = scope["row"]["entity"]["body"];
                                if (sWkParams != null)
                                    sWkParams = sWkParams.replace(/\n/g, "<br>");
                                return sWkParams;
                            },
                            "html": true
                        });
                    }
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime le tooltip.
                    $(element)["popover"]("destroy");
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        }
    };
    vitisApp["compileProvider"].directive("appMessageBodyColumn", vitisApp.appMessageBodyColumnDrtv);

    /**
     * loadEmailTemplateAdvancedEdition function.
     * Traitements au lancement de la section "Définition avançée" du modèle d'email.
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadEmailTemplateAdvancedEdition"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        //
        $log.info("loadEmailTemplateAdvancedEdition");
        if (envSrvc["sMode"] != "search") {
            // Attends la fin de la compilation du formulaire.
            var clearListener = this.$root.$on('endFormNgRepeat', function (event, sFormDefinitionName) {
                // Supprime le "listener".
                clearListener();
                // Calcule la hauteur de l'éditeur CodeMirror.
                var oSectionForm = envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]];
                var oSectionContainer = document.querySelector("#container_section_" + envSrvc["oSelectedObject"]["name"] + "_" + oSectionForm["sections"][oSectionForm["iSelectedSectionIndex"]]["name"] + " > .simple-form");
                var oForm = oSectionContainer.querySelector("form");
                var oCodeMirror = oSectionContainer.querySelector(".CodeMirror");
                oCodeMirror["CodeMirror"]["setSize"]("100%", oCodeMirror.clientHeight + oSectionContainer.clientHeight - oForm.clientHeight - 55);
            });
        }
    };

    /**
     * generateEmailTemplateCode function.
     * Génération du code du template.
     */
    angular.element(vitisApp.appMainDrtv).scope()["generateEmailTemplateCode"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("generateEmailTemplateCode");
        var scope = this;
        ajaxRequest({
            "method": "GET",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/emailtemplates/" + envSrvc["sId"] + "/Code",
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] == 1) {
                    // Mise à jour du contenu de l'éditeur CodeMirror.
                    var oSectionForm = envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]];
                    var oCodeMirror = document.querySelector("#container_section_" + envSrvc["oSelectedObject"]["name"] + "_" + oSectionForm["sections"][oSectionForm["iSelectedSectionIndex"]]["name"] + " .CodeMirror");
                    oCodeMirror["CodeMirror"]["setValue"](response["data"]["emailtemplates"][0]["code"]);
                }
            }
        });
    };

    /**
     * checkEmailTemplateCode function.
     * Vérification du code du template.
     */
    angular.element(vitisApp.appMainDrtv).scope()["checkEmailTemplateCode"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $q = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$q"])
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("checkEmailTemplateCode");
        var scope = this;
        var deferred = $q.defer();
        var promise = deferred.promise;
        // Requête vers la validation du code php du template d'email.
        var formData = new FormData();
        formData.append("code", envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["code"]);
        formData.append("error_type", "E_PARSE");
        ajaxRequest({
            "method": "POST",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/emailtemplates/" + envSrvc["sId"] + "/CodeValidation",
            "data": formData,
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] == 1) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                    var oOptions = {"className": "modal-danger"};
                    // Message d'erreur ?
                    if (response["data"]["errorMessage"] != null)
                        oOptions["message"] = response["data"]["errorMessage"];
                    scope["modalWindow"]("alert", "PHP_VALIDATION_ERROR", oOptions);
                }
            }
        });
        //
        return promise;
    };

    /**
     * checkCronExpression function.
     * Vérification de l'expression cron de la période.
     */
    angular.element(vitisApp.appMainDrtv).scope()["checkCronExpression"] = function (sFieldName) {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $templateRequest = angular.element(vitisApp.appMainDrtv).injector().get(["$templateRequest"]);
        var $compile = angular.element(vitisApp.appMainDrtv).injector().get(["$compile"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        // .
        $log.info("checkCronExpression");
        var scope = this;
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        scope["oCheckCronExpressionResult"] = {};
        // Paramètres du service web (vitis, gtf...)
        var sResourceId = envSrvc["getSectionWebServiceResourceId"]();
        var aResourceId = envSrvc["explodeWebServiceResourceId"](sResourceId);
        ajaxRequest({
            "method": "GET",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/" + aResourceId[0] + "/" + aResourceId[1] + "/" + envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["period_id"] + "/CronValidation/",
            "params": {"code": envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]][sFieldName]},
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] == 1) {
                    scope["oCheckCronExpressionResult"] = envSrvc["extractWebServiceData"](aResourceId[1], response["data"])[0]["checkcron"];
                    var sContainerElementName = scope["sFormDefinitionName"] + "_check_cron_expression_container";
                    var oLastFormElement = document.querySelector("#" + envSrvc["oFormDefinition"][scope["sFormDefinitionName"]]["name"] + " .form-row:last-child");
                    // Crée l'élément conteneur pour afficher le résultat.
                    if (typeof (document.getElementById(sContainerElementName))) {
                        var oDiv = document.createElement("div");
                        oDiv.id = scope["sFormDefinitionName"] + "_check_cron_expression_container";
                        oLastFormElement.parentElement.insertBefore(oDiv, oLastFormElement);
                    }
                    // Traduction du message du résultat.
                    $translate([scope["oCheckCronExpressionResult"]["message"]], scope["oCheckCronExpressionResult"]).then(function (translations) {
                        scope["sCronTestResultMessage"] = translations[scope["oCheckCronExpressionResult"]["message"]];
                    });
                    // Expression cron valide ?
                    scope["bCronExpressionArguments"] = true;
                    if (scope["oCheckCronExpressionResult"]["status"] == 1) {
                        scope["sCronTestResultClass"] = "panel panel-success";
                    } else {
                        scope["sCronTestResultClass"] = "panel panel-danger";
                        // Argument invalide ?
                        if (typeof (scope["oCheckCronExpressionResult"]["index_error_argument"]) == "undefined")
                            scope["bCronExpressionArguments"] = false;
                    }
                    // Compile le template du résultat.
                    $templateRequest("modules/gtf/templates/checkCronExpressionTpl.html").then(function (sTemplate) {
                        $compile($("#" + sContainerElementName).html(sTemplate).contents())(scope);
                    });
                }
            }
        });
    };

    /**
     * setSupervisionRecapFilter function.
     * Filtre la liste des demandes, abonnements, surveillance (mode supervision).
     * @param {strint} sFilter Paramètre "filter" pour l'api rest.
     */
    angular.element(vitisApp.appMainDrtv).scope()["setSupervisionRecapFilter"] = function (sFilter) {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("setSupervisionRecapFilter");
        var scope = this;
        var sColumn;
        // Sauve le formulaire par défaut des filtres.
        if (typeof (envSrvc["oWorkspaceList"][envSrvc["oSelectedObject"]["name"]]["oDefaultValues"]) == "undefined") {
            envSrvc["oWorkspaceList"][envSrvc["oSelectedObject"]["name"]]["oDefaultValues"] = angular.copy(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]);
            envSrvc["oWorkspaceList"][envSrvc["oSelectedObject"]["name"]]["oValues"] = angular.copy(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]);
        }
        // Onglet "Demandes".
        if (envSrvc["oSelectedObject"]["name"] == "supervision_gtf_order") {
            // Maj du <select> de l'état dans le filtre de recherche.
            //if (typeof(envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]) != "undefined")
            //document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] select[name='order_status_id']").value = sFilter;
            if (typeof (envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]) != "undefined") {
                if (typeof (envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["order_status_id"]) != "undefined")
                    envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["order_status_id"]["selectedOption"]["value"] = sFilter;
                envSrvc["oWorkspaceList"][envSrvc["oSelectedObject"]["name"]]["oValues"] = angular.copy(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]);
            }
            sColumn = "order_status_id";
        }
        // Onglet "Abonnements" / "Surveillances".
        else if (envSrvc["oSelectedObject"]["name"] == "supervision_gtf_message"){
            if (typeof (envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]) != "undefined" && typeof (envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"]) != "undefined")
                envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["status"] = JSON.parse(sFilter.toLowerCase());
            sColumn = "status";
        }
        // Onglet "Abonnements" / "Surveillances".
        else {
            if (typeof (envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]) != "undefined" && typeof (envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"]) != "undefined")
                envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"] = JSON.parse(sFilter.toLowerCase());
            sColumn = "enabled";
        }
        // Filtre la liste avec le statut passé.
        scope["gridOptions"]["oFilter"] = {
            "relation": "AND",
            "operators": [{
                "column": sColumn,
                "compare_operator": "=",
                "value": String(sFilter)
            }]
        };
        if (scope["gridOptions"]["paginationCurrentPage"] == 1)
            scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["pagination"]["raise"]["paginationChanged"](1, scope["gridOptions"]["paginationPageSize"]);
        else
            scope["gridOptions"]["paginationCurrentPage"] = 1;
    };

    /**
     * CleanOrders function.
     * Purge les demandes.
     */
    angular.element(vitisApp.appMainDrtv).scope()["CleanOrders"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("CleanOrders");
        var scope = this;
        var oParams = {};
        // Des demandes sont sélectionnées ?
        var aSelectedRows = scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["selection"]["getSelectedRows"]();
        if (aSelectedRows.length > 0) {
            // Sauve la sélection
            scope["saveGridSelection"](scope, scope["gridOptions"]);
            // Liste des enregistrements à supprimer.
            var i = 0, aIdToDelete = [];
            while (i < aSelectedRows.length) {
                aIdToDelete.push(aSelectedRows[i][envSrvc["oSelectedObject"]["sIdField"]]);
                i++;
            }
            oParams["idList"] = aIdToDelete.join("|");
        }
        ajaxRequest({
            "method": "DELETE",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/orders/clean",
            "params": oParams,
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] == 0) {
                    // Affichage de la fenêtre modale d'erreur.
                    var oOptions = {
                        "className": "modal-danger",
                        "message": response["data"]["errorMessage"]
                    };
                    scope["modalWindow"]("dialog", "ERROR_CLEANING_ORDERS_SUPERVISION_ORDER", oOptions);
                } else {
                    // Recharge la liste des demandes.
                    scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["pagination"]["raise"]["paginationChanged"](1, scope["gridOptions"]["paginationPageSize"]);
                }
            }
        });
    };

    /**
     * ModifyEngine function.
     * Formulaire de changement du n° de moteur gtf pour une demande.
     */
    angular.element(vitisApp.appMainDrtv).scope()["ModifyEngine"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var $compile = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$compile"]);
        var $templateRequest = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$templateRequest"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        //
        $log.info("ModifyEngine");
        var scope = this;
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        // Des demandes sont sélectionnées ?
        var aSelectedRows = scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["selection"]["getSelectedRows"]();
        if (aSelectedRows.length > 0) {
            // Sauve la sélection
            scope["saveGridSelection"](scope, scope["gridOptions"]);
            // Crée un nouveau scope.
            var scope = this.$new();
            var sFormId = "form_change_gtf_engine_" + envSrvc["oSelectedObject"]["name"];
            // Traduction du titre et affichage de la fenêtre modale.
            // Affichage de la fenêtre modale d'erreur.
            var oOptions = {
                "className": "dialog-modal-window",
                "message": '<div id="' + sFormId + '"></div>'
            };
            scope["modalWindow"]("dialog", "TITLE_CHANGE_GTF_ENGINE_SUPERVISION_ORDER", oOptions);

            // Nom + url du formulaire.
            scope["sFormDefinitionName"] = envSrvc["oSelectedObject"]["name"] + "_change_gtf_engine_form";
            envSrvc["sFormDefinitionName"] = scope["sFormDefinitionName"];
            // Paramètres pour la requête ajax du subform.
            scope["oFormRequestParams"] = {
                "sUrl": "modules/gtf/forms/supervision/change_gtf_engine.json",
            };
            // Suppression de la définition et des données du formulaire (sinon problème de cache...).
            //formSrvc["clearFormData"](scope["sFormDefinitionName"]);
            scope.$root["clearFormData"](scope["sFormDefinitionName"], scope);
            envSrvc["oFormValues"][scope["sFormDefinitionName"]] = {};
            // Pas de données de form. à charger.
            scope["bLoadFormValues"] = false;

            // Compile le template de formulaire.
            var sTemplateUrl = 'templates/formTpl.html';
            $templateRequest(sTemplateUrl).then(function (sTemplate) {
                $compile($("#" + sFormId).html(sTemplate).contents())(scope);
            });
            $log.info('compileObjectTemplate : ' + sTemplateUrl);
        } else {
            // Affichage de la fenêtre modale d'erreur.
            var oOptions = {
                "className": "modal-danger",
            };
            scope["modalWindow"]("dialog", "ERROR_NO_SELECTION_CHANGE_GTF_ENGINE_SUPERVISION_ORDER", oOptions);
        }
    };


    /**
     * setOrderGtfEngine function.
     * Change le n° du moteur Gtf d'une ou plusieurs demandes.
     */
    angular.element(vitisApp.appMainDrtv).scope()["setOrderGtfEngine"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $q = angular.element(vitisApp.appMainDrtv).injector().get(["$q"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("setOrderGtfEngine");
        var scope = this;
        var deferred = $q.defer();
        var promise = deferred.promise;
        var oFormValues = envSrvc["oFormValues"][scope["sFormDefinitionName"]];
        var oParams = {
            "gtf_engine_id": oFormValues['gtf_engine_id']["selectedOption"]["value"],
        };
        // Des demandes sont sélectionnées ?
        var aSelectedRows = scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["selection"]["getSelectedRows"]();
        if (aSelectedRows.length > 0) {
            // Liste des enregistrements à supprimer.
            var i = 0, aIdToDelete = [];
            while (i < aSelectedRows.length) {
                aIdToDelete.push(aSelectedRows[i][envSrvc["oSelectedObject"]["sIdField"]]);
                i++;
            }
            oParams["idList"] = aIdToDelete.join("|");
        }
        ajaxRequest({
            "method": "PUT",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/orders/gtfengine",
            "data": oParams,
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] == 0) {
                    var oOptions = {
                        "className": "modal-danger",
                        "message": response["data"]["errorMessage"]
                    };
                    scope["modalWindow"]("dialog", "ERROR_CHANGE_GTF_ENGINE_SUPERVISION_ORDER", oOptions);
                } else {
                    // Ferme la fenêtre modale.
                    bootbox["hideAll"]();
                    // Recharge la liste des demandes.
                    scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["pagination"]["raise"]["paginationChanged"](1, scope["gridOptions"]["paginationPageSize"]);
                    //
                    scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["selection"]["selectRow"](aSelectedRows);
                }
            }
        });
        // Retourne la promesse.
        return promise;
    };

    /**
     * appDeletedOrderColumn directive.
     * Mise en forme de la colonne "supprimé" de l'onglet Demandes (mode supervision).
     * @ngInject
     */
    vitisApp.appDeletedOrderColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appDeletedOrderColumn", function (value) {
                    var sEnabledClassName;
                    if (scope["row"]["entity"][scope["col"]["field"]])
                        sEnabledClassName = "false-icon";
                    else if (!scope["row"]["entity"][scope["col"]["field"]])
                        sEnabledClassName = "";
                    // Classes css (ui-grid + spécifiques).
                    element[0].className = "ui-grid-cell-contents " + sEnabledClassName;
                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        }
    };
    vitisApp["compileProvider"].directive("appDeletedOrderColumn", vitisApp.appDeletedOrderColumnDrtv);

    /**
     * ModifyStatus function.
     * Réinitialise une ou plusieurs demandes.
     */
    angular.element(vitisApp.appMainDrtv).scope()["ModifyStatus"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $q = angular.element(vitisApp.appMainDrtv).injector().get(["$q"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("ModifyStatus");
        var scope = this;
        var deferred = $q.defer();
        var promise = deferred.promise;
        var oParams = {};
        // Des demandes sont sélectionnées ?
        var aSelectedRows = scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["selection"]["getSelectedRows"]();
        if (aSelectedRows.length > 0) {
            // Sauve la sélection
            scope["saveGridSelection"](scope, scope["gridOptions"]);
            // Liste des enregistrements à supprimer.
            var i = 0, aIdToDelete = [];
            while (i < aSelectedRows.length) {
                aIdToDelete.push(aSelectedRows[i][envSrvc["oSelectedObject"]["sIdField"]]);
                i++;
            }
            oParams["idList"] = aIdToDelete.join("|");
            //
            ajaxRequest({
                "method": "PUT",
                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/orders/reset",
                "data": oParams,
                "scope": scope,
                "success": function(response) {
                    if (response["data"]["status"] == 0) {
                        // Affichage de la fenêtre modale d'erreur.
                        var oOptions = {
                            "className": "modal-danger",
                            "message": response["data"]["errorMessage"]
                        };
                        scope["modalWindow"]("dialog", "ERROR_RESET_ORDER_SUPERVISION_ORDER", oOptions);
                    } else {
                        // Ferme la fenêtre modale.
                        bootbox["hideAll"]();
                        // Recharge la liste des demandes.
                        scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["pagination"]["raise"]["paginationChanged"](1, scope["gridOptions"]["paginationPageSize"]);
                    }
                }
            });
        } else {
            var oOptions = {
                "className": "modal-danger",
                "appDuration": 2000
            };
            scope["modalWindow"]("dialog", "ERROR_NO_SELECTION_RESET_ORDER_SUPERVISION_ORDER", oOptions);
        }
        // Retourne la promesse.
        return promise;
    };

    /**
     * ActivateOrder function.
     * Active / désactive une demande.
     */
    angular.element(vitisApp.appMainDrtv).scope()["ActivateOrder"] = function (bActivate) {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $q = angular.element(vitisApp.appMainDrtv).injector().get(["$q"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("ActivateOrder");
        // Activation ou désactivation de l'abonnement ?
        if (typeof (bActivate) == "undefined")
            bActivate = true;
        //
        var scope = this;
        var deferred = $q.defer();
        var promise = deferred.promise;
        var oParams = {};
        // Des demandes sont sélectionnées ?
        var aSelectedRows = scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["selection"]["getSelectedRows"]();
        var sOperationId;
        if (aSelectedRows.length > 0) {
            // Activation ou désactivation de l'abonnement ?
            var sErrorTitle;
            if (bActivate) {
                sOperationId = "activate";
                sErrorTitle = "ERROR_ACTIVATE_ORDER_SUPERVISION";
            } else {
                sOperationId = "desactivate";
                sErrorTitle = "ERROR_DESACTIVATE_ORDER_SUPERVISION";
            }
            // Liste des enregistrements à supprimer.
            var i = 0, aIdToDelete = [];
            while (i < aSelectedRows.length) {
                aIdToDelete.push(aSelectedRows[i][envSrvc["oSelectedObject"]["sIdField"]]);
                i++;
            }
            oParams["idList"] = aIdToDelete.join("|");
            ajaxRequest({
                "method": "PUT",
                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/orders/" + sOperationId,
                "data": oParams,
                "scope": scope,
                "success": function(response) {
                    if (response["data"]["status"] == 0) {
                        var oOptions = {
                            "className": "modal-danger",
                            "message": response["data"]["errorMessage"]
                        };
                        scope["modalWindow"]("dialog", sErrorTitle, oOptions);
                    } else {
                        // Ferme la fenêtre modale.
                        bootbox["hideAll"]();
                        // Recharge la liste des demandes.
                        scope.$root["gridApi"][scope["sSelectedGridOptionsName"]]["pagination"]["raise"]["paginationChanged"](1, scope["gridOptions"]["paginationPageSize"]);
                    }
                }
            });
        } else {
            var oOptions = {
                "className": "modal-danger",
                "appDuration": 2000
            };
            scope["modalWindow"]("dialog", "ERROR_NO_SELECTION_RESET_ORDER_SUPERVISION_ORDER", oOptions);
        }
        // Retourne la promesse.
        return promise;
    };

    /**
     * DesactivateOrder function.
     * Désactive une demande.
     */
    angular.element(vitisApp.appMainDrtv).scope()["DesactivateOrder"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        //
        $log.info("DesactivateOrder");
        this["ActivateOrder"](false);
    }

    /**
     * afterProjectDirectory function.
     * Actions à effectuer après l'upload d'un fichier dans le répertoire d'un projet fme.
     */
    angular.element(vitisApp.appMainDrtv).scope()["afterProjectDirectory"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        //
        $log.info("afterProjectDirectory");
        // Remise à zéro du formulaire.
        this["resetForm"]();
        angular.element("input[type=file]")["fileinput"]("clear");
        // Recharge la liste des fichiers.
        this["loadTreeview"]();
    }

    /**
     * afterMyWorkRemoval function.
     * Actions à effectuer après la suppression d'un enregistrement dans le mode "my_work".
     */
    angular.element(vitisApp.appMainDrtv).scope()["afterMyWorkRemoval"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("afterMyWorkRemoval");
        delete envSrvc["oLastSelectedObjectMode"]["supervision"];
    }

    /**
     * afterSupervisionRemoval function.
     * Actions à effectuer après la suppression d'un enregistrement dans le mode "Supervision".
     */
    angular.element(vitisApp.appMainDrtv).scope()["afterSupervisionRemoval"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("afterSupervisionRemoval");
        delete envSrvc["oLastSelectedObjectMode"]["my_work"];
    }

    /**
     * ImportWorkspaces function.
     * Import en masse des projets fme.
     */
    angular.element(vitisApp.appMainDrtv).scope()["ImportWorkspaces"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $compile = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$compile"]);
        var $templateRequest = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$templateRequest"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        //
        $log.info("ImportWorkspaces");
        // Supprime les données de l'onglet "Projet FME".
        modesSrvc["clearObjectData"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"]);
        //
        var scope = this.$new();
        // Paramètres de l'onglet d'importation.
        envSrvc["oSelectedObject"] = {
            "actions": [],
            "columns": [],
            "mode_id": envSrvc["oSelectedMode"]["mode_id"],
            "name": "import_" + envSrvc["oSelectedObject"]["name"],
            "ressource_id": null,
            "sections": "",
            "template_name": "importWorkspace"
        };
        // Sauve le nouvel onglet.
        var oMode = modesSrvc["getMode"](envSrvc["oSelectedMode"]["mode_id"]);
        oMode["objects"].push(angular.copy(envSrvc["oSelectedObject"]));
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        // Compilation du template "doubleFormTpl".
        //var sTemplateUrl = 'templates/doubleFormTpl.html';
        var sTemplateUrl = 'modules/gtf/templates/importWorkspaceTpl.html';
        $templateRequest(sTemplateUrl).then(function (sTemplate) {
            $compile($("#container_mode_" + envSrvc["oSelectedMode"]["mode_id"]).html(sTemplate).contents())(scope);
        });
    }

    /**
     * appWorkspaceFormColumn directive.
     * Mise en forme de la colonne "form" dans la liste de l'onglet "projet FME" (Publication) .
     * @param {service} $translate Translate service.
     * @ngInject
     */
    vitisApp.appWorkspaceFormColumnDrtv = function () {
        return {
            link: function (scope, element, attrs) {
                // 1er affichage ou tri de la liste : maj de la mise en forme.
                var clearObserver = attrs.$observe("appWorkspaceFormColumn", function (value) {
                    var sContentLabel = "", sWorkspaceFormTypeClassName;
                    if (value == "")
                        sWorkspaceFormTypeClassName = "false-icon";
                    else if (value == "default")
                        sWorkspaceFormTypeClassName = "true-icon";
                    else if (value == "custom")
                        sWorkspaceFormTypeClassName = "custom-icon";
                    // Classes css (ui-grid + spécifiques).
                    element[0].className = "ui-grid-cell-contents " + sWorkspaceFormTypeClassName;

                });
                // Attends la suppression du scope.
                scope.$on("$destroy", function () {
                    // Supprime l'observateur.
                    clearObserver();
                });
            }
        }
    };
    vitisApp["compileProvider"].directive("appWorkspaceFormColumn", vitisApp.appWorkspaceFormColumnDrtv);

    /**
     * showWorkspaceDescription function.
     * Affiche la description des projets FME listés pour la création d'une demande.
     */
    angular.element(vitisApp.appMainDrtv).scope()["showWorkspaceDescription"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $rootScope = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$rootScope"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("showWorkspaceDescription");
        // Cache tous les tooltip.
        $(".popover")["popover"]('hide');
        // Evènement "change" sur le <select> des projets FME.
        var oWorkspaceSelectElement = document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] select[name='workspace_id']");
        oWorkspaceSelectElement.removeEventListener("change", angular.element(vitisApp.appMainDrtv).scope().showWorkspaceDescription);
        oWorkspaceSelectElement.addEventListener("change", angular.element(vitisApp.appMainDrtv).scope().showWorkspaceDescription);
        //
        var aWorkspaces = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["workspace_id"]["options"];
        if (aWorkspaces.length > 1) {
            var aWorkspacesId = [], oWorkspacesDescription = {};
            aWorkspaces.forEach(function (oOption) {
                if (oOption["value"] != "")
                    aWorkspacesId.push(oOption["value"]);
            })

            // Charge le titre et résumé des projets FME.
            var oParams = {
                "filter": {
                    "relation": "AND",
                    "operators": [
                        {
                            "column": "workspace_id",
                            "compare_operator": "IN",
                            "value": aWorkspacesId
                        },
                        {
                            "column": "description",
                            "compare_operator": "<>",
                            "value": "NULL"
                        }
                    ]
                }
            }
            ajaxRequest({
                "method": "GET",
                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces",
                "params": oParams,
                "scope": $rootScope,
                "success": function(response) {
                    if (response["data"]["status"] == 1) {
                        if (response["data"]["list_count"] > 0) {
                            // Sauve le titre et résumé des projets FME.
                            response["data"]["workspaces"].forEach(function (oWorkspace) {
                                if (oWorkspace["description"] != "") {
                                    oWorkspacesDescription[oWorkspace["workspace_id"]] = {
                                        "name": oWorkspace["name"],
                                        "description": oWorkspace["description"]
                                    };
                                }
                            });
                            $rootScope["oWorkspacesDescription"] = oWorkspacesDescription;
                            // Création des tooltips.
                            //var oSelectElement = document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] select[name='workspace_id']");
                            var i = 0;
                            while (i < oWorkspaceSelectElement.length) {
                                if (typeof (oWorkspacesDescription[oWorkspaceSelectElement.options[i].value]) != "undefined") {
                                    var oOptions = {
                                        "trigger": "hover",
                                        "title": function () {
                                            if (!isNaN(this.value))
                                                return $rootScope["oWorkspacesDescription"][this.value]["name"];
                                        },
                                        "content": function () {
                                            if (isNaN(this.value))
                                                $(this)["popover"]("destroy");
                                            else
                                                return $rootScope["oWorkspacesDescription"][this.value]["description"];
                                        },
                                        "container": "body",
                                        "html": true
                                    };
                                    $(oWorkspaceSelectElement.options[i])["popover"](oOptions);
                                }
                                i++;
                            }
                        }
                    }
                }
            });
        }
    }

    /**
     * showGtfLicenseInfos function.
     * Affiche les infos. de la licence de Gtf.
     */
    angular.element(vitisApp.appMainDrtv).scope()["showGtfLicenseInfos"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $templateRequest = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$templateRequest"]);
        var $compile = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$compile"]);
        var $timeout = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$timeout"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        //
        $log.info("showGtfLicenseInfos");
        var scope = this.$new();
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        // Attends la compilation du formulaire de la section "licence".
        var clearListener = scope.$root.$on('endFormNgRepeat', function (event) {
            // Supprime le "listener".
            clearListener();
            ajaxRequest({
                "method": "GET",
                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/license",
                "scope": scope,
                "success": function(response) {
                    if (response["data"]["status"] == 1) {
                        // Attends la fin du $digest().
                        $timeout(function () {
                            scope["oGtfLicenseInfos"] = response["data"]["license"];
                            var sContainerElementName = envSrvc["sFormDefinitionName"] + "_license_infos_container";
                            var oLicenseInfosElement = document.querySelector("#" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + " .form-row:nth-child(2)");
                            // Crée l'élément conteneur pour afficher les infos de la licence.
                            if (document.getElementById(sContainerElementName) == null) {
                                var oDiv = document.createElement("div");
                                oDiv.id = envSrvc["sFormDefinitionName"] + "_license_infos_container";
                                oLicenseInfosElement.parentElement.insertBefore(oDiv, oLicenseInfosElement);
                            }
                            // Le fichier de licence a été trouvé ?
                            var sErrorMessage;
                            if (scope["oGtfLicenseInfos"]["license"] !== true)
                                sErrorMessage = "FORM_LICENSE_NOT_FOUND_CONFIGURATION_CONFIGURATION_GTF_LICENSE";
                            // Compile le template du résultat.
                            $templateRequest("modules/gtf/templates/gtfLicenceTpl.html").then(function (sTemplate) {
                                $compile($("#" + sContainerElementName).html(sTemplate).contents())(scope);
                            });
                        });
                    }
                }
            });
        });
    }

    /**
     * showGtfLincenseFileRequestForm function.
     * Affichage de la fenêtre modale et du formulaire de demande d'un fichier de licence pour Gtf.
     */
    angular.element(vitisApp.appMainDrtv).scope()["showGtfLincenseFileRequestForm"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $compile = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$compile"]);
        var $templateRequest = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$templateRequest"]);
        var $translate = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$translate"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        //
        $log.info("showGtfLincenseFileRequestForm");
        // Crée un nouveau scope.
        var scope = this.$new();
        // Sauve le nouveau scope crée dans la définition de l'onglet. 
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        //
        var sFormId = "form_gtf_license_file_request_" + envSrvc["oSelectedObject"]["name"];
        // Traduction du titre et affichage de la fenêtre modale.
        var oOptions = {
            "className": "dialog-modal-window",
            "message": '<div id="' + sFormId + '"></div>',
        };
        scope["modalWindow"]("dialog", "FORM_TITLE_REQUEST_LICENCE_CONFIGURATION_CONFIGURATION_GTF_LICENSE", oOptions);

        // Nom + url du formulaire.
        scope["sFormDefinitionName"] = envSrvc["oSelectedObject"]["name"] + "_gtf_license_file_request_form";
        envSrvc["sFormDefinitionName"] = scope["sFormDefinitionName"];
        // Paramètres pour la requête ajax du subform.
        scope["oFormRequestParams"] = {
            "sUrl": "modules/gtf/forms/configuration/gtf_license_file_request.json",
        };
        // Suppression de la définition et des données du formulaire (sinon problème de cache...).
        //formSrvc["clearFormData"](scope["sFormDefinitionName"]);
        scope.$root["clearFormData"](scope["sFormDefinitionName"], scope);
        // Pas de données de form. à charger.
        scope["bLoadFormValues"] = false;

        // Valeurs du formulaire.
        $translate(["FORM_MAIL_BODY_MESSAGE_REQUEST_LICENCE_CONFIGURATION_CONFIGURATION_GTF_LICENSE"], {"sHostName": location.hostname}).then(function (oTranslations) {
            envSrvc["oFormValues"][scope["sFormDefinitionName"]] = {
                "to": "codes@veremes.com",
                "message": oTranslations["FORM_MAIL_BODY_MESSAGE_REQUEST_LICENCE_CONFIGURATION_CONFIGURATION_GTF_LICENSE"]
            };
        });

        // Compile le template de formulaire.
        var sTemplateUrl = 'templates/formTpl.html';
        $templateRequest(sTemplateUrl).then(function (sTemplate) {
            $compile($("#" + sFormId).html(sTemplate).contents())(scope);
        });
        $log.info('compileObjectTemplate : ' + sTemplateUrl);
    };

    /**
     * activateGtfLicense function.
     * Activation de la licence de Gtf à partir du fichier fourni.
     */
    angular.element(vitisApp.appMainDrtv).scope()["activateGtfLicense"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("activateGtfLiecense");
        var scope = this;
        //
        envSrvc["sFormDefinitionName"] = envSrvc["oSelectedObject"]["name"] + "_" + envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]]["sections"][envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]]["iSelectedSectionIndex"]]["name"] + "_" + envSrvc["sMode"] + "_form";
        scope["sFormDefinitionName"] = envSrvc["sFormDefinitionName"];
        // Envoi du fichier de licence.
        ajaxRequest({
            "method": "POST",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/license",
            "params": {"action": "activate"},
            "data": formSrvc["getFormData"](envSrvc["sFormDefinitionName"]),
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] == 1) {
                    // Affichage du message de succés.
                    $translate("LICENSE_FILE_INSTALL_SUCCESS_CONFIGURATION_CONFIGURATION_GTF_LICENSE").then(function (sTranslation) {
                        $.notify(sTranslation, "success");
                        // Reset du  formulaire.
                        document.querySelector("form[name='" + envSrvc["oFormDefinition"][scope["sFormDefinitionName"]]["name"] + "']").reset();
                        // Affiche les infos de la licence.
                        scope["showGtfLicenseInfos"]();
                        // Evènement pour raffraichir l'affichage.
                        scope.$root.$emit('endFormNgRepeat');
                    });
                } else {
                    // Affichage du message d'erreur.
                    // Message d'erreur ?
                    if (typeof (response["data"]["errorMessage"]) != "undefined" && response["data"]["errorMessage"] != null)
                        var sText = response["data"]["errorMessage"];
                    // Paramètres de la fenêtre modale.
                    var oOptions = {
                        "className": "modal-danger",
                        "message": sText,
                    };
                    // Affichage de la fenêtre modale.
                    scope["modalWindow"]("dialog", "FORM_VALIDATION_ERROR", oOptions);
                }
            }
        });
    };

    /**
     * askGtfLicenseFile function.
     * Activation de la licence de Gtf à partir du fichier fourni.
     */
    angular.element(vitisApp.appMainDrtv).scope()["askGtfLicenseFile"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("activateGtfLiecense");
        var scope = this;
        //
        //envSrvc["sFormDefinitionName"] = envSrvc["oSelectedObject"]["name"] + "_" + envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]]["sections"][envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]]["iSelectedSectionIndex"]]["name"] + "_" + envSrvc["sMode"] + "_form";
        //scope["sFormDefinitionName"] = envSrvc["sFormDefinitionName"];
        // Paramètres pour le Web Service (nom + contenu des champs de form.).
        var oWebServiceParams = formSrvc["getFormData"](envSrvc["sFormDefinitionName"], true);
        //var sLicenseNumber = envSrvc["oFormValues"][scope["sFormDefinitionName"]]["licence_number"];
        $translate(["MAIL_SUBJECT_LICENSE_TEMP_REQUEST_LICENCE_CONFIGURATION_CONFIGURATION_GTF_LICENSE", "MAIL_SUBJECT_LICENSE_REQUEST_LICENCE_CONFIGURATION_CONFIGURATION_GTF_LICENSE"], oWebServiceParams).then(function (oTranslations) {
            if (typeof (oWebServiceParams["license_number"]) == "undefined")
                oWebServiceParams["subject"] = oTranslations["MAIL_SUBJECT_LICENSE_TEMP_REQUEST_LICENCE_CONFIGURATION_CONFIGURATION_GTF_LICENSE"];
            else
                oWebServiceParams["subject"] = oTranslations["MAIL_SUBJECT_LICENSE_REQUEST_LICENCE_CONFIGURATION_CONFIGURATION_GTF_LICENSE"];
            // Envoi du fichier de licence.
            ajaxRequest({
                "method": "POST",
                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/license",
                "params": {"action": "ask"},
                "scope": scope,
                "data": oWebServiceParams,
                "success": function(response) {
                    // Ferme la fenêtre modale.
                    bootbox["hideAll"]();
                    if (response["data"]["status"] == 1) {
                        // Affichage du message de succés.
                        $translate("SEND_MAIL_SUCCESS_CONFIGURATION_CONFIGURATION_GTF_LICENSE").then(function (sTranslation) {
                            $.notify(sTranslation, "success");
                        });
                    } else {
                        // Affichage du message d'erreur.
                        // Message d'erreur ?
                        if (typeof (response["data"]["errorMessage"]) != "undefined" && response["data"]["errorMessage"] != null)
                            var sText = response["data"]["errorMessage"];
                        // Paramètres de la fenêtre modale.
                        var oOptions = {
                            "className": "modal-danger",
                            "message": sText,
                        };
                        // Affichage de la fenêtre modale.
                        scope["modalWindow"]("dialog", "FORM_VALIDATION_ERROR", oOptions);
                    }
                }
            });
        });

    };

    /**
     * loadEmailTemplateSimpleEdition function.
     * Chargement des tags pour l'éditeur TinyMCE de l'onglet Modèles e-mail > edition simplifié.
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadEmailTemplateSimpleEdition"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $timeout = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$timeout"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        //
        $log.info("loadEmailTemplateSimpleEdition");
        var scope = this;
        // Suppression de tous les éditeurs de tinyMCE.
        tinymce["remove"]();
        // Attends la fin de l'affichage du 1er formulaire.
        var clearListener = scope.$root.$on('endFormNgRepeat', function (event) {
            // Supprime le "listener".
            clearListener();
            ajaxRequest({
                "method": "GET",
                "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/emailtemplates/" + envSrvc["sId"] + "/Tags",
                "params": {"language": propertiesSrvc["language"]},
                "scope": scope,
                "success": function(response) {
                    if (response["data"]["status"] == 1) {
                        $timeout(function () {
                            // Toolbar des boutons.
                            var aTagsToolbar = [];
                            response["data"]["tags"].forEach(function (oTag) {
                                aTagsToolbar.push(oTag["name"]);
                            });
                            // Création de l'éditeur TinyMCE.
                            var oFormElement = formSrvc["getFormElementDefinition"]("body", envSrvc["sFormDefinitionName"]);
                            var oOptions = {
                                "selector": "form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] textarea[name='" + oFormElement["name"] + "']",
                                "theme": "modern",
                                "entity_encoding": "raw",
                                "mode": "exact",
                                "min_height": 200,
                                "setup": function (editor) {
                                    // Création des boutons pour les tags.
                                    response["data"]["tags"].forEach(function (oTag) {
                                        editor["addButton"](oTag["name"], {
                                            text: "[" + oTag["name"] + "]",
                                            tooltip: oTag["description"],
                                            icon: false,
                                            size: "small",
                                            onclick: function () {
                                                editor["insertContent"]("[" + oTag["name"] + "]");
                                            }
                                        }
                                        );
                                    });
                                    // Sauve le contenu de l'éditeur tinyMCE à chaque changement.
                                    editor["on"]("change", function () {
                                        envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]][oFormElement["name"]] = editor["getContent"]();
                                    });
                                },
                                "toolbar1": "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | preview fullpage | forecolor backcolor",
                                "toolbar2": aTagsToolbar.join(" | ")
                            };
                            // Non modifable (mode "display").
                            if (envSrvc["sMode"] == "display")
                                oOptions["readonly"] = 1;
                            if (propertiesSrvc["language"] != "en")
                                oOptions["language"] = propertiesSrvc["language"] + "_" + propertiesSrvc["language"].toUpperCase();
                            tinymce["init"](oOptions);
                        });
                    }
                }
            });
        });
    };

    /**
     * resizeProjectDirectoryTreeviewContainer function.
     * Calcule la hauteur de l'élément conteneur du treeview pour l'onglet "Projet FME" > "Répertoire projet".
     */
    angular.element(vitisApp.appMainDrtv).scope()["resizeProjectDirectoryTreeviewContainer"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        //
        $log.info("resizeProjectDirectoryTreeviewContainer");
        // Calcule la hauteur de l'élément conteneur du treeview.
        if (document.getElementById("project-directory") != null) {
            var iTitleHeight = document.getElementById("project_directory_title_container").clientHeight;
            var iFormHeight = document.getElementById("project_directory_form_container").clientHeight;
            document.getElementById("project-directory-treeview-container").style.height = document.getElementById("project-directory").clientHeight - iTitleHeight - iFormHeight + "px";
        }
    };


    /**
     * loadGtfConfig function.
     * Chargement de la section "Configuration GTF" dans l'onglet "Configuration".
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadGtfConfig"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        //
        $log.info("loadGtfConfig");
        // Paramètres des properties dans les valeurs du formulaire de config de GTF.
        angular.element(vitisApp.appMainDrtv).scope()["setPropertiesFormValues"]();
        // Surcharge l'url du formulaire des properties de GTF.
        var scope = this;
        var sTable = envSrvc["oSelectedObject"]["name"];
        scope["oFormRequestParams"] = {
            "sUrl": "modules/gtf/forms/" + envSrvc["oSelectedMode"]["mode_id"] + "/" + sTable + "_" + envSrvc["oSectionForm"][sTable]["sections"][envSrvc["oSectionForm"][sTable]["iSelectedSectionIndex"]]["name"] + ".json"
        };
    };

    /**
     * loadLicenseConfig function.
     * Chargement de la section "Licence" dans l'onglet "Configuration".
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadLicenseConfig"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        //
        $log.info("loadLicenseConfig");
        // Surcharge l'url du formulaire de la licence de GTF.
        var scope = this;
        var sTable = envSrvc["oSelectedObject"]["name"];
        scope["oFormRequestParams"] = {
            "sUrl": "modules/gtf/forms/" + envSrvc["oSelectedMode"]["mode_id"] + "/" + sTable + "_" + envSrvc["oSectionForm"][sTable]["sections"][envSrvc["oSectionForm"][sTable]["iSelectedSectionIndex"]]["name"] + ".json"
        };
        // Affichage des infos. de la licence de Gtf.
        angular.element(vitisApp.appMainDrtv).scope()["showGtfLicenseInfos"]();
    };

    /**
     * refreshStatistics function.
     * Recalcule les stats.
     */
    angular.element(vitisApp.appMainDrtv).scope()["refreshStatistics"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        //
        $log.info("refreshStatistics");
        if (envSrvc["oSelectedMode"]["mode_id"] === "statistics")
            $('#btn_start_stats').click();
    };

    /**
     * loadPublicToken function.
     * Met à jour le champ de form. "Jeton de connexion" (Projet FME > Appel Externe)avec un token public.
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadPublicToken"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var propertiesSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["propertiesSrvc"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("loadPublicToken");
        envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["token"] = propertiesSrvc["public_token"];
    };

    /**
     * importToken function.
     * Met à jour le champ de form. "Jeton de connexion" (Projet FME > Appel Externe) avec un token public.
     */
    angular.element(vitisApp.appMainDrtv).scope()["importToken"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $compile = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$compile"]);
        var $templateRequest = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$templateRequest"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var modesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["modesSrvc"]);
        //
        $log.info("importToken");
        var scope = this.$new();
        modesSrvc["addScopeToObject"](envSrvc["oSelectedObject"]["name"], envSrvc["oSelectedMode"]["mode_id"], scope);
        var sFormContainerId = envSrvc["oSelectedObject"]["name"] + "_import_token_form_container";
        // Traduction du titre et affichage de la fenêtre modale.
        var oOptions = {
            "className": "dialog-modal-window",
            "message": '<div id="' + sFormContainerId + '"></div>'
        };
        scope["modalWindow"]("dialog", "TOOLTIP_TITLE_IMPORT_TOKEN_CONNECTION", oOptions);

        // Nom + url du formulaire.
        scope["sFormDefinitionName"] = envSrvc["oSelectedObject"]["name"] + "_import_token_form";
        //envSrvc["sFormDefinitionName"] = scope["sFormDefinitionName"];
        // Paramètres pour la requête ajax du subform.
        scope["oFormRequestParams"] = {
            "sUrl": "modules/gtf/forms/publication/import_token_connection.json"
        };
        // Suppression de la définition et des données du formulaire (sinon problème de cache...).
        //formSrvc["clearFormData"](scope["sFormDefinitionName"]);
        scope.$root["clearFormData"](scope["sFormDefinitionName"], scope);
        // Pas de données de form. à charger.
        scope["bLoadFormValues"] = false;
        envSrvc["oFormValues"][scope["sFormDefinitionName"]] = {};

        // Compile le template de formulaire.
        var sTemplateUrl = 'templates/formTpl.html';
        $templateRequest(sTemplateUrl).then(function (sTemplate) {
            $compile($("#" + sFormContainerId).html(sTemplate).contents())(scope);
        });
    };

    /**
     * loadPrivateToken function.
     * Envoi une demande de token privé et met à jour le champ "Jeton de connexion" (Projet FME > Appel Externe).
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadPrivateToken"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        var sessionSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["sessionSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        // .
        $log.info("loadPrivateToken");
        var scope = this;
        var oFormValues = envSrvc["oFormValues"][scope["sFormDefinitionName"]];
        var oEndDate = formSrvc["getFormElementDefinition"]("end_date", scope["sFormDefinitionName"]);
        var oData = {
            "user": oFormValues["user"],
            "password": oFormValues["password"],
            "duration": parseInt((parseInt($("#" + oEndDate["id"]).data("DateTimePicker")["date"]().format("x")) + 86400000 - Date.now()) / 60000) + 1 // Durée du token en minutes.
        };
        // Demande de token pour l'utilisateur.
        ajaxRequest({
            "method": "POST",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/" + sessionSrvc["web_service"] + "/privatetoken",
            "data": oData,
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] === 1) {
                    // Met à jour le champ "Jeton de connexion" avec le token.
                    envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["token"] = response["data"]["token"];
                    // Ferme la fenêtre modale.
                    bootbox["hideAll"]();
                } else {
                    var oOptions = {"className": "modal-danger"};
                    // Message d'erreur ?
                    if (response["data"]["errorMessage"] !== null)
                        oOptions["message"] = response["data"]["errorMessage"];
                    scope["modalWindow"]("alert", "ERROR_IMPORT_TOKEN_CONNECTION", oOptions);
                }
            }
        });
    };

    /**
     * generateCodeWidget function.
     * Compile le template du widget et affiche le code dans le champ codeMirror.
     */
    angular.element(vitisApp.appMainDrtv).scope()["generateCodeWidget"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(['$log']);
        var $compile = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(['$compile']);
        var $timeout = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(['$timeout']);
        var $templateRequest = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(['$templateRequest']);
        var $templateCache = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(['$templateCache']);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(['envSrvc']);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(['formSrvc']);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(['propertiesSrvc']);
        //
        var sFormElementName = envSrvc['oFormDefinition'][envSrvc['sFormDefinitionName']]['name'];
        var formScope = angular.element('form[name=\'' + sFormElementName + '\']').scope();
        // Le formulaire est valide ?
        if (formScope[sFormElementName].$valid) {
            $log.info('generateCodeWidget');
            var scope = this;
            var oFormValues = envSrvc['oFormValues'][envSrvc['sFormDefinitionName']];
            // Paramètres pour le template du widget.
            scope['oWidgetParams'] = {
                'client_url': propertiesSrvc['web_server_name'] + '/' + sessionStorage['appEnv'],
                'button_label': vitisApp['htmlentities'](oFormValues['buttonText'])
            };
            // Fichiers js à charger.
            goog.object.extend(scope['oWidgetParams'], {
                'widget_iframe_url': scope['oWidgetParams']['client_url'] + '/modules/gtf/javascript/widget/index_iframe.html?version=' + propertiesSrvc['build'],
                'widget_popup_init_file_url': scope['oWidgetParams']['client_url'] + '/modules/gtf/javascript/widget/initPopup.js?version=' + propertiesSrvc['build'],
                'widget_embedded_init_file_url': scope['oWidgetParams']['client_url'] + '/modules/gtf/javascript/widget/initEmbedded.js?version=' + propertiesSrvc['build'],
                'load_external_files': scope['oWidgetParams']['client_url'] + '/modules/gtf/javascript/widget/loadExternalFiles.js?version=' + propertiesSrvc['build'],
                'less': scope['oWidgetParams']['client_url'] + '/javascript/externs/less/less.min.js?version=' + propertiesSrvc['build']
            });
            // Paramètres pour la fenêtre modale.
            scope['oWidgetParams']['modal_window_params'] = {
                'client_url': scope['oWidgetParams']['client_url'],
                'web_server_name': propertiesSrvc['web_server_name'],
                'widget_type': oFormValues['widgetType']['selectedOption']['value'],
                'title': vitisApp['htmlentities'](oFormValues['widget_title']),
                'width': oFormValues['width'],
                'height': oFormValues['height'],
                'key': oFormValues['key'],
                'token': oFormValues['token'],
                'window_id': oFormValues['divId'],
                'notification_type': oFormValues['notificationsType']['selectedOption']['value'],
                'notification': oFormValues['notifications']['selectedOption']['value'],
                'application': sessionStorage['application'],
                'captcha': oFormValues['captcha']['selectedOption']['value']
            };
            if (oFormValues['captcha']['selectedOption']['value'] === 'enable') {
                //scope['oWidgetParams']['modal_window_params']['captcha'] = oFormValues['captcha']['selectedOption']['value'];
                scope['oWidgetParams']['modal_window_params']['captcha_key'] = oFormValues['captcha_key'];
            }
            scope['sModalWindowParams'] = encodeURIComponent(JSON.stringify(scope['oWidgetParams']['modal_window_params']));
            var sTemplateUrl = 'modules/gtf/templates/widgetTpl.html';
            // Vide le cache des templates.
            $templateCache.remove(sTemplateUrl + '?vitis_version=' + propertiesSrvc['build']);
            // Compile le template du widget.
            $templateRequest(sTemplateUrl).then(function (sTemplate) {
                var oHtml = document.createElement('html');
                $compile($(oHtml).html(sTemplate).contents())(scope);
                // Attend la fin de la compilation et met à jour le champ codeMirror.
                $timeout(function () {
                    var sCode = oHtml.innerHTML;
                    // Sauve les paramètres pour l'iframe.
                    sCode = sCode.replace(/\[sModalWindowParams\]/g, scope['sModalWindowParams']);
                    // Décode l'entité html du caractère '&'.
                    sCode = sCode.replace(/&amp;/g, '&');
                    // Si Page Widget, token en paramètre
                    if (scope['oWidgetParams']['modal_window_params']['widget_type'] === 'File') {
                        sCode = sCode.replace(oFormValues['token'], "'+token+'");
                    }
                    // Supprime les commentaires d'angular.
                    sCode = sCode.replace(/<!--[\s\S]*?-->/g, '');
                    // Supprime tous les attributs d'angular.
                    sCode = sCode.replace(/ng-[a-z]+="[\s\S]*?"/g, '');
                    // Supprime les lignes vides.
                    oFormValues['code'] = sCode.replace(/^[ \t]*\n/gm, '');
                    // Création du fichier du widget et affichage des boutons
                    if (scope['oWidgetParams']['modal_window_params']['widget_type'] === 'File') {
                        ajaxRequest({
                            "method": "POST",
                            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces/" + oFormValues['workspace_id'] + "/GenerateWidgetFile",
                            "data": {"widgetFileContent": sCode},
                            "scope": scope,
                            "success": function(response) {
                                oFormValues['url_widget_file'] = propertiesSrvc['web_server_name'] + '/' + propertiesSrvc['ws_data_alias'] + '/gtf/widget/' + response["data"]['workspace_key'] + '.html?token=' + oFormValues['token'];
                                oFormValues['btn_download_widget_file'] = oFormValues['url_widget_file'];
                                formSrvc['getFormElementDefinition']('url_widget_file', envSrvc['sFormDefinitionName'])['visible'] = true;
                                formSrvc['getFormElementDefinition']('btn_download_widget_file', envSrvc['sFormDefinitionName'])['visible'] = true;
                                formSrvc['getFormElementDefinition']('btn_delete_widget_file', envSrvc['sFormDefinitionName'])['visible'] = true;
                            }
                        });
                    }
                    // Affiche le champ codeMirror.
                    var oFormFieldDefinition = formSrvc['getFormElementDefinition']('code', envSrvc['sFormDefinitionName']);
                    if (scope['oWidgetParams']['modal_window_params']['widget_type'] !== 'File') {
                        oFormFieldDefinition['visible'] = true;
                    } else {
                        oFormFieldDefinition['visible'] = false;
                    }
                    setTimeout(function () {
                        // Affiche le champ codeMirror.
                        if (scope['oWidgetParams']['modal_window_params']['widget_type'] !== 'File') {
                            // Hauteur de l'éditeur codeMirror.
                            document.querySelector('form[name=\'' + sFormElementName + '\'] .CodeMirror')['CodeMirror']['setSize']('100%', 200);
                        }
                    });
                });

            });
        }
    };

    /**
     * loadWorkspaceEditWidget function.
     * Traitements au lancement de la section "Appel Externe" du projet FME.
     */
    angular.element(vitisApp.appMainDrtv).scope()["loadWorkspaceEditWidget"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(['propertiesSrvc']);
        //
        $log.info("loadWorkspaceEditWidget");
        var scope = this;
        if (envSrvc["sMode"] !== "display") {
            // Attends la fin de la compilation du formulaire.
            var clearListener = this.$root.$on('endFormNgRepeat', function (event, sFormDefinitionName) {
                // Supprime le "listener".
                clearListener();
                var oCaptcha = document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] select[name='captcha']");
                var oCaptchaKey = formSrvc["getFormElementDefinition"]("captcha_key", envSrvc["sFormDefinitionName"]);
                var oCaptchaKeyField = document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] input[name='captcha_key']");
                var oButtonText = formSrvc["getFormElementDefinition"]("buttonText", envSrvc["sFormDefinitionName"]);
                var oWidgetType = document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] select[name='widgetType']");
                var oNotificationsType = document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] select[name='notificationsType']");
                var oNotifications = formSrvc["getFormElementDefinition"]("notifications", envSrvc["sFormDefinitionName"]);
                // Pas de captcha par défaut.
                oCaptchaKeyField.parentElement.style.display = "none";
                // Evènement sur le <select> du captcha.
                oCaptcha.addEventListener("change", function () {
                    var sDisplay = "";
                    var sRequired = true;
                    if (this.value === "disable") {
                        sDisplay = "none";
                        sRequired = false;
                    }
                    // Si captcha : clé obligatoire.
                    oCaptchaKeyField.parentElement.style.display = sDisplay;
                    oCaptchaKey["required"] = sRequired;
                });
                // Evènement sur le <select> du type de fenêtre.
                oWidgetType.addEventListener("change", function () {
                    var sDisplay = "";
                    if (this.value === "Embedded")
                        sDisplay = "none";
                    // Si <iframe> : pas de bouton pour ouvrir la fenêtre modale.
                    document.getElementById(oButtonText["id"]).parentElement.style.display = sDisplay;
                });
                // Evènement sur le <select> de notification par e-mail
                oNotificationsType.addEventListener("change", function () {
                    var sDisplay = "";
                    if (this.value === 2)
                        sDisplay = "none";
                    // Si pas de notification : pas de saisie de l'adresse.
                    document.getElementById(oNotifications["id"]).parentElement.style.display = sDisplay;
                });
                ajaxRequest({
                    "method": "GET",
                    "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/Workspaces/" + envSrvc["sId"] + "/CheckWidgetFile",
                    "scope": scope,
                    "success": function(response) {
                        if (response["data"]['status'] === 1) {
                            oFormValues['url_widget_file'] = propertiesSrvc['web_server_name'] + '/' + propertiesSrvc['ws_data_alias'] + '/gtf/widget/' + response["data"]['workspace_key'] + '.html?token=' + oFormValues['token'];
                            oFormValues['btn_download_widget_file'] = oFormValues['url_widget_file'];
                            formSrvc['getFormElementDefinition']('url_widget_file', envSrvc['sFormDefinitionName'])['visible'] = true;
                            formSrvc['getFormElementDefinition']('btn_download_widget_file', envSrvc['sFormDefinitionName'])['visible'] = true;
                            formSrvc['getFormElementDefinition']('btn_delete_widget_file', envSrvc['sFormDefinitionName'])['visible'] = true;
                        }
                    }
                });
            });
        }
    };

    /**
     * deleteWidgetFile function.
     * Suppression le fichier du widget.
     */
    angular.element(vitisApp.appMainDrtv).scope()['deleteWidgetFile'] = function () {
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(['envSrvc']);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(['propertiesSrvc']);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(['formSrvc']);
        //
        var scope = this;
        ajaxRequest({
            "method": "DELETE",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/Workspaces/" + envSrvc['sId'] + '/DeleteWidgetFile',
            "scope": scope,
            "success": function(response) {
                if (response["data"]['status'] === 1) {
                    // Supprimer le lien, et les boutons pour télécharger et supprimer le widget.
                    formSrvc['getFormElementDefinition']('url_widget_file', envSrvc['sFormDefinitionName'])['visible'] = false;
                    formSrvc['getFormElementDefinition']('btn_download_widget_file', envSrvc['sFormDefinitionName'])['visible'] = false;
                    formSrvc['getFormElementDefinition']('btn_delete_widget_file', envSrvc['sFormDefinitionName'])['visible'] = false;

                } else {
                    // Affichage de la fenêtre modale d'erreur.
                    this['modalWindow']('dialog', response["data"]['errorMessage'], {'className': 'modal-danger'});
                }
            }
        });
    };

    /**
     * regenerateWorkspaceMetaData function.
     * Régénération des métadonnées du workspace.
     */
    angular.element(vitisApp.appMainDrtv).scope()["regenerateWorkspaceMetaData"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("regenerateWorkspaceMetaData");
        var scope = this;
        ajaxRequest({
            "method": "GET",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces/" + envSrvc["sId"] + "/Metadata",
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] === 0) {
                    var oOptions = {
                        "className": "modal-danger",
                        "message": response["data"]["errorMessage"]
                    };
                    scope["modalWindow"]("dialog", "ERROR_REGENERATE_METADATA_PUBLICATION_WORKSPACE", oOptions);
                } else {
                    // Affiche le message de succés.
                    $translate("SUCCESSFUL_OPERATION").then(function (sTranslation) {
                        $.notify(sTranslation, "success");
                    });
                    // Recharge la section "Métadonnées" du projet FME.
                    var oWorkspaceSectionForm = envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]];
                    var iSelectedSectionIndex = oWorkspaceSectionForm["iSelectedSectionIndex"];
                    oWorkspaceSectionForm["sections"].forEach(function (aSection) {
                        // Force le rechargement de la section "Métadonnées".
                        if (aSection["name"] === "updateMetadata")
                            aSection["bLoaded"] = false;
                    });
                    // Suppression du scope du formulaire (sinon bug retour chariot avec TinyMCE).
                    var formScope = angular.element("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"]).scope();
                    formScope.$destroy();
                    // Recharge la section.
                    var sectionScope = angular.element("#container_mode_" + envSrvc["oSelectedMode"]["mode_id"] + " .section-form").scope();
                    sectionScope["selectSection"](iSelectedSectionIndex, oWorkspaceSectionForm["sections"][iSelectedSectionIndex]);
                }
            }
        });
    };

    /**
     * reintegrateWorkspaceMetaData function.
     * Réintégration des métadonnées du workspace.
     */
    angular.element(vitisApp.appMainDrtv).scope()["reintegrateWorkspaceMetaData"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("reintegrateWorkspaceMetaData");
        var scope = this;
        ajaxRequest({
            "method": "PUT",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces/" + envSrvc["sId"],
            "params": {"action": "Metadata"},
            "scope": scope,
            "success": function(response) {
                if (response["data"]["status"] === 0) {
                    var oOptions = {
                        "className": "modal-danger",
                        "message": response["data"]["errorMessage"]
                    };
                    scope["modalWindow"]("dialog", "ERROR_REEINTEGRATE_METADATA_PUBLICATION_WORKSPACE", oOptions);
                } else {
                    // Affiche le message de succés.
                    $translate("SUCCESSFUL_OPERATION").then(function (sTranslation) {
                        $.notify(sTranslation, "success");
                    });
                    // Recharge la section "Métadonnées" du projet FME.
                    var oWorkspaceSectionForm = envSrvc["oSectionForm"][envSrvc["oSelectedObject"]["name"]];
                    //var iSelectedSectionIndex = oWorkspaceSectionForm["iSelectedSectionIndex"];
                    oWorkspaceSectionForm["sections"].forEach(function (aSection) {
                        // Force le rechargement de la section "Répertoire projet".
                        if (aSection["name"] === "loadProjectDirectory")
                            aSection["bLoaded"] = false;
                    });
                }
            }
        });
    };

    /**
     * initPublicationWorkspaceGeneralForm function.
     * Traitement après le chargement du formulaire du projet FME (section general).
     */
    angular.element(vitisApp.appMainDrtv).scope()["initPublicationWorkspaceGeneralForm"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $translate = angular.element(vitisApp.appMainDrtv).injector().get(["$translate"]);
        var $rootScope = angular.element(vitisApp.appMainDrtv).injector().get(["$rootScope"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var formSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["formSrvc"]);
        //
        $log.info("initPublicationWorkspaceGeneralForm");
        var oFormValues = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]];
        // Intitulé suivant l'état du formulaire (par défaut, personnalisé...)
        var sTranslationId;
        switch (oFormValues["form_type"]) {
            case "custom":
                sTranslationId = "FORM_CUSTOM_FORM_PUBLICATION_WORKSPACE";
                break;
            case "default":
                sTranslationId = "FORM_DEFAULT_FORM_PUBLICATION_WORKSPACE";
                break;
            default:
                sTranslationId = "FORM_MISSING_FORM_PUBLICATION_WORKSPACE";
        }
        //
        $translate([sTranslationId]).then(function (aTranslation) {
            //var formScope = angular.element("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "']").scope();
            oFormValues["form_type"] = aTranslation[sTranslationId];
            angular.element(vitisApp.appMainDrtv).scope().$emit("WorkspaceGeneralSectionReady");
        });
        // Formatage de la date de création du projet FME.
        if (goog.isDefAndNotNull(oFormValues["creation_date"]))
            oFormValues["creation_date"] = moment(oFormValues["creation_date"]).format('L');
        // Traduction des valeurs booléennes (disponible sur abonnement, disponible pour surveillance, verrou).
        if (envSrvc["sMode"] === "display") {
            var scope = this;
            scope.$root["getBooleanTranslation"](oFormValues["subscription"]).then(function (sTranslation) {
                oFormValues["subscription"] = sTranslation;
            });
            scope.$root["getBooleanTranslation"](oFormValues["survey"]).then(function (sTranslation) {
                oFormValues["survey"] = sTranslation;
            });
        }
        // Paramètres du lien vers le fichier fmw du projet fme.
        var oFmwFileUrlElementDef = formSrvc["getFormElementDefinition"]("fmw_file_url", envSrvc["sFormDefinitionName"]);
        oFmwFileUrlElementDef["text"] = oFormValues["fmw_file"];
        oFormValues["fmw_file_url"] = "#";
        if (typeof(oFmwFileUrlElementDef["id"]) != "undefined")
            document.getElementById(oFmwFileUrlElementDef["id"]).setAttribute("onclick", "angular.element(vitisApp.appMainDrtv).injector().get([\"$rootScope\"])[\"downloadGtfWorkspaceFile\"](\"" + oFormValues["fmw_file"] + "\")");
        else {
            // Attends la fin de l'affichage du formulaire.
            var clearListener = $rootScope.$on('formExtracted', function (event) {
                clearListener();
                document.getElementById(oFmwFileUrlElementDef["id"]).setAttribute("onclick", "angular.element(vitisApp.appMainDrtv).injector().get([\"$rootScope\"])[\"downloadGtfWorkspaceFile\"](\"" + oFormValues["fmw_file"] + "\")");
            });
        }
    };

    /**
     * decodeFmeGtfTags function.
     * Remplace les balises FME et GTF par les caractères correspondants.
     * @param {string} str Chaine de caractère à convertir.
     */
    angular.element(vitisApp.appMainDrtv).scope()["decodeFmeGtfTags"] = function (str) {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        //
        $log.info("decodeFmeGtfTags");
        if (!goog.isString(str))
            return str;
        // table de correspondance
        var caracInGTF = ["<", ">", "\n", " ", "=", "(", ")", "$", "&", "@", "°", "'", ",", "\"", "{", "}", "[", "]", "|", ";", "/", "\\", "é", "à"];
        var caracForFME = ["<lt>", "<gt>", "<lf>", "<space>", "<GTF_EQUAL>", "<openparen>", "<closeparen>", "<dollar>", "<amp>", "<at>", "<u00b0>", "<apos>", "<comma>", "<quote>", "<opencurly>", "<closecurly>", "<openbracket>", "<closebracket>", "<GTF_PIPE>", "<semicolon>", "<solidus>", "<backslash>", "<u00e9>", "<u00e0>"];
        //variables parcours de chaine
        var result = str;

        for (var j = 0; j < caracInGTF.length; j++) {
            while (result.indexOf(caracForFME[j]) !== - 1)
                result = result.replace(caracForFME[j], caracInGTF[j]);
        }

        var code = result.search(/<u[0-9a-fA-F]{4}>/);
        while (code !== -1) {
            var part1 = result.substr(0, code);
            var char = result.substr(code + 2, code + 6);
            var part2 = result.substr(code + 7, result.length - 1);
            char = String.fromCharCode(parseInt(char, 16));
            result = part1 + char + part2;
            code = result.search(/<u[0-9a-fA-F]{4}>/);
        }

        return result;
    };

    /**
     * Load the studio with the gtf workspace params
     */
    angular.element(vitisApp.appMainDrtv).scope()['loadStudioGTF'] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $rootScope = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$rootScope"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["propertiesSrvc"]);
        var sessionSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["sessionSrvc"]);
        //
        $log.info("loadStudioGTF");

        /**
         * config.avaliable_elems {array} Type d'éléments disponibles
         * config.avaliable_form_types {array|undefined} Types de formulaire (update, insert etcc..) dispo. Si avaliable_form_types est null, alors l'application utilisera tous les types disponibles du formulaire
         * config.default_form_type {string} Type de formulaire selectionné par défaut
         * @type object
         */
        var config = {
            'avaliable_elems': ["title", "label", "radio", "textarea", "select", "list", "datetime", "upload", "hidden", "text", "password", "email", "url", "integer", "float", "number", "color_picker", "slider", "hr", "map_osm", "map_bing", "map_vmap", "ui_grid", "treeview"],
            'avaliable_form_types': ['insert'],
            'default_form_type': 'insert'
        };

        oVFB["reset"]();
        oVFB["setId"](envSrvc["sId"]);
        oVFB["setToken"](sessionSrvc["token"]);
        oVFB["setApplication"]("gtf");
        oVFB["setContainer"]("#container_section_" + envSrvc["oSelectedObject"]["name"] + "_SubForm");
        oVFB["setAppProperties"](propertiesSrvc);

        oVFB.init(config);
        // Attends la fin de l'affichage du formulaire.
        var clearListener = $rootScope.$on('formExtracted', function (event) {
            // Supprime le "listener".
            clearListener();
            // Rafraichissement du formulaire.
            $rootScope.$broadcast("updateJsonModel", oVFB.getJsonOutput());
            $rootScope.$broadcast("updateForm", oVFB.getJsonOutput());
        });
    };

    /**
     * initPublicationWorkspaceUpdateMetaDataForm function.
     * Traitement après le chargement du formulaire des métadonnées.
     */
    angular.element(vitisApp.appMainDrtv).scope()["initPublicationWorkspaceUpdateMetaDataForm"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("initPublicationWorkspaceUpdateMetaDataForm");
        // Formatage de la date de dernière sauvegarde des métadonnées.
        var scope = this;
        if (goog.isDefAndNotNull(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["last_save_date"])) {
            envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["last_save_date"] = moment(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["last_save_date"]).format('L LTS');
            scope.$apply();
        }
    };

    /**
     * initGtfEngineForm function.
     * Traitement après le chargement du formulaire des moteurs GTF.
     */
    angular.element(vitisApp.appMainDrtv).scope()["initGtfEngineForm"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("initGtfEngineForm");
        if (envSrvc["sMode"] === "display") {
            var scope = this;
            scope.$root["getBooleanTranslation"](envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"]).then(function (sTranslation) {
                envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"] = sTranslation;
            });
        }
    };

    /**
     * initPublicationEmailTemplateGeneralForm function.
     * Traitement après le chargement du formulaire des modèles d'email (section "general").
     */
    angular.element(vitisApp.appMainDrtv).scope()["initPublicationEmailTemplateGeneralForm"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("initPublicationEmailTemplateGeneralForm");
        if (envSrvc["sMode"] === "display") {
            var scope = this;
            scope.$root["getBooleanTranslation"](envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["use_advanced"]).then(function (sTranslation) {
                envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["use_advanced"] = sTranslation;
            });
        }
    };

    /**
     * initPublicationPeriodForm function.
     * Traitement après le chargement du formulaire des périodes.
     */
    angular.element(vitisApp.appMainDrtv).scope()["initPublicationPeriodForm"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        //
        $log.info("initPublicationPeriodForm");
        if (envSrvc["sMode"] === "display") {
            var scope = this;
            scope.$root["getBooleanTranslation"](envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"]).then(function (sTranslation) {
                envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["enabled"] = sTranslation;
            });
        }
    };

    /**
     * beforeProjectDirectory function.
     * Traitement avant l'envoi du formulaire de la section "Répertoire Projet" (publication > Projet FME).
     */
    angular.element(vitisApp.appMainDrtv).scope()["beforeProjectDirectory"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $q = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$q"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("beforeProjectDirectory");
        var scope = this;
        var deferred = $q.defer();
        var promise = deferred.promise;
        //
        var oFmwFile = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["fmw_file"];
        var oCompFile = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["comp_file"];
        var iMaxUploadFileSize = parseInt(propertiesSrvc["max_upload_file_size"]);
        var sErrorMessage;

        // Vérification du fichier .fmw.
        if (typeof (oFmwFile) === "object" && typeof (oFmwFile["aFiles"]) !== "undefined" && oFmwFile["aFiles"].length > 0) {
            if (oFmwFile["aFiles"][0]["name"].split(".").pop() === "fmw") {
                // Taille maxi du fichier.
                if (oFmwFile["aFiles"][0]["size"] > iMaxUploadFileSize)
                    sErrorMessage = "ERROR_FILE_SIZE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
            } else
                sErrorMessage = "ERROR_FMW_FILE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
        }
        // Vérification du fichier de ressources complémentaires.
        if (typeof (sErrorMessage) === "undefined") {
            if (typeof (oCompFile) === "object" && typeof (oCompFile["aFiles"]) !== "undefined" && oCompFile["aFiles"].length > 0) {
                var sFileExtension = oCompFile["aFiles"][0]["name"].split(".").pop();
                var sForbiddenExtension = propertiesSrvc["forbidden_extension"].replace(/[^a-zA-Z0-9\|]+/g, "");
                if (sForbiddenExtension.split("|").indexOf(sFileExtension) === -1) {
                    // Taille maxi du fichier.
                    if (oCompFile["aFiles"][0]["size"] > iMaxUploadFileSize)
                        sErrorMessage = "ERROR_FILE_SIZE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
                } else
                    sErrorMessage = "ERROR_ADDITIONAL_RESOURCES_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
            }
        }
        // Validation du formulaire.
        if (typeof (sErrorMessage) === "undefined")
            deferred.resolve();

        // Affichage de la fenêtre modale d'erreur.
        if (typeof (sErrorMessage) !== "undefined") {
            var oOptions = {
                "className": "modal-danger",
                "message": sErrorMessage
            };
            scope.$root["modalWindow"]("dialog", "FORM_VALIDATION_ERROR", oOptions);
        }
        //
        return promise;
    };

    /**
     * beforePublicationWorkspaceGeneralForm function.
     * Traitement avant l'envoi du formulaire de la section "Répertoire Projet" (publication > Projet FME).
     */
    angular.element(vitisApp.appMainDrtv).scope()["beforePublicationWorkspaceGeneralForm"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var $q = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$q"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("beforePublicationWorkspaceGeneralForm");
        var scope = this;
        var deferred = $q.defer();
        var promise = deferred.promise;
        //
        var oFmwFile = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["fmw_file"];
        var oCompFile = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["comp_file"];
        var iMaxUploadFileSize = parseInt(propertiesSrvc["max_upload_file_size"]);
        var sErrorMessage;

        // Vérification du fichier .fmw.
        if (typeof (oFmwFile) === "object" && typeof (oFmwFile["aFiles"]) !== "undefined" && oFmwFile["aFiles"].length > 0) {
            if (oFmwFile["aFiles"][0]["name"].split(".").pop() === "fmw") {
                // Taille maxi du fichier.
                if (oFmwFile["aFiles"][0]["size"] > iMaxUploadFileSize)
                    sErrorMessage = "ERROR_FILE_SIZE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
            } else
                sErrorMessage = "ERROR_FMW_FILE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
        }
        // Vérification du fichier de ressources complémentaires.
        if (typeof (sErrorMessage) === "undefined") {
            if (typeof (oCompFile) === "object" && typeof (oCompFile["aFiles"]) !== "undefined" && oCompFile["aFiles"].length > 0) {
                var sFileExtension = oCompFile["aFiles"][0]["name"].split(".").pop();
                var sForbiddenExtension = propertiesSrvc["forbidden_extension"].replace(/[^a-zA-Z0-9\|]+/g, "");
                if (sForbiddenExtension.split("|").indexOf(sFileExtension) === -1) {
                    // Taille maxi du fichier.
                    if (oCompFile["aFiles"][0]["size"] > iMaxUploadFileSize)
                        sErrorMessage = "ERROR_FILE_SIZE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
                } else
                    sErrorMessage = "ERROR_ADDITIONAL_RESOURCES_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
            }
        }

        // Validation du formulaire.
        if (typeof (sErrorMessage) === "undefined")
            deferred.resolve();

        // Affichage de la fenêtre modale d'erreur.
        if (typeof (sErrorMessage) !== "undefined") {
            var oOptions = {
                "className": "modal-danger",
                "message": sErrorMessage
            };
            scope.$root["modalWindow"]("dialog", "FORM_VALIDATION_ERROR", oOptions);
        }
        //
        return promise;
    };

    /**
     * getHurl function.
     * Retourne la valeur du paramètre "H_url" dans les formulaires json d'un projet FME.
     * @return {string}
     */
    angular.element(vitisApp.appMainDrtv).scope()["getHurl"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("getHurl");
        return (propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf");
    };

    /**
     * loadGtfGroup function.
     * Chargement de la section "Gtf" dans l'onglet "Groupes" (mode "Utilisateurs").
     **/
    angular.element(vitisApp.appMainDrtv).scope()["loadGtfGroup"] = function () {
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        //
        $log.info("loadGtfGroup");
        // Surcharge l'url du formulaire des groupes de Gtf.
        var scope = this;
        var sTable = envSrvc["oSelectedObject"]["name"];
        scope["oFormRequestParams"] = {
            "sUrl": "modules/gtf/forms/" + envSrvc["oSelectedMode"]["mode_id"] + "/" + sTable + "_" + envSrvc["oSectionForm"][sTable]["sections"][envSrvc["oSectionForm"][sTable]["iSelectedSectionIndex"]]["name"] + ".json"
        };
    };
    
    /**
     * loadGtfGroupQualigeo function.
     * Chargement de la section "Qualigeo" dans l'onglet "Groupes" (mode "Utilisateurs").
     **/
    angular.element(vitisApp.appMainDrtv).scope()["loadGtfGroupQualigeo"] = function () {
        console.log("FJHGIFHGFIHGIFHGIHGIORGHIO");
        // Injection des services.
        var $log = angular.element(vitisApp.appMainDrtv).injector().get(["$log"]);
        var envSrvc = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["envSrvc"]);
        //
        $log.info("loadGtfGroupQualigeo");
        // Surcharge l'url du formulaire des groupes de Gtf.
        var scope = this;
        var sTable = envSrvc["oSelectedObject"]["name"];
        scope["oFormRequestParams"] = {
            "sUrl": "modules/gtf/forms/" + envSrvc["oSelectedMode"]["mode_id"] + "/" + sTable + "_" + envSrvc["oSectionForm"][sTable]["sections"][envSrvc["oSectionForm"][sTable]["iSelectedSectionIndex"]]["name"] + ".json"
        };
    };
    
    /**
     * afterGtfEngineForm function.
     * Traitement apès l'envoi du formulaire de l'onglet "Moteur GTF".
     **/
    angular.element(vitisApp.appMainDrtv).scope()["afterGtfEngineForm"] = function () {
        // Injection des services.
        var $rootScope = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$rootScope"]);
        var $log = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$log"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("afterGtfEngineForm");
        // Recharge les properties.
        propertiesSrvc["getFromServer"]().then(function(){
            // Passage en mode "update" après la création d'un moteur GTF.
            $rootScope["editSectionForm"]()
        });
    };
    
    /**
     * deleteGtfEngine function.
     * Suppression d'un ou plusieurs moteurs GTF.
     **/
    angular.element(vitisApp.appMainDrtv).scope()["deleteGtfEngine"] = function () {
        // Injection des services.
        var $rootScope = angular.element(vitisApp.appStatisticsFormDrtv).injector().get(["$rootScope"]);
        var $log = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$log"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        //
        $log.info("deleteGtfEngine");
        // Recharge les properties après la suppression des enregistrements.
        var clearListener = $rootScope.$on('WorkspaceListSelectionRemoved', function (event) {
            // Supprime le "listener".
            clearListener();
            // Recharge les properties.
            propertiesSrvc["getFromServer"]();
        });
        // Supprime les enregistrements.
        $rootScope["DeleteSelection"]();
    };
    
    /**
     * downloadGtfWorkspaceFile function.
     * Téléchargement d'un fichier du répertoire "workspace" d'un projet.
     * @param {string} sFileName Nom du fichier.
     */
    angular.element(vitisApp.appWorkspaceListDrtv).scope()["downloadGtfWorkspaceFile"] = function (sFileName) {
        // Injection des services.
        var $log = angular.element(vitisApp.appWorkspaceListDrtv).injector().get(["$log"]);
        var propertiesSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["propertiesSrvc"]);
        var envSrvc = angular.element(vitisApp.appMainDrtv).injector().get(["envSrvc"]);
        // Log.
        $log.info("downloadGtfWorkspaceFile");
        // Charge le résumé de la supervision.
        var sWebServiceUrl = propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/Workspaces/" + envSrvc["sId"] + "/File";
        // Charge le fichier au format blob.
        ajaxRequest({
            "method": "GET",
            "url": sWebServiceUrl,
            "params": {
                "file_name": sFileName
            },
            //"scope": $scope,
            "responseType": "blob",
            "success": function(response) {
                if (typeof(window.navigator.msSaveOrOpenBlob) == "undefined") {
                    // Crée un lien et simule un click dessus.
                    var link = document.createElement('a');
                    link.href = window.URL.createObjectURL(response["data"]);
                    link.download = sFileName;
                    link.style.display = 'none';
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);
                }
                else {
                    // Pour Edge et IE.
                    window.navigator.msSaveOrOpenBlob(response["data"], sFileName);
                }
            }
        });
    };
});