'use strict';

var oUrlParams = {};
location.search.replace("?", "").split("&").forEach(function (sUrlParams) {
    var aUrlParams = sUrlParams.split("=");
    oUrlParams[aUrlParams[0]] = aUrlParams[1];
});
var token;
if (typeof oUrlParams['token'] === 'undefined')
    token = "";
else
    token = oUrlParams['token'];
/**
 * afterIframeLoad function.
 * Paramétrage de l'iframe et affichage du formulaire de la demande.
 * @param {object} oIframeElement Elément html de l'iframe.
 * @param {string} sModalWindowParams Paramètres du widget.
 **/
function afterIframeLoad(oIframeElement, sModalWindowParams) {
    var oModalWindowParams = JSON.parse(decodeURIComponent(sModalWindowParams));
    // Pas de bords.
    oIframeElement.style.border = "none";
    // Largeur et hauteur de l'iframe.
    var sWidth = oModalWindowParams["width"];
    if (!isNaN(sWidth))
        sWidth += "px";
    var sHeight = oModalWindowParams["height"];
    if (!isNaN(sHeight))
        sHeight += "px";
    oIframeElement.style.width = sWidth;
    oIframeElement.style.height = sHeight;
    // Lance l'affichage du formulaire de la demande.
    oIframeElement.contentWindow.postMessage(sModalWindowParams, "*");
};
