'use strict';

var oScript = document.querySelector("[data-modal-window-params*='client_url']")
if (oScript != null) {
    var oModalWindowParams = JSON.parse(decodeURIComponent(oScript.getAttribute("data-modal-window-params")));
    if (oModalWindowParams["client_url"] != null) {
        // Charge les fichiers css.
        var aCssFiles = [
            oModalWindowParams["client_url"] + "/less/main.less",
            oModalWindowParams["client_url"] + "/modules/gtf/less/widget.less",
            oModalWindowParams["client_url"] + "/css/lib/bootstrap/css/bootstrap.min.css"
        ];
        loadExternalCss(aCssFiles);
        // Charge les fichiers js.
        var aJsFiles = [
            oModalWindowParams["client_url"] + "/javascript/externs/jquery/jquery-1.11.3.min.js",
            oModalWindowParams["client_url"] + "/javascript/externs/jquery/plugins/bootbox/bootbox.min.js",
            oModalWindowParams["client_url"] + "/javascript/externs/bootstrap/bootstrap.min.js"
        ];
        //
        loadExternalJs(aJsFiles, {
            "async": false,
            //"scriptInBody": true,
                "callback": function () {
                    document.getElementById("btn_open_modal_window").addEventListener("click", function () {
                    // Affichage de la fenêtre modale.
                    var oOptions = {
                        "className": "dialog-modal-window widget-popup",
                        "message": '<div id="widget_form_container"><iframe src="' + oModalWindowParams["client_url"] + '/modules/gtf/javascript/widget/index_popup.html" name="gtf_widget_popup" id="' + oModalWindowParams["window_id"] + '" class="gtf-widget-iframe" onload="this.contentWindow.postMessage(\'' + oScript.getAttribute("data-modal-window-params") + '\',\'*\')"></iframe></div>',
                        "title": oModalWindowParams.title
                    };
                    var oDialog = bootbox["dialog"](oOptions);
                    // Largeur et hauteur du widget.
                    var sWidth = oModalWindowParams["width"];
                    if (!isNaN(sWidth))
                        sWidth += "px";
                    var sHeight = oModalWindowParams["height"];
                    if (!isNaN(sHeight))
                        sHeight += "px";
                    // Largeur et hauteur du widget.
                    oDialog[0].querySelector(".modal-content").style.width = sWidth;
                    oDialog[0].querySelector(".modal-content").style.height = sHeight;
                    // Hauteur du header du widget.
                    oDialog[0].querySelector(".modal-header").style.height = "56px";
                    // Hauteur du body du widget.
                    oDialog[0].querySelector(".modal-body").style.height = ($(oDialog).find(".modal-content").height() - 56 - 4) + "px";
                });
            }
        });
    }
}
