'use strict';

/**
 * oModalWindowParams Object
 * @type {object}
 * @export
 */
var oModalWindowParams = function(){};

// Mode debug ?
if (location.search.indexOf("debug") != -1)
        sessionStorage["debug"] = "true";
else
        sessionStorage["debug"] = "false";

window.addEventListener("message", function(event){
    // Charge les widgets une seule fois.
    if (Object.keys(oModalWindowParams).length == 0) {
        oModalWindowParams = JSON.parse(decodeURIComponent(event["data"]));
        if (oModalWindowParams["widget_type"] == "Embedded" || oModalWindowParams["widget_type"] == "File") {
            // Titre du formulaire.
            document.getElementById("widget_form_title").innerHTML = oModalWindowParams["title"];
        }
        else if (oModalWindowParams["widget_type"] == "Pop-up") {
            // Scrollbar sur l'iframe.
            document.querySelector("body").style.overflow = "auto";
        }
        //
        ajaxNativeRequest({"url": "../../../../conf/properties.json",
            "success": function(data){
                // Sauve les properties du client.
                window["oClientProperties"] = JSON.parse(data);
                // Surcharge le paramètre "web_server_name".
                window["oClientProperties"]["web_server_name"] = oModalWindowParams["web_server_name"];
                // Charge les fichiers css.
                var aCssFiles = [
                    "../../../../less/main.less",
                    "../../../../modules/gtf/less/widget.less",
                    "../../../../css/lib/bootstrap/css/bootstrap.min.css",
                    "../../../../css/lib/jquery/plugins/bootstrap-fileinput/css/fileinput.min.css",
                    "../../../../css/lib/jquery/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css",
                    "../../../../css/lib/bootstrap-checkbox/build.css",
                    "../../../../css/lib/bootstrap-checkbox/font-awesome.css",
                    "../../../../css/lib/jquery/plugins/bootstrap-slider/bootstrap-slider.min.css",
                    "../../../../css/lib/openlayers/ol.css",
                    "../../../../css/lib/jquery/plugins/bootstrap-treeview/bootstrap-treeview.min.css"
                ];
                loadExternalCss(aCssFiles);
                // Charge les fichiers js.
                var aJsFiles = [
                    //"../../../../conf/node_modules/google-closure-library/closure/goog/base.js",
                    "../../../../javascript/externs/jquery/jquery-1.11.3.min.js",
                    "../../../../javascript/externs/underscore-min.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-fileinput/fileinput.min.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-fileinput/fileinput_locale_fr.js",
                    "../../../../javascript/externs/jquery/plugins/bootbox/bootbox.min.js",
                    "../../../../javascript/externs/jquery/plugins/notify/notify.js",
                    "../../../../javascript/externs/angular/angular.min.js",
                    "../../../../javascript/externs/angular/modules/angular-translate/angular-translate.min.js",
                    "../../../../javascript/externs/angular/modules/angular-translate/angular-translate-loader-partial.min.js",
                    "../../../../javascript/externs/angular-bind-notifier/bindNotifier.js",
                    "../../../../javascript/externs/bootstrap/bootstrap.min.js",
                    "../../../../javascript/externs/moment/moment.min.js",
                    "../../../../javascript/externs/moment/min/moment-with-locales.min.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-colorpicker/bootstrap-colorpicker.min.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-datetimepicker/bootstrap-datetimepicker.min.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-datepicker/bootstrap-datepicker.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-datepicker/locales/bootstrap-datepicker.fr.min.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-slider/bootstrap-slider.min.js",
                    "../../../../javascript/externs/jquery/plugins/bootstrap-treeview/bootstrap-treeview.js",
                    "https://www.google.com/recaptcha/api.js?render=explicit"
                ];
                // Mode "debug" : charge tous les fichiers angular sinon le fichier js compilé par closure.
                if (sessionStorage["debug"] == "true") {
                    aJsFiles = aJsFiles.concat([
                        "../../../../javascript/app/app.js",
                        "../../../../javascript/app/services/mainSrvc.js",
                        "../../../../javascript/app/services/formSrvc.js",
                        "../../../../modules/gtf/javascript/widget/widgetMod.js",
                        "../../../../javascript/externs/formReader/formReader.js",
                        "../../../../javascript/externs/formReader/formReaderSrvc.js",
                        "../../../../javascript/app/controllers/htmlFormCtrl.js",
                        "../../../../javascript/externs/formReader/formReaderCtrl.js",
                        "../../../../javascript/app/directives/htmlFormDrtv.js",
                        "../../../../javascript/externs/formReader/formReaderDrtv.js",
                        "../../../../modules/gtf/javascript/widget/script_widget.js"
                    ]);
                }
                else
                    aJsFiles.push("../../../../javascript/widget.min.js");
                //
                loadExternalJs(aJsFiles, {
                    "async": false,
                    //"scriptInBody": true,
                    "callback": function () {
                        // Bootstrap l'application.
                        angular.bootstrap(document, ['vitisApp']);
                        // Traitement postérieur au bootstrap de l'appli.
                        vitisApp.afterBootstrap();
                        // Sauve les fonctions dans le scope.
                        angular.element(vitisApp.appHtmlFormDrtv).scope().widget = widget;
                        // Affiche la fenêtre modale.
                        widget.initWidget();
                    }
                });
            }});
    }
}, false);