'use strict';

// Google closure
goog.provide("vitis.gtf.widget.script");
goog.require('goog.object');

/**
 * initWidget function.
 * Affiche la fenêtre modale et le formulaire du projet FME.
 * @export
 **/
widget.initWidget = function () {
    // Injection des services.
    var $log = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$log"]);
    var $compile = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$compile"]);
    var $templateRequest = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$templateRequest"]);
    var $q = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$q"]);
    var envSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["envSrvc"]);
    var propertiesSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["propertiesSrvc"]);
    var sessionSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["sessionSrvc"]);
    var formSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["formSrvc"]);
    //
    $log.info("initWidget");
    // Sauve toutes les properties.
    var i = 0;
    var aKeys = Object.keys(oClientProperties);
    while (i < aKeys.length) {
            propertiesSrvc[aKeys[i]] = oClientProperties[aKeys[i]];
            i++;
    }
    // Charge les properties stockées côté serveur.
    propertiesSrvc["getFromServer"]().then(function() {
        // Initialisation.
        sessionSrvc["token"] = oModalWindowParams["token"];
        sessionStorage["application"] = oModalWindowParams["application"];
        sessionStorage["session_token"] = oModalWindowParams["token"];
        if (oClientProperties['environment'] != "")
            sessionStorage['appEnv'] = sessionStorage['application'] + "_" + oClientProperties['environment'];
        else
            sessionStorage['appEnv'] = sessionStorage['application'];
        
        // Paramètres de l'onglet d'importation.
        envSrvc["oSelectedObject"] = {
            "actions": [],
            "columns": [],
            "mode_id": "widget",
            "name": "widget",
            "ressource_id": null,
            "sections": ""
        };
        envSrvc["sMode"] = "insert";
        // Nom + url du formulaire.
        var scope = angular.element(vitisApp.appHtmlFormDrtv).scope();
        scope["sFormDefinitionName"] = "widget_form";
        envSrvc["sFormDefinitionName"] = scope["sFormDefinitionName"];
        // 
        delete envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]];
        // Chargement de l'id du projet FME à partir de sa clé.
        var oUrlParams = {
            //"filter": "key='" + oModalWindowParams["key"] + "'"
            "filter": {
                "relation": "AND",
                "operators": [{
                    "column": "key",
                    "compare_operator": "=",
                    "value": oModalWindowParams["key"]
                }]
            },
        };
        ajaxRequest({
            "method": "GET",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces",
            "params": oUrlParams,
            "scope": scope,
            "disconnect": false,
            "success": function(response) {
                if (parseInt(response["data"]["status"]) == 1) {
                    // Sauve i'id du projet FME.
                    oModalWindowParams["workspace_id"] = response["data"]["workspaces"][0]["workspace_id"];
                    // Paramètres pour la requête ajax du form.
                    scope["oFormRequestParams"] = {
                        "sUrl": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/workspaces/" + oModalWindowParams["workspace_id"],
                        "sResourceId": "gtf/workspaces",
                        "oParams": {
                            "form": "Published"
                        },
                        "sExtractData": "widget.extractSubformData(oFormRequestParams)"
                    };
                    // Pas de données de form. à charger.
                    scope["bLoadFormValues"] = false;
                    var sFormContainerId = "widget_form_container";

                    // Largeur et hauteur du widget.
                    var sWidth = oModalWindowParams["width"];
                    if (!isNaN(sWidth))
                        sWidth += "px";
                    var sHeight = oModalWindowParams["height"];
                    if (!isNaN(sHeight))
                        sHeight += "px";

                   if (oModalWindowParams["widget_type"] == "Embedded" || oModalWindowParams["widget_type"] == "File") {
                        // Largeur et hauteur du widget.
                        document.querySelector(".widget").parentNode.style.width = "100%";
                        document.querySelector(".widget").parentNode.style.height = "100%";
                        document.querySelector(".widget").parentNode.style.padding = 0;
                        document.querySelector(".widget").style.width = "100%";
                        document.querySelector(".widget").style.height = "100%";
                        // Hauteur du "body".
                        document.querySelector(".widget .panel-body").style.height = parseInt(document.querySelector(".widget").clientHeight) - parseInt(document.querySelector(".widget .panel-heading").clientHeight) - 3 + "px";
                    }
                    // Création du captcha.
                    if (oModalWindowParams["captcha"] == "enable") {
                        var clearListener2 = scope.$root.$on('endFormNgRepeat', function(event) {
                            // Supprime le "listener".
                            clearListener2();
                            // Création du conteneur.
                            var oCaptcha = document.createElement("div");
                            oCaptcha["id"] = "widget_captcha";
                            var oLastFormRow = document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "'] .form-row:last-child");
                            oLastFormRow.parentNode.insertBefore(oCaptcha, oLastFormRow);
                            // reCAPTCHA (google).
                            scope["iCaptchaWidgetId"] = grecaptcha["render"]("widget_captcha", {
                                "sitekey": oModalWindowParams["captcha_key"],
                                "data-type": "image"
                            });
                        });
                    }
                    // Compile le template de formulaire.
                    var sTemplateUrl = oModalWindowParams["client_url"] + '/templates/formTpl.html';
                    $templateRequest(sTemplateUrl).then(function (sTemplate) {
                        $compile($("#" + sFormContainerId).html(sTemplate).contents())(scope);
                    });
                    $log.info('compileObjectTemplate : ' + sTemplateUrl);
                    // Ajoute un bouton submit et un "event" au formulaire.
                    var clearFormDefListener = scope.$root.$on('formDefinitionLoaded', function (event, sFormDefinitionName) {
                        // Supprime le "listener".
                        clearFormDefListener();
                        // Vérification avant l'envoi du formulaire
                        envSrvc["oFormDefinition"][sFormDefinitionName]["beforeEvent"] = function () {
                            var deferred = $q.defer();
                            var promise = deferred.promise;
                            var sErrorMessage;
                            var oFormValues = envSrvc["oFormValues"][sFormDefinitionName];
                            formSrvc["getAllFormElementDefinition"](sFormDefinitionName).forEach(function(oElementDefinition) {
                                if (oElementDefinition["type"] == "upload") {
                                    // Vérification du fichier de ressources complémentaires.
                                    if (typeof(oFormValues[oElementDefinition["name"]]) == "object" && typeof(oFormValues[oElementDefinition["name"]]["aFiles"]) != "undefined" && oFormValues[oElementDefinition["name"]]["aFiles"].length > 0) {
                                        var sFileExtension = oFormValues[oElementDefinition["name"]]["aFiles"][0]["name"].split(".").pop();
                                        var sForbiddenExtension = propertiesSrvc["forbidden_extension"].replace(/[^a-zA-Z0-9\|]+/g, "");
                                        if (sForbiddenExtension.split("|").indexOf(sFileExtension) == -1) {
                                            // Taille maxi du fichier.
                                            if (oFormValues[oElementDefinition["name"]]["aFiles"][0]["size"] > parseInt(propertiesSrvc["max_upload_file_size"]))
                                                sErrorMessage = "ERROR_FILE_SIZE_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
                                        }
                                        else
                                            sErrorMessage = "ERROR_ADDITIONAL_RESOURCES_PUBLICATION_WORKSPACE_LOAD_PROJECT_DIRECTORY";
                                    }
                                    if (typeof(sErrorMessage) != "undefined") {
                                        deferred.reject();
                                    }
                                }
                            });
                            // Affichage de la fenêtre modale d'erreur.
                            if (typeof(sErrorMessage) != "undefined") {
                                var oOptions = {
                                    "className": "modal-danger",
                                    "message": sErrorMessage
                                };
                                widget["modalWindow"]("dialog", "FORM_VALIDATION_ERROR", oOptions);
                            }
                            else
                                deferred.resolve();
                            return promise;
                        };
                        // Fonction à appeler après l'envoi du form.
                        envSrvc["oFormDefinition"][sFormDefinitionName]["event"] = "widget.sendSubForm()";
                        // Adresse email.
                        if (oModalWindowParams["notification"] != "none") {
                            var sEmailLabel, bEmailRequired;
                            if (oModalWindowParams["notification"] == "optional") {
                                sEmailLabel = "FORM_WIDGET_NOTIFICATIONS_OPTIONAL_PUBLICATION_WORKSPACE_EDIT_WIDGET";
                                bEmailRequired = false;
                            }
                            else {
                                sEmailLabel = "FORM_WIDGET_NOTIFICATIONS_NEEDED_PUBLICATION_WORKSPACE_EDIT_WIDGET";
                                bEmailRequired = true;
                            }
                            envSrvc["oFormDefinition"][sFormDefinitionName]["rows"].push(
                            {
                                "fields":[
                                    {
                                        "type":"text",
                                        "name":"email_notifications",
                                        "label":sEmailLabel,
                                        "required":bEmailRequired,
                                        "nb_cols":12,
                                        "pattern" : "^(([A-Za-z0-9_\\+\\-]+\\.)*[A-Za-z0-9_\\+\\-]+@([A-Za-z0-9_\\+\\-]+\\.)+([A-Za-z]{2,4})(\\s*(\n)\\s*))*([A-Za-z0-9_\\+\\-]+\\.)*[A-Za-z0-9_\\+\\-]+@([A-Za-z0-9_\\+\\-]+\\.)+([A-Za-z]{2,4})$",
                                        "visibleAllTabs": true
                                    }
                                ]
                            });
                        }
                        // Bouton submit.
                        envSrvc["oFormDefinition"][sFormDefinitionName]["rows"].push(
                        {
                            "fields": [
                                {
                                    "type": "button",
                                    "class": "btn-ungroup btn-group-sm",
                                    "nb_cols": 12,
                                    "buttons": [
                                        {
                                            "type": "submit",
                                            "name": "form_submit",
                                            "label": "FORM_BTN_CREATE_ORDER_MY_WORK_GTF_USER_ORDER",
                                            "class": "btn-primary",
                                            "visibleAllTabs": true
                                        }
                                    ]
                                }
                            ]
                        });
                    });
                }
            }
        });
    });
};

/**
 * extractSubformData function.
 * Extrait les données d'un formulaire subform retourné par un web service.
 * @param {object} oFormRequestParams Paramètres et données retournés par le web service (demande du subform).
 * @export
 **/
widget.extractSubformData = function (oFormRequestParams) {
    // Injection des services.
    var $log = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$log"]);
    var envSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["envSrvc"]);
    //
    $log.info("extractSubformData");
    var aResourceId = envSrvc["explodeWebServiceResourceId"](oFormRequestParams["sResourceId"]);
    return oFormRequestParams["oData"][aResourceId[1]][0]["json_form"][0];
};

/**
 * sendSubForm function.
 * Envoi le formulaire "subform" avec les paramètres du workspace.
 * @export
 **/
widget.sendSubForm = function () {
    // Injection des services.
    var $log = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$log"]);
    var $translate = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$translate"]);
    var envSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["envSrvc"]);
    var formSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["formSrvc"]);
    var propertiesSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["propertiesSrvc"]);
    //var sessionSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["sessionSrvc"]);
    var externFunctionSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["externFunctionSrvc"]);
    //
    $log.info("sendSubForm");
    var scope = angular.element(vitisApp.appHtmlFormDrtv).scope();
    var sFormElementName = envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"];
    var formScope = angular.element("form[name='" + sFormElementName + "']").scope();
    var bFormValid = true;
    // Vérification du captcha.
    var sCaptchaResponse = "";
    if (oModalWindowParams["captcha"] == "enable") {
        document.getElementById("widget_captcha").className = "";
        sCaptchaResponse = grecaptcha["getResponse"](scope["iCaptchaWidgetId"]);
        if (sCaptchaResponse == "") {
            bFormValid = false;
            document.getElementById("widget_captcha").className = "widget-captcha-error";
        }
    }
    if (typeof(formScope[sFormElementName]["appFormSubmitted"]) == "undefined")
        formScope[sFormElementName]["appFormSubmitted"] = false;
    // Le formulaire est valide ?
    if (formScope[sFormElementName].$valid && bFormValid && !formScope[sFormElementName]["appFormSubmitted"]) {
        formScope[sFormElementName]["appFormSubmitted"] = true;
        showAjaxLoader();
        // Paramètres de la demande.
        var oWebServiceParams = {
            "wk_params": widget.formatSubForm(scope),
            "priority_id": 1,
            "workspace_id": oModalWindowParams["workspace_id"],
            "email_option_id": 1,
            "captcha_response": sCaptchaResponse
        };
        // Adresse email.
        var sEmailNotifications = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["email_notifications"];
        if (goog.isDefAndNotNull(sEmailNotifications))
            oWebServiceParams["email_notifications"] = sEmailNotifications;
        // Répertoire d'upload
        if (typeof(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"]) != "undefined")
            oWebServiceParams["upload_directory"] = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"];
        // Création du formData.
        var oFormData = formSrvc["getFormData"](envSrvc["sFormDefinitionName"]);
        var aFormDataKeys = Object.keys(oWebServiceParams);
        for (var i = 0; i < aFormDataKeys.length; i++) {
            oFormData.append(aFormDataKeys[i], oWebServiceParams[aFormDataKeys[i]]);
        }        
        // Envoi du fichier.
        ajaxRequest({
            "method": "POST",
            "url": propertiesSrvc["web_server_name"] + "/" + propertiesSrvc["services_alias"] + "/gtf/userorders",
            "data": oFormData,
            "scope": scope,
            "disconnect": false,
            "success": function(response) {
                hideAjaxLoader();
                if (response["data"]["status"] == 1) {
                    // Affichage du message de succés.
                    $translate("FORM_VALIDATION_OK").then(function (sTranslation) {
                        $.notify(sTranslation, "success");
                        // Recharge le widget.
                        setTimeout(function(){
                            window.location.reload();
                        }, 2000);
                        // Vidage du formulaire.
                        //angular.element("#widget_form_container").empty();
                        /*
                            // Reset du formulaire et du captcha.
                            document.querySelector("form[name='" + envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["name"] + "']").reset();
                            if (oModalWindowParams["captcha"] == "enable")
                                grecaptcha["reset"](scope["iCaptchaWidgetId"]);
                        */
                        //}
                    });
                } else {
                    // Affichage du message d'erreur.
                    if (typeof (response["data"]["errorMessage"]) != "undefined" && response["data"]["errorMessage"] != null)
                        var sText = response["data"]["errorMessage"];
                    // Paramètres de la fenêtre modale.
                    var oOptions = {
                        "className": "modal-danger",
                        "message": sText
                    };
                    // Affichage de la fenêtre modale.
                    externFunctionSrvc["modalWindow"]("dialog", "FORM_VALIDATION_ERROR", oOptions);
                    // Le formulaire n'a pas été envoyé.
                    formScope[sFormElementName]["appFormSubmitted"] = false;
                }
            }
        });
    }
};

/**
 * sendSubForm function.
 * Envoi le formulaire "subform" avec les paramètres du workspace.
 * @param {angular.$scope} scope Scope d'angular.
 * @return {string}
 * @export
 **/
widget.formatSubForm = function (scope) {
    // Injection des services.
    var envSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["envSrvc"]);
    var formSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["formSrvc"]);
    // Valeurs des champs cachés du form. de la demande.
    var oWkParams = {};
    //var aSerializedSubForm = angular.element("#double_form_right_section_" + envSrvc["oSelectedObject"]["name"] + " form").serializeArray();
    //mise en forme pour fme 
    /***********************************************************************/
    var encoderFME = function (str) {

        if (!goog.isString(str))
            return str;
        // table de correspondance
        var caracInGTF = [" ", "=", "\r\n", "(", ")", "$", "&", "@", "°", "'", ",", "\"", "{", "}", "[", "]", "|", ";", "/", "\\", "é", "à"];
        var caracForFME = ["<space>", "<GTF_EQUAL>", "<lf>", "<openparen>", "<closeparen>", "<dollar>", "<amp>", "<at>", "<u00b0>", "<apos>", "<comma>", "<quote>", "<opencurly>", "<closecurly>", "<openbracket>", "<closebracket>", "<GTF_PIPE>", "<semicolon>", "<solidus>", "<backslash>", "<u00e9>", "<u00e0>"];
        //variables parcours de chaine
        var result = str;
        var istr = 0;
        var iresult = 0;
        // remplacement des <> par parcours de chaine
        // avec vérification des mots clef
        // et gestion des caractère unicode
        while (istr < str.length) {
            if (str.charAt(istr) === "<") {

                var j = 0;
                var find = false;
                while (j < caracForFME.length && !find) {
                    var clipper = result.substr(iresult, caracForFME[j].length);
                    if (clipper === caracForFME[j]) {
                        istr += caracForFME[j].length;
                        iresult += caracForFME[j].length;
                        find = true;
                    }
                    j++;
                }
                /*****************************/
                //GTF_QUOTE et GTF BACKSLASH
                /* var quote = "<GTF_QUOTE>";
                 var backslash = "<GTF_BACKSLASH>";

                 var clipper = result.substr(iresult, quote.length);
                 if (clipper === quote) {
                 istr += quote.length;
                 iresult += quote.length;
                 find = true;
                 }

                 clipper = result.substr(iresult, backslash.length);
                 console.error(result,clipper, iresult);
                 if (clipper === backslash) {
                 istr += backslash.length;
                 iresult += backslash.length;
                 find = true;
                 }
                 /*****************************/

                if (!find) {
                    var part1 = result.substr(0, iresult);
                    var part2 = result.substr(iresult + 1, result.length - 1);
                    result = part1 + "<lt>" + part2;
                    iresult += 4;
                    istr += 1;
                }
            } else if (str.charAt(istr) === ">") {
                var part1 = result.substr(0, iresult);
                var part2 = result.substr(iresult + 1, result.length - 1);
                result = part1 + "<gt>" + part2;
                istr += 1;
                iresult += 4;
            } else {
                //unicode
                var code = str.charCodeAt(istr);
                if (code > 127) {
                    var part1 = result.substr(0, iresult);
                    var part2 = result.substr(iresult + 1, result.length - 1);
                    var charCode = (+code).toString(16);

                    while (charCode.length < 4) {
                        charCode = "0" + charCode;
                    }

                    result = part1 + "<u" + charCode + ">" + part2;
                    istr += 1;
                    iresult += 7;
                } else {
                    istr += 1;
                    iresult += 1;
                }
                /*******************************************/
            }
        }

        for (var j = 0; j < caracInGTF.length; j++) {
            while (result.indexOf(caracInGTF[j]) !== - 1)
                result = result.replace(caracInGTF[j], caracForFME[j]);
        }

        return result;
    };
    
    var oFormValues = goog.object.clone(scope["oFormValues"][scope["sFormDefinitionName"]]);
    //for (var i = 0; i < scope["oFormDefinition"][scope["sFormDefinitionName"]]["rows"].length; i++) {
    scope["oFormDefinition"][scope["sFormDefinitionName"]]["rows"].forEach(function(oRow, iRowIndex, oRows) {
        oRow["fields"].forEach(function(oField, iFieldIndex, oFields) {
        //for (var j = 0; j < oRow["fields"].length; j++) {
            var val = oField;
            if (goog.isDef(oFormValues[val["name"]])) {
                switch (val["type"]) {
                    case "datetime":
                        var tmp = angular.copy(oFormValues[val["name"]]);
                        tmp = tmp.split(" ");
                        // si il y a un espace alors mise en forme sinon c'est une valeur par défaut à ne pas retoucher
                        if (tmp.length === 2) {
                            var date = tmp[0];
                            var time = tmp[1];
                            //traitement date
                            date = date.split("/");
                            //traitement time
                            time = time.split(":");
                            if (time.length === 2) {
                                time.push("00");
                            }
                            //reconstitution
                            oFormValues[val["name"]] = date[2] + date[1] + date[0] + time[0] + time[1] + time[2];
                        }
                        break;
                    case "color_picker":
                        var tmp = angular.copy(oFormValues[val["name"]]);
                        if (tmp.indexOf('(') !== -1 && tmp.indexOf(')') !== -1 && tmp.indexOf(',') !== -1) {
                            tmp = tmp.split("(");
                            tmp = tmp[1].split(")");
                            tmp = tmp[0].split(",");
                            var R = (parseFloat(tmp[0]) / 255).toFixed(6);
                            var G = (parseFloat(tmp[1]) / 255).toFixed(6);
                            var B = (parseFloat(tmp[2]) / 255).toFixed(6);
                            // alpha non pris en charge par fme
                            // fme ne prend que des % de couleur
                            oFormValues[val["name"]] = R + "," + G + "," + B;
                        } else {
                            console.error('ColorPicker value not acceptable: ', tmp);
                            oFormValues[val["name"]] = '1,1,1';
                        }
                        break;
                    case "list":
                        var tmp = angular.copy(oFormValues[val["name"]]["selectedOption"]);
                        if (goog.isArray(tmp)) {
                            oFormValues[val["name"]] = "";
                            if (tmp.length > 0) {
                                for (var choice = 0; choice < tmp.length - 1; choice++) {
                                    if (!goog.isString(tmp[choice]["value"])) {
                                        tmp[choice]["value"] = tmp[choice]["value"].toString();
                                    }
                                    if (tmp[choice]["value"].indexOf(" ") !== -1) {
                                        oFormValues[val["name"]] += ("\"" + tmp[choice]["value"] + "\"" + " ");
                                    } else {
                                        oFormValues[val["name"]] += (tmp[choice]["value"] + " ");
                                    }
                                }
                                if (!goog.isString(tmp[tmp.length - 1]["value"])) {
                                    tmp[tmp.length - 1]["value"] = tmp[tmp.length - 1]["value"].toString();
                                }
                                if (tmp[tmp.length - 1]["value"].indexOf(" ") !== -1) {
                                    oFormValues[val["name"]] += tmp[tmp.length - 1]["value"];
                                } else {
                                    oFormValues[val["name"]] += (tmp[tmp.length - 1]["value"]);
                                }
                            }
                        } else if (goog.isObject(tmp)) {
                            if (typeof (tmp["value"]) != "undefined")
                                oFormValues[val["name"]] = tmp["value"].replace("|", " ");
                        }

                        oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                        break;
                    case "select":
                        var tmp = angular.copy(oFormValues[val["name"]]["selectedOption"]);
                        if (goog.isObject(tmp)) {
                            oFormValues[val["name"]] = tmp["value"];
                        } else {
                            oFormValues[val["name"]] = tmp;
                        }
                        oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                        break;
                    case "double_select":
                        var oSelectedOptions = oFormValues[val["name"]];
                        var aSelectedOptions = [];
                        oSelectedOptions["options"].forEach(function (oOption) {
                            aSelectedOptions.push(oOption["value"]);
                        });
                        oFormValues[val["name"]] = encoderFME(aSelectedOptions.join(" "));
                        delete oFormValues[val["name_from"]];
                        break;
                    case "upload":
                        if (goog.isDefAndNotNull(oFormValues[val["name"]])) {
                            var tmp = oFormValues[val["name"]];
                            // Répertoire côté serveur pour tous les fichiers uploadés.
                            var sDirectory;
                            if (typeof(envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"]) == "undefined") {
                                sDirectory = new Date().getTime() + parseInt(Math.random() * 100000);
                                envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"] = sDirectory;
                            }
                            else
                                sDirectory = envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"];
                            //
                            envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["rows"].push({"fields": [formSrvc["getFormElementDefinition"](val["name"], scope["sFormDefinitionName"])]});
                            envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]][val["name"]] = envSrvc["oFormValues"][scope["sFormDefinitionName"]][val["name"]];

                            // Fichier sélectionné.
                            if (typeof (tmp["aFiles"]) != "undefined" && tmp["aFiles"].length > 0) {
                                var aUploadFiles = [];
                                for (var iFileIndex = 0; iFileIndex < tmp["aFiles"].length; iFileIndex++) {
                                    aUploadFiles.push(sDirectory + "/" + tmp["aFiles"][iFileIndex]["name"]);
                                }
                                oFormValues[val["name"]] = aUploadFiles.join(",");
                            }
                            else {
                                if (typeof (scope["oOriginalFormValues"][val["name"]]) != "undefined")
                                    oFormValues[val["name"]] = scope["oOriginalFormValues"][val["name"]];
                                else
                                    oFormValues[val["name"]] = "";
                            }
                        } else {
                            if (typeof (scope["oOriginalFormValues"][val["name"]]) != "undefined")
                                oFormValues[val["name"]] = scope["oOriginalFormValues"][val["name"]];
                            else
                                oFormValues[val["name"]] = "";
                        }
                        break;
                    case "textarea":
                        oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                        break;
                    case "text":
                        oFormValues[val["name"]] = encoderFME(oFormValues[val["name"]]);
                        break;
                    case "treeview":
                        oFormValues[val["name"]] = String(oFormValues[val["name"]]).replace(/\|/g, "<GTF_PIPE>");
                        break;
                }
            }
            //}
        });
    });
    /*************************************************************************/
    // Dédoublonnage (select multiple).
    //var i = 0;
    //while (i < aSerializedSubForm.length) {
    //    if (typeof (oWkParams[aSerializedSubForm[i]["name"]]) == "undefined")
    //        oWkParams[aSerializedSubForm[i]["name"]] = aSerializedSubForm[i]["value"];
    //    else
    //        oWkParams[aSerializedSubForm[i]["name"]] += "," + aSerializedSubForm[i]["value"];
    //    i++;
    //}
    // Création du paramètre wk_params.
    var aKeys = Object.keys(oFormValues);
    var aWkParams = [];
    i = 0;
    while (i < aKeys.length) {
        if (aKeys[i] != "email_notifications")
            aWkParams.push(aKeys[i] + "=" + oFormValues[aKeys[i]]);
        i++;
    }
    var sWkParams = aWkParams.join("|");
    // Fichiers à uploader ?
    //var oFileInput = document.querySelector("form[name='" + envSrvc["oFormDefinition"][scope["sFormDefinitionName"]]["name"] + "']").querySelectorAll("input[type='file']");

    //i = 0;
    //while (i < oFileInput.length) {
    //    var sDirectory = new Date().getTime() + parseInt(Math.random() * 100000);
    //    envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]]["upload_directory"] = sDirectory;
    // Si un fichier est sélectionné -> ajoute la définition et les valeurs du champ sur le formulaire de la demande.
    //    if (oFileInput[i]["files"].length > 0) {
    //        envSrvc["oFormDefinition"][envSrvc["sFormDefinitionName"]]["rows"].push({"fields": [formSrvc["getFormElementDefinition"](oFileInput[i]["name"], scope["sFormDefinitionName"])]});
    //        envSrvc["oFormValues"][envSrvc["sFormDefinitionName"]][oFileInput[i]["name"]] = envSrvc["oFormValues"][scope["sFormDefinitionName"]][oFileInput[i]["name"]];
    //        sWkParams += "|" + oFileInput[i]["name"] + "=" + sDirectory + "/" + oFileInput[i]["files"][0]["name"];
    //    }
    //    i++;
    //}
    return sWkParams;
};

/**
 * afterBootstrap function
 * Traitement à exécuter après le bootstrapping de l'application. 
 * @export
 */
vitisApp.afterBootstrap = function () {
    /**
     * getPropertie function.
     * Retourne la valeur d'une "propertie".
     * @param {string} sPropertieName Nom de la "propertie".
     * @return {}
     * @expose
     **/
    angular.element(vitisApp.appHtmlFormDrtv).scope().getPropertie = function (sPropertieName) {
        // Injection des services.
        var $log = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$log"]);
        var propertiesSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["propertiesSrvc"]);
        // Edition d'un enregistrement.
        $log.info("getPropertie : " + sPropertieName);
        var sValue;
        if (sPropertieName.indexOf(".") != -1)
            eval("sValue = propertiesSrvc." + sPropertieName);
        else
            sValue = propertiesSrvc[sPropertieName];
        return sValue;
    };
    
    /**
     * getProj function.
     * Tous les types de projections supportés pour une carte vMap ?
     * @return {}
     * @expose
     **/
    angular.element(vitisApp.appHtmlFormDrtv).scope().getProj = function () {
        var appMainScope = angular.element(vitisApp.appHtmlFormDrtv).scope();
        // Get fichier de langue
            ajaxRequest({
                "method": "GET",
                "url": "../../../vitis/data/proj.json",
                "scope": appMainScope,
                "disconnect": false,
                "success": function(response) {
                    // Utilisé par les autres cpmposants
                    appMainScope['proj'] = response["data"];
                },
                "error": function (response) {
                    console['error']('ERROR : (AJAX request : ' + response["status"] + ' ) On loading Projections, contact Veremes please');
                }
            });
    };
    angular.element(vitisApp.appHtmlFormDrtv).scope().getProj();
};

/**
 * modalWindow function.
 * Affiche une fenêtre modale.
 * @param {string} sType Type de fenêtre (alert, confirm...).
 * @param {string} sTitle Titre de la fenêtre.
 * @param {object} oOptions Paramètres du composant et autres (appDuration, appBootstrapStyle).
 * @return {promise}
 * @export
 **/
widget.modalWindow = function (sType, sTitle, oOptions) {
    // Injection des services.
    var $log = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$log"]);
    var externFunctionSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["externFunctionSrvc"]);
    // 
    $log.info("modalWindow");
    return externFunctionSrvc["modalWindow"](sType, sTitle, oOptions);
};
/**
 * isCaptchaValid function.
 * Affiche une fenêtre modale.
 * @param {integer} iCaptchaWidgetId Id du captcha à vérifier.
 * @return {boolean}
 * @export
 **/
/*
widget.isCaptchaValid = function (iCaptchaWidgetId) {
    // Injection des services.
    var $log = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["$log"]);
    // 
    $log.info("isCaptchaValid");
    var bReturn = false;
    var sCaptchaResponse = grecaptcha["getResponse"](iCaptchaWidgetId);
    if (sCaptchaResponse != "")
        bReturn = true;
    return bReturn;
};
*/
/**
 * appMain directive.
 * Directive utilisée dans sle formReader.
 * @export
 * @ngInject
 **/
vitisApp.appMainDrtv = function () {
    return {
    }
};
vitisApp.module.directive("appMain", vitisApp.appMainDrtv);