'use strict';

// Google closure
goog.provide("vitis.gtf.widget.modules.main");
goog.require('vitis');
goog.require("vitis.services.main");
goog.require("vitis.services.form");

/**
 * widget Object
 * @type {object}
 * @export
 */
var widget = function(){};

// Module.
var aModuleDependencies = ["angular.bind.notifier", "pascalprecht.translate", "formReader"];

vitisApp.module = angular.module("vitisApp", aModuleDependencies);

// Services.
vitisApp.module.service("sessionSrvc", vitisApp.sessionSrvc);
vitisApp.module.service("envSrvc", vitisApp.envSrvc);
vitisApp.module.service("modesSrvc", vitisApp.modesSrvc);
vitisApp.module.value("userSrvc", vitisApp.userSrvc);
vitisApp.module.service("externFunctionSrvc", vitisApp.externFunctionSrvc);
vitisApp.module.service("propertiesSrvc", vitisApp.propertiesSrvc);
vitisApp.module.service("formSrvc", vitisApp.formSrvc);

/**
 * Module config
 * 
 * @param {angular.$httpProvider} $httpProvider Angular httpProvider service.
 * @param {angular.$logProvider} $logProvider Angular logProvider service.
 * @param {angular.$compileProvider} $compileProvider Angular compileProvider service.
 * @param {angular.$controllerProvider} $controllerProvider Angular controllerProvider service.
 * @param {angular.$provide} $provide Angular provide service.
 * @param {angular.$translateProvider} $translateProvider Angular translateProvider service.
 * @param {angular.$translatePartialLoaderProvider} $translatePartialLoaderProvider Angular translatePartialLoaderProvider service.
 * @param {angular.$sceDelegateProvider} $sceDelegateProvider Angular sceDelegateProvider service.
 * @ngInject
 **/
vitisApp.config = function($httpProvider, $logProvider, $compileProvider, $controllerProvider, $provide, $translateProvider, $translatePartialLoaderProvider, $sceDelegateProvider) {
        // Désactive les logs en mode "compilé".
        if (sessionStorage["debug"] == "false") {
            $logProvider["debugEnabled"](false);
            $provide.decorator('$log', ['$delegate', function ($delegate) {
                return {
                    error: function (text) {
                        //$delegate.error(text);
                    },
                    info: function (text) {
                        //$delegate.info(text);
                    },
                    log: function (text) {
                        //$delegate.info(text);
                    },
                    warn: function (text) {
                        //$delegate.info(text);
                    }
                };
            }]);
        }
        // Paramètrage du module de traduction.
        $translateProvider["useLoader"]("$translatePartialLoader", {
                "urlTemplate": "{part}/lang-{lang}.json"
        });
        // Charge le fichier du noyau.
        $translatePartialLoaderProvider["addPart"](oModalWindowParams["client_url"] + '/lang');
        // Charge le fichier de langue du module vitis.
        $translatePartialLoaderProvider["addPart"](oModalWindowParams["client_url"] + '/modules/vitis/lang');
        // Charge le fichier de langue du module GTF.
        $translatePartialLoaderProvider["addPart"](oModalWindowParams["client_url"] + '/modules/gtf/lang');
        // Langue par défaut.
        $translateProvider["preferredLanguage"]('fr');
        //
        vitisApp["compileProvider"] = $compileProvider; // Registering a directive after app bootstrap
        //vitisApp.routeProvider = $routeProvider;
        //vitisApp.filterProvider = $filterProvider;
        //vitisApp.provide = $provide;       
		// Autorise le chargement des templates (formReader...) depuis au autre domaine (sinon erreur de cross-domain avec angular).
		$sceDelegateProvider.resourceUrlWhitelist([
			'self',
			oModalWindowParams["client_url"] + "/**"]
		);
        // Interception des requêtes ajax d'angular.
        $httpProvider.interceptors.push(function () {
            return {
                // Chargement.
                "request": function (config) {
                    // Paramètre "version" dans toutes les requêtes.
                    if (config["url"].indexOf("ui-grid/") == -1) {
                        if (typeof (config["params"]) == "undefined")
                            config["params"] = {"vitis_version": oClientProperties['build']};
                        else
                            config["params"]["vitis_version"] = oClientProperties['build'];
                    }
                    // Affiche le loader.
                    if (sessionStorage["ajaxLoader"] == "true")
                        showAjaxLoader();
                    // Maj du compteur des téléchargements en cours.
                    var iLoadingCounter = parseInt(sessionStorage["loading_counter"]);
                    iLoadingCounter++;
                    sessionStorage["loading_counter"] = iLoadingCounter;
                    return config;
                },
                // Chargement terminée.
                "response": function (response) {
                    // Erreur passé dans la réponse de la requête ?
                    if (typeof (response["data"] == "object") && typeof (response["data"]["errorCode"]) != "undefined") {
                        // Cache la fenêtre modale de chargement.
                        hideAjaxLoader();
                        //
                        var sessionSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["sessionSrvc"]);
                        var externFunctionSrvc = angular.element(vitisApp.appHtmlFormDrtv).injector().get(["externFunctionSrvc"]);
                        var oOptions = {
                            "className": "modal-danger",
                            "buttons": {
                                "ok": {
                                    label: "OK",
                                    className: "btn-default"
                                }
                            },
                            "callback": function () {
                                //sessionSrvc["disconnect"]();
                            }
                        };
                        var sTitle = "";
                        switch(response["data"]["errorCode"]) {
                            // Token expiré.
                            case 15:
                                // Paramètres de la fenêtre modale.
                                oOptions["message"] = "EXPIRED_WIDGET_TOKEN_ERROR";
                                sTitle = "EXPIRED_TOKEN_ERROR_TITLE";
                                break;
                            // Token invalide.
                            case 16:
                                // Paramètres de la fenêtre modale.
                                oOptions["message"] = "INVALID_WIDGET_TOKEN_ERROR";
                                sTitle = "INVALID_TOKEN_ERROR_TITLE";
                                break;
                        }
                        // Affichage de la fenêtre modale.
                        if (goog.isDef(oOptions["message"]))
                            externFunctionSrvc["modalWindow"]("alert", sTitle, oOptions);
                    } else {
                        // Maj du compteur des téléchargements en cours.
                        var iLoadingCounter = parseInt(sessionStorage["loading_counter"]);
                        if (iLoadingCounter > 0)
                            iLoadingCounter--;
                        else
                            iLoadingCounter = 0;
                        sessionStorage["loading_counter"] = iLoadingCounter;
                        // Si tous les chargements sont terminés : supprime le loader.
                        if (iLoadingCounter == 0)
                            hideAjaxLoader();
                    }
                    return response;
                },
                "requestError": function (rejection) {
                    console.error("requestError", rejection);
                    return rejection;
                },
                "responseError": function (rejection) {
                    console.error("responseError", rejection);
                    // Supprime le loader ajax.
                    hideAjaxLoader();
                    return rejection;
                }
            };
        });
};
vitisApp.module.config(vitisApp.config);