<?php

//require_once("vmlib/BD.class.inc");
//require_once("vmlib/logUtil.inc");
//require_once("vmlib/dbUtil.inc");
//require_once("vmlib/Vm.class.inc"); 
//require_once("vmlib/phpUtil.inc");
//require_once("vmlib/stringUtil.inc");
//require_once("vmlib/VirtualFormV2.class.inc");
require_once("GtfGui.class.inc");

class GtfFmwParser {

    var $sFmwFileName;
    var $aGuiObject = array();
    var $aIgnoreMacro = array();
    var $aDefaultMacro = array();
    var $aFileNameMustExistMacro = array();
    var $aLignes = array();
    var $sEncoding;
    var $sTitle;
    var $sDescription;
    var $sCategory;
    var $sLegal;
    var $sUsage;
    var $sHistory;
    var $sSaveDate;
    var $sSaveBuild;
    var $sRequirement;

// var $sOriginalName;

    /*
     * Constructeur de la classe GtfFmwParser
     * le fichier fmw est parcouru ligne par ligne et chaque occurrence
     * correspondant à un GUI est stocké dans le tableau approrié
     */
    function __construct($sFmwFileName) {
        $this->sFmwFileName = $sFmwFileName;
        $oFichier = fopen(utf8_decode($this->sFmwFileName), "r");
        $sRc = chr(10); // Compatible avec FME 2014 et inférieur
        $sRecherche = "^GUI(.*)" . $sRc;
        $sRechercheIgnore = "^GUI IGNORE(.*)" . $sRc;
        $sRechercheFileNameMustExist = '^#![ \t]+GUI_LINE="GUI(.*)FILENAME_MUSTEXIST';
        $sRechercheTitle = '^#![ \t]+TITLE=\"(.*)\"';
        $sRechercheEncoding = '^#![ \t]+<\?xml version=\"1\.0\" encoding=\"(.*)\" \?>';
        $sRechercheDescription = '^#![ \t]+DESCRIPTION=\"(.*)\"';
        $sRechercheCategory = '^#![ \t]+CATEGORY=\"(.*)\"';
        $sRechercheLegal = '^#![ \t]+LEGAL_TERMS_CONDITIONS=\"(.*)\"';
        $sRechercheUsage = '^#![ \t]+USAGE=\"(.*)\"';
        $sRechercheHistory = '^#![ \t]+HISTORY=\"(.*)\"';
        $sRechercheSaveDate = '^#![ \t]+LAST_SAVE_DATE=\"(.*)\"';
        $sRechercheSaveBuild = '^#![ \t]+LAST_SAVE_BUILD=\"(.*)\"';
        $sRechercheRequirements = '^#![ \t]+REQUIREMENTS=\"(.*)\"';
        $sRechercheWorkspace = '^#![ \t]+<WORKSPACE';
        $sRechercheEndWorkspace = '^#![ \t]+>';
        $sRechercheTransformer = '^#![ \t]+<TRANSFORMER';
        $sRechercheTransformerType = '^#![ \t]+TYPE=\"(.*)\"';
        $sRechercheTransformerEnabled = '^#![ \t]+ENABLED=\"(.*)\"';
        $i = 0;
        $j = 0;
        $bIsWorkspace = false;
        $bIsTransformer = false;
        $bIsVisualizer = false;

        $this->aFileNameMustExistMacro = Array();
        if ($oFichier != false) {
            while (!feof($oFichier)) {
                $sLigne = fgets($oFichier);
                // Encodage de la ligne en UTF-8
                if (strtolower($this->sEncoding) != 'utf-8')
                    $sLigne = utf8_encode($sLigne);

                // Traitement de tous les GUI
                if (mb_eregi($sRecherche, $sLigne, $aOccurence)) {
                    $oGuiObject = new GtfGui($sLigne, $this->sFmwFileName, $this->sEncoding);
                    array_push($this->aGuiObject, $oGuiObject);
                }

                // Traitement des GUI IGNORE (Les paramètres privés ne sont plus spécifiquement gérés)
                if (mb_eregi($sRechercheIgnore, $sLigne, $aOccurence) && strpos($sLigne, 'GUI IGNORE OPTIONAL') === false) {
                    // Pour la compatibilité avec FME 2014, on supprime les retours chariots en fin de ligne pour faire fonctionner la vérification dans la fonction removeIgnoredMacro() (ligne 85)
                    $aOccurence[1] = str_replace(chr(10), '', $aOccurence[1]);
                    $aOccurence[1] = str_replace(chr(13), '', $aOccurence[1]);
                    $aIgnoreMacro = explode(',', str_replace(' ', '', $aOccurence[1]));
                    $this->aIgnoreMacro = array_merge($this->aIgnoreMacro, $aIgnoreMacro);
                }

                // Traitement des FILENAME_MUSTEXIST -- recherche des paramètres filename utilisés comme source
                if (mb_eregi($sRechercheFileNameMustExist, $sLigne, $aOccurence)) {
                    // Remplace les séries d'espaces par un seul (FME 2016...).
                    $sLigne = preg_replace('([ \t]{2,})', ' ', $sLigne);
                    //
                    $aLignFileNameMustExist = explode(' ', $sLigne);
                    if ($aLignFileNameMustExist[2] == "OPTIONAL") {
                        $aFileNameMustExistMacro = $aLignFileNameMustExist[4];
                        $this->aFileNameMustExistMacro[$j] = $aLignFileNameMustExist[4];
                    } else {
                        $aFileNameMustExistMacro = $aLignFileNameMustExist[3];
                        $this->aFileNameMustExistMacro[$j] = $aLignFileNameMustExist[3];
                    }
                    $j++;
                }
                //Traitement du catalogue
                //Encoding
                if (mb_eregi($sRechercheEncoding, $sLigne, $aOccurence)) {
                    $this->sEncoding = $this->charFMWToRealCharacter($aOccurence[1]);
                }

                //Suppression Visualizer actifs
                if (mb_eregi($sRechercheTransformer, $sLigne, $aOccurence)) {
                    $bIsTransformer = true;
                }
                if ($bIsTransformer == true) {
                    if (mb_eregi($sRechercheTransformerType, $sLigne, $aOccurence)) {
                        if ($aOccurence[1] == "Inspector") {
                            $bIsVisualizer = true;
                        }
                        $bIsTranformer = false;
                    }
                }
                if ($bIsVisualizer == true) {
                    if (mb_eregi($sRechercheTransformerEnabled, $sLigne, $aOccurence)) {
                        $this->aLignes[] = str_replace("true", "false", $sLigne);
                        $bIsVisualizer = false;
                    } else {
                        $this->aLignes[] = $sLigne;
                    }
                } else {
                    $this->aLignes[] = $sLigne;
                }
                if (mb_eregi($sRechercheWorkspace, $sLigne, $aOccurence)) {
                    $bIsWorkspace = true;
                }
                if ($bIsWorkspace == true) {
                    //Description
                    if (mb_eregi($sRechercheDescription, $sLigne, $aOccurence)) {
                        $this->sDescription = str_replace('\n', '', $this->charFMWToRealCharacter($aOccurence[1]));
                    }
                    //Title
                    if (mb_eregi($sRechercheTitle, $sLigne, $aOccurence)) {
                        $this->sTitle = $this->charFMWToRealCharacter($aOccurence[1]);
                    }

                    //Category
                    if (mb_eregi($sRechercheCategory, $sLigne, $aOccurence)) {
                        $this->sCategory = $this->charFMWToRealCharacter($aOccurence[1]);
                    }
                    //Usage
                    if (mb_eregi($sRechercheUsage, $sLigne, $aOccurence)) {
                        $this->sUsage = str_replace('\n', '', $this->charFMWToRealCharacter($aOccurence[1]));
                    }
                    //Legal
                    if (mb_eregi($sRechercheLegal, $sLigne, $aOccurence)) {
                        $this->sLegal = str_replace('\n', '', $this->charFMWToRealCharacter($aOccurence[1]));
                    }
                    //History -- TODO
                    if (mb_eregi($sRechercheHistory, $sLigne, $aOccurence)) {
                        $this->sHistory = str_replace("<solidus>", "/", $this->charFMWToRealCharacter($aOccurence[1]));
                    }
                    //SaveDate
                    if (mb_eregi($sRechercheSaveDate, $sLigne, $aOccurence)) {
                        $this->sSaveDate = $this->charFMWToRealCharacter($aOccurence[1]);
                    }
                    //SaveBuild
                    if (mb_eregi($sRechercheSaveBuild, $sLigne, $aOccurence)) {
                        $this->sSaveBuild = $this->charFMWToRealCharacter($aOccurence[1]);
                    }
                    //Requirements
                    if (mb_eregi($sRechercheRequirements, $sLigne, $aOccurence)) {
                        $this->sRequirements = str_replace('\n', '', $this->charFMWToRealCharacter($aOccurence[1]));
                    }
                    if (mb_eregi($sRechercheEndWorkspace, $sLigne, $aOccurence)) {
                        $bIsWorkspace = false;
                    }
                }
                $i++;
            }
            fclose($oFichier);
        }
        $this->removeIgnoredMacro();
        $this->changeFileNameMustExist();
    }

    /*
     * Fonction qui permet d'exclure les Objets GUI
     * qui ne font pas partie intégrante du sous formulaire et
     * qui alimente le tableau final des objets 
     */

    function removeIgnoredMacro() {
        $aNouveauTableau = array();
        foreach ($this->aGuiObject as $oGtfGui) {
            if (!in_array($oGtfGui->sDefault_Macro, $this->aIgnoreMacro)) {
                array_push($aNouveauTableau, $oGtfGui);
            }
        }
        $this->aGuiObject = $aNouveauTableau;
    }

    /*
     * Fonction qui permet de changer la propriété isDest des GUI de type FileName
     * qui se trouvent dans le tableau $this->aFileNameMustExistMacro
     */

    function changeFileNameMustExist() {
        $aNouveauTableau = array(); //?
        foreach ($this->aGuiObject as $oGtfGui) {
            if (in_array($oGtfGui->sDefault_Macro, $this->aFileNameMustExistMacro)) {
                $sSource = $oGtfGui->sFiltreSource; // Récupération de la valeur de la source
                $oGtfGui->sFiltreSource = $oGtfGui->sFiltreDest;
                $oGtfGui->sFiltreDest = $sSource;
                $oGtfGui->bIsSource = True;
                $oGtfGui->bIsDest = False;
            }
        }
    }

    /*
     * fonction qui renvoie un tableau des lignes correspondant
     * aux objets GUI du sous formulaire sous la forme d'une
     * chaine de caractères
     */

    /* function getVerification(){
      $sVerification="";
      foreach ($this->aGuiObject as $oGtfGui){
      $sDefaultValue = str_replace(chr(13), '', $oGtfGui->sDefault_Macro);
      $sDefaultValue = str_replace(chr(10), '', $sDefaultValue);
      $sLibelle = str_replace(chr(13), '', $oGtfGui->sLibelle);
      $sLibelle = str_replace(chr(10), '', $sLibelle);
      if ($oGtfGui->sType == "INTEGER"){
      $sVerification.="\$sError .= VerifIsInteger(\$_REQUEST['".$sDefaultValue."'], \"".$sLibelle."\");".chr(13);
      }
      if ($oGtfGui->sType == "FLOAT"){
      $sVerification.="\$sError .= VerifIsDecimal(\$_REQUEST['".$sDefaultValue."'], \"".$sLibelle."\");".chr(13);
      }
      if ($oGtfGui->sType == "FILENAME"){
      $sVerification.="\$sError .= VerifUpload(\$_REQUEST['".$sDefaultValue."'], \"".$sLibelle."\");".chr(13);
      }
      }

      return $sVerification;
      }########################### */

    /*
     * fonction qui vérifie l'existence de liste des systèmes de coordonnées
     * aux objets GUI du sous formulaire sous la forme d'une
     * chaine de caractères
     */

    function verifyCoordsys() {
        $bExistCoordsys = false;
        foreach ($this->aGuiObject as $oGtfGui) {
            if ($oGtfGui->sType == "COORDSYS") {
                $bExistCoordsys = true;
            }
        }
        return $bExistCoordsys;
    }

    /*
     * fonction qui vérifie l'existence de liste de formats pour writerpick
     * aux objets GUI du sous formulaire sous la forme d'une
     * chaine de caractères
     */

    function verifyWriterPick() {
        $bExistWriterpick = false;
        foreach ($this->aGuiObject as $oGtfGui) {
            if ($oGtfGui->sType == "WRITERPICK") {
                $bExistWriterpick = true;
            }
        }
        return $bExistWriterpick;
    }

    /*
     * fonction qui renvoie un tableau des lignes correspondant
     * aux objets GUI du sous formulaire sous la forme d'une
     * chaine de caractères
     */

    function getExportParameters() {
        $aGuiLigne = array();
        $sVerifaValue = "//Default Values\n";
        array_push($aGuiLigne, "\t\t//Form attributes\n");

        foreach ($this->aGuiObject as $oGtfGui) {
            // bizarre mais des lignes peuvent être vides (génération KML)... à voir
            if ($oGtfGui->sDefault_Macro != "") {
                array_push($aGuiLigne, $oGtfGui->getGui());
                $sDefaultValue = str_replace('"', '\"', $oGtfGui->sDefaultValue);
                //Suppression des retours chariot (sinon les valeurs par défaut dans les listes déroulantes ne fonctionnent pas)
                $sDefaultValue = str_replace(chr(13), '', $sDefaultValue);
                $sDefaultValue = str_replace(chr(10), '', $sDefaultValue);
                //Suppression des valeurs par défaut
                //MULTIFILE : Entre autre les champs Upload
                //PASSWORD : Mot de passe qui ne doit pas apparaitre pour une meilleure sécurité
                //DIRNAME :  chemin comportant des "$"
                if ($oGtfGui->sType == "FLOAT") {
                    $sDefaultValue = str_replace(",", ".", $sDefaultValue);
                }
                if ($oGtfGui->sType == "FILENAME" || $oGtfGui->sType == "DIRNAME") {
                    $sDefaultValue = str_replace(array("$(FME_MF_DIR)", "$(FME_MF_DIR_USERTYPED)"), array("", ""), $sDefaultValue);
                    $aDefaultValue = explode("\\", $sDefaultValue); // Exemple : resultat_DwgDxf2Dgn_param_prive\resultat_DwgDxf2Dgn_param_prive\result.dgn
                    if (isset($aDefaultValue[count($aDefaultValue) - 1])) {
                        $sDefaultValue = $aDefaultValue[count($aDefaultValue) - 1];
                    }
                }
                if ($oGtfGui->sType != "MULTIFILE" && $oGtfGui->sType != "PASSWORD") {
                    $sVerifaValue.=chr(9) . chr(9) . 'if ($aValues["' . $oGtfGui->sDefault_Macro . '"]==""){$aValues["' . $oGtfGui->sDefault_Macro . '"]="' . $sDefaultValue . '";}' . chr(13);
                }
            }
        }
        //Suppression des retours chariot (sinon les valeurs par défaut dans les listes déroulantes ne fonctionnent pas)
        $aGuiLigne = str_replace(chr(13), '', $aGuiLigne);
        $aGuiLigne = str_replace(chr(10), '', $aGuiLigne);
        //Ajout de retour chariot pour une meilleure mise en page du formulaire généré
        return $sVerifaValue . chr(13) . implode(chr(13), $aGuiLigne);
    }

    /**
     * Product a JSON form
     * @param array $aProperties
     * @param string $sName
     * @return array
     */
    function productJson($aProperties, $sName) {
        $aJson = array("name" => "Subform", "title" => $sName, "input_size" => "xxs", "nb_cols" => 12, "rows" => array());
        $aFields = array("fields" => array());
        foreach ($this->aGuiObject as $oGtfGui) {
            // bizarre mais des lignes peuvent être vides (génération KML)... à voir
            if ($oGtfGui->sDefault_Macro != "") {
                $aFormField = $oGtfGui->getGuiV2($aProperties);
                // Décode les tags de FME et GTF dans les valeurs par défaut du formulaire json.
                if (!empty($aFormField[0]['default_value']))
                    $aFormField[0]['default_value'] = $oGtfGui->decodeFmeGtfTags($aFormField[0]['default_value']);
                $aFields = array("fields" => $aFormField);
                array_push($aJson["rows"], $aFields);
            }
        }

        $aJsonFinal = $this->productFinalJSON($aJson);

        return $aJsonFinal;
    }

    function productFinalJSON($aJson) {
        
        $aDatasources = [];
        $iDatasourceNumber = 0;
        
        // Création et attribution des datasources
        // Pour chaque row
        for ($i = 0; $i < count($aJson['rows']); $i++) {
            // Pour chaque field
            for ($ii = 0; $ii < count($aJson['rows'][$i]['fields']); $ii++) {
                // Si type est select ou list
                if ($aJson['rows'][$i]['fields'][$ii]['type'] === 'select' || $aJson['rows'][$i]['fields'][$ii]['type'] === 'list') {
                    // Si options est défini
                    if (isset($aJson['rows'][$i]['fields'][$ii]['options'])) {
                        // Céation du datasource
                        $aDatasources['datasource_'.$iDatasourceNumber] = array('type' => 'object', 'dataType' => 'text', 'name' => $aJson['rows'][$i]['fields'][$ii]['name'], 'description' => '', 'options' => $aJson['rows'][$i]['fields'][$ii]['options']);
                        // Attribution du datasource
                        $aJson['rows'][$i]['fields'][$ii]['datasource'] = array('datasource_id' => 'datasource_'.$iDatasourceNumber);
                        // Suppression des options dans le field
                        unset($aJson['rows'][$i]['fields'][$ii]['options']);
                        // Incémente le nom du datasource
                        $iDatasourceNumber++;
                    }
                }
            }
        }
        
        // Création du JSON Final
        $aJsonFinal = array("datasources" => $aDatasources, "display" => $aJson, "insert" => $aJson, "update" => $aJson, "search" => array());
        return $aJsonFinal;
    }

    /*
     * fonction qui renvoie un tableau des lignes correspondant
     * aux déclarations de objets GUI du sous formulaire sous la forme d'une
     * chaine de caractères
     */

    function getDeclaration() {
        $aGuiChoix = array();
        foreach ($this->aGuiObject as $oGtfGui) {
            array_push($aGuiChoix, $oGtfGui->getChoix());
        }
        if (count($aGuiChoix) > 1) {
            $aGuiChoixComment = array();
            array_push($aGuiChoixComment, "//List values\n");
            $aGuiChoix = $aGuiChoixComment + $aGuiChoix;
        }
        return implode(" ", $aGuiChoix);
    }

    /*
     *  fonction qui renvoie le tableau des systêmes de coordonées
     *  en s'aidant du fichier texte qui contient la liste
     */

    function getCoordSys() {
        $aTemp = file("../../../gtf.client/coordsys.txt");
        $sText .= "//Coordinate systems\n";
        for ($i = 1; $i < count($aTemp); $i++) {
            $sValeur = $aTemp[$i];
            //Suppression des retours chariot (sinon les valeurs par défaut dans les listes déroulantes ne fonctionnent pas)
            $sValeur = str_replace(chr(13), '', $sValeur);
            $sValeur = str_replace(chr(10), '', $sValeur);
            $sText .= "\t\t\$aCoordsys[\"" . $sValeur . "\"]=\"" . $sValeur . "\";\n";
        }
        return $sText;
    }

    /*
     *  fonction qui renvoie le tableau des formats pour le WRITERPICK
     *  en s'aidant du fichier texte qui contient la liste
     */

    function getWriterPick() {
        $aTemp = file("../../../gtf.client/writerpick.txt");
        $sText .= "//Writerpick formats\n";
        $sText .= "\t\t\$aWriterPick[\"\"]=\"\";\n";
        for ($i = 1; $i < count($aTemp); $i++) {
            $sValue = $aTemp[$i];
            //Suppression des retours chariot (sinon les valeurs par défaut dans les listes déroulantes ne fonctionnent pas)
            $sValue = str_replace(chr(13), '', $sValue);
            $sValue = str_replace(chr(10), '', $sValue);
            $aValues = explode("=", $sValue);
            $sText .= "\t\t\$aWriterPick[\"" . trim($aValues[1]) . "\"]=\"" . trim($aValues[0]) . "\";\n";
        }
        return $sText;
    }

    /*
     * fonction qui renvoie une chaine de caracteres
     * contenant la liste des contrôles à exporter
     * et à insérer dans le sous formulaire.
     */

    function getParameters() {
        $sListeParams = "//Workspace parameters\n\t\t\$oForm->hiddenField (\"liste_parametres\",'";
        $sParam = "";
        foreach ($this->aGuiObject as $oGtfGui) {
            if ($oGtfGui->sDefault_Macro != "" && $oGtfGui->sDefault_Macro != "GTF_ORDER_ID" && $oGtfGui->sDefault_Macro != "GTF_CONNECTION_STRING" && $oGtfGui->sDefault_Macro != "GTF_SHARED_DIR")
                $sParam .= $oGtfGui->sDefault_Macro . "|";
        }
        $sParam = substr($sParam, 0, -1);
        $sListeParams .= $sParam . "');";

        $sListeParams .= "\n\t\t//Workspace parameters required\n\t\t\$oForm->hiddenField (\"parameters_list_required\",'";
        $sParam = "";
        foreach ($this->aGuiObject as $oGtfGui) {
            if ($oGtfGui->sDefault_Macro != "" && (!$oGtfGui->bOptional) && $oGtfGui->sDefault_Macro != "GTF_ORDER_ID" && $oGtfGui->sDefault_Macro != "GTF_CONNECTION_STRING" && $oGtfGui->sDefault_Macro != "GTF_SHARED_DIR")
                $sParam .= $oGtfGui->sDefault_Macro . "|";
        }
        $sParam = substr($sParam, 0, -1);
        $sListeParams .= $sParam . "');";
        return $sListeParams;
    }

    /*
     * fonction lancant la génération du sous formulaire
     * a partir du template "Modele.SubForm.class.inc"
     * remplacant les balises du template par
     * les chaines de caractères correspondantes
     */

    function generateSubForm($sTemplate, $sFileName, $iWorkspaceId) {
        $sSubFormTemp = file_get_contents($sTemplate);
        $sSubFormTemp = str_replace("[WorkspaceId]", $iWorkspaceId, $sSubFormTemp);
        $sSubFormTemp = str_replace("[DECLARATION]", $this->getDeclaration(), $sSubFormTemp);
        if ($this->verifyCoordsys() == true) {
            $sSubFormTemp = str_replace("[COORD_SYS]", $this->getCoordSys(), $sSubFormTemp);
        } else {
            $sSubFormTemp = str_replace("[COORD_SYS]", "", $sSubFormTemp);
        }
        if ($this->verifyWriterPick() == true) {
            $sSubFormTemp = str_replace("[WRITER_PICK]", $this->getWriterPick(), $sSubFormTemp);
        } else {
            $sSubFormTemp = str_replace("[WRITER_PICK]", "", $sSubFormTemp);
        }
        $this->productJson(); //############################################ Genese du Json
        $sSubFormTemp = str_replace("[EXPORT_PARAMETRE]", str_replace("\\", "\\\\", $this->getExportParameters()), $sSubFormTemp);
        $sSubFormTemp = str_replace("[PARAMETRES]", $this->getParameters(), $sSubFormTemp);
        $oFile = fopen($sFileName, "w+");
        fwrite($oFile, $sSubFormTemp);
        fclose($oFile);
    }

    function charFMWToRealCharacter($sValue) {
        return str_replace('\\u', "\\\\u", str_replace("'", "''", str_replace('&#10;', '\n', htmlspecialchars_decode($sValue))));
    }

    function realCharacterToCharFMW($sValue) {
        if (strtolower($this->sEncoding) != 'utf-8') {
            $sValue = utf8_decode($sValue);
        }
        return htmlspecialchars(str_replace(chr(13), '', str_replace(chr(10), '', $sValue)));
    }

    function updateMetadata($oBd, $iId) {
        $sSql = "SELECT \"name\" FROM s_gtf.workspace WHERE workspace_id = " . $iId . ";";
        $oResultat = $oBd->execute($sSql);
        if (!$oBd->erreurRencontree) {
            while ($oWorkspace = $oBd->objetSuivant($oResultat)) {
                $sWorkspaceName = $oWorkspace->name;
            }
        }
        if ($this->sCategory != "") {
            $sSql = "SELECT category_id FROM s_gtf.category WHERE lower(name) = lower('" . $this->sCategory . "');";
            $iCategoryId = 0;
            $oResultat = $oBd->execute($sSql);
            if (!$oBd->erreurRencontree) {
                while ($oCategory = $oBd->objetSuivant($oResultat)) {
                    $iCategoryId = $oCategory->category_id;
                }
            }
            if ($iCategoryId == 0) {
                $aFields['name'] = $this->sCategory;
                $iCategoryId = $oBd->insert("s_gtf", "category", $aFields, "s_gtf.seq_common", "category_id");
            }
        } else {
            $iCategoryId = "NULL";
        }
        if ($this->sSaveDate == "") {
            $sSaveDate = "NULL";
        } else {
            $sSaveDate = "'" . $this->sSaveDate . "'";
        }
        if ($this->sDescription == "") {
            $sDescription = "NULL";
        } else {
            $sDescription = "'" . $this->sDescription . "'";
        }
        // Création d'un titre si inexistant.
        if ($this->sTitle == "")
            $this->sTitle = pathinfo($this->sFmwFileName, PATHINFO_FILENAME);
        if ($sWorkspaceName != "") {
            $sSql = "UPDATE s_gtf.workspace set description = " . $sDescription . ", category_id = " . $iCategoryId . ", legal_terms_conditions = '" . $this->sLegal . "', \"usage\" = '" . $this->sUsage . "', last_save_date = " . $sSaveDate . ", last_save_build = '" . $this->sSaveBuild . "', file_encoding = '" . $this->sEncoding . "', requirements = '" . $this->sRequirements . "', history = '" . $this->sHistory . "', title = '" . $this->sTitle . "' WHERE workspace_id = " . $iId . ";";
        } else {
            $title = $this->sTitle;
            $sSql = "SELECT workspace_id FROM s_gtf.workspace WHERE lower(name) = lower('" . $title . "');";
            $iResult = $oBd->execute($sSql);
            if ($aWorkspace = $oBd->ligneSuivante($iResult)) {
                $title = $title . date("Ymd-His") . rand(0, 100);
            }
            $sSql = "UPDATE s_gtf.workspace set description = '" . $this->sDescription . "', category_id = " . $iCategoryId . ", legal_terms_conditions = '" . $this->sLegal . "', \"usage\" = '" . $this->sUsage . "', last_save_date = " . $sSaveDate . ", last_save_build = '" . $this->sSaveBuild . "', file_encoding = '" . $this->sEncoding . "', requirements = '" . $this->sRequirements . "', history = '" . $this->sHistory . "', title = '" . $this->sTitle . "', \"name\" = '" . $title . "' WHERE workspace_id = " . $iId . ";";
        }
        $oResultat = $oBd->execute($sSql);
    }

    function getBdMetadata($oBd, $iId) {
        $sSql = "SELECT workspace.description, category.name as category_name, title, legal_terms_conditions, usage, requirements FROM s_gtf.workspace left join s_gtf.category on workspace.category_id = category.category_id WHERE workspace_id = " . $iId . ";";
        $oResultat = $oBd->execute($sSql);
        if (!$oBd->erreurRencontree) {
            while ($oMeta = $oBd->objetSuivant($oResultat)) {
                $this->sDescription = $oMeta->description;
                $this->sCategory = $oMeta->category_name;
                $this->sLegal = $oMeta->legal_terms_conditions;
                $this->sUsage = $oMeta->usage;
                $this->sRequirements = $oMeta->requirements;
                $this->sTitle = $oMeta->title;
            }
        }
    }

    function save($sFileName) {

        $sRechercheTitle = '^#![ \t]+TITLE=\"(.*)\"';
        $sRechercheDescription = '^#![ \t]+DESCRIPTION=\"(.*)\"';
        $sRechercheCategory = '^#![ \t]+CATEGORY=\"(.*)\"';
        $sRechercheLegal = '^#![ \t]+LEGAL_TERMS_CONDITIONS=\"(.*)\"';
        $sRechercheUsage = '^#![ \t]+USAGE=\"(.*)\"';
        $sRechercheRequirements = '^#![ \t]+REQUIREMENTS=\"(.*)\"';
        $sRechercheName = '^#![ \t]+NAME=\"(.*)\"';
        $sRechercheWorkspace = '^#![ \t]+<WORKSPACE';
        $sRechercheEndWorkspace = '^#![ \t]+>';
        $bIsWorkspace = false;

        $ecriture = fopen($sFileName, "w+");
        foreach ($this->aLignes as $ligne) {
            if (strtolower($this->sEncoding) != 'utf-8') {
                $ligne = utf8_decode($ligne);
            }
            if (mb_eregi($sRechercheWorkspace, $ligne, $aOccurence)) {
                $bIsWorkspace = true;
            }
            if ($bIsWorkspace == true) {
                //Description
                if (mb_eregi($sRechercheDescription, $ligne, $aOccurence)) {

                    $ligne = str_replace('"' . $aOccurence[1] . '"', '"' . $this->realCharacterToCharFMW($this->sDescription) . '"', $ligne);
                }
                //Title
                if (mb_eregi($sRechercheTitle, $ligne, $aOccurence)) {
                    $ligne = str_replace('"' . $aOccurence[1] . '"', '"' . $this->realCharacterToCharFMW($this->sTitle) . '"', $ligne);
                }

                //Category
                if (mb_eregi($sRechercheCategory, $ligne, $aOccurence)) {
                    $ligne = str_replace('"' . $aOccurence[1] . '"', '"' . $this->realCharacterToCharFMW($this->sCategory) . '"', $ligne);
                }
                //Usage
                if (mb_eregi($sRechercheUsage, $ligne, $aOccurence)) {
                    $ligne = str_replace('"' . $aOccurence[1] . '"', '"' . $this->realCharacterToCharFMW($this->sUsage) . '"', $ligne);
                }
                //Legal
                if (mb_eregi($sRechercheLegal, $ligne, $aOccurence)) {
                    $ligne = str_replace('"' . $aOccurence[1] . '"', '"' . $this->realCharacterToCharFMW($this->sLegal) . '"', $ligne);
                }
                //Requirements
                if (mb_eregi($sRechercheRequirements, $ligne, $aOccurence)) {
                    $ligne = str_replace('"' . $aOccurence[1] . '"', '"' . $this->realCharacterToCharFMW($this->sRequirements) . '"', $ligne);
                }
                if (mb_eregi($sRechercheEndWorkspace, $ligne, $aOccurence)) {
                    $bIsWorkspace = false;
                }
            }
            fwrite($ecriture, $ligne); // affichera $prenoms[0], $prenoms[1] etc.
        }

        fclose($ecriture);
    }

}

?>
