<?php

//require_once("vmlib/BD.class.inc");
//require_once("vmlib/logUtil.inc");
//require_once("vmlib/dbUtil.inc");
//require_once("vmlib/Vm.class.inc"); 
//require_once("vmlib/phpUtil.inc");
//require_once("vmlib/stringUtil.inc");
//require_once("vmlib/VirtualFormV2.class.inc");

class GtfGui {

    var $sDefault_Macro;
    var $sType;
    var $sLibelle;
    var $sDefaultValue;
    var $sFiltreSource;
    var $sFiltreDest;
    var $aChoix;
    var $bIsSource = false;
    var $bIsDest = false;
    var $sFmwFileName;
    var $sUniqId;
    var $bOptional = false;
    var $bPrivate = false;

    /*
     * Constructeur de la classe GtfGui
     * Chaque occurence contenue dans le tableau des GUI est examiné
     * et les valeurs correspondantes des paramètres sont renvoyées
     */

    function __construct($sValue, $sFmwFileName, $sEncoding) {
        $aPart = $this->guiExplode($sValue, $sFmwFileName);
        if (count($aPart) < 20)
            $aPart = array_merge($aPart, array_fill(count($aPart), (20 - count($aPart)), ''));
        $this->sFmwFileName = $sFmwFileName;
        if ($aPart[1] == "OPTIONAL") {
            $this->bOptional = true;
            if ($aPart[2] == "IGNORE") {
                $this->bPrivate = true;
                $i = 2;
            } else {
                $i = 1;
            }
        } else if ($aPart[1] == "IGNORE") {
            $this->bPrivate = true;
            $i = 1;
        } else {
            $i = 0;
        }
        $this->sType = $aPart[$i + 1];
        if ($this->bPrivate != true) {
            switch ($this->sType) {
                case "DATE_TIME" :
                case "FLOAT" :
                case "INTEGER" :
                case "PASSWORD" :
                case "STRING_ENCODED" :
                case "TEXT" :
                case "TEXT_EDIT" :
                case "TEXT_EDIT_OR_NUM" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "ATTRLIST_COMMAS" :
                case "ATTRLIST_OR_ATTR":
                case "ATTRLIST" :
                case "ATTR" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "URL" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "FILENAME" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsDest = true;
                    $this->sFiltreDest = $aPart[$i + 3];
                    break;
                case "FILENAME_EXISTING" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsSource = true;
                    $this->sFiltreDest = $aPart[$i + 3];
                    break;
                case "SOURCE_GEODATABASE" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsSource = true;
                    $this->sFiltreSource = "*.gdb";
                    break;
                case "DEST_GEODATABASE" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsDest = true;
                    break;
                case "FILE_OR_URL" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsSource = true;
                    $this->sFiltreSource = $aPart[$i + 3];
                    break;
                case "DIRNAME" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsDest = true;
                    break;
                case "DIRNAME_SRC" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsSource = true;
                    break;
                case "COORDSYS" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "WRITERPICK" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "CHOICE" :
                    $this->sDefault_Macro = $aPart[$i + 2];
					
					$j = 0;
					$sChoice = "";
					$this->aChoix = array();
					
					while($j < strlen($aPart[$i + 3])){
						if($aPart[$i + 3][$j] == '"'){
							$j += 1;
							while($aPart[$i + 3][$j] != '"'){
								$sChoice .= $aPart[$i + 3][$j];
								$j += 1;
							}
							$j += 1;
						} else if ($aPart[$i + 3][$j] === "%"){
							array_push($this->aChoix, $sChoice);
							$sChoice = "";
							$j += 1;
						} else {
							$sChoice .= $aPart[$i + 3][$j];
							$j += 1;
						}
					}
                    array_push($this->aChoix, $sChoice);
					
					$this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "LOOKUP_LISTBOX" :
                case "LISTBOX" :
                case "CLASSICLISTBOX" :
                    $this->sDefault_Macro = $aPart[$i + 2];
					
					$j = 0;
					$sChoice = "";
					$this->aChoix = array();
					
					while($j < strlen($aPart[$i + 3])){
						if($aPart[$i + 3][$j] == '"'){
							$j += 1;
							while($aPart[$i + 3][$j] != '"'){
								$sChoice .= $aPart[$i + 3][$j];
								$j += 1;
							}
							$j += 1;
						} else if ($aPart[$i + 3][$j] === "%"){
							array_push($this->aChoix, $sChoice);
							$sChoice = "";
							$j += 1;
						} else {
							$sChoice .= $aPart[$i + 3][$j];
							$j += 1;
						}
					}
					array_push($this->aChoix, $sChoice);
					
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "STRING_OR_CHOICE" :
                    $this->sDefault_Macro = $aPart[$i + 2];
					
					$j = 0;
					$sChoice = "";
					$this->aChoix = array();
					
					while($j < strlen($aPart[$i + 3])){
						if($aPart[$i + 3][$j] == '"'){
							$j += 1;
							while($aPart[$i + 3][$j] != '"' && $j < strlen($aPart[$i + 3])){
								$sChoice .= $aPart[$i + 3][$j];
								$j += 1;
							}
							$j += 1;
						} else if ($aPart[$i + 3][$j] === "%"){
							array_push($this->aChoix, $sChoice);
							$sChoice = "";
							$j += 1;
						} else {
							$sChoice .= $aPart[$i + 3][$j];
							$j += 1;
						}
					}
					array_push($this->aChoix, $sChoice);
					
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "LOOKUP_CHOICE" :
                    $this->sDefault_Macro = $aPart[$i + 2];
					
					$j = 0;
					$sChoice = "";
					$this->aChoix = array();
					
					while($j < strlen($aPart[$i + 3])){
						if($aPart[$i + 3][$j] == '"'){
							$j += 1;
							while($aPart[$i + 3][$j] != '"'){
								$sChoice .= $aPart[$i + 3][$j];
								$j += 1;
							}
							$j += 1;
						} else if ($aPart[$i + 3][$j] === "%"){
							array_push($this->aChoix, $sChoice);
							$sChoice = "";
							$j += 1;
						} else {
							$sChoice .= $aPart[$i + 3][$j];
							$j += 1;
						}
					}
					array_push($this->aChoix, $sChoice);
					
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "COLOR_PICK" :
                case "Color_Pick" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 3] . " " . $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "RANGE_SLIDER" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->aChoix = explode("%", $aPart[$i + 3]);
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    break;
                case "MULTIFILE" :
                    $this->sDefault_Macro = $aPart[$i + 2];
                    $this->sLibelle = $aPart[$i + 4] . " " . $aPart[$i + 5] . " " . $aPart[$i + 6] . " " . $aPart[$i + 7] . " " . $aPart[$i + 8] . " " . $aPart[$i + 9] . " " . $aPart[$i + 10] . " " . $aPart[$i + 11] . " " . $aPart[$i + 12] . " " . $aPart[$i + 13];
                    $this->bIsSource = true;
                    $this->sFiltreSource = $aPart[$i + 3];
                    break;
            }
            if ($this->sDefault_Macro != "" && $this->bIsSource == false) {
                $this->sDefaultValue = $this->getDefaultValue($this->sDefault_Macro, $sEncoding);
            }
        }
    }

    /*
     * Fonction récupérant les paramètres des Gui
     * et générant la ligne de code php correspondante au contrôle
     * à insérer dans la page du sous formulaire
     */
    /*
      function getGui(){
      if ($this->bPrivate!=true && $this->sDefault_Macro != "GTF_ORDER_ID" && $this->sDefault_Macro != "GTF_CONNECTION_STRING" && $this->sDefault_Macro != "GTF_SHARED_DIR"){
      if (preg_match("#^H_#", $this->sDefault_Macro)){
      $sGui .= "\t\t\$oForm->hiddenField(\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"]);\n";
      }else{
      switch ($this->sType){
      case "MULTIFILE" :
      $this->sUniqId = $this->getUniqId();
      $sOnChange = '"uploadFile(window.document.getElementById(\'EXTERNAL_UPLOAD_'.$this->sUniqId.'\'), window.document.getElementById(\''.$this->sDefault_Macro.'\'),\'\', window.document.getElementById(\'sPathFile_'.$this->sUniqId.'\'))"';
      $sValeur = '$aValues["'.$this->sDefault_Macro.'"]';
      $sGui = "\t\t\$oForm->uploadField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",80,\"\",".$sOnChange.",\"sPathFile_".$this->sUniqId."\");\n \t\t\$oForm->hiddenField (\"EXTERNAL_UPLOAD_".$this->sUniqId."\",\"upload|zip|sPathFile_".$this->sUniqId."|import|\");\n";
      break;
      case "FILE_OR_URL" :
      $this->sUniqId = $this->getUniqId();
      $sOnChange = '"uploadFile(window.document.getElementById(\'EXTERNAL_UPLOAD_'.$this->sUniqId.'\'), window.document.getElementById(\''.$this->sDefault_Macro.'\'),\'\', window.document.getElementById(\'sPathFile_'.$this->sUniqId.'\'))"';
      $sValeur = '$aValues["'.$this->sDefault_Macro.'"]';
      $sGui = "\t\t\$oForm->uploadField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",80,\"\",".$sOnChange.",\"sPathFile_".$this->sUniqId."\");\n \t\t\$oForm->hiddenField (\"EXTERNAL_UPLOAD_".$this->sUniqId."\",\"upload|zip|sPathFile_".$this->sUniqId."|import|\");\n";
      break;
      case "FILENAME" :
      case "FILENAME_EXISTING" :
      case "SOURCE_GEODATABASE" :
      case "DIRNAME_SRC" :
      if ($this->bIsSource){
      $this->sUniqId = $this->getUniqId();
      $sOnChange = '"uploadFile(window.document.getElementById(\'EXTERNAL_UPLOAD_'.$this->sUniqId.'\'), window.document.getElementById(\''.$this->sDefault_Macro.'\'),\'\', window.document.getElementById(\'sPathFile_'.$this->sUniqId.'\'))"';
      $sValeur = '$aValues["'.$this->sDefault_Macro.'"]';
      $sGui = "\t\t\$oForm->uploadField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",80,\"\",".$sOnChange.",\"sPathFile_".$this->sUniqId."\");\n \t\t\$oForm->hiddenField (\"EXTERNAL_UPLOAD_".$this->sUniqId."\",\"upload|zip|sPathFile_".$this->sUniqId."|import|\");\n";

      }else{
      $sGui = "\t\t\$oForm->textField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],75);";
      }
      break;
      case "DATE_TIME" :
      $sGui = "\t\t\$oForm->calendarDateTimeField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],75);";
      break;
      case "DIRNAME" :
      case "DEST_GEODATABASE" :
      $sGui = "\t\t\$oForm->textField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],75);";
      break;
      case "COORDSYS" :
      $sGui = "\t\t\$oForm->listField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],0,\$aCoordsys);\n";
      break;
      case "WRITERPICK" :
      $sGui = "\t\t\$oForm->listField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],0,\$aWriterPick);\n";
      break;
      case "FLOAT" :
      $sGui = "\t\t\$oForm->textField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],25);";
      break;
      case "INTEGER" :
      $sGui = "\t\t\$oForm->numberField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],10);";
      break;
      case "CHOICE" :
      $sGui = "\t\t\$oForm->listField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],0,\$a".$this->sDefault_Macro.");\n";
      break;
      case "LOOKUP_LISTBOX" :
      case "LISTBOX" :
      case "CLASSICLISTBOX" :
      $sGui = "\t\t\$oForm->listField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],5,\$a".$this->sDefault_Macro.",true);\n";
      break;
      case "PASSWORD" :
      $sGui = "\t\t\$oForm->PasswordField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\"\",40);\n";
      break;
      case "TEXT" :
      $sGui = "\t\t\$oForm->textField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],80,80);\n";
      break;
      case "TEXT_EDIT" :
      case "TEXT_EDIT_OR_NUM" :
      $sGui = "\t\t\$oForm->areaField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],3,80);\n";
      break;
      case "STRING_ENCODED" :
      $sGui = "\t\t\$oForm->textField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],80,80);\n";
      break;
      case "STRING_OR_CHOICE" :

      $sData="var data_".$this->sDefault_Macro." = {};data_".$this->sDefault_Macro.".results = [";
      $iNbrElementChampStringOrChoice=count($this->aChoix);
      $i=1;
      foreach ($this->aChoix as $sValue) {
      $sValue = str_replace("'", "\'", $sValue);
      $sValue = str_replace('"', '\"', $sValue);
      if ($i==$iNbrElementChampStringOrChoice){
      $sData.="{id:'".$sValue."',name:'".$sValue."'}";
      }else{
      $sData.="{id:'".$sValue."',name:'".$sValue."'},";
      }
      $i++;
      }
      $sData.="];";

      $sGui = "\t\t\$oForm->formContent .= \"	<script type='text/javascript'>

      ".$sData."

      $(function() {

      $('#".$this->sDefault_Macro."').flexbox(data_".$this->sDefault_Macro.", {
      autoCompleteFirstMatch: false,
      paging: false,
      noResultsText: '',
      });

      });
      </script>

      <div class='attributeName' id='".$this->sDefault_Macro."_label'>".$this->sLibelle."</div><div id='".$this->sDefault_Macro."'></div>\n\";\n";

      break;
      case "LOOKUP_CHOICE" :
      $sGui = "\t\t\$oForm->listField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],0,\$a".$this->sDefault_Macro.");\n";
      break;
      case "COLOR_PICK" :
      case "Color_Pick" :
      $sGui = "\t\t\$oForm-> graphicsPaletteField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues['".$this->sDefault_Macro."'],20,0,\"Palette\", \"link_submit\",\"colorPicker('".$this->sDefault_Macro."');\", \"formLink\",\$sCouleurFond);\n";
      break;
      case "RANGE_SLIDER" :
      if (isset($this->aChoix[2])){
      $iValueDecimal=$this->aChoix[2];
      }else{
      $iValueDecimal=1;
      }
      $sDefaultValue=round($this->sDefaultValue); //La valeur par défaut est arrondi car le slider ne gère pas de nombre de type float
      $sGui = "\t\t\$oForm->SliderField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\", 5, ".$this->aChoix[0].", ".$this->aChoix[1].", ".$sDefaultValue.", 1, ".$iValueDecimal.");";
      break;
      case "URL" :
      $sGui = "\t\t\$oForm->textField(\"".$this->sLibelle."\",\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"],80,80);\n";
      break;
      }
      }
      }
      return $sGui;
      }
     */

    function getGuiV2($aProperties) {
        $aFields = array();
		 $this->sDefaultValue = str_replace(array("$(FME_MF_DIR)", "$(FME_MF_DIR_USERTYPED)"), array("", ""), $this->sDefaultValue);
        if ($this->bPrivate != true && substr($this->sDefault_Macro, 0, 4) != "GTF_") {
			$aDefaultValue = explode("\\", $this->sDefaultValue); // Exemple : resultat_DwgDxf2Dgn_param_prive\resultat_DwgDxf2Dgn_param_prive\result.dgn
			if (isset($aDefaultValue[count($aDefaultValue) - 1])) {
				 $this->sDefaultValue = $aDefaultValue[count($aDefaultValue) - 1];
			}
            if (preg_match("#^H_#", $this->sDefault_Macro)) {
                //Champs à cacher donc rien à faire ?
                //$sGui .= "\t\t\$oForm->hiddenField(\"".$this->sDefault_Macro."\",\$aValues[\"".$this->sDefault_Macro."\"]);\n";
                // Supprime le pramètre FME "$(FME_MF_DIR)".
               
                // Sauve le champ caché.
                $aFields = array(array("type" => "hidden", "name" => $this->sDefault_Macro, "default_value" => $this->sDefaultValue, "nb_cols" => 12));
            } else {
                switch ($this->sType) {
                    case "MULTIFILE" :
                        $aFields = array(array("type" => "upload", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "nb_cols" => 12, "default_value" => $this->sDefaultValue, 'multiple' => true));
                        break;
                    case "FILE_OR_URL" :
                        $aFields = array(array("type" => "upload", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "FILENAME_EXISTING" :
                    case "SOURCE_GEODATABASE" :
                    case "DIRNAME_SRC" :
                        $aFields = array(array("type" => "upload", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "FILENAME" :
                        if ($this->bIsDest)
                            $aFields = array(array("type" => "text", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "pattern" => "", "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        else
                            $aFields = array(array("type" => "upload", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "DATE_TIME" :
						$sYear = substr($this->sDefaultValue,0,4);
						$sMonth = substr($this->sDefaultValue,4,2);
						$sDay = substr($this->sDefaultValue,6,2);
						$sHours = substr($this->sDefaultValue,8,2);
						$sMinute = substr($this->sDefaultValue,10,2);
						$sSecond = substr($this->sDefaultValue,12,2);
						
						$sTMP = $sDay ."/". $sMonth ."/". $sYear ."  ". $sHours . ":" . $sMinute;
						
                        $aFields = array(array("type" => "datetime", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "nb_cols" => 12, "default_value" => $sTMP));
                        break;
                    case "DIRNAME" :
                    case "DEST_GEODATABASE" :
                        $aFields = array(array("type" => "text", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "pattern" => "", "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "COORDSYS" :
                        $aCoordsys = array();
                        $sFilename = $aProperties["vas_home"] . "/util/coordsys.txt";
                        $fPointeur = fopen($sFilename, "r");
                        while (!feof($fPointeur)) {
                            $sLine = fgets($fPointeur);
                            $sLine = str_replace(array("\n", "\r"), "", $sLine);
                            array_push($aCoordsys, $sLine);
                        }
                        fclose($fPointeur);
                        $aFields = array(array("type" => "select", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "options" => $aCoordsys, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "WRITERPICK" :
                        $aWriterPick = array();
                        $sFilename = $aProperties["vas_home"] . "/util/writerpick.txt";
                        $fPointeur = fopen($sFilename, "r");
                        while (!feof($fPointeur)) {
                            $sLine = fgets($fPointeur);
                            $sLine = str_replace(array("\n", "\r"), "", $sLine);
                            array_push($aWriterPick, $sLine);
                        }
                        fclose($fPointeur);
                        $aFields = array(array("type" => "select", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "options" => $aWriterPick, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "FLOAT" :
                        $aFields = array(array("type" => "float", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "INTEGER" :
                        $aFields = array(array("type" => "integer", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "CHOICE" :
                        $this->aChoix = $this->getChoix();
						$this->sDefaultValue = $this->replacer($this->sDefaultValue);
                        $aFields = array(array("type" => "select", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "options" => $this->aChoix, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "LOOKUP_LISTBOX" :
                    case "LISTBOX" :
                    case "CLASSICLISTBOX" :
                        $this->aChoix = $this->getChoix();
						$this->sDefaultValue = $this->replacer($this->sDefaultValue);
                        $aFields = array(array("type" => "list", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "options" => $this->aChoix, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "PASSWORD" :
                        $aFields = array(array("type" => "password", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "pattern" => "", "nb_cols" => 12));
                        break;
                    case "TEXT" :
						$this->sDefaultValue = $this->replacer($this->sDefaultValue);
                        $aFields = array(array("type" => "text", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "pattern" => "", "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "TEXT_EDIT" :
                    case "TEXT_EDIT_OR_NUM" :
						$this->sDefaultValue = $this->replacer($this->sDefaultValue);
                        $aFields = array(array("type" => "textarea", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "STRING_ENCODED" :
                        $aFields = array(array("type" => "text", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "pattern" => "", "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "STRING_OR_CHOICE" :
                        $this->aChoix = $this->getChoix();
                        $aFields = array(array("type" => "select", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "options" => $this->aChoix, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "LOOKUP_CHOICE" :
						$this->sDefaultValue = $this->replacer($this->sDefaultValue);
                        $this->aChoix = $this->getChoix();
                        $aFields = array(array("type" => "select", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "options" => $this->aChoix, "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "COLOR_PICK" :
                    case "Color_Pick" :

                        //$aColors = explode(',', $this->sDefaultValue);
                        //$this->sDefaultValue = "";
                        /*for ($i = 0; $i < count($aColors); $i++) {
                            $this->sDefaultValue .= round($aColors[$i] * 255).",";
                        }*/
                        //$this->sDefaultValue = "rgba(".$this->sDefaultValue."1)";
                        $aFields = array(array("type" => "color_picker", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "nb_cols" => 12, "default_value" => $this->sDefaultValue));

                        break;
                    case "RANGE_SLIDER" :
                        if ($this->aChoix[2] == "") {
                            $this->aChoix[2] = 0;   // si aucune précision n'est défini valeur par défaut
                        }
                        $fStep = 1.0 / pow(10, (int) $this->aChoix[2]); // adaptation du pas par rapport à la précision
                        $aFields = array(array("type" => "slider", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "options" => array("min" => (int) $this->aChoix[0], "max" => (int) $this->aChoix[1], "precision" => (int) $this->aChoix[2], "step" => $fStep), "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                    case "URL" :
                        $aFields = array(array("type" => "url", "name" => $this->sDefault_Macro, "label" => $this->sLibelle, "required" => !$this->bOptional, "pattern" => "", "nb_cols" => 12, "default_value" => $this->sDefaultValue));
                        break;
                }
            }
        }
        return $aFields;
    }

    /*
     * Fonction récupérant les paramètres des Gui
     * et générant la ligne de code php correspondante aux choix
     * des listes se trouvant dans le fichier fmw
     */

    function getChoix() {
        if ($this->bPrivate != true) {
            $aChoixTmp = array();
            $aChoix = $this->aChoix;
            switch ($this->sType) {
                case "LOOKUP_LISTBOX" :
                case "LISTBOX" :
                case "CHOICE" :
                case "CLASSICLISTBOX" :
                    foreach ($aChoix as $sValue) {
                        //$sValue = str_replace("'","\'",$sValue);
                        //$sValue = str_replace("\"", "", $sValue);
                        //$sValue = str_replace("<quote>", '\"', $sValue);
                        //$sValue = str_replace("<space>", " ", $sValue);
                        //$sValue = str_replace("<apos>", "'", $sValue);
                        //$sValue = str_replace("<u00e9>", "é", $sValue);
                        //$sValue = str_replace("<u00e0>", "à", $sValue);
						
                        $bComaExisting = strpos($sValue, ",");
                        
						if ($bComaExisting === false) {
                            //La chaine "," n'existe pas
                            //$sText .= "\t\t\$a".$this->sDefault_Macro."[\"".$sValue."\"]=\"".$sValue."\";\n";
							$sValue = $this->replacer($sValue);
                            array_push($aChoixTmp, $sValue);
                        } else {
                            //La chaine "," Existe
                            $aValue = explode(",", $sValue);
							
							foreach($aValue as &$sVal){
								$sVal = $this->replacer($sVal);
							}
                            //$aValue = str_replace("<comma>", ",", $aValue);
                            //$sText .= "\t\t\$a".$this->sDefault_Macro."[\"".$aValue[1]."\"]=\"".$aValue[0]."\";\n";
                            array_push($aChoixTmp, $aValue[0] . "|" . $aValue[1]);
                        }
                    }
                    break;
                case "LOOKUP_CHOICE" :
                    foreach ($aChoix as $sValue) {
                        //$sValue = str_replace("\"", "", $sValue);
                        //$sValue = str_replace("<quote>", '\"', $sValue);
                        //$sValue = str_replace("<space>", " ", $sValue);
                        //$sValue = str_replace("<apos>", "'", $sValue);
                        //$sValue = str_replace("<u00e9>", "é", $sValue);
                        //$sValue = str_replace("<u00e0>", "à", $sValue);
                        $aValue = explode(",", $sValue);
						
						foreach($aValue as &$sVal){
								$sVal = $this->replacer($sVal);
						}
                        
						array_push($aChoixTmp, $aValue[0] . "|" . $aValue[1]);
                    }
                    break;
                case "STRING_OR_CHOICE" :
                    foreach ($aChoix as $sValue) {
                        $sValue = str_replace("\"", "", $sValue);
                        array_push($aChoixTmp, $sValue);
                    }
                    break;
            }
        }
        return $aChoixTmp;
    }

    /*
     *  Fonction qu permet de récupérer dans un tableau les extensions associées à la source de données
     *  $sFiltre : chaine de caractere contenant les extensions autorisées
     */

    function getExtensionArray($sFiltre) {
        $aExtension = array();
        $aExtension = $this->ExtensionSeeker($sFiltre);
        return $aExtension;
    }

    /*
     *  Fonction qui avec la chaine des extensions en entrée, renvoi un tableau contenant une ligne par extension autorisée pour la source de données.
     *  Si plusieurs extensions sont fournies le "*.*" est ignoré
     *  $sChaine : chaine de caractères contenant les extensions (en itération paire) séparés par des |
     */

    function ExtensionSeeker($sChaine) {
        $aTemp = array();
        $aTemp2 = array();
        $aExtension = array();
        $aTemp = explode("|", $sChaine);
        $i = 0;
        $l = 0;
        if (sizeOf($aTemp) == 1)
            array_push($aTemp2, $aTemp[0]);
        else {
            foreach ($aTemp as $sValue) {
                if ($i % 2) {
                    if ($l >= 1) {
                        if ($sValue != "*.*") {
                            array_push($aTemp2, $sValue);
                            $l++;
                        }
                    } else {
                        array_push($aTemp2, $sValue);
                        $l++;
                    }
                }
                $i++;
            }
        }
        foreach ($aTemp2 as $sValue) {
            $aTmp = preg_split("/[,;_]/", $sValue);
            foreach ($aTmp as $sTmp)
                array_push($aExtension, $sTmp);
        }
        return array_iunique($aExtension);
    }

    /*
     *  Fonction qui permet de prendre une lige GUI
     *  Et de la découper de manière à avoir tout les paramêtres remplis
     *  Avec gestion des espaces pour les listes de choix
     */

    function guiExplode($sValue) {
        $aTypeParametre = explode(" ", $sValue);
        $iArray = 0;
        $iChar = 0;
        $iLength = strlen($sValue);
        //$aPart = array();
        $aPart = array_fill(0, substr_count($sValue, ' ') + 1, '');
        $sEspace = " ";
        $sDoubleQuote = '"';
        while ($iChar < $iLength) {
            if ($sValue[$iChar] == $sEspace) {
                $iArray++;
                $iChar++;
            } else {  // caractère différent d'un espace
                if ($sValue[$iChar] == $sDoubleQuote) {  // le caractère est un premier double quote
                    $aPart[$iArray].=$sValue[$iChar];
					$iChar++;
                    while ($sValue[$iChar] != $sDoubleQuote) {  // on boucle jusqu'à trouver la deuxième double quote
                        $aPart[$iArray].=$sValue[$iChar];
                        $iChar++;
                    }
                    if ($aTypeParametre[1]=="OPTIONAL"){
						if ($aTypeParametre[2]=="IGNORE"){
							if ($aTypeParametre[3]=="STRING_OR_CHOICE"){$iChar++;}
						}//else{if ($aTypeParametre[2]=="STRING_OR_CHOICE"){$iChar++;}}
					}else if($aTypeParametre[1]=="IGNORE"){if ($aTypeParametre[2]=="STRING_OR_CHOICE"){$iChar++;}
                    }else{if ($aTypeParametre[1]=="STRING_OR_CHOICE"){$iChar++;}} 
                } // ni espace, ni double quote, ni après doublequote
                $aPart[$iArray].=$sValue[$iChar];
                $iChar++;
            }
        } //while
        return $aPart;
    }

    /*
     *  Fonction qui permet de prendre une ligne GUI
     *  Et de la découper de manière à stocker la valeur par défaut
     */

    function getDefaultValue($sDefault_Macro, $sEncoding) {
        $oFichier = fopen($this->sFmwFileName, "r");
        $sRc = chr(10); // Compatible avec FME 2014 et inférieur
        $sRecherche = "^DEFAULT_MACRO " . $sDefault_Macro . "(.*)" . $sRc;
        if ($oFichier != false) {
            while (!feof($oFichier)) {
                $sLigne = fgets($oFichier);
                if (strtolower($sEncoding) != 'utf-8')
                    $sLigne = utf8_encode($sLigne);
                // Traitement de tous les GUI			  
                if (mb_eregi($sRecherche, $sLigne, $aOccurence)) {
                    $aDefaultValue = explode(" ", $sLigne);
                    if ($aDefaultValue[1] == $sDefault_Macro) {
                        unset($aDefaultValue[0]); //Suppression du premier élément du tableau (égal à : DEFAULT_MACRO)
                        unset($aDefaultValue[1]); //Suppression du second élément du tableau (égal au nom du paramètre : ex : pgDatabase)
                        $sDefaultValue = implode(" ", $aDefaultValue);
                        //Impossible d'utiliser la fonction Implode pour ce cas là. L'impode effectué est trop complexe. On va donc regarder caractère par caractère (voir ci-desous)
                        $i = 0;
                        $j = 0;
                        $sDefaultValueFinal = "";
                        //On parcourt caractère par caractère la chaine "valeur par défaut".
                        $sEspace = " ";
                        $sDoubleQuote = '"';
						//$sDoubleQuote = '&quot;';
                        while ($i < strlen($sDefaultValue)) {
                            // Ce if rassemble les cas des listes à possibilité de plusieurs valeurs par défaut.
                            if ($this->sType == "LISTBOX" || $this->sType == "LOOKUP_LISTBOX" || $this->sType == "CLASSICLISTBOX") {
                                if ($sDefaultValue[$i] == $sEspace) { // Si le caractère est un espace
                                    //$sDefaultValueFinal.="\" \"";
                                    // Pas de quotes.
                                    $sDefaultValueFinal.=' ';
                                    $j++;
                                    $i++;
                                } else {  // caractère différent d'un espace
                                    if ($sDefaultValue[$i] == $sDoubleQuote) {  // le caractère est un premier double quote
                                        $i++;
                                        while ($sDefaultValue[$i] != $sDoubleQuote) {  // on boucle jusqu'à trouver la deuxième double quote
                                            $sDefaultValueFinal.=$sDefaultValue[$i];
                                            $i++;
                                        }
                                        $i++;
                                    } else {
                                        // ni espace, ni double quote, ni après doublequote
                                        $sDefaultValueFinal.=$sDefaultValue[$i];
                                        $i++;
                                    }
                                }
                            } else {
                                $sDefaultValueFinal.= $sDefaultValue[$i];
                                $i++;
                            }
                        }
                    }
                }
            }
            fclose($oFichier);
        }
        //return $sDefaultValue;
		$sDefaultValueFinal = rtrim($sDefaultValueFinal, "\n");

        return $sDefaultValueFinal;
    }
	
	function unichr($u) {
		return mb_convert_encoding('&#' . intval($u) . ';', 'UTF-8', 'HTML-ENTITIES');
	}
	
	function replacer($sStr){
		//table de correcpondance des symboles UTF-8 avec les codes FME/GTF
		// ATTENTION : laisser < > en premier sinon replace remplace les balises par d'autre balise
		$aReplaceGTF = array("\r\n", " ", "<GTF_EQUAL>", "<openparen>", "<closeparen>", "$",  "&","@", "°", "'", "<comma>", "<quote>", "{", "}","[", "]", "<GTF_PIPE>", ";", "/", "<backslash>", "é", "à");
		$aReplaceFME = array("<lf>", "<space>", "=", "(", ")", "<dollar>", "<amp>", "<at>", "<u00b0>", "<apos>", ",", "\"", "<opencurly>", "<closecurly>", "<openbracket>", "<closebracket>", "|", "<semicolon>", "<solidus>", "\\", "<u00e9>", "<u00e0>");
		$aReplaceFMWToGTF = array("<lt>" => "<", "<gt>" => ">");
		$sReplaced = $sStr;
		
		//on gere les chevrons simultanèment pour ne pas gener l'encodage après
		if(strpos($sReplaced, "<lt>") !== false && strpos($sReplaced, "<gt>") !== false){
			$sReplaced = strtr($sReplaced, $aReplaceFMWToGTF);
		}
		//on remplace tous les encodage par leurs symboles
		for ($i = 0; $i < count($aReplaceGTF); $i++) {
			if(strpos($sReplaced, $aReplaceFME[$i]) !== false){
				$sReplaced = str_replace($aReplaceFME[$i], $aReplaceGTF[$i] ,$sReplaced);
			}
		}
		
		// on decode les balises UTF-8 		
		$matches = array();
		
		preg_match_all("/<u[0-9a-fA-F]{4}>/", $sStr, $matches);
		
		for($i = 0; $i < count($matches[0]); $i++){
			$iCode = hexdec(substr($matches[0][$i],2,4));
			$cChr = $this->unichr($iCode);
			$sReplaced = str_replace($matches[0][$i], $cChr ,$sReplaced);
		}
		
		return $sReplaced;
	}
        
        /**
         * decodeFmeGtfTags function
         * @param string $sStr String to decode
         */
	function decodeFmeGtfTags($sStr){
		$aReplaceGTF = array("\r\n", " ", "=", "(", ")", "$",  "&","@", "°", "'", ",", "\\\"", "{", "}","[", "]", "|", ";", "/", "\\", "é", "à");
		$aReplaceFME = array("<lf>", "<space>", "<GTF_EQUAL>", "<openparen>", "<closeparen>", "<dollar>", "<amp>", "<at>", "<u00b0>", "<apos>", "<comma>", "<quote>", "<opencurly>", "<closecurly>", "<openbracket>", "<closebracket>", "<GTF_PIPE>", "<semicolon>", "<solidus>", "<backslash>", "<u00e9>", "<u00e0>");
		$aReplaceFMWToGTF = array("<lt>" => "<", "<gt>" => ">");
		$sReplaced = $sStr;
		for ($i = 0; $i < count($aReplaceGTF); $i++) {
			if(strpos($sReplaced, $aReplaceFME[$i]) !== false){
				$sReplaced = str_replace($aReplaceFME[$i], $aReplaceGTF[$i] ,$sReplaced);
			}
		}
		return $sReplaced;
	}

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
// Fin
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------



    function UniqFileName() {
        $sUniqFileName = date(YmdHis) . rand(1, 100000);
        return $sUniqFileName;
    }

    function getUniqId() {
        $sUniqId = $this->UniqFileName();
        return $sUniqId;
    }

}

?>