<?php
/**
* \class order
* \file Order.class.inc
*/

require_once ("gtf_lib/Gtf.class.inc");
require_once("vmlib/error.inc");

class orderLib extends GtfLib{
    var $sPkField = "order_id";
    var $sTable = "v_user_order";
	
	/**
	* Class constructor
	* \param $oBd Connection object.
	* \param $iOrderId Order id.
	* \param $aProperties Array of properties.
	* \param $sTable Name of the table.
	*/
    function __construct($oBd, $iOrderId, $aProperties = array(), $sTable = "v_user_order"){
        include 'gtf_lib/' . $this->sRessourcesFile;

        $this->iPkValue = $iOrderId;
        $this->oBd=$oBd;
        $this->sTable = $sTable;
		$this->aProperties = $aProperties;

        if ($iOrderId!=-1){
            $sSql = $aSql['orderClass'];
            $sSql = str_replace('[sIdOrder]', $iOrderId, $sSql);
            $sSql = str_replace('[sSchemaGtf]', $aProperties['schema_gtf'], $sSql);
			$sSql = str_replace('[sTable]', $sTable, $sSql);
			$oPDOresult= $this->oBd->execute($sSql);
            if ($oBd->enErreur()) {
				$this->bEnErreur=1;
				$this->aFields['order_id']=$iOrderId;
				$this->sMessage = $this->oBd->getBDMessage();
            }else{
                $this->aFields =  $this->oBd->ligneSuivante ($oPDOresult);			
			// result_file (chemin du fichier de résultat), log_file (chemin du fichier de log)
                                if (!empty($this->aFields['result_url']))
                                    $this->aFields['result_file'] = $aProperties['dir_export'] . '/gtf/' . $this->aFields['result_url'];
                                else
                                    $this->aFields['result_file'] = '';
				$this->aFields['log_file'] = $aProperties['dir_export'] . '/gtf/' . $this->aFields['log_url'];
			//
				if ($oBd->enErreur()) {
                   $this->bEnErreur=1;
                   $this->sMessage = $this->oBd->getBDMessage();
                } else {
					if(!isset($this->aFields['order_id'])){ // aFields['order_id'] n'existe pas.
						$this->aFields['order_id']=$iOrderId;
						$this->bEnErreur= -1;
						$this->iErrorCode=3;
						$this->sMessage	="The order_id #".$iOrderId." doesn't exist";						
					}else{
						$this->bEnErreur= 0;
					}
				}
            }
        }
	}

	/*
	* function getIdEngine
	* \brief function that assigns each request processing an engine number. This engine number will be defined by the algorithm associated to the treatment.
	* \param $iOrderId Identifier of the request
	* \param $sTable Name of the table.
	* \param $iWorkspaceId Identifier of the treatment.
	*/
    function getIdEngine($iOrderId, $sTable, $iWorkspaceId){
        require 'gtf_lib/' . $this->sRessourcesFile;
		$this->iPkValue=$iOrderId;
		$this->sTable=$sTable;

		// Récupération de l'algorithme
		$sSql = $aSql['getEnginesId'];
		$sSql = str_replace("[sSchemaGtf]", $this->aProperties['schema_gtf'], $sSql);
		$sSql = str_replace("[iWorkspaceId]", $iWorkspaceId, $sSql);
		$resultat = $this->oBd->execute ($sSql);
		$this->oBd->cleanMessage();
		$aEnginesId = array();
		while($oEnginesId = $this->oBd->objetSuivant ($resultat))
			$aEnginesId[] = $oEnginesId->gtf_engine_id;
		$this->oBd->fermeResultat();
		
		if(count($aEnginesId)==0){
			// Le tag correspondant n'a pas été trouvé, nous allons cherché la liste des moteur ayant comme tag |default|
			$sSql = $aSql['getEnginesDefaultTag'];
			$sSql = str_replace("[sSchemaGtf]", $this->aProperties['schema_gtf'], $sSql);
			$resultat = $this->oBd->execute ($sSql);
			$this->oBd->cleanMessage();
			$aEnginesId = array();
			while($oEnginesId = $this->oBd->objetSuivant ($resultat))
				$aEnginesId[] = $oEnginesId->gtf_engine_id;
			$this->oBd->fermeResultat();
			if(count($aEnginesId)>0)
				writeToErrorLog(str_replace('[iOrderId]', $iOrderId, ERROR_0006));
		}
		// Si la requête est en erreur ou Si aucun moteur n'a été trouvé.
		if ($this->oBd->erreurRencontree || count($aEnginesId)==0){
			$aGtfEngineList = explode(",", $this->aProperties["engines_list"]);
			// Aucun tag ne correspond
			$iEngine = $aGtfEngineList[0];
			if ($iEngine != "")
				writeToErrorLog(str_replace('[aGtfEngineList[0]]', $iEngine, str_replace('[iOrderId]', $iOrderId, ERROR_0007)));
		}else{
			$iEngine = $this->returnEngineId($iOrderId, $aEnginesId);
		}

		if ($iEngine == ""){
			writeToErrorLog(str_replace('[iOrderId]', $iOrderId, ERROR_0008));
			$this->aFields['gtf_engine_id'] = 1;
		}else{
			$this->aFields['gtf_engine_id'] = $iEngine;	
		}
    }

	/*
	* function returnEngineId
	* \param $oAlgoIndex Object of the algorithm.
	* \param $aGtfEngineList Array that corresponds to the list of available engines numbers.
	* \return Returns the engine number.
	*/
	function returnEngineId($iOrderId, $aEnginesId){
		$iEngine = "";
		if(count($aEnginesId) > 0){
			$sRowCount = $iOrderId % count($aEnginesId);
			$iEngine = $aEnginesId[$sRowCount];
		}
		return $iEngine;
	}

	/*
	* function getUser
	* \return Returns an object from the class "User"
	*/
	function getUser() {
		require_once ("User.class.inc");
		$oUser = new User($this->oBd, $this->aFields['user_id'], $this->aProperties);
		return $oUser;
	}

	/*
	* function getWorkspace
	* \return Returns an object from the class "workspace"
	*/
	function getWorkspace() {
		require_once ("Workspace.class.inc");
		$oWorkspace = new workspace($this->oBd, $this->aFields['workspace_id'], $this->aProperties);
		return $oWorkspace;
	}

	/*
	* function getGtfEngine
	* \return Returns an object from the class "GtfEngine"
	*/
	function getGtfEngine() {
		require_once ("GtfEngine.class.inc");
		$oGtfEngine = new gtfEngine($this->oBd, $this->aFields['gtf_engine_id'], $this->aProperties);
		return $oGtfEngine;
	}

	/*
	* function getFmeEngine
	* \return Returns an object from the class "FmeEngine"
	*/
	function getFmeEngine() {
		require_once ("FmeEngine.class.inc");
		$oFmeEngine = new fmeEngine($this->oBd, $this->getGtfEngine()->aFields['fme_engine_id'], $this->aProperties);
		return $oFmeEngine;
	}

	/*
	* function formatOrderEmail
	* \brief Formats the data for an email
	*/
	function formatOrderEmail() {
	// Calcule la date et heure de fin
		list($iHours, $iMinutes, $iSeconds) = explode(':', $this->aFields['length_sec']);
		$oLengthSec = new DateInterval('PT' . intval($iHours) . 'H' . intval($iMinutes) . 'M' . intval($iSeconds) . 'S');
		$this->aFields['length_sec'] = $oLengthSec->format('%s');
		if (!empty($this->aFields['execution_date']) && !empty($this->aFields['length_sec']))
			$this->aFields['process_date'] = date_add(date_create($this->aFields['execution_date']), new DateInterval('PT' . intval($this->aFields['length_sec']) . 'S'));
	// Format des dates
		if ($this->aProperties['language'] == 'fr')
			$sDateFormat = 'd/m/Y H:i:s';
		else
			$sDateFormat = 'Y-m-d H:i:s';
		$this->aFields['order_date'] = date_format(date_create($this->aFields['order_date']), $sDateFormat);
		$this->aFields['execution_date'] = date_format(date_create($this->aFields['execution_date']), $sDateFormat);
		if (!empty($this->aFields['process_date']))
			$this->aFields['process_date'] = date_format($this->aFields['process_date'], $sDateFormat);
	// Url du résultat et du log
		if (!empty($this->aFields['result_url'])) {
			$this->aFields['result_url'] = $this->aProperties['web_server_name'] . '/' . $this->aProperties['public_alias'] . '/gtf/' . $this->aFields['result_url'];
			$this->aFields['log_url'] = $this->aProperties['web_server_name'] . '/' . $this->aProperties['public_alias'] . '/gtf/' . $this->aFields['log_url'];
		}
	}
}
?>