<?php
/**
* \class User
* \file User.class.inc
*/

require_once ("gtf_lib/Gtf.class.inc");

class User extends GtfLib {
	var $aFields = array();

	/**
	* Class constructor
	* \param $oBd Connection object.
	* \param $iUserdId User id.
	* \param $aProperties Array of properties.
	*/	
	function __construct($oBd, $iUserdId, $aProperties) {
		require 'User.class.sql.inc';
		$sSql = str_replace('[sSchemaFramework]', $aProperties['schema_framework'], $aSql['pgsql']['getUserParameters']);
		$sSql = str_replace('[user_id]', $iUserdId, $sSql);
		$oResult = $oBd->execute($sSql);
		if (!$oBd->enErreur() && $oBd->nombreLigne($oResult) > 0) {
			$aUserParam = $oBd->ligneSuivante($oResult);
			foreach($aUserParam as $sParamKey => $sParamValue)
				$this->aFields[$sParamKey] = $sParamValue;
		}
	}
}
?>