<?php
/**
* \class workspace
* \file Workspace.class.inc
*/

require_once ("gtf_lib/Gtf.class.inc");

class workspace extends GtfLib  {
	var $sPkField = "workspace_id";
	var $sTable = "v_user_workspace";

	/**
	* Class constructor
	* \param $oBd Connection object.
	* \param $iWorkspaceId Workspace id.
	* \param $aProperties Array of properties.
	*/
	function __construct($oBd, $iWorkspaceId, $aProperties = array()){
		include 'gtf_lib/' . $this->sRessourcesFile;
		$this->aProperties = $aProperties;

		$this->iPkValue = $iWorkspaceId;
		$this->oBd=$oBd;
		//if ($iWorkspaceId != -1){
			$sSql = $aSql['workspace'];
			$sSql = str_replace('[iWorkspaceId]', $iWorkspaceId, $sSql);
			$sSql = str_replace('[sSchemaGtf]', $aProperties['schema_gtf'], $sSql);
			$oPDOresult= $this->oBd->execute($sSql);
			if ($oBd->enErreur()) {
				$this->bEnErreur = 1; //En erreur c'est pas -1 plutôt ??
				$this->aFields['workspace_id']=$iWorkspaceId;
				$this->sMessage = $this->oBd->getBDMessage();
			}else{
				$this->aFields =  $this->oBd->ligneSuivante ($oPDOresult);
				if ($oBd->enErreur()){
					$this->bEnErreur = 1; //En erreur c'est pas -1 plutôt ??
					$this->sMessage = $this->oBd->getBDMessage();
				}else{
					if(!isset($this->aFields['workspace_id'])){ // aFields['workspace_id'] n'existe pas.
						$this->aFields['workspace_id'] = $iWorkspaceId;
						$this->bEnErreur = -1;
						$this->iErrorCode = 11;
						$this->sMessage = "The workspace_id #".$iWorkspaceId." doesn't exist";
					}else{
						$this->bEnErreur = 0;
						//$this->iErrorCode=0;
					}
				}
			}
		//}
	}

	/**
	* function getCategory
	* \brief Return a object of the "Category" Class
	* \return an object
	*/
	function getCategory() {
		if (!empty($this->aFields['category_id'])) {
			require_once ("Category.class.inc");
			$oCategory = new Category($this->oBd, $this->aFields['category_id']);
			return $oCategory;
		}
	}
}

?>