<?php

/**
 * \file imap_veremes.php
 * \brief class Imap pour se connecter à un serveur imap et lire les mails.
 *
 * \author Anthony Borghi <anthony.borghi@veremes.com>
 */

require_once("ImapConnection.php");
require_once("MailStruct.php");

class MailBox {

    /**
     * imap connection
     */
    public $oConnection = false;
    
    /**
     * Liste de mail pour une boite définie
     */
    protected $aMails = array();
    

	/**
     * initialize imap connection
     *
     * @return void
     * @param $mailbox imap_open string
     * @param $port
     * @param $username
     * @param $password
     * @param $encryption ssl or tls
     */
	public function __construct($mailbox, $port, $username, $password, $encryption = false) {
        $this->oConnection = new ImapConnection($mailbox, $port, $username, $password, $encryption);
    }

    function __destruct() {
        $this->oConnection->close();
    }

     /**
     * create if not exist and select given folder 
     *
     * @return bool successfull creation folder
     * @param $sFolderName name of the folder to create and select
     */
    public function createFolderAndSelect ($sFolderName){
        $bStatusCreation = $this->oConnection->addFolderIfNotExists($sFolderName);
        
        $this->oConnection->selectFolder($sFolderName);
        
        return $bStatusCreation;
    }

    /**
     * fill the array with mail in selected folder
     *
     * @return array of mail structure
     */
    public function fillMailList (){
        $this->aMails = array();
        $aUid = $this->oConnection->getMessagesUidList();
        foreach ($aUid as $iUid) {
            $oMailStruct = new MailStruct($this->oConnection, $iUid);
            array_push($this->aMails, $oMailStruct);
        }
        return $this->aMails;
    }

    public function getMailWithUid ($iUid){
        $this->aMails = array();
        $oMailStruct = new MailStruct($this->oConnection, $iUid);
        array_push($this->aMails, $oMailStruct);
        return $this->aMails;
    }

    public function getMailWithsearchObject ($aFilter){
        $this->aMails = array();
        $aUid = $this->oConnection->searchInFolder($aFilter);
        if(is_array($aUid)){
            foreach ($aUid as $iUid) {
                $oMailStruct = new MailStruct($this->oConnection, $iUid);
                array_push($this->aMails, $oMailStruct);
            }
        }
        return $this->aMails;
    }

    /**
     * get th email list
     *
     * @return array of mail structure
     */
    public function getMailList (){
        return $this->$aMails;
    }

}


?>