<?php
/*
* \file vmlib/phpUtil.inc
* \brief Fonctions php diverses
*
* \author Fabien Marty <fabien.marty@veremes.com> 
*/
/*
* Variable globale stockant le nom de dossier lib.
*/
require_once("vmlib/error.inc");
$sFolderLib="gtf_lib";
/**
* Teste un code pour savoir si il correspond à une fréquence.
* Ce code est d'un jour (de 1 à 31), d'un mois (de 1 à 12) et d'un type de jour de la semaine (de 1 à 7).
* Ces éléments doivent être définis ainsi : * défini tout le temps et / défini une répétition.
* \param $sCode Code de la fréquence.
* return Retourne rien si le code est bon sinon retourne un message d'erreur.
*/
function TestPeriodCode($sCode) {
	global $properties, $sFolderLib;
	loadLang($sFolderLib, $properties["language"], $sFolderLib."/");
	$bIsCorrecte = true;
	$sErrorMessage ="";
	$aCode = explode(" ", $sCode);
	
 // $sErrorMessage = print_r($aCode,true);
 // $sErrorMessage .= count($aCode);

	if (count($aCode) == 5 && $aCode[4]!="") {
		$aCode = Array('minute'=>$aCode[0], 'heure'=>$aCode[1], 'jour'=>$aCode[2], 'mois'=>$aCode[3], 'jour_semaine'=>$aCode[4]);
		$aPatterns = array( 
            '((?P<minute>(?:\*|(?:(?:[0-9]|[1-5][0-9])(?:-(?:[0-9]|[1-5][0-9]))?)(?:,(?:[0-9]|[1-5][0-9])(?:-(?:[0-9]|[1-5][0-9]))?)*)(?:/(?:[1-9]|[1-5][0-9]))?)$)AD',
            '((?P<hour>(?:\*|(?:(?:[0-9]|1[0-9]|2[0-3])(?:-(?:[0-9]|1[0-9]|2[0-3]))?)(?:,(?:[0-9]|1[0-9]|2[0-3])(?:-(?:[0-9]|1[0-9]|2[0-3]))?)*)(?:/(?:[1-9]|1[0-9]|2[0-3]))?)$)AD',
            '((?P<dayOfMonth>(?:\*|(?:(?:[1-9]|[1-2][0-9]|3[0-1])(?:-(?:[1-9]|[1-2][0-9]|3[0-1]))?)(?:,(?:[1-9]|[1-2][0-9]|3[0-1])(?:-(?:[1-9]|[1-2][0-9]|3[0-1]))?)*)(?:/(?:[1-9]|[1-2][0-9]|3[0-1]))?)$)AD',
            '((?P<month>(?:\*|jan|feb|mar|abr|may|jun|jul|aug|sep|oct|nov|dec|(?:(?:[1-9]|1[0-2])(?:-(?:[1-9]|1[1-2]))?)(?:,(?:[1-9]|1[1-2])(?:-(?:[1-9]|1[1-2]))?)*)(?:/(?:[1-9]|1[1-2]))?)$)AD',
            '((?P<dayOfWeek>(?:\*|sun|mon|tue|wed|thu|fri|sat|(?:(?:[0-7])(?:-(?:[0-7]))?)(?:,(?:[0-7])(?:-(?:[0-7]))?)*)(?:/(?:[1-7]))?)$)AD');
		foreach( $aCode as $key => $column ) 
		{
			if ( preg_match( $aPatterns[$key], $column ) !== 1 ) 
			{
				$sError .= "Code cron non Valide (Valeur de l'argument ".$aPatterns[$key].")";
			}
		}
		// Je ne sais pas si ça sert de développer un truc comme ça alors qu'il faudrait mieux développer une interface qui permettrait de directement entrer le code

	} else {
		$sErrorMessage =ERROR_CODE_CONTAIN_SPACE;
		$bIsCorrecte = false;
	}
	
	$sReturn = $sErrorMessage;
	
	return $sReturn;
}


/**
* Cette fonction permet d'uploader un fichier sur le server.
* \param $sNomObjet Nom de l'objet parcourir.
* \param $sFileType Type de fichier attendu.
* \param $sServerPath Chemin où le fichier doit être copié.
* \param $sMaxSize Taille maximal du fichier.
* return Retourne un tableau.
*/
function uploadFileGtf($sNomObjet, $sFileType, $sServerPath, $sMaxSize) {
	global $properties, $sFolderLib;
	loadLang($sFolderLib, $properties["language"], $sFolderLib."/");
	$sTmpFile=$_FILES[$sNomObjet]['tmp_name'];
	// Si l'utilisateur n'a indiqué aucun fichier à uploader, il ne se passe rien
	$sErrorMsg="";
	if ($sTmpFile==''){
		if($_FILES[$sNomObjet]['name']!=""){
			switch($_FILES[$sNomObjet]['error']){
				case "1" :
					$sErrorMsg=ERROR_DOWNLOAD_FILE.$_FILES[$sNomObjet]['name']." : ".ERROR_UPLOAD_MAX_FILE_SIZE."<br>";
				break;
				case "2" :
					$sErrorMsg=ERROR_DOWNLOAD_FILE.$_FILES[$sNomObjet]['name']." : ".ERROR_MAX_FILE_SIZE."<br>";
				break;
				case "3" :
					$sErrorMsg=ERROR_DOWNLOAD_FILE.$_FILES[$sNomObjet]['name']." : ".ERROR_PARTIAL_DOWNLOAD."<br>";
				break;
				case "4" :
					$sErrorMsg=ERROR_NO_FILE_DOWNLOADED."<br>";
				break;
				case "6" :
					$sErrorMsg=ERROR_DOWNLOAD_FILE.$_FILES[$sNomObjet]['name']." : ".ERROR_MISSING_TEMP_FOLDER."<br>";
				break;
				case "7" :
					$sErrorMsg=ERROR_DOWNLOAD_FILE.$_FILES[$sNomObjet]['name']." : ".ERROR_WRITING_DISK."<br>";
				break;
				case "8" :
					$sErrorMsg=ERROR_DOWNLOAD_FILE.$_FILES[$sNomObjet]['name']." : ".ERROR_PHP_EXT_SEND."<br>";
				break;
			}
			writeToErrorLog($sErrorMsg);
		}
		return $sErrorMsg;
	}
	
	if (is_uploaded_file($sTmpFile)) {
		//Teste si le fichier correspont au format voulu.
		$bAllowUpload=false;

		//Teste si le fichier n'est pas de trop grande taille.
		if ($_FILES[$sNomObjet]['size']>$sMaxSize || $_FILES[$sNomObjet]['error']==1){
			$bAllowUpload=false;
			if ($_FILES[$sNomObjet]['size']>$sMaxSize) $sErrorMsg .='Le fichier '.$_FILES[$sNomObjet]['name'].' de '.$_FILES[$sNomObjet]['size'].' octets dépasse la taille maximale autorisée ('.$sMaxSize.' octets).<br>';
			if ($_FILES[$sNomObjet]['error']>$sMaxSize) $sErrorMsg .='Le fichier '.$_FILES[$sNomObjet]['name'].' dépasse la taille maximale autorisée par la configuration PHP ('.$sMaxSize.' octets).<br>';
		}
		if ($sErrorMsg==""){
			$bAllowUpload=true;
		}else{
			$bAllowUpload=false;
		}

		//Lance l'upload.
		if ($bAllowUpload){
			if (!move_uploaded_file($sTmpFile, $sServerPath)){
				writeToErrorLog(ERROR_COPYING_FILE.$_FILES[$sNomObjet]['name'].ON_SERVER_PHPUTIL.', '.$sTmpFile.', '.$sServerPath);
				$sErrorMsg =ERROR_COPYING_FILE.$_FILES[$sNomObjet]['name'].ON_SERVER_PHPUTIL.'.<br>';
			}
		}
	} else {
		writeToErrorLog(str_replace('[_FILES[sNomObjet][name]]', $_FILES[$sNomObjet]['name'], ERROR_0011));
		$sErrorMsg ='Le fichier '.$_FILES[$sNomObjet]['name'].' n\'est pas téléchargé sur le serveur (Code erreur : '.$_FILES[$sNomObjet]['error'].').<br>';
	}
	// if ($sErrorMsg!=""){
		// $sErrorMsg.="La demande a été supprimée car celle-ci ne pourra pas être traitée.";
	// }
	
	return $sErrorMsg;
}

/**
* Cette fonction permet de supprimer un fichier sur le serveur.
* \param $sFichier Fichier à supprimer.
* return un booleen.
*/
function clearFile($sFichier) {
	unlink($sFichier);
}

/**
* Cette fonction permet de supprimer un fichier sur le serveur de manière récursive.
* \param $sFichier Fichier à supprimer.
* return un tableau avec la liste des fichiers supprimés et la liste des fichiers qui n'ont pas pu être supprimés.
*/
function clearRecursiveFile($sFolder){
	$oDirectory = @opendir($sFolder);
	$bDirectoryIntoDirectory=false;
	while($sFileNameLog=@readdir($oDirectory) ){
		$aExtensionFile = explode(".", $sFileNameLog);
		if(!in_array($sFileNameLog, array("..", ".")) ){
			if( is_dir($sFolder."/".$sFileNameLog) ){	
				$aFilesDeleteOrNotDelete=clearRecursiveFile($sFolder."/".$sFileNameLog);
				$sFileDeteleOK.=$aFilesDeleteOrNotDelete["sFileDeteleOK"];
				$sFileDeteleEchec.=$aFilesDeleteOrNotDelete["sFileDeteleEchec"];
													
				$bDirectoryIntoDirectory=true;
		
			}else{ // Si c'est un fichier
				if ($aExtensionFile[1]=="log"){
					$iNbrDaysBetween2Date = nbrDaysBetween2Date(date ("F d Y H:i:s.", filemtime($sFolder."/".$sFileNameLog)));
					if ($iNbrDaysBetween2Date > $_REQUEST["iDaysDeleteFiles"]){ // Suppression du fichier				
						clearFile($sFolder."/".$sFileNameLog);
						$sFile = $sFolder."/".$sFileNameLog;
						if (file_exists($sFile)){
							$sFileDeteleEchec.="<img class=\"img\" src=\"./images/false.png\"/>&nbsp;".htmlentities("Echec de la suppression du fichier \"".$sFile."\".", ENT_COMPAT | ENT_HTML401, "UTF-8")."<br>";
						}else{
							if (filesize($sFile)!=""){
								$sFileDeteleEchec.="<img class=\"img\" src=\"./images/false.png\"/>&nbsp;".htmlentities("Echec de la suppression du fichier \"".$sFile."\" (vous n'avez pas les droits pour supprimer ce fichier).", ENT_COMPAT | ENT_HTML401, "UTF-8")."<br>";
							}else{
								$sFileDeteleOK.="<img class=\"img\" src=\"./images/true.png\"/>&nbsp;".htmlentities("Fichier \"".$sFile."\" correctement supprimé.", ENT_COMPAT | ENT_HTML401, "UTF-8")."<br>";
							}
						}
					}
				}
			}
		}
	}
	@closedir($oDirectory);
	// Suppression du dossier si ce derneir est vide
	if (countFilesAndDir($sFolder)==0){
		rmdir($sFolder);
	}
	
	$aFileDeteleOkAndFileDeteleEchec = array("sFileDeteleOK" => $sFileDeteleOK,"sFileDeteleEchec" => $sFileDeteleEchec);
	return $aFileDeteleOkAndFileDeteleEchec;
}



/**
* Cette fonction permet de retourner le nombre d'éléments (fichier et dossier) qui se trouvent dans un dossier 
* \param $sDate Date à comparer 
* return un entier.
*/

function countFilesAndDir($sDirectory){
	$iNbr = 0;
	$dir_handle = opendir($sDirectory);
		while($entry = readdir($dir_handle)){	
			if($entry != ".." and $entry !="."){
				$iNbr++;
			}
		}
	closedir($dir_handle);
	return $iNbr;
} 




function userToFolder($sUser){
	return $sUser;
}


/**
* Cette fonction permet de retourner le nom de jour qui séparer deux dates : la date passée en paramètre et la date du jour
* \param $sDate Date à comparer 
* return un entier.
*/

function nbrDaysBetween2Date($sDate){
	$s = strtotime("now")-strtotime($sDate);
	$inbrDaysBetween2Date = intval($s/86400)+1;   
	return $inbrDaysBetween2Date; 
} 

/**********************************
 Retourne un tableau contenant des informations
 sur la licence du logiciel fme passé en paramètre
 $fmepath : Chemin vers le logiciel fme.exe
 Tableau de retour:
 - exists (booléen) -> Est ce que le fichier existe ?
 - valid (booléen) -> Est ce que la licence FME est valide ?
 - version (string) -> Version de FME
 - type (string) ->
 - validity (string) -> Validité de la licence (Permanent / Temporary License: xxx days left)
 - host (string)
***********************************/
function getFmeLicence($fmepath)
{
// Tableau de retour contenant les infos de la licence
	$aFmeLicence = array('exists' => false, 'valid' => false, 'version' => '', 'type' => '', 'validity' => '', 'host' => '');
	
// Si le fichier existe et la fonction exec ne renvoie pas d'erreur : remplissage du tableau
	if (file_exists($fmepath))
	{
	// Le fichier existe
		$aFmeLicence['exists'] = true;

	// Exécute fme.exe
		$aOutput = array();
		$iReturnStatus = 1;
		exec($fmepath, $aOutput, $iReturnStatus);
		
	// Le fichier fme.exe s'est exécuté normalement ?
		if ($iReturnStatus === 0)
		{
		// Est ce que la licence a expiré ?
			if (stripos(implode($aOutput), 'licence has expired') !== false)
				$aFmeLicence['valid'] = false;
			else
			{
			// La licence est valide	
				$aFmeLicence['valid'] = true;
		
			// Version du logiciel
				$aFmeLicence['version'] = trim($aOutput[0]);

			// Type de licence
				$aFmeLicence['type'] = trim($aOutput[1]);
		
			// Validité de la licence
				$aFmeLicence['validity'] = trim($aOutput[2]);
				
			// Host
				$aFmeLicence['host'] = trim(substr($aOutput[3], stripos($aOutput[3], ':') + 1));
			}
		}
	}
	
	return $aFmeLicence;
}

//Retourne un tableau de valeurs unique et insensible à la casse
// $aArray Tableau à filtrer
function array_iunique($aArray){
    return array_intersect_key($aArray, array_unique(array_map("StrToLower",$aArray)));
}

/**
 * Generate a GTF instance id.
 * @return GTF instance id
 */
function generateGtfInstanceId() {
    $aOutput = array();
    $iReturnStatus = 1;
    if (strtolower(substr(PHP_OS, 0, 3)) == 'win') {
        // Paramètres à concaténer pour un identifiant unique par machine.
        $aCommands = array(
            'NICCONFIG',    // cartes réseaux (adresses MAC)
            'CPU',  // modèle, vitesse, id...
            'DISKDRIVE',    // N° de série...
            'MEMORYCHIP',
            'CDROM',    // Lecteur DVD...
            'path win32_VideoController',   // Carte vidéo
            'IDECONTROLLER',
            'SCSICONTROLLER',
            'DESKTOPMONITOR',
            'LOGON',
            'NETLOGIN'
        );
        $sCommandLine = 'wmic '. implode(' & wmic ', $aCommands);
        exec($sCommandLine, $aOutput, $iReturnStatus);
    }
    else if (strtolower(substr(PHP_OS, 0, 5)) == 'linux') {
        $aLinuxCommand = array('lscpu', 'lspci', 'df', 'free', 'ip a', 'cat /var/lib/dbus/machine-id'); // , 'sudo cat /sys/class/dmi/id/product_uuid'
        foreach ($aLinuxCommand as $sCommand) {
            exec($sCommand, $aOutput, $iReturnStatus);
        }
        $aOutput['ses_Login'] = $_SESSION['ses_Login'];
    }
    return 'GTF_' . hash_hmac('sha256', implode(chr(20), $aOutput), uniqid('', true));
}
?>