ALTER TABLE s_gtf.fme_engine ADD COLUMN fme_engine_type_id character varying(50) NOT NULL DEFAULT 'desktop';
ALTER TABLE s_gtf.fme_engine ADD COLUMN server_url character varying(255);
ALTER TABLE s_gtf.fme_engine ADD COLUMN login character varying(50);
ALTER TABLE s_gtf.fme_engine ADD COLUMN password character varying(50);
ALTER TABLE s_gtf.fme_engine ADD COLUMN s3_access_key_id character varying(50);
ALTER TABLE s_gtf.fme_engine ADD COLUMN s3_secret_access_key character varying(50);
ALTER TABLE s_gtf.fme_engine ADD COLUMN fme_cloud_api_token character varying(100);
ALTER TABLE s_gtf.fme_engine ADD COLUMN s3_region character varying(50);
ALTER TABLE s_gtf.fme_engine ADD COLUMN iam_access_key_id character varying(50);
ALTER TABLE s_gtf.fme_engine ADD COLUMN iam_secret_access_key character varying(50);

-- Types de moteurs FME.
CREATE TABLE s_gtf.rt_fme_engine_type (fme_engine_type_id character varying(50) NOT NULL, label_id character varying(60));
ALTER TABLE s_gtf.rt_fme_engine_type OWNER TO u_vitis;
ALTER TABLE ONLY s_gtf.rt_fme_engine_type  ADD CONSTRAINT pk_fme_engine_type_id PRIMARY KEY (fme_engine_type_id);
GRANT ALL ON TABLE s_gtf.rt_fme_engine_type TO gtf_admin;
GRANT SELECT ON TABLE s_gtf.rt_fme_engine_type TO gtf_user;
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Libellé "desktop" de la table rt_fme_engine_type', 'gtf_323');
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Libellé "fme_server" de la table rt_fme_engine_type', 'gtf_324');
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Libellé "fme_cloud" de la table rt_fme_engine_type', 'gtf_325');
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Libellé "fme_cloud_for_gtf" de la table rt_fme_engine_type', 'gtf_326');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_323', 'fr', 'Desktop');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_323', 'en', 'Desktop');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_324', 'fr', 'FME Server');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_324', 'en', 'FME Server');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_325', 'fr', 'FME Cloud');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_325', 'en', 'FME Cloud');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_326', 'fr', 'FME cloud for GTF');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_326', 'en', 'FME cloud for GTF');
INSERT INTO s_gtf.rt_fme_engine_type (fme_engine_type_id, label_id) VALUES ('desktop', 'gtf_323');
INSERT INTO s_gtf.rt_fme_engine_type (fme_engine_type_id, label_id) VALUES ('fme_server', 'gtf_324');
INSERT INTO s_gtf.rt_fme_engine_type (fme_engine_type_id, label_id) VALUES ('fme_cloud', 'gtf_325');
INSERT INTO s_gtf.rt_fme_engine_type (fme_engine_type_id, label_id) VALUES ('fme_cloud_for_gtf', 'gtf_326');
--
CREATE VIEW s_gtf.v_fme_engine_type AS SELECT rt_fme_engine_type.fme_engine_type_id, vm_translation.translation AS fme_engine_type_label, vm_translation.lang FROM (s_gtf.rt_fme_engine_type JOIN s_vitis.vm_translation ON (((vm_translation.translation_id)::text = (rt_fme_engine_type.label_id)::text)));
ALTER TABLE s_gtf.v_fme_engine_type OWNER TO u_vitis;
GRANT ALL ON TABLE s_gtf.v_fme_engine_type TO gtf_admin;
GRANT SELECT ON TABLE s_gtf.v_fme_engine_type TO gtf_user;
GRANT SELECT ON TABLE s_gtf.v_fme_engine_type TO gtf_author;
--
DROP VIEW s_gtf.v_fme_engine;
CREATE OR REPLACE VIEW s_gtf.v_fme_engine AS SELECT fme_engine.fme_engine_id,fme_engine.name,fme_engine.server_id,fme_engine.local_path,server.hostname AS server_name,fme_engine.server_url,fme_engine.login,fme_engine.password,fme_engine.fme_engine_type_id,fme_engine.s3_access_key_id,fme_engine.s3_secret_access_key,fme_engine.fme_cloud_api_token,v_fme_engine_type.fme_engine_type_label,v_fme_engine_type.lang,fme_engine.s3_region,fme_engine.iam_access_key_id,fme_engine.iam_secret_access_key FROM s_gtf.fme_engine LEFT JOIN s_gtf.server ON fme_engine.server_id = server.server_id LEFT JOIN s_gtf.v_fme_engine_type ON fme_engine.fme_engine_type_id = v_fme_engine_type.fme_engine_type_id;
ALTER TABLE s_gtf.v_fme_engine OWNER TO u_vitis;
GRANT ALL ON TABLE s_gtf.v_fme_engine TO u_vitis;
GRANT ALL ON TABLE s_gtf.v_fme_engine TO gtf_admin;
GRANT SELECT ON TABLE s_gtf.v_fme_engine TO gtf_user;
GRANT SELECT ON TABLE s_gtf.v_fme_engine TO gtf_author;
CREATE OR REPLACE RULE delete_v_fme_engine AS ON DELETE TO s_gtf.v_fme_engine DO INSTEAD  DELETE FROM s_gtf.fme_engine WHERE fme_engine.fme_engine_id = old.fme_engine_id;
CREATE OR REPLACE RULE insert_v_fme_engine AS ON INSERT TO s_gtf.v_fme_engine DO INSTEAD  INSERT INTO s_gtf.fme_engine (fme_engine_id, name, server_id, local_path, server_url, login, password, fme_engine_type_id, s3_access_key_id, s3_secret_access_key, fme_cloud_api_token, s3_region, iam_access_key_id, iam_secret_access_key) VALUES (new.fme_engine_id, new.name, new.server_id, new.local_path, new.server_url, new.login, new.password, new.fme_engine_type_id, new.s3_access_key_id, new.s3_secret_access_key, new.fme_cloud_api_token, new.s3_region, new.iam_access_key_id, new.iam_secret_access_key);
CREATE OR REPLACE RULE update_v_fme_engine AS ON UPDATE TO s_gtf.v_fme_engine DO INSTEAD  UPDATE s_gtf.fme_engine SET fme_engine_id = new.fme_engine_id, name = new.name, server_id = new.server_id, local_path = new.local_path, server_url = new.server_url, login = new.login, password = new.password, fme_engine_type_id = new.fme_engine_type_id, s3_access_key_id = new.s3_access_key_id, s3_secret_access_key = new.s3_secret_access_key, fme_cloud_api_token = new.fme_cloud_api_token, s3_region = new.s3_region, iam_access_key_id = new.iam_access_key_id, iam_secret_access_key = new.iam_secret_access_key WHERE fme_engine.fme_engine_id = new.fme_engine_id;
ALTER TABLE s_gtf.fme_engine ADD CONSTRAINT fk_fme_engine_type_id FOREIGN KEY (fme_engine_type_id) REFERENCES s_gtf.rt_fme_engine_type (fme_engine_type_id) MATCH SIMPLE ON UPDATE NO ACTION ON DELETE NO ACTION;
-- Champs manquants dans la liste des moteurs FME.
UPDATE s_vitis.vm_table_field SET width = 150 WHERE label_id = 'gtf_212';
UPDATE s_vitis.vm_table_field SET index = 5, width = 300 WHERE label_id = 'gtf_213';
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Champ server_url de l''onglet "gtf_fme_engine"', 'gtf_319');
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Champ login de l''onglet "gtf_fme_engine"', 'gtf_320');
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Champ fme_engine_type_id de l''onglet "gtf_fme_engine"', 'gtf_321');
INSERT INTO s_vitis.vm_string (string, string_id) VALUES ('Champ s3_access_key_id de l''onglet "gtf_fme_engine"', 'gtf_322');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_319', 'fr', 'Url du serveur');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_319', 'en', 'Server url');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_320', 'fr', 'Utilisateur');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_320', 'en', 'Username');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_321', 'fr', 'Type');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_321', 'en', 'Type');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_322', 'fr', 'Clé d''accès S3');
INSERT INTO s_vitis.vm_translation (translation_id, lang, translation) VALUES ('gtf_322', 'en', 'S3 access key');
INSERT INTO s_vitis.vm_table_field (table_field_id, name, sortable, resizeable, index, width, align, label_id, module, ressource_id, template, tab_id) VALUES ((select nextval('s_vitis.seq_vm'::regclass)), 'server_url', true, true, 6, 250, 'left', 'gtf_319', NULL, 'gtf/fmeengines', NULL, (select tab_id from s_vitis.vm_tab where name = 'gtf_fme_engine'));
INSERT INTO s_vitis.vm_table_field (table_field_id, name, sortable, resizeable, index, width, align, label_id, module, ressource_id, template, tab_id) VALUES ((select nextval('s_vitis.seq_vm'::regclass)), 'login', true, true, 7, 150, 'left', 'gtf_320', NULL, 'gtf/fmeengines', NULL, (select tab_id from s_vitis.vm_tab where name = 'gtf_fme_engine'));
INSERT INTO s_vitis.vm_table_field (table_field_id, name, sortable, resizeable, index, width, align, label_id, module, ressource_id, template, tab_id) VALUES ((select nextval('s_vitis.seq_vm'::regclass)), 'fme_engine_type_label', true, true, 4, 100, 'left', 'gtf_321', NULL, 'gtf/fmeengines', NULL, (select tab_id from s_vitis.vm_tab where name = 'gtf_fme_engine'));
INSERT INTO s_vitis.vm_table_field (table_field_id, name, sortable, resizeable, index, width, align, label_id, module, ressource_id, template, tab_id) VALUES ((select nextval('s_vitis.seq_vm'::regclass)), 's3_access_key_id', true, true, 8, 150, 'left', 'gtf_322', NULL, 'gtf/fmeengines', NULL, (select tab_id from s_vitis.vm_tab where name = 'gtf_fme_engine'));
-- Libellé du champ "type" de moteur FME.
UPDATE s_vitis.vm_tab SET event = 'loadList(null, {"lang": ""})' WHERE name ='gtf_fme_engine';
-- 
UPDATE s_vitis.vm_table_field SET width = 200 WHERE label_id = 'gtf_128';

-- Anthony le 18/09/2018 14:43
ALTER TABLE s_gtf.fme_engine ADD COLUMN useexternaldbconnection boolean DEFAULT FALSE;
CREATE OR REPLACE VIEW s_gtf.v_fme_engine AS SELECT fme_engine.fme_engine_id, fme_engine.name, fme_engine.server_id, fme_engine.local_path, server.hostname AS server_name, fme_engine.server_url, fme_engine.login, fme_engine.password, fme_engine.fme_engine_type_id, fme_engine.s3_access_key_id, fme_engine.s3_secret_access_key, fme_engine.fme_cloud_api_token, v_fme_engine_type.fme_engine_type_label, v_fme_engine_type.lang, fme_engine.s3_region, fme_engine.iam_access_key_id, fme_engine.iam_secret_access_key, fme_engine.fme_server_instance_name, fme_engine.fme_server_s3_bucket, useexternaldbconnection FROM s_gtf.fme_engine LEFT JOIN s_gtf.server ON fme_engine.server_id = server.server_id LEFT JOIN s_gtf.v_fme_engine_type ON fme_engine.fme_engine_type_id::text = v_fme_engine_type.fme_engine_type_id::text;
CREATE OR REPLACE RULE insert_v_fme_engine AS ON INSERT TO s_gtf.v_fme_engine DO INSTEAD  INSERT INTO s_gtf.fme_engine (fme_engine_id, name, server_id, local_path, server_url, login, password, fme_engine_type_id, s3_access_key_id, s3_secret_access_key, fme_cloud_api_token, s3_region, iam_access_key_id, iam_secret_access_key, fme_server_instance_name, fme_server_s3_bucket, useexternaldbconnection) VALUES (new.fme_engine_id, new.name, new.server_id, new.local_path, new.server_url, new.login, new.password, new.fme_engine_type_id, new.s3_access_key_id, new.s3_secret_access_key, new.fme_cloud_api_token, new.s3_region, new.iam_access_key_id, new.iam_secret_access_key, new.fme_server_instance_name, new.fme_server_s3_bucket, new.useexternaldbconnection);
CREATE OR REPLACE RULE update_v_fme_engine AS ON UPDATE TO s_gtf.v_fme_engine DO INSTEAD  UPDATE s_gtf.fme_engine SET fme_engine_id = new.fme_engine_id, name = new.name, server_id = new.server_id, local_path = new.local_path, server_url = new.server_url, login = new.login, password = new.password, fme_engine_type_id = new.fme_engine_type_id, s3_access_key_id = new.s3_access_key_id, s3_secret_access_key = new.s3_secret_access_key, fme_cloud_api_token = new.fme_cloud_api_token, s3_region = new.s3_region, iam_access_key_id = new.iam_access_key_id, iam_secret_access_key = new.iam_secret_access_key, fme_server_instance_name = new.fme_server_instance_name, fme_server_s3_bucket = new.fme_server_s3_bucket, useexternaldbconnection = new.useexternaldbconnection WHERE fme_engine.fme_engine_id = new.fme_engine_id;
