<?php

/**
 * \file Workspaces.class.inc
 * \class Workspaces
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Workspaces php class
 *
 * This class defines Rest Api to Gtf workspaces
 * 
 */
require 'Workspaces.class.inc';
require 'AuthorWorkspace.class.inc';

class AuthorWorkspaces extends Workspaces {
    /**
     * @SWG\Definition(
     *   definition="/authorworkspaces",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/authorworkspaces")
     *   }
     * )
     * * @SWG\Tag(
     *   name="AuthorWorkspaces",
     *   description="Operations about Author Workspaces"
     * )
     */
    
    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
    }
    
    /**
     * get author workspaces
     * @return Author workspaces
     */
    function GET() {
        if (!empty($this->aPath[3])) {
            if ($this->aPath[3] == "File") {
                $this->getWorkspaceFile();
            } else {
                if ($this->aPath[3] == "Tree") {
                    $aReturn = $this->getWorkspaceDirectoryTree();
                } else if ($this->aPath[3] == "Metadata") {
                    $aReturn = $this->regenerateMetadata();
                } else if ($this->aPath[3] == "CheckWidgetFile") {
                    $aReturn = $this->checkWidgetFile();
                }
                $aXmlRacineAttribute['status'] = $aReturn['status'];
                if ($aReturn['status'] == 1) {
                    $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                } else {
                    $oError = new VitisError($aReturn['error_code'], $aReturn['message']);
                    $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                }
                return $sMessage;
            }
        } else {
            $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "v_author_workspace", "workspace_id");
            // Formatage de la colonne "form_type".
            if ($aReturn['sStatus'] == 1) {
                foreach ($this->aObjects as &$oWorkspace) {
                    $sFile = $this->aProperties['workspace_dir'] . "/" . $oWorkspace->aFields['workspace_id'] . '/form/Subform.json';
                    if (!file_exists($sFile)) {
                        $oWorkspace->aFields['form_type'] = '';
                    } else {
                        if ($oWorkspace->aFields['form_type'] != "custom") {
                            $oWorkspace->aFields['form_type'] = "default";
                        }
                    }
                }
                $aXmlRacineAttribute['status'] = 1;
                $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            } else {
                $sMessage = $aReturn['sMessage'];
            }
            return $sMessage;
        }
    }
}
?>