<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file Category.class.inc
 * \class Category
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Category php class
 *
 * This class defines operation for one Category
 * 
 */
class Categorie extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('category_id', 'name', 'description', 'workspaces');
    }

    /**
     * @SWG\Get(path="/categories/{category_id}", 
     *   tags={"Categories"},
     *   summary="Get Category",
     *   description="Request to get Category by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="category_id",
     *     in="path",
     *     description="category id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/categories")
     *     )
     *  )
     */

    /**
     * get informations about mode
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "category", "category_id");
        // Traitements liés à la catégorie.
        $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
        $aParams['category_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
        $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getCategoryTraitement'], $aParams);
        $aWorkspacesId = array();
        $aWorkspacesName = array();
        while ($oWorkspacesId = $this->oConnection->oBd->objetSuivant($oPDOresult)) {
            $aWorkspacesId[] = $oWorkspacesId->workspace_id;
            $aWorkspacesName[] = $oWorkspacesId->name;
        }
        $this->aFields['workspaces'] = implode('|', $aWorkspacesId);
        $this->aFields['workspaces_label'] = implode(',', $aWorkspacesName);
    }

    /**
     * delete a category
     */
    function DELETE() {
        // Workspaces liés à la catégorie.
        require $this->sRessourcesFile;
        $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
        $aParams['category_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
        $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['setWorkspaceCategory'], $aParams);
        //
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'category', 'category_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['category_id'] = $this->aValues["my_vitis_id"];
        }
    }

}

?>