<?php

/**
 * \file EmailTemplates.class.inc
 * \class EmailTemplates
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Modes php class
 *
 * This class defines Rest Api to Vitis EmailTemplates
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'EmailTemplate.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/Email.class.inc';

class EmailTemplates extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/emailtemplates",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/emailtemplates")
     *   }
     * )
     * * @SWG\Tag(
     *   name="EmailTemplates",
     *   description="Operations about EmailTemplate"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('email_template_id', 'name', 'subject', 'body', 'to', 'cc', 'cci', 'code', 'use_advanced', 'rt_emailcontext_id', 'attachment');
    }

    /**
     * @SWG\Get(path="/emailtemplates",
     *   tags={"EmailTemplates"},
     *   summary="Get EmailTemplate",
     *   description="Request to get EmailTemplate",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="emailtemplate token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */
    /**
     * @SWG\Get(path="/emailtemplates/{email_template_id}/Code",
     *   tags={"EmailTemplates"},
     *   summary="Get EmailTemplate code",
     *   description="Request to get EmailTemplate code by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="email_template_id",
     *     in="path",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */
    /**
     * @SWG\Get(path="/emailtemplates/{email_template_id}/Tags",
     *   tags={"EmailTemplates"},
     *   summary="Get EmailTemplate tags",
     *   description="Request to get EmailTemplate tags",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="email_template_id",
     *     in="path",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="language",
     *     in="query",
     *     description="user language",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */

    /**
     * get EmailTemplates
     * @return  EmailTemplates
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "email_template", "email_template_id");
        if (isset($this->aPath[3])) {
            // Code du template ?
            if ($this->aPath[3] == "Code") {
                if ($aReturn['sStatus'] == 1) {
                    $this->getEmailTemplateCode();
                    $aXmlRacineAttribute['status'] = 1;
                    $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                    return $sMessage;
                }
            }
            // Tags du template ?
            else if ($this->aPath[3] == "Tags") {
                if ($aReturn['sStatus'] == 1) {
                    $this->getEmailTemplateTags();
                    $aXmlRacineAttribute['status'] = 1;
                    $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                    return $sMessage;
                }
            }
        } else
            return $aReturn['sMessage'];
    }

    /**
     * @SWG\Post(path="/emailtemplates",
     *   tags={"EmailTemplates"},
     *   summary="Add EmailTemplate",
     *   description="Request to add email template",
     *   operationId="POST",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="email template token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="name",
     *     in="formData",
     *     description="name of the email template",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="rt_emailcontext_id",
     *     in="formData",
     *     description="context of the email template",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="use_advanced",
     *     in="formData",
     *     description="use advanced definition of email template ?",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Parameter(
     *     name="to",
     *     in="formData",
     *     description="to",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="cc",
     *     in="formData",
     *     description="cc",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="cci",
     *     in="formData",
     *     description="cci",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="subject",
     *     in="formData",
     *     description="subject",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="body",
     *     in="formData",
     *     description="Message",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="code",
     *     in="formData",
     *     description="code",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */
    /**
     * @SWG\Post(path="/emailtemplates/CodeValidation",
     *   tags={"EmailTemplates"},
     *   summary="Email template's code validation",
     *   description="Request to validate email template's code",
     *   operationId="POST",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="code",
     *     in="formData",
     *     description="code to check",
     *     required=true,
     *     type="string",
     *   ),
     *   @SWG\Parameter(
     *     name="error_type",
     *     in="formData",
     *     description="types of error check",
     *     required=false,
     *     type="string",
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */
    /**
     * insert email template
     * @return id of the email template created
     */
    function POST() {
        // Vérification du code du template ?
        if (!empty($this->aPath[3]) && $this->aPath[3] == "CodeValidation")
            $this->checkEmailTemplateCode();
        else {
            $aReturn = $this->genericPost($this->aProperties['schema_gtf'], 'email_template', $this->aProperties['schema_gtf'] . '.seq_common', 'email_template_id');
            if ($aReturn['sStatus'] == 1) {
                $aXmlRacineAttribute['status'] = 1;
                $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                $oEmailTemplate = new EmailTemplate($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
                $oEmailTemplate->GET();
            } else {
                $sMessage = $aReturn['sMessage'];
            }
            return $sMessage;
        }
    }

    /**
     * @SWG\Put(path="/emailtemplates/{email_template_id}",
     *   tags={"EmailTemplates"},
     *   summary="Update EmailTemplate",
     *   description="Request to update EmailTemplate",
     *   operationId="PUT",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="email template token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="email_template_id",
     *     in="path",
     *     description="id of the email template",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     *   @SWG\Parameter(
     *     name="name",
     *     in="query",
     *     description="name of the email template",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="rt_emailcontext_id",
     *     in="query",
     *     description="context of the email template",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="use_advanced",
     *     in="query",
     *     description="use advanced definition of email template ?",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Parameter(
     *     name="to",
     *     in="query",
     *     description="to",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="cc",
     *     in="query",
     *     description="cc",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="cci",
     *     in="query",
     *     description="cci",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="subject",
     *     in="query",
     *     description="subject",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="body",
     *     in="query",
     *     description="Message",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="code",
     *     in="query",
     *     description="code",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */

    /**
     * update email template
     * @return id of the email template if ok error object if ko
     */
    function PUT() {
        $aReturn = $this->genericPut($this->aProperties['schema_gtf'], 'email_template', 'email_template_id');
        if ($aReturn['sStatus'] == 1) {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            $oEmailTemplate = new EmailTemplate($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
            $oEmailTemplate->GET();
        } else {
            $sMessage = $aReturn['sMessage'];
        }
        return $sMessage;
    }

    /**
     * @SWG\Delete(path="/emailtemplates/",
     *   tags={"EmailTemplates"},
     *   summary="delete EmailTemplate",
     *   description="Request to delete EmailTemplate",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="email template token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="idList",
     *     in="query",
     *     description="id of the EmailTemplates",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */
    /**
     * @SWG\Delete(path="/emailtemplates/{email_template_id}",
     *   tags={"EmailTemplates"},
     *   summary="delete EmailTemplate",
     *   description="Request to delete EmailTemplate",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="email template token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="email_template_id",
     *     in="path",
     *     description="id of the email template",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/emailtemplates")
     *     )
     *  )
     */

    /**
     * delete email template
     * @return id of email template deleted or error object if a email template is not deleted
     */
    function DELETE() {
        $aReturn = $this->genericDelete($this->aProperties['schema_gtf'], 'email_template', 'email_template_id');
        return $aReturn['sMessage'];
    }

    /**
     * Get the code of email template.
     */
    function getEmailTemplateCode() {
        $oEmail = new Email($this->oConnection->oBd, $this->aObjects[0]->aFields["email_template_id"], $this->aProperties, array());
        $this->aObjects[0]->aFields = array('code' => $oEmail->oEmailTemplate->generateCode(true));
    }

    /**
     * Fonction appelée à la fin du script (par défaut uniquement des erreurs de syntaxe)
     */
    static function shutDownCallBack($oEmailTemplates) {
        // Constantes d'erreur passées ?
        if (!empty($oEmailTemplates->aValues['error_type']))
            $sErrorType = $oEmailTemplates->aValues['error_type'];
        else
            $sErrorType = 'E_PARSE';
        // Récupère la dernière erreur php.
        $error = error_get_last();
        //
        if (!empty($error)) {
            $aErrorType = array(E_ERROR => 'PHP Fatal Error', E_WARNING => 'PHP Warning', E_PARSE => 'PHP Parse error', E_NOTICE => 'PHP Notice');
            // Crée le masque avec toutes les constantes d'erreurs.
            $iErrorType = 0;
            foreach (explode('|', $sErrorType) as $sErrorConstant)
                $iErrorType += constant($sErrorConstant);
            //
            if (($error['type'] & $iErrorType) > 0) {
                $oError = new VitisError(1, $aErrorType["{$error['type']}"] . ' : ' . $error['message'] . ' on line ' . $error['line']);
                $aXmlRacineAttribute['status'] = 0;
                $sMessage = $oError->asDocument('', 'vitis', $oEmailTemplates->aValues['sEncoding'], True, $aXmlRacineAttribute, $oEmailTemplates->aValues['sSourceEncoding'], $oEmailTemplates->aValues['output']);
            } else {
                $aXmlRacineAttribute['status'] = 1;
                $sMessage = $oEmailTemplates->asDocument('', 'vitis', $oEmailTemplates->aValues['sEncoding'], True, $aXmlRacineAttribute, $oEmailTemplates->aValues['sSourceEncoding'], $oEmailTemplates->aValues['output']);
            }
        } else {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $oEmailTemplates->asDocument('', 'vitis', $oEmailTemplates->aValues['sEncoding'], True, $aXmlRacineAttribute, $oEmailTemplates->aValues['sSourceEncoding'], $oEmailTemplates->aValues['output']);
        }
        // Affiche le retour vers le client.
        echo $sMessage;
        header('HTTP/1.1 200 OK');
    }

    /**
     * Check the code of email template.
     */
    function checkEmailTemplateCode() {
        // Enregistre une fonction de rappel à appeler à la fin du script
        register_shutdown_function('EmailTemplates::shutdownCallBack', $this);

        // Evaluation du code 
        if (!empty($this->aValues['code']))
            @eval($this->aValues['code']);
    }

    /**
     * Get the tags of email template.
     */
    function getEmailTemplateTags() {
        // Liste des balises (récupère le code des balises sans l'exécuter).
        $aTagButton = array();
        if (file_exists($this->aProperties['vas_home'] . '/rest/class/vmlib/context/' . $this->aObjects[0]->aFields['rt_emailcontext_id'] . '.inc')) {
            $sMailContextCode = file_get_contents($this->aProperties['vas_home'] . '/rest/class/vmlib/context/' . $this->aObjects[0]->aFields['rt_emailcontext_id'] . '.inc', true);
            preg_match_all('/=.+;/', $sMailContextCode, $aTagCode);
            foreach ($aTagCode[0] as $iIndex => $sTagCode) {
                $sTagCode = trim(substr($sTagCode, 1, strlen($sTagCode) - 2));
                if (preg_match('/^[^\'"]/', $sTagCode) === 1)
                    $sMailContextCode = str_replace($sTagCode, "'" . str_replace("'", "\'", $sTagCode) . "'", $sMailContextCode);
            }
            $sMailContextCode = preg_replace("/'{2,}/", "'", $sMailContextCode);
            $sMailContextCode = str_replace(array('<?php', '?>'), '', $sMailContextCode);
            eval($sMailContextCode);
            //	
            define('TINYMCE_ADD_BUTTON', 'editor.addButton("[tag_name]", {text: "[[tag_name]]", tooltip: "[tag_description]", icon: false, size: "small", onclick: function() {editor.insertContent("[[tag_name]]");}});');
            foreach ($properties as $sIndex => $aTagValues) {
                $aMailTag[$sIndex]['value'] = $aTagValues['value'];
                $aMailTag[$sIndex]['description'] = $aTagValues[$this->aValues['language']];
            }

            // Fichiers de langue de TinyMce
            $aTinyMceLang = array('en' => '', 'fr' => 'fr_FR');

            // Création des boutons en js
            foreach ($aMailTag as $sIndex => $aTagValues) {
                $aTagButton[] = array('name' => $sIndex, 'description' => $aTagValues['description']);
            }
        }
        $this->aFields['tags'] = $aTagButton;
    }

}

?>