<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file FmeEngine.class.inc
 * \class FmeEngine
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the FmeEngine php class
 *
 * This class defines operation for one FmeEngine
 * 
 */
class FmeEngine extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("fme_engine_id", "name", "server_id", "local_path", "server_name", "fme_engine_type_id", "server_url", "login", "password", "s3_access_key_id", "s3_secret_access_key", "fme_cloud_api_token", "fme_engine_type_label", "s3_region", "iam_access_key_id", "iam_secret_access_key", 'fme_server_instance_name', 'fme_server_s3_bucket', "useexternaldbconnection");
    }

    /**
     * @SWG\Get(path="/fmeengines/{fme_engine_id}", 
     *   tags={"FmeEngines"},
     *   summary="Get FmeEngine",
     *   description="Request to get FmeEngine by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="fme_engine_id",
     *     in="path",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/fmeengines")
     *     )
     *  )
     */

    /**
     * @SWG\Get(path="/fmeengines/{fme_engine_id}/instances/{instance_name}", 
     *   tags={"FmeEngines"},
     *   summary="Get Fme Server instance",
     *   description="Request to get an instance of Fme Server on Fme Cloud",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="fme_engine_id",
     *     in="path",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     * * @SWG\Parameter(
     *     name="instance_name",
     *     in="path",
     *     description="name of the fme server instance",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/fmeengines")
     *     )
     *  )
     */

    /**
     * @SWG\Get(path="/fmeengines/{fme_engine_id}/instances/{instance_name}/info", 
     *   tags={"FmeEngines"},
     *   summary="Get Fme Server instance information",
     *   description="Request to get the FME Server build number and version on Fme Cloud",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="fme_engine_id",
     *     in="path",
     *     description="user id",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     * * @SWG\Parameter(
     *     name="instance_name",
     *     in="path",
     *     description="name of the fme server instance",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/fmeengines")
     *     )
     *  )
     */
    
    /**
     * get informations about mode
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "v_fme_engine", "fme_engine_id");
    }

    /**
     * delete an user
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'v_fme_engine', 'fme_engine_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['fme_engine_id'] = $this->aValues["my_vitis_id"];
        }
    }

}

?>