<?php

//Définition des requêtes de l'api Vitis
$aSql['checkIP'] = "SELECT user_id, ip_constraint FROM [sSchemaFramework].v_user WHERE login ='[sLogin]'";
$aSql['getGroups'] = "SELECT group_id FROM [sSchemaFramework].v_user_group_by_rights WHERE user_id = [user_id]";
$aSql['loginUnique'] = 'SELECT UPPER("login") FROM [sSchemaFramework]."v_user" where UPPER("login")=UPPER(\'sLoginUser\')';
$aSql['getLoginbyId'] = 'SELECT "login" FROM [sSchemaFramework]."v_user" where user_id=[user_id]';
$aSql['getTableColumn'] = 'SELECT column_name FROM INFORMATION_SCHEMA.COLUMNS where table_schema = \'[sSchemaFramework]\' and table_name= \'[sTable]\'';
$aSql['getUserPrivileges'] = 'SELECT groname FROM pg_user s LEFT OUTER JOIN pg_group g on (s.usesysid = any(g.grolist) )inner join [sSchemaFramework].v_user on "v_user".login = usename where user_id = [user_id]';
$aSql['listDomain'] = 'SELECT distinct domain, alias FROM [sSchemaFramework].domain WHERE "type" = \'AD\'';
$aSql['createRolname'] = 'CREATE ROLE "vitis_[sDomain]" NOSUPERUSER INHERIT NOCREATEDB CREATEROLE;';
$aSql['getInfoRolname'] = 'SELECT * FROM pg_catalog.pg_roles WHERE rolname = \'vitis_[sDomain]\'';
// Orders
$aSql['getEnginesId'] = 'SELECT * FROM [sSchemaGtf].gtf_engine WHERE enabled = TRUE AND tags like \'%\' || (SELECT tag FROM [sSchemaGtf].workspace WHERE workspace_id =[iWorkspaceId]) || \'%\'';
$aSql['getEnginesDefaultTag'] = 'SELECT * FROM [sSchemaGtf].gtf_engine WHERE enabled = TRUE AND tags like \'%default%\'';
$aSql['setOrderEngineId'] = 'UPDATE [sSchemaGtf].order SET gtf_engine_id=[gtf_engine_id] WHERE order_id=[order_id]';
$aSql['getAllOrders'] = 'SELECT DISTINCT log_url FROM [sSchemaGtf].v_order WHERE log_url IS NOT NULL AND deleted = true';
$aSql['getOrders'] = 'SELECT DISTINCT log_url FROM [sSchemaGtf].v_order WHERE log_url IS NOT NULL AND order_id IN ([idList])';
$aSql['setOrderGtfEngine'] = 'UPDATE [sSchemaGtf].order SET gtf_engine_id = [gtf_engine_id] WHERE order_id IN ([idList])';
$aSql['resetOrder'] = 'UPDATE [sSchemaGtf].order SET order_status_id = 1, attempt = 0, execution_date = NULL, length_sec = NULL, log_url = null, result_url = null WHERE order_id = [order_id]';
$aSql['activateOrder'] = 'UPDATE [sSchemaGtf].order SET enabled = TRUE WHERE order_id IN ([idList])';
$aSql['desactivateOrder'] = 'UPDATE [sSchemaGtf].order SET enabled = FALSE WHERE order_id IN ([idList])';
$aSql['getOrderPathFiles'] = 'SELECT log_url,result_url FROM [sSchemaGtf].v_order WHERE order_id = [order_id]';
$aSql['getOrderWorkspace'] = 'SELECT workspace_id FROM [sSchemaGtf].v_order WHERE order_id = [order_id] LIMIT 1';
$aSql['getOrderEngineStatus'] = 'SELECT gtf_engine.enabled FROM [sSchemaGtf]."order" LEFT JOIN [sSchemaGtf].gtf_engine ON "order".gtf_engine_id = gtf_engine.gtf_engine_id WHERE order_id = [order_id]';
$aSql['getRunningOrders'] = 'SELECT order_id, gtf_engine_id FROM [sSchemaGtf]."order" WHERE order_status_id IN (1, 5)';
$aSql['updateOrderStatus'] = 'UPDATE [sSchemaGtf].order SET order_status_id = [order_status_id] WHERE order_id = [order_id]';
//$aSql['getOrdersToDelete'] = 'SELECT order_id, gtf_engine_id, order_status_id FROM [sSchemaGtf]."order" WHERE order_id IN([idList])';
$aSql['getOrdersToDelete'] = 'SELECT fme_engine.fme_engine_type_id, "order".order_id, "order".gtf_engine_id, "order".order_status_id FROM [sSchemaGtf].order, [sSchemaGtf].gtf_engine, [sSchemaGtf].fme_engine WHERE gtf_engine.gtf_engine_id = "order".gtf_engine_id AND fme_engine.fme_engine_id = gtf_engine.fme_engine_id AND order_id IN([idList])';
//$aSql['getOrderFmeEngine'] = 'SELECT fme_engine.fme_engine_type_id, fme_engine.server_url, fme_engine.login, fme_engine.password, fme_engine.fme_cloud_api_token, fme_engine.fme_server_instance_name, server.engines_home, v_order.gtf_engine_id FROM [sSchemaGtf].v_order, [sSchemaGtf].gtf_engine, [sSchemaGtf].fme_engine, [sSchemaGtf].server WHERE gtf_engine.gtf_engine_id = v_order.gtf_engine_id AND fme_engine.fme_engine_id = gtf_engine.fme_engine_id AND server.server_id = fme_engine.server_id AND order_id = [iOrderId] LIMIT 1';
$aSql['getGtfEngineHomeFromOrderId'] = 'SELECT engines_home, "order".gtf_engine_id, "order".order_id FROM [sSchemaGtf]."server", [sSchemaGtf].gtf_engine, [sSchemaGtf]."order" WHERE gtf_engine.server_id = "server".server_id AND gtf_engine.gtf_engine_id = "order".gtf_engine_id AND order_id = [order_id]';
$aSql['getGtfEngineHomeFromEngineId'] = 'SELECT engines_home, "order".gtf_engine_id, "order".order_id FROM [sSchemaGtf]."server", [sSchemaGtf].gtf_engine, [sSchemaGtf]."order" WHERE gtf_engine.server_id = "server".server_id AND gtf_engine.gtf_engine_id = "order".gtf_engine_id AND gtf_engine.gtf_engine_id = [iGtfEngineId]';
$aSql['getFmeServerOrder'] = 'SELECT fme_engine.fme_engine_type_id, fme_engine.server_url, fme_engine.login, fme_engine.password, fme_engine.fme_cloud_api_token, fme_engine.fme_server_instance_name, "order".gtf_engine_id, "order".pid, server.engines_home, "order".log_url FROM [sSchemaGtf].order, [sSchemaGtf].gtf_engine, [sSchemaGtf].fme_engine, [sSchemaGtf].server WHERE gtf_engine.gtf_engine_id = "order".gtf_engine_id AND fme_engine.fme_engine_id = gtf_engine.fme_engine_id AND server.server_id = fme_engine.server_id AND order_id = [order_id] LIMIT 1';
$aSql['getOrderPid'] = 'SELECT fme_engine.fme_engine_type_id, "order".gtf_engine_id, "order".pid FROM [sSchemaGtf]."order", [sSchemaGtf].gtf_engine, [sSchemaGtf].fme_engine, [sSchemaGtf].server WHERE gtf_engine.gtf_engine_id = "order".gtf_engine_id AND fme_engine.fme_engine_id = gtf_engine.fme_engine_id AND server.server_id = fme_engine.server_id AND order_id = [order_id] LIMIT 1';
$aSql['getOrderFmeEngineType'] = 'SELECT fme_engine.fme_engine_type_id FROM [sSchemaGtf]."order", [sSchemaGtf].gtf_engine, [sSchemaGtf].fme_engine WHERE gtf_engine.gtf_engine_id = "order".gtf_engine_id AND fme_engine.fme_engine_id = gtf_engine.fme_engine_id AND order_id = [order_id] LIMIT 1';
// UserSubscriptions
$aSql['setSubscriptionEngineId'] = 'UPDATE [sSchemaGtf].subscription SET gtf_engine_id=[gtf_engine_id] WHERE subscription_id=[subscription_id]';
$aSql['getUserSubscriptions'] = "SELECT order_id, label_name, CASE when v_user_subscription.enabled IS TRUE THEN '<img src=''./images/true.png'' />' ELSE '<img src=''./images/false.png'' />' END as enabled, order_date, '<img src=''./images/wk_params.png''  onmouseover=''loadTooltip(event,0,0,\"White\",\"#' || order_id || '\", \"' || replace(replace(replace(replace(wk_params,'\r\n', '<br/>'),'\\','\\\\'), '\"', '\\\"'),'''', '&#39;') || '\" )'' onmouseout=''unshow()''/>'  as wk_params, period.name as order_period_libelle, v_user_subscription.email_option_id, label_id, CASE WHEN email_notifications IS NOT NULL then '<img src=''./images/enveloppe.png'' onmouseover=''showTooltip(event,500,0,\"White\",\"#' || order_id || '\", \"' || replace(email_notifications, ';', '<br>') || '\" )'' onmouseout=''unshow()''/>' END as email_notifications, translation_email_notification.translation as notification FROM [sSchemaGtf].v_user_subscription LEFT JOIN [sSchemaGtf].period ON period.period_id = v_user_subscription.period_id LEFT JOIN [sSchemaGtf].rt_email_option on rt_email_option.email_option_id = v_user_subscription.email_option_id LEFT JOIN [sSchemaFramework].vm_translation translation_email_notification ON rt_email_option.label_id = translation_email_notification.translation_id WHERE translation_email_notification.lang = '[sLang]'";
$aSql['getUserSubscription'] = "SELECT order_id, workspace_id, enabled, login, order_status_id,  order_date, execution_date, wk_params, period_id, result_url, user_id, order_period_libelle, v_subscription.email_option_id, vm_translation.translation as notification FROM [sSchemaGtf].v_subscription LEFT JOIN [sSchemaGtf].rt_email_option ON v_subscription.email_option_id = rt_email_option.email_option_id LEFT JOIN [sSchemaFramework].vm_translation ON rt_email_option.label_id = vm_translation.translation_id WHERE vm_translation.lang = '[sLang]' AND v_subscription.order_id = [order_id]";
// GtfEngines
$aSql['getTags'] = 'SELECT tags FROM [sSchemaGtf].gtf_engine WHERE tags IS NOT NULL';
$aSql['truncateTags'] = 'TRUNCATE [sSchemaGtf].rt_tag';
$aSql['insertTag'] = 'INSERT INTO [sSchemaGtf].rt_tag VALUES ([sTag])';
// Categories
$aSql['getCategoryTraitement'] = 'SELECT workspace_id, name FROM [sSchemaGtf].workspace WHERE category_id=[category_id]';
$aSql['setWorkspaceCategory'] = 'UPDATE [sSchemaGtf].workspace SET category_id=NULL WHERE category_id IN([category_id])';
// Inboxes
$aSql['getInboxGroups'] = 'SELECT inbox_group.group_id, "group".name FROM [sSchemaGtf].inbox_group LEFT JOIN [sSchemaFramework]."group" ON inbox_group.group_id = "group".group_id WHERE inbox_group.inbox_id = [inbox_id]';
// UserOrders
$aSql['getUserOrders'] = "SELECT order_id, workspace.name as label_name,CASE WHEN rt_order_status.order_status_id =1 then '<img src=''./images/sql_list/st1.gif'' \ronmouseover=''showTooltip(event,100,0,\"White\",\"#' || order_id || '\", \"' || translation_status.translation || '\" )'' onmouseout=''unshow()''/>' WHEN rt_order_status.order_status_id =2 then '<img src=''./images/sql_list/st2.png'' onmouseover=''showTooltip(event,100,0,\"White\",\"#' || order_id || '\", \"' || translation_status.translation || '\" )'' onmouseout=''unshow()''/>' WHEN rt_order_status.order_status_id =3 then '<img src=''./images/sql_list/st3.png'' onmouseover=''showTooltip(event,100,0,\"White\",\"#' || order_id || '\", \"' || translation_status.translation || '\" )'' onmouseout=''unshow()''/>' WHEN rt_order_status.order_status_id =5 then '<img src=''./images/sql_list/st5.gif'' onmouseover=''showTooltip(event,100,0,\"White\",\"#' || order_id || '\", \"' || translation_status.translation || '\" )'' onmouseout=''unshow()''/>' WHEN rt_order_status.order_status_id =6 then '<img src=''./images/sql_list/st6.png'' onmouseover=''showTooltip(event,100,0,\"White\",\"#' || order_id || '\", \"' || translation_status.translation || '\" )'' onmouseout=''unshow()''/>' else '<img src=''./images/sql_list/st4.png''  onmouseover=''showTooltip(event,100,0,\"White\",\"#' || order_id || '\", \"' || translation_status.translation || '\" )'' onmouseout=''unshow()''/>' end as order_status_libelle, translation_status.translation, order_date, execution_date, CASE WHEN email_notifications IS NOT NULL then '<img src=''./images/enveloppe.png'' onmouseover=''showTooltip(event,500,0,\"White\",\"#' || order_id || '\", \"' || replace(email_notifications, ';', '<br>') || '\" )'' onmouseout=''unshow()''/>' END as email_notifications, '<img src=''./images/wk_params.png''  onmouseover=''loadTooltip(event,0,0,\"White\",\"#' || order_id || '\", \"' || replace(replace(replace(replace(wk_params,'\r\n', '<br/>' ),'\\','\\\\'), '\"', '\\\"'),'''', '&#39;') || '\" )'' onmouseout=''unshow()''/>'  as parametres, rt_priority.priority_id, translation_priority.translation as priorite_libelle, translation_email.translation as email_libelle, case when result_url IS NULL then '' else '<a href=javascript:OpenFile(\"' || 'properties[url_export]/' || result_url ||'\");><img src=''./images/telecharger.png''/></a>' end as result_url, log_url,  deleted, gtf_engine_id, length_sec FROM ([sSchemaGtf].\"v_user_order\" LEFT JOIN [sSchemaGtf].workspace ON \"v_user_order\".workspace_id = workspace.workspace_id LEFT JOIN [sSchemaGtf].rt_order_status ON \"v_user_order\".order_status_id = rt_order_status.order_status_id LEFT JOIN [sSchemaGtf].rt_priority ON \"v_user_order\".priority_id = rt_priority.priority_id) LEFT JOIN [sSchemaGtf].\"rt_email_option\" ON \"v_user_order\".\"email_option_id\" = \"rt_email_option\".\"email_option_id\" LEFT JOIN [sSchemaFramework].\"v_user\" ON \"v_user\".\"user_id\" = [sSchemaGtf].\"v_user_order\".\"user_id\" LEFT JOIN [sSchemaFramework].vm_translation as translation_priority ON translation_priority.translation_id = rt_priority.label_id LEFT JOIN [sSchemaFramework].vm_translation as translation_email ON translation_email.translation_id = rt_email_option.label_id and translation_email.lang=translation_priority.lang LEFT JOIN [sSchemaFramework].vm_translation as translation_status ON rt_order_status.label_id = translation_status.translation_id and translation_status.lang=translation_priority.lang WHERE translation_status.lang = '[sLang]'";
$aSql['getUserOrder'] = "SELECT v_user_order.order_id, workspace.workspace_id, workspace.name, \"v_user\".\"user_id\" as \"user_id\", \"v_user\".\"name\" as \"user_name\", v_user_order.order_date, v_user_order.execution_date, v_user_order.wk_params, rt_priority.priority_id, v_user_order.result_url as \"result_url\", v_user_order.log_url as \"log_url\", v_user_order.email_notifications FROM ([sSchemaGtf].v_user_order LEFT JOIN [sSchemaGtf].order ON v_user_order.order_id = \"order\".order_id LEFT JOIN [sSchemaGtf].workspace ON v_user_order.workspace_id = workspace.workspace_id LEFT JOIN [sSchemaGtf].rt_order_status ON v_user_order.order_status_id = rt_order_status.order_status_id LEFT JOIN [sSchemaGtf].rt_priority ON v_user_order.priority_id = rt_priority.priority_id LEFT JOIN [sSchemaGtf].rt_email_option ON v_user_order.email_option_id = rt_email_option.email_option_id) LEFT JOIN [sSchemaFramework].\"v_user\" ON \"v_user\".\"user_id\" = v_user_order.\"user_id\" WHERE v_user_order.order_id = [order_id]";
$aSql['setUserOrderEngineId'] = 'UPDATE [sSchemaGtf].order SET gtf_engine_id=[gtf_engine_id] WHERE order_id=[order_id]';
// Groups
$aSql['getWorkspaces'] = "SELECT workspace_id FROM [sSchemaGtf].workspace_group WHERE group_id = [group_id]";
$aSql['getInboxes'] = "SELECT inbox_id FROM [sSchemaGtf].inbox_group WHERE group_id = [group_id]";
$aSql['insertGroupWorkspaces'] = "INSERT INTO [sSchemaGtf].workspace_group(workspace_id, group_id, workspace_group_id) VALUES([workspace_id], [group_id], nextval('[sSchemaGtf].seq_common'))";
$aSql['insertGroupInboxes'] = "INSERT INTO [sSchemaGtf].inbox_group(inbox_id, group_id) VALUES([inbox_id], [group_id])";
$aSql['getWorkspaceGroups'] = 'SELECT workspace_group.group_id, "group".name FROM [sSchemaGtf].workspace_group LEFT JOIN [sSchemaFramework].group ON workspace_group.group_id = "group".group_id WHERE workspace_group.workspace_id=[workspace_id]';
$aSql['getLastGTFEngineID'] = 'SELECT min(num)-1 as id FROM generate_series(1,(SELECT max(gtf_engine_id) FROM [sSchemaGtf].gtf_engine)+ 1) t(num) LEFT JOIN [sSchemaGtf].gtf_engine  on (t.num =gtf_engine.gtf_engine_id) WHERE gtf_engine.gtf_engine_id is null;';
//ImportWorkspace
$aSql['getWorkspaceId'] = 'SELECT workspace_id FROM [sSchemaGtf].workspace WHERE lower(name) = lower([sFileName]);';
$aSql['getWorkspaceId2'] = 'SELECT workspace_id FROM [sSchemaGtf].workspace where key = [sKey];';
$aSql['getOwnerId'] = 'SELECT "user_id" FROM [sSchemaFramework]."v_user" WHERE login = [sLogin]';
// UserOrders
$aSql['checkUserWorkspace'] = 'SELECT * FROM [sSchemaGtf].v_user_workspace WHERE workspace_id=[workspace_id]';
// Workspaces
$aSql['getWorkspaceLastSaveData'] = 'SELECT last_save_date, last_save_build FROM [sSchemaGtf].workspace WHERE workspace_id=[workspace_id]';
$aSql['checkWorkspaceName'] = 'SELECT workspace_id FROM [sSchemaGtf].workspace WHERE name=[name]';
// FmeEngines
$aSql['getFmeEngine'] = 'SELECT * FROM [sSchemaGtf].fme_engine WHERE fme_engine_id = [fme_engine_id]';
?>
