<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file Group.class.inc
 * \class Group
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Group php class
 *
 * This class defines operation for one Group
 * 
 */
class GtfGroup extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("group_id", "name", "nb_members", "workspaces", "inboxes");
    }

    /**
     * @SWG\Get(path="/gtfgroups/{group_id}", 
     *   tags={"Groups"},
     *   summary="Get Group",
     *   description="Request to get Group by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="group_id",
     *     in="path",
     *     description="group id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/groups")
     *     )
     *  )
     */

    /**
     * get informations about mode
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields($this->aProperties['schema_framework'], "v_group", "group_id");
        $this->getWorkspaces();
        $this->getInboxes();
    }

    /**
     *  get workspaces of group
     */
    function getWorkspaces() {
        require $this->sRessourcesFile;
        if (in_array("workspaces", $this->aSelectedFields)) {
            $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
            $aParams['group_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getWorkspaces'], $aParams);
            $sListWorkspaceId = "";
            while ($aLigne = $this->oConnection->oBd->ligneSuivante($oPDOresult)) {
                if ($sListWorkspaceId == "") {
                    $sListWorkspaceId = $aLigne["workspace_id"];
                } else {
                    $sListWorkspaceId .= "|" . $aLigne["workspace_id"];
                }
            }
            $oPDOresult = $this->oConnection->oBd->fermeResultat();
            $this->aFields['workspaces'] = $sListWorkspaceId;
        }
    }

    /**
     *  get inboxes of group
     */
    function getinboxes() {
        require $this->sRessourcesFile;
        if (in_array("inboxes", $this->aSelectedFields)) {
            $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
            $aParams['group_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
            $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getInboxes'], $aParams);
            $sListInboxId = "";
            while ($aLigne = $this->oConnection->oBd->ligneSuivante($oPDOresult)) {
                if ($sListInboxId == "") {
                    $sListInboxId = $aLigne["inbox_id"];
                } else {
                    $sListInboxId .= "|" . $aLigne["inbox_id"];
                }
            }
            $oPDOresult = $this->oConnection->oBd->fermeResultat();
            $this->aFields['inboxes'] = $sListInboxId;
        }
    }

}

?>