<?php

/**
 * \file Groups.class.inc
 * \class Groups
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Modes php class
 *
 * This class defines Rest Api to Vitis Groups
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'GtfGroup.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

class GtfGroups extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/gtfgroups",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/gtfgroups")
     *   }
     * )
     * * @SWG\Tag(
     *   name="GtfGroups",
     *   description="Operations about Groups"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array("group_id", "name", "nb_members", "workspaces", "inboxes");
    }

    /**
     * get Groups
     * @return  Groups
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_framework'], "v_group", "group_id");

        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Put(path="/gtfgroups/{group_id}",
     *   tags={"Groups"},
     *   summary="Update Group",
     *   description="Request to update Group",
     *   operationId="PUT",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="group token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="group_id",
     *     in="path",
     *     description="id of the group",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * * @SWG\Parameter(
     *     name="workspaces",
     *     in="query",
     *     description="Workspaces of the group",
     *     required=false,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="inboxes",
     *     in="query",
     *     description="Inboxes of the group",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/groups")
     *     )
     *  )
     */

    /**
     * update group
     * @return id of the group if ok error object if ko
     */
    function PUT() {
        $aReturn = $this->genericPut($this->aProperties['schema_framework'], 'v_group', 'group_id');
        if ($aReturn['sStatus'] == 1) {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            $oGroup = new GTFGroup($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
            $oGroup->GET();
            require $this->sRessourcesFile;
            // Supprime les Traitements rattachés au groupe.
            $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'workspace_group', 'group_id', $this->aValues["my_vitis_id"]);
            // Traitements à rattacher au groupe ?
            if (!empty($this->aValues['workspaces'])) {
                $aWorkspaces = explode('|', $this->aValues['workspaces']);
                foreach ($aWorkspaces as $iWorkspaceId) {
                    $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
                    $aParams['group_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
                    $aParams['workspace_id'] = array('value' => $iWorkspaceId, 'type' => 'number');
                    $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['insertGroupWorkspaces'], $aParams);
                }
            }

            // Supprime les dépôts rattachés au groupe.
            $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'inbox_group', 'group_id', $this->aValues["my_vitis_id"]);
            // Traitements à rattacher au groupe ?
            if (!empty($this->aValues['inboxes'])) {
                $aInboxes = explode('|', $this->aValues['inboxes']);
                foreach ($aInboxes as $iInboxId) {
                    $aParams = array();
                    $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
                    $aParams['group_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
                    $aParams['inbox_id'] = array('value' => $iInboxId, 'type' => 'number');
                    $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['insertGroupInboxes'], $aParams);
                }
            }
        } else {
            $sMessage = $aReturn['sMessage'];
        }
        return $sMessage;
    }

}

?>