<?php

require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';

/**
 * \file Inbox.class.inc
 * \class Inbox
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Inbox php class
 *
 * This class defines operation for one Inbox
 * 
 */
class Inboxe extends GTF {

    public $oError;

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('inbox_id', 'name', 'alias', 'groups');
    }

    /**
     * @SWG\Get(path="/inboxes/{inbox_id}", 
     *   tags={"Inboxes"},
     *   summary="Get Inbox",
     *   description="Request to get Inbox by id",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="inbox_id",
     *     in="path",
     *     description="inbox id",
     *     required=true,
     *     type="integer",
     *   format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/inboxes")
     *     )
     *  )
     */

    /**
     * get informations about mode
     */
    function GET() {
        require $this->sRessourcesFile;
        $this->aFields = $this->getFields($this->aProperties['schema_gtf'], "inbox", "inbox_id");
        // Groupes liés à au dépôt.
        $aParams['sSchemaGtf'] = array('value' => $this->aProperties['schema_gtf'], 'type' => 'schema_name');
        $aParams['sSchemaFramework'] = array('value' => $this->aProperties['schema_framework'], 'type' => 'schema_name');
        $aParams['inbox_id'] = array('value' => $this->aValues['my_vitis_id'], 'type' => 'number');
        $oPDOresult = $this->oConnection->oBd->executeWithParams($aSql['getInboxGroups'], $aParams);
        $aGroupsId = array();
        $aGroupsName = array();
        while ($oGroupsId = $this->oConnection->oBd->objetSuivant($oPDOresult)) {
            $aGroupsId[] = $oGroupsId->group_id;
            $aGroupsName[] = $oGroupsId->name;
        }
        $this->aFields['groups'] = implode('|', $aGroupsId);
        $this->aFields['groups_label'] = implode(',', $aGroupsName);
    }

    /**
     * delete an inbox
     */
    function DELETE() {
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'inbox', 'inbox_id', $this->aValues["my_vitis_id"], 'integer');
        if ($this->oConnection->oBd->enErreur()) {
            $this->oError = new VitisError(1, $this->oConnection->oBd->getBDMessage());
        } else {
            $this->aFields['inbox_id'] = $this->aValues["my_vitis_id"];
        }
    }

}

?>