<?php

/**
 * \file Inboxes.class.inc
 * \class Inboxes
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Modes php class
 *
 * This class defines Rest Api to Vitis Inboxes
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'Inbox.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

class Inboxes extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/inboxes",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/inboxes")
     *   }
     * )
     * * @SWG\Tag(
     *   name="Inboxes",
     *   description="Operations about Inbox"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('inbox_id', 'name', 'alias');
    }

    /**
     * @SWG\Get(path="/inboxes",
     *   tags={"Inboxes"},
     *   summary="Get Inbox",
     *   description="Request to get Inbox",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="inbox token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="order_by",
     *     in="query",
     *     description="list of ordering fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="sort_order",
     *     in="query",
     *     description="sort order",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/inboxes")
     *     )
     *  )
     */

    /**
     * get Inboxes
     * @return  Inboxes
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "inbox", "inbox_id");
        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Post(path="/inboxes",
     *   tags={"Inboxes"},
     *   summary="Add Inbox",
     *   description="Request to add inbox",
     *   operationId="POST",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="inbox token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="name",
     *     in="formData",
     *     description="name of the inbox",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="alias",
     *     in="formData",
     *     description="alias of the inbox",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="groups",
     *     in="formData",
     *     description="groups of the inbox",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/inboxes")
     *     )
     *  )
     */

    /**
     * insert inbox
     * @return id of the inbox created
     */
    function POST() {
        if (strpos($this->aValues['name'], '/$user') == false) {
            $this->aValues['name'] .= '/$user';
        }
        if (strpos($this->aValues['alias'], '/$user') == false) {
            $this->aValues['alias'] .= '/$user';
        }
        $aReturn = $this->genericPost($this->aProperties['schema_gtf'], 'inbox', $this->aProperties['schema_gtf'] . '.seq_common', 'inbox_id');
        if ($aReturn['sStatus'] == 1) {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            $oInbox = new Inboxe($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
            $oInbox->GET();
            // Groupes à associer au dépôt.
            $this->insertGroupInbox();
        } else {
            $sMessage = $aReturn['sMessage'];
        }
        return $sMessage;
    }

    /**
     * @SWG\Put(path="/inboxes/{inbox_id}",
     *   tags={"Inboxes"},
     *   summary="Update Inbox",
     *   description="Request to update Inbox",
     *   operationId="PUT",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="inbox token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="inbox_id",
     *     in="path",
     *     description="id of the inbox",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     *   @SWG\Parameter(
     *     name="name",
     *     in="query",
     *     description="name of the inbox",
     *     required=true,
     *     type="integer",
     *     format="int32"
     *   ),
     *   @SWG\Parameter(
     *     name="alias",
     *     in="query",
     *     description="alias of the inbox",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="groups",
     *     in="query",
     *     description="groups of the inbox",
     *     required=false,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/inboxes")
     *     )
     *  )
     */

    /**
     * update inbox
     * @return id of the inbox if ok error object if ko
     */
    function PUT() {
        if (strpos($this->aValues['name'], '/$user') == false) {
            $this->aValues['name'] .= '/$user';
        }
        $aReturn = $this->genericPut($this->aProperties['schema_gtf'], 'inbox', 'inbox_id');
        if ($aReturn['sStatus'] == 1) {
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            $oInbox = new Inboxe($this->aPath, $this->aValues, $this->aProperties, $this->oConnection);
            $oInbox->GET();
            // Groupes à associer au dépôt.
            $this->insertGroupInbox();
        } else {
            $sMessage = $aReturn['sMessage'];
        }
        return $sMessage;
    }

    /**
     * @SWG\Delete(path="/inboxes/",
     *   tags={"Inboxes"},
     *   summary="delete Inbox",
     *   description="Request to delete Inbox",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="inbox token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="idList",
     *     in="query",
     *     description="id of the Inboxes",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/inboxes")
     *     )
     *  )
     */
    /**
     * @SWG\Delete(path="/inboxes/{inbox_id}",
     *   tags={"Inboxes"},
     *   summary="delete Inbox",
     *   description="Request to delete Inbox",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="inbox token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="inbox_id",
     *     in="path",
     *     description="id of the inbox",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/inboxes")
     *     )
     *  )
     */

    /**
     * delete inbox
     * @return id of inbox deleted or error object if a inbox is not deleted
     */
    function DELETE() {
        $aReturn = $this->genericDelete($this->aProperties['schema_gtf'], 'inbox', 'inbox_id');
        return $aReturn['sMessage'];
    }

    /*
     * *	Groupes liés au dépôts.
     */

    Public function insertGroupInbox() {
        //
        $this->oConnection->oBd->delete($this->aProperties['schema_gtf'], 'inbox_group', 'inbox_id', $this->aValues["my_vitis_id"]);
        // Le paramètre "groups" est passé dans la requête ?
        if ($this->aValues['groups'] !== NULL) {
            // Groupes à rattacher au dépôt ?
            if (!empty($this->aValues['groups'])) {
                $aGroups = explode('|', $this->aValues['groups']);
                foreach ($aGroups as $sValue) {
                    $aValues = array('inbox_id' => $this->aValues["my_vitis_id"], 'group_id' => $sValue);
                    $this->oConnection->oBd->insert($this->aProperties['schema_gtf'], 'inbox_group', $aValues, $this->aProperties['schema_gtf'] . '.seq_common', '');
                }
            }
        }
    }

}

?>