<?php
/**
 * \file Instance.class.inc
 * \class Instance
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Instance php class
 *
 * This class defines Rest Api to Gtf order statutes
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';
require_once ("gtf_lib/phpUtility.inc");

class Instance extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/instance",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/instance")
     *   }
     * )
     * * @SWG\Tag(
     *   name="Instance",
     *   description="Operations about Instance"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('instance_id');
    }

    /**
     * @SWG\Post(path="/instance/generate",
     *   tags={"Instance"},
     *   summary="Generate a GTF instance id",
     *   description="Request to generate a new instance id for GTF",
     *   operationId="POST",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   consumes= { "multipart/form-data"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/instance")
     *     )
     *  )
     */

    /**
     * Generate a GTF instance
     * @return id of the workspace created
     */
    function POST() {
        if ($this->aPath[2] == 'generate') {
            $this->aFields['instance_id'] = generateGtfInstanceId();
            $aXmlRacineAttribute['status'] = 1;
            $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            return $sMessage;
        }
    }
}
?>