<?php

/**
 * \file License.class.inc
 * \class License
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the License php class
 *
 * This class defines Rest Api to Gtf order statutes
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
//require_once 'Priority.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';
//require_once ("PEAR/Mail.php");
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require_once 'PHPMailer/src/Exception.php';
require_once 'PHPMailer/src/PHPMailer.php';
require_once 'PHPMailer/src/SMTP.php';

//require_once ("PEAR/Mail/mime.php");

class License extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/license",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/license")
     *   }
     * )
     * * @SWG\Tag(
     *   name="License",
     *   description="Operations about License"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('priority_id', 'priority_label');
    }

    /**
     * @SWG\Get(path="/license",
     *   tags={"License"},
     *   summary="Get License",
     *   description="Request to get License",
     *   operationId="GET",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/license")
     *     )
     *  )
     */

    /**
     * get License
     * @return  License
     */
    function GET() {
        $sLicenseFile = $this->aProperties['vas_home'] . '/../gtf.engines/licenses/license.txt';
        if (!file_exists($sLicenseFile) || !$fp = fopen($sLicenseFile, 'r'))
            $aLicense = array('license' => false);
        else {
            $aLicense = array('license' => true);
            while (!feof($fp)) { //on parcourt toutes les lignes
                $ligne = str_replace('Sgtf-', '', fgets($fp, 4096)); // lecture du contenu de la ligne
                //
                $pattern = '#^License number: ([0-9A-Za-z]+)#';
                $found = preg_match($pattern, $ligne, $matches, PREG_OFFSET_CAPTURE, 0);
                if ($found)
                    $aLicense['license_number'] = $matches[1][0];
                //
                $pattern = '#^Expiry date: (Permanent|[0-9]{8})#';
                $found = preg_match($pattern, $ligne, $matches, PREG_OFFSET_CAPTURE, 0);
                if ($found)
                    $aLicense['expiry_date'] = str_replace(chr(13), "", str_replace(chr(10), "", $matches[1][0]));
                //
                $pattern = '#^Engines: ([0-9]+)#';
                $found = preg_match($pattern, $ligne, $matches, PREG_OFFSET_CAPTURE, 0);
                if ($found)
                    $aLicense['engines'] = $matches[1][0];
                //
                $pattern = '#^Owner: (.+)\n#';
                $found = preg_match($pattern, $ligne, $matches, PREG_OFFSET_CAPTURE, 0);
                if ($found)
                    $aLicense['owner'] = str_replace(chr(13), "", str_replace(chr(10), "", $matches[1][0]));
            }
        }
        $this->aFields['license'] = $aLicense;
        $aXmlRacineAttribute['status'] = 1;
        $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
        return $sMessage;
    }

    /**
     * @SWG\Post(path="/license",
     *   tags={"License"},
     *   summary="Add license file",
     *   description="Request to add a licence file",
     *   operationId="POST",
     *   produces={"application/xml", "application/json", "application/x-vm-json"},
     *   consumes= { "multipart/form-data"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="formData",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Parameter(
     *     name="license_file",
     *     in="formData",
     *     description="File of the licence",
     *     required=true,
     *     type="file"
     *   ),
     *   @SWG\Parameter(
     *     name="action",
     *     in="formData",
     *     description="File of the licence (ask or activate)",
     *     required=true,
     *     type="string"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/activate")
     *     )
     *  )
     */

    /**
     * insert licence file
     * @return id of the workspace created
     */
    function POST() {
        if ($this->aValues["action"] == 'activate') {
            if (!empty($_FILES['license_file'])) {
                $sErrorMessage = uploadFile('license_file', "", $this->aProperties['vas_home'] . '/../gtf.engines/licenses/' . $_FILES['license_file']["name"], $_FILES['license_file']['size'] + 1);
                rename($this->aProperties['vas_home'] . '/../gtf.engines/licenses/' . $_FILES['license_file']["name"], $this->aProperties['vas_home'] . '/../gtf.engines/licenses/license.txt');
                if ($sErrorMessage == "") {
                    $aXmlRacineAttribute['status'] = 1;
                    $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                } else {
                    writeToErrorLog($sErrorMessage);
                    $oError = new VitisError(1, 'LICENSE_FILE_INSTALL_ERROR_CONFIGURATION_CONFIGURATION_GTF_LICENSE');
                    $aXmlRacineAttribute['status'] = 0;
                    $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                }
            }
        } else if ($this->aValues["action"] == 'ask') {
            $mail = new PHPMailer;

            $mail->isSMTP();                                                // Set mailer to use SMTP
            //$mail->SMTPDebug = 3;                                         // debugger level (3 all with connection)
            $mail->Debugoutput = function($str, $level) {error_log("debug level $level; message: $str");};
            $mail->Host = $this->aProperties["smtp_host"];                  // Specify main and backup SMTP servers
            $mail->Port = $this->aProperties["smtp_port"];                  // TCP port to connect to
            $mail->SMTPAuth = $this->aProperties["smtp_authentification"];  // Enable SMTP authentication
            // if authentication add parameter to connect SMTP
            if ($this->aProperties["smtp_authentification"] === true){
                $mail->AuthType = 'LOGIN';
                $mail->Username = $this->aProperties["smtp_login"];             // SMTP username
                $mail->Password = $this->aProperties["smtp_password"];          // SMTP password
                $mail->SMTPSecure = 'tls';                                      // Enable TLS encryption, `ssl` also accepted (deprecated)
            } 
            $sTo = 'codes@veremes.com';
            $mail->AddAddress($sTo);
            $mail->SetFrom($this->aProperties['mail_sender'], $this->aProperties['nickname_sender']);
            $mail->AddReplyTo($this->aValues['reply_to']);
            $mail->IsHTML(true);                                            // Set email format to HTML
            $mail->CharSet = 'UTF-8';
            $mail->Subject = $this->aValues['subject'] . $this->aValues['license_number'];
            $mail->Body = /*utf8_decode*/('<html><body>' . $this->aValues['message'] . '</body></html>');
            $mail->AddCC($this->aValues['reply_to']);
            
            // Depuis PHP 5.6 -> vérification du certificat SSL.
            if (!$this->aProperties['proxy_check_ssl']) {
                $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );
            }
            
            //
            if (!$mail->send()) {
                writeToErrorLog(ERROR_0023 . $sTo . '.');
                writeToErrorLog("Error message : " . $mail->ErrorInfo);
                writeToLog("|WARN|PHP|Failed sending email to the following address : " . $sTo . ' and copy to : ' . $this->aValues['reply_to'], $this->aProperties['mail_log_file']);
                $oError = new VitisError(1, 'SEND_MAIL_ERROR_CONFIGURATION_CONFIGURATION_GTF_LICENSE');
                $aXmlRacineAttribute['status'] = 0;
                $sMessage = $oError->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
                    //$sErrorMessage = $sMail->getMessage();
            } else {
                writeToLog("|INFORM|PHP| An email has been sent to the following address : " . $sTo . ' and copy to : ' . $this->aValues['reply_to'], $this->aProperties['mail_log_file']);
                if(!empty($this->aProperties['SaveSentMail']) && $this->aProperties['SaveSentMail'] === true){
                    $imap = new Imap($this->aProperties['imapBotSender_host'], $this->aProperties['imapBotSender_port'], $this->aProperties['imapBotSender_login'], $this->aProperties['imapBotSender_pwd'], $this->aProperties['imapBotSender_encrypt']);
                    if($imap->isConnected()===false)
                        writeToLog("|WARN|PHP| can't connect to the IMAP at hostname : " . $this->aProperties['imapBotSender_host'], $this->aProperties['mail_log_file']);
                    else{
                        $imap->selectFolder("Sent");
                        $imap->saveMessageInSent($mail->getSentMIMEMessage(), "");
                    }
                }
                $aXmlRacineAttribute['status'] = 1;
                $sMessage = $this->asDocument('', 'vitis', $this->aValues['sEncoding'], True, $aXmlRacineAttribute, $this->aValues['sSourceEncoding'], $this->aValues['output']);
            }
        }
        return $sMessage;
    }

}

?>