<?php

/**
 * \file Messages.class.inc
 * \class Messages
 *
 * \author Yoann Perollet <yoann.perollet@veremes.com>.
 *
 * 	\brief This file contains the Messages php class
 *
 * This class defines Rest Api to Gtf messages
 * 
 */
require_once 'Gtf.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vitis_lib/Connection.class.inc';
require_once 'Message.class.inc';
require_once dirname($_SERVER['SCRIPT_FILENAME']) . '/class/vmlib/BdDataAccess.inc';

class Messages extends GTF {
    /**
     * @SWG\Definition(
     *   definition="/messages",
     *   allOf={
     *     @SWG\Schema(ref="#/definitions/messages")
     *   }
     * )
     * * @SWG\Tag(
     *   name="Messages",
     *   description="Operations about Messages"
     * )
     */

    /**
     * construct
     * @param type $aPath url of the request
     * @param type $aValues parameters of the request
     * @param type $properties properties
     * @param type $bShortcut false to reinit variables
     * @param type $oConnection connection object
     */
    function __construct($aPath, $aValues, $properties, $bShortcut = false, $oConnection = false) {
        parent::__construct($aPath, $aValues, $properties, $bShortcut, $oConnection);
        $this->aSelectedFields = Array('message_id', 'messageclass', $this->getDateSelectedFields('creation_date', 'yeartosecond'), 'body', 'sender', 'messageclass_type', 'status', $this->getDateSelectedFields('minexecdate', 'yeartosecond'));
    }

    /**
     * @SWG\Get(path="/messages",
     *   tags={"Messages"},
     *   summary="Get Messages",
     *   description="Request to get Messages",
     *   operationId="GET",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="message_by",
     *     in="query",
     *     description="list of messageing fields",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="limit",
     *     in="query",
     *     description="number of element",
     *     required=false,
     *     type="integer",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="offset",
     *     in="query",
     *     description="index of first element",
     *     required=false,
     *     type="string",
     *     format="int32"
     *   ),
     * @SWG\Parameter(
     *     name="attributs",
     *     in="query",
     *     description="list of attributs",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="filter",
     *     in="query",
     *     description="filter results",
     *     required=false,
     *     type="string"
     *   ),
     * @SWG\Parameter(
     *     name="distinct",
     *     in="query",
     *     description="delete duplicates",
     *     required=false,
     *     type="boolean"
     *   ),
     *   @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/messages")
     *     )
     *  )
     */

    /**
     * get Messages
     * @return  Messages
     */
    function GET() {
        $aReturn = $this->genericGet($this->aProperties['schema_gtf'], "v_message", "message_id");
        return $aReturn['sMessage'];
    }

    /**
     * @SWG\Delete(path="/messages/",
     *   tags={"Messages"},
     *   summary="delete Message",
     *   description="Request to delete Message",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="idList",
     *     in="query",
     *     description="id of the messages",
     *     required=true,
     *     type="string"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/messages")
     *     )
     *  )
     */
    /**
     * @SWG\Delete(path="/messages/{message_id}",
     *   tags={"Messages"},
     *   summary="delete Message",
     *   description="Request to delete Message",
     *   operationId="DELETE",
     *   produces={"application/xml", "application/json"},
     *   @SWG\Parameter(
     *     name="token",
     *     in="query",
     *     description="user token",
     *     required=true,
     *     type="string"
     *   ),
     * * @SWG\Parameter(
     *     name="message_id",
     *     in="path",
     *     description="id of the message",
     *     required=true,
     *     type="integer",
     *     format = "int32"
     *   ),
     * @SWG\Response(
     *         response=200,
     *         description="Poprerties Response",
     *         @SWG\Schema(ref="#/definitions/messages")
     *     )
     *  )
     */

    /**
     * delete message
     * @return id of message deleted or error object if a message is not deleted
     */
    function DELETE() {
        $aReturn = $this->genericDelete($this->aProperties['schema_gtf'], 'message', 'message_id');
        return $aReturn['sMessage'];
    }

}

?>